/*
 * CAN/LIN Checker for RL78/F13,F14
 *
 * Target: QB-R5F10PPJ-TB (RL78/F14, 100pin, 256KB ROM, 20KB RAM)
 * Author: Yasushi Tanaka
 *
 * [ ^C}hCo ]
 */

#include "common.h"
#include "iodefine.h"
#include "cpu.h"
#include "can.h"
#include "timer.h"

/*
 * ^C}
 * ݒl
 */
#define TIMER_TCR_PER_MS		(250)
									/* 1ms̃JEg */
#define TIMER_TCR_THRES			((u2)(TIMER_TCR_PER_MS / 2))
									/* I[o[bvpl */

/*
 * SFRݒl(PER0WX^)
 */
#define RL78F_PER0_TAU0EN		((u1)(0x01))
									/* ^C}EACEjbg0L */

/*
 * SFRݒl(MK1LWX^)
 */
#define RL78F_MK1L_TMMK01		((u1)(0x20))
									/* `l1荞݃}XN */

/*
 * SFRݒl(PR01LWX^)
 */
#define RL78F_PR01L_TMPR001		((u1)(0x20))
									/* `l1荞ݗD揇(bit0) */

/*
 * SFRݒl(PR11LWX^)
 */
#define RL78F_PR11L_TMPR101		((u1)(0x20))
									/* `l1荞ݗD揇(bit1) */

/*
 * SFRݒl(TTmWX^)
 */
#define RL78F_TT_ALL			((u2)(0x0aff))
									/* ^C}~(S`l) */

/*
 * SFRݒl(TPSmWX^)
 */
#define RL78F_TPS_128			((u2)(0x0007))
									/* CKm0ƂfCLK/2^7I */

/*
 * SFRݒl(TMRmnWX^)
 */
#define RL78F_TMR_SPLIT			((u2)(0x0800))
									/* C^[oE8rbgE^C} */

/*
 * SFRݒl(TDRmnLWX^)
 */
#define RL78F_TDRL_1MS			((u1)((TIMER_TCR_PER_MS - 1)))
									/* 32MHz/2^7=250kHzAݒl+1LƂȂ邽-1 */

/*
 * SFRݒl(TIS0WX^)
 */
#define RL78F_TIS0_INPUT		((u2)(0x0000))
									/* ^C}͒[q(TI0n)^C}͂ƂĎgp */

/*
 * SFRݒl(TOEmWX^)
 */
#define RL78F_TOE_DISABLE		((u2)(0x0000))
									/* ^C}o͂֎~(S`l) */
/*
 * SFRݒl(TOmWX^)
 */
#define RL78F_TO_DISABLE		((u2)(0x0000))
									/* p|[g^C}ƂȂ(S`l) */

/*
 * SFRݒl(TOLmWX^)
 */
#define RL78F_TOL_NORMAL		((u2)(0x0000))
									/* ^C}o͒l𔽓]Ȃ(S`l) */

/*
 * SFRݒl(TOMmWX^)
 */
#define RL78F_TOM_MASTER		((u2)(0x0000))
									/* }X^E`lo̓[h(S`l) */

/*
 * SFRݒl(NFEN1WX^)
 */
#define RL78F_NFEN1_DISABLE		((u1)(0x00))
									/* mCYEtB^OFF(S`l) */
/*
 * SFRݒl(TSmWX^)
 */
#define RL78F_TS_CH1			((u1)(0x02))
									/* `l1(SPLIT[hLOŴ)Jn */

/*
 * ^C}
 * O[oϐ
 */
SADDR u2 timer_ms;
								/* ^C}荞݉(msP) */
SADDR u2 timer_sec[2];
								/* ^C}荞݉(secP) */

/*
 * ^C}
 * 
 */
void timer_init(void)
{
	/* ӃCl[uEWX^0Ń^C}EACEjbg0Lɂ */
	PER0 |= RL78F_PER0_TAU0EN;

	/* ^C}荞݉񐔂 */
	timer_ms = 0x0000;
	timer_sec[0] = 0x0000;
	timer_sec[1] = 0x0000;

	/* `l1̊荞݂}XN */
	MK1L |= RL78F_MK1L_TMMK01;

	/* `l1̊荞ݗD揇ʂx0(ō)ɐݒ */
	PR01L &= (u1)(~RL78F_PR01L_TMPR001);
	PR11L &= (u1)(~RL78F_PR01L_TMPR001);

	/* ^C}~(S`l) */
	TT0 = RL78F_TT_ALL;

	/* CKm0ƂfCLK/128I */
	TPS0 = RL78F_TPS_128;

	/* `l1C^[oE8rbgE^C}ɐݒ */
	TMR01 = RL78F_TMR_SPLIT;

	/* ^C}EJEglݒ */
	TDR01L = RL78F_TDRL_1MS;

	/* ^C}͒[q^C}͂Ƃ(ۂ͈ӖȂ) */
	TIS0 = RL78F_TIS0_INPUT;

	/* ^C}o͔g`^C}o͒[qɏo͂Ȃ */
	TOE0 = RL78F_TOE_DISABLE;

	/* p|[g^C}ƂȂ */
	TO0 = RL78F_TO_DISABLE;

	/* ^C}o͒[q𔽓]Ȃ(ۂ͈ӖȂ) */
	TOL0 = RL78F_TOL_NORMAL;

	/* }X^E`lo̓[hƂ */
	TOM0 = RL78F_TOM_MASTER;

	/* mCYEtB^OFF */
	NFEN1 = RL78F_NFEN1_DISABLE;

	/* `l1X^[g(荞݂̓}XNĂ) */
	TS0 = RL78F_TS_CH1;
}

/*
 * ^C}
 * 荞݊Jn
 */
void timer_start(void)
{
	/* `l1̊荞݃}XN */
	MK1L &= (u1)(~RL78F_MK1L_TMMK01);
}

/*
 * ^C}
 * 荞݃nh
 *
 * 1msŌĂ΂
 */
void timer_isr(void)
{
	/* msJE^CNg */
	timer_ms++;

	/* 1000ɒBAsecJE^CNg */
	if (timer_ms >= 1000)
	{
		timer_ms = 0;
		timer_sec[0]++;

		/* 10000secɒBÃJE^CNg */
		if (timer_sec[0] >= 10000)
		{
			timer_sec[0] = 0;
			timer_sec[1]++;

			/* 10000secɒBAŏIJE^Zbg */
			if (timer_sec[1] >= 10000)
			{
				timer_sec[1] = 0;
			}
		}
	}

	/* CAÑ^CEX^vXV(ۂ20msԊuxŗǂ) */
	can_time_update();
}

/*
 * ^C}
 * 擾
 */
void timer_getinfo(timer_info* info)
{
#if TIMER_TCR_PER_MS == 250
	u1 psw;
	u1 tcr1;
	u1 tcr2;

	/* 荞݋֎~ */
	psw = cpu_di();

	/* 擾 */
	tcr1 = (u1)TCR01;
	info->ms = timer_ms;
	info->sec[0] = timer_sec[0];
	info->sec[1] = timer_sec[1];
	tcr2 = (u1)TCR01;

	/* 荞ݕA */
	cpu_ei(psw);

	/* OE㔼bit7ɂȂ܂ŌJԂ */
	while ((tcr1 & 0x80) != (tcr2 & 0x80))
	{
		/* 荞݋֎~ */
		psw = cpu_di();

		/* 擾 */
		tcr1 = (u1)TCR01;
		info->ms = timer_ms;
		info->sec[0] = timer_sec[0];
		info->sec[1] = timer_sec[1];
		tcr2 = (u1)TCR01;

		/* 荞ݕA */
		cpu_ei(psw);
	}

	/* usݒ */
	info->us = (u2)(4 * (249 - tcr2));
#else
	u1 psw;
	u2 tcr1;
	u2 tcr2;

	/* 荞݋֎~ */
	psw = cpu_di();

	/* 擾 */
	tcr1 = (u2)(TCR01 & 0x00ff);
	info->ms = timer_ms;
	info->sec[0] = timer_sec[0];
	info->sec[1] = timer_sec[1];
	tcr2 = (u2)(TCR01 & 0x00ff);

	/* 荞ݕA */
	cpu_ei(psw);

	/* OE㔼ɂȂ܂ŌJԂ */
	while (tcr1 != tcr2)
	{
		if (tcr1 < TIMER_TCR_THRES)
		{
			if (tcr2 < TIMER_TCR_THRES)
			{
				/*  */
				tcr1 = tcr2;
			}
		}
		else
		{
			if (tcr2 >= TIMER_TCR_THRES)
			{
				/*  */
				tcr1 = tcr2;
			}
		}

		/* łȂ΁AĎ擾 */
		if (tcr1 != tcr2)
		{
			/* 荞݋֎~ */
			psw = cpu_di();

			/* Ď擾 */
			tcr1 = (u2)(TCR01 & 0x00ff);
			info->ms = timer_ms;
			info->sec[0] = timer_sec[0];
			info->sec[1] = timer_sec[1];
			tcr2 = (u2)(TCR01 & 0x00ff);

			/* 荞ݕA */
			cpu_ei(psw);
		}
	}

	/* usݒ */
	info->us = (u2)((1000 / TIMER_TCR_PER_MS) * ((TIMER_TCR_PER_MS - 1) - tcr2));
#endif
}
