/***************************************************************************/
/** @file       mm_etc.h
    @brief      Zp֐
    @author     shom
****************************************************************************/

#pragma once


namespace mm
{
	__declspec( dllexport )	u32	rand_i();

	__declspec( dllexport )	s32 sign_i( const s32 in_val );
	__declspec( dllexport )	f32 sign_f( const f32 in_val );

	__declspec( dllexport )	s32	abs_i( const s32 in_val );
	__declspec( dllexport )	f32	abs_f( const f32 in_val );

	__declspec( dllexport )	b32 is_nearly_equal_i
	( const s32 a, const s32 b, const s32 tolerance );
	__declspec( dllexport )	b32 is_nearly_equal_f
	( const f32 a, const f32 b, const f32 tolerance );

	__declspec( dllexport )	s32 clamp_i( s32 in_iVal, s32 in_iMin, s32 in_iMax );
	__declspec( dllexport )	f32 clamp_f( f32 in_fVal, f32 in_fMin, f32 in_fMax );
	__declspec( dllexport )	f32 saturate( f32 in_fVal );

	__declspec( dllexport )	s32 min_i( s32 in_iVal1, s32 in_iVal2 );
	__declspec( dllexport )	f32 min_f( f32 in_fVal1, f32 in_fVal2 );
	__declspec( dllexport )	s32 max_i( s32 in_iVal1, s32 in_iVal2 );
	__declspec( dllexport )	f32 max_f( f32 in_fVal1, f32 in_fVal2 );
}
