/***************************************************************************/
/** @file       mm_angle.cpp
    @brief      Zp֐
    @author     shom
****************************************************************************/

#include "pch_util.h"

#include <math.h>


namespace
{
	f64	sin_raw( f64 in_val )
	{
		return sin( in_val );
	}
	f64	cos_raw( f64 in_val )
	{
		return cos( in_val );
	}
	f64	tan_raw( f64 in_val )
	{
		return tan( in_val );
	}
}


/***************************************************************************
	mm( namespace )
****************************************************************************/

angle	mm::degree_to_angle( f32 deg )
{
	while( deg < 0.0f || 360.0f <= deg )
	{
		deg = deg + 360.0f * mm::sign_f( deg ) * -1.0f;
	}

	const f32 ang_max = SCAST<f32>( 0x100000000 );
	return ( SCAST< angle >( ang_max * deg / 360.0f ) );
}

f32		mm::degree_to_radian( f32 deg )
{
	return ( deg * ( sc_fPi / 180.0f ) );
}

vec2f	mm::degree_to_v2( f32 deg )
{
	const f32 rad = degree_to_radian( deg );

	return ( radian_to_v2( rad ) );
}

f32		mm::angle_to_degree( angle ang )
{
	const f32 deg = 180.0f * SCAST<f32>( ang ) / SCAST<f32>( 0x80000000 );

	return ( deg == 360.0f ) ? 0.0f : deg;
}

f32		mm::angle_to_radian( angle ang )
{
	const f32 deg = angle_to_degree( ang );

	return ( degree_to_radian( deg ) );
}

vec2f	mm::angle_to_v2( angle ang )
{
	const f32 rad = angle_to_radian( ang );

	return ( radian_to_v2( rad ) );
}

f32		mm::radian_to_degree( f32 rad )
{
	return ( rad * ( 180.0f / sc_fPi ) );
}

angle	mm::radian_to_angle( f32 rad )
{
	const f32 deg = radian_to_degree( rad );

	return ( degree_to_angle( deg ) );
}

vec2f	mm::radian_to_v2( f32 rad )
{
	return vec2f( cos( rad ), sin( rad ) );
}

f32		mm::v2_to_degree( const vec2f& v )
{
	const f32 rad = v2_to_radian( v );

	return ( radian_to_degree( rad ) );
}

angle	mm::v2_to_angle( const vec2f& v )
{
	const f32 rad = v2_to_radian( v );

	return ( radian_to_angle( rad ) );
}

f32		mm::v2_to_radian( const vec2f& v )
{
	if( is_equal_zero_f( v.x ) )
	{
		return ( v.y == 0.0f ) ? 0.0f :
			   ( v.y > 0.0f ) ? ( sc_fPi * 0.5f ) : ( sc_fPi * 1.5f );
	}
	else if( is_equal_zero_f( v.y ) )
	{
		return ( v.x > 0.0f ) ? 0.0f : sc_fPi;
	}
	else
	{
		return ( atan2( v.y, v.x ) + ( ( v.x > 0.0f ) ? 0.0f : sc_fPi ) - ( sc_fPi * 0.5f ) );
	}
}

vec2f	mm::inverse_dir(
	const vec2f& v2_dir,
	b32 b_inverse_x, b32 b_inverse_y
	)
{
	vec2f v2_out;

	v2_out.x = b_inverse_x ? ( - v2_dir.x ) : v2_dir.x;
	v2_out.y = b_inverse_y ? ( - v2_dir.y ) : v2_dir.y;

	return v2_out;
}

f32		mm::sin( f32 in_rad )
{
	return SCAST< f32 >( sin(  SCAST< f64 >( in_rad ) ) );
}

f64		mm::sin( f64 in_rad )
{
	return sin_raw( in_rad );
}

f32		mm::cos( f32 in_rad )
{
	return SCAST< f32 >( cos(  SCAST< f64 >( in_rad ) ) );
}

f64		mm::cos( f64 in_rad )
{
	return cos_raw( in_rad );
}

f32		mm::tan( f32 in_rad )
{
	return SCAST< f32 >( tan(  SCAST< f64 >( in_rad ) ) );
}

f64		mm::tan( f64 in_rad )
{
	return tan_raw( in_rad );
}

