/***************************************************************************/
/** @file       image_board.h
    @brief      drawing the board-polygon with texture
    @author     shom
****************************************************************************/

#pragma once

#include "board.h"

class crender;

namespace
{
#ifdef DX
	typedef std::vector<LPDIRECT3DTEXTURE9> p_texture_list_t;
#endif
}

class cimage_board
:
public cboard
{
public:
	cimage_board();
	virtual ~cimage_board();
private:	//--	inner function
	void	release_all();
public:		//--

	virtual b32		Initialize();
	virtual b32		Initialize(
		const TCHAR* const sz_path_texture,
		f32 width = F32_INVALID, f32 height = F32_INVALID
		);
	virtual void	Finalize();

	virtual void	Draw();

	u32		CreateTexture(
		const TCHAR* const sz_path_texture,
		f32 width = F32_INVALID, f32 height = F32_INVALID
		);
	void	SetTextureActive( u32 idx );

private:
	u32					m_idx_texture_active;
#ifdef DX
	p_texture_list_t	m_p_texture_list;
#endif
};
