/***************************************************************************/
/** @file       mm_type.h
    @brief      Zp֐
    @author     shom
****************************************************************************/

#pragma once

///--	basis
typedef	short int          u8;
typedef	short unsigned int u16;
typedef	unsigned int       u32;
typedef short signed int   s16;
typedef signed int         s32;
typedef	float              f32;
typedef	double             f64;
typedef u8                 b8;
typedef u32                b32;

#define ct	const

typedef ct u8	cu8;
typedef ct u16	cu16;
typedef ct u32	cu32;
typedef ct s16	cs16;
typedef	ct s32	cs32;
typedef	ct f32	cf32;
typedef ct f64	cf64;
typedef cu8		cb8;
typedef cu32	cb32;

#undef TRUE
#define TRUE 1
#undef FALSE
#define FALSE 0
///--

///--	angle
typedef u32	angle;
///--

///--	vector
#ifdef DX

struct D3DXVECTOR2;
struct D3DXVECTOR3;
struct D3DXVECTOR4;

typedef D3DXVECTOR2	vec2f;
typedef D3DXVECTOR3	vec3f;
typedef D3DXVECTOR4	vec4f;

#else	//if GL

struct vec2f
{
	f32 x;
	f32 y;

    vec2f()
    {
        this->x = 0.0f;
        this->y = 0.0f;
    }
	vec2f( f32 x, f32 y )
    {
        this->x = x;
        this->y = y;
    }
};
struct vec3f
{
	f32 x;
	f32 y;
	f32 z;

    vec3f()
    {
        this->x = 0.0f;
        this->y = 0.0f;
        this->z = 0.0f;
    }
    vec3f( f32 x, f32 y, f32 z )
    {
        this->x = x;
        this->y = y;
        this->z = z;
    }
};
struct vec4f
{
	f32 x;
	f32 y;
	f32 z;
	f32 w;

    vec4f()
    {
        this->x = 0.0f;
        this->y = 0.0f;
        this->z = 0.0f;
        this->w = 0.0f;
    }
    vec4f( f32 x, f32 y, f32 z, f32 w )
    {
        this->x = x;
        this->y = y;
        this->z = z;
        this->w = w;
    }
};

#endif
///--

