/***************************************************************************/
/** @file       render_dx.cpp
    @brief      
    @author     shom
****************************************************************************/

#include "pch_core.h"

#include "render_dx.h"


/***************************************************************************
	crender
****************************************************************************/

crender::crender()
:
m_p_d3d( NULL ),
m_p_device( NULL ),

m_present_params()//,
{
}

crender::~crender()
{
	release_all();
}

b32		crender::Initialize( HWND h_wnd )
{
#define PROC_ERR	if( FAILED( hr ) ) { DEBUG_BREAK(); return FALSE; }

	HRESULT hr = S_OK;

	///--	Direct3D9IuWFNg̍쐬
	m_p_d3d = Direct3DCreate9( D3D_SDK_VERSION );
	if( !m_p_d3d ) { return FALSE; }
	///--

	///--	D3DfoCX̍쐬
	//--	݂̃fBXvC[h擾
	D3DDISPLAYMODE d3ddm;
	hr = m_p_d3d->GetAdapterDisplayMode( D3DADAPTER_DEFAULT, &d3ddm );
	PROC_ERR;
	//--

	//--	v[e[Vp[^̐ݒ
	D3DPRESENT_PARAMETERS m_present_params;
	ZeroMemory( &m_present_params, sizeof( D3DPRESENT_PARAMETERS ) );

	m_present_params.BackBufferCount	= 1;
	m_present_params.Windowed			= TRUE;				// EChE\̎w
	m_present_params.BackBufferFormat	= d3ddm.Format;		// J[[h̎w
	m_present_params.SwapEffect			= D3DSWAPEFFECT_DISCARD;	// 
	m_present_params.EnableAutoDepthStencil	= TRUE;			// G[΍
	m_present_params.AutoDepthStencilFormat	= D3DFMT_D16;	// G[΍
	//--

	//--	fBXvCA_v^\߂̃foCX쐬
#define CREATE_DEVICE__RENDER( _dev_type, _vertex_processing )	\
	if( FAILED( m_p_d3d->CreateDevice(	\
					D3DADAPTER_DEFAULT,	\
					##_dev_type##,		\
					h_wnd,				\
					##_vertex_processing##,	\
					&m_present_params,	\
					&m_p_device	\
					) ) )

	CREATE_DEVICE__RENDER( D3DDEVTYPE_HAL, D3DCREATE_HARDWARE_VERTEXPROCESSING )
	CREATE_DEVICE__RENDER( D3DDEVTYPE_HAL, D3DCREATE_SOFTWARE_VERTEXPROCESSING )
	CREATE_DEVICE__RENDER( D3DDEVTYPE_REF, D3DCREATE_HARDWARE_VERTEXPROCESSING )
	CREATE_DEVICE__RENDER( D3DDEVTYPE_REF, D3DCREATE_SOFTWARE_VERTEXPROCESSING )
	{
		release_all();

		DEBUG_BREAK();

		return FALSE;
	}

#undef CREATE_DEVICE__RENDER
#undef PROC_ERR
	//--
	///--

	return TRUE;

}

void	crender::Finalize()
{
	release_all();
}

b32		crender::BeginDraw()
{
	const u32 clear_color = COLOR_BLACK;
	m_p_device->Clear( 0, NULL, D3DCLEAR_TARGET, clear_color, 1.0f, 0 );

	return ( SUCCEEDED( m_p_device->BeginScene() ) );
}

b32		crender::EndDraw()
{
	///--
	m_p_device->EndScene();
	///--

	///--	V[̕\
	if( FAILED( m_p_device->Present( NULL, NULL, NULL, NULL ) ) )
	{
		//foCX畜A
		m_p_device->Reset( &m_present_params );

		DEBUG_BREAK();
		return FALSE;
	}
	///--

	return TRUE;
}

LPDIRECT3DDEVICE9 const	crender::GetDevice()	const
{
	return m_p_device;
}

void	crender::release_all()
{
	my_safe_rel( m_p_device );
	my_safe_rel( m_p_d3d );
}


