/***************************************************************************/
/** @file       debug_dip.h
    @brief      fobO@\XCb`
    @author     shom
    @internal
****************************************************************************/

#pragma once

namespace debug_dip
{
	enum eDebugDipCategory
	{
	/**---------------------------------------------------------------------**/
	#define DEBUG_DIP_CATEGORY( _name )	\
	\
		eDebugDipCategory_##_name##,

	#include "core/debug/debug_dip/debug_dip_def.h"
	#undef DEBUG_DIP_CATEGORY
	/**---------------------------------------------------------------------**/

		eNof_DebugDipCategory,
	};

	enum eDebugDipItem
	{
	/**-------------------------------------------------------------------**/
	#define DEBUG_DIP_ITEM( _category, _name, _msg )	\
	\
		eDebugDipItem_##_name##,
	
	#include "core/debug/debug_dip/debug_dip_def.h"
	#undef DEBUG_DIP_ITEM
	/**-------------------------------------------------------------------**/
	
		eNof_DebugDipItem,

		eDebugDipItem_Zero = 0,
		eDebugDipItem_Default = eDebugDipItem_Zero,
	};
	
	extern const TCHAR*	GetDipCategoryName( eDebugDipItem in_eDip );
	extern const TCHAR*	GetDipItemName( eDebugDipItem in_eDip );

	extern b32	IsDip( eDebugDipItem e_dip );
	extern void	SetDip( eDebugDipItem e_dip, b32 b_set );
	
	extern void	InitDip();
	extern void	FinDip();
}

