/***************************************************************************/
/** @file       util.cpp
    @brief      
    @author     shom
****************************************************************************/

#include "pch_util.h"

#include "util.h"


void my_memzero( void* dst, u32 size )
{
    memset( dst, 0, size );
}

u32	set_color_argb( u32 a, u32 r, u32 g, u32 b )
{
	ASSERT( ( a <= 0xff ) && ( r <= 0xff ) && ( g <= 0xff ) && ( b <= 0xff ) );

	return (
		( ( (a) & 0xff ) << 24 ) |
		( ( (r) & 0xff ) << 16 ) | ( ( (g) & 0xff ) << 8 ) | ( (b) & 0xff )
		);
}

u32	set_color_rgba( u32 r, u32 g, u32 b, u32 a )
{
	return ( set_color_argb( a, r, g, b ) );
}

u32	switch_color_a( u32 color, u32 a )
{
	return ( set_color_argb( a, get_color_r( color ), get_color_g( color ), get_color_b( color ) ) );
}

u32	switch_color_r( u32 color, u32 r )
{
	return ( set_color_argb( get_color_a( color ), r, get_color_g( color ), get_color_b( color ) ) );
}

u32	switch_color_g( u32 color, u32 g )
{
	return ( set_color_argb( get_color_a( color ), get_color_r( color ), g, get_color_b( color ) ) );
}

u32	switch_color_b( u32 color, u32 b )
{
	return ( set_color_argb( get_color_a( color ), get_color_r( color ), get_color_g( color ), b ) );
}

u32	add_color_a( u32 color, u32 a )
{
	return ( switch_color_a( color, mm::min_i( get_color_a( color ) + a, 0xff ) ) );
}

u32	add_color_r( u32 color, u32 r )
{
	return ( switch_color_r( color, mm::min_i( get_color_a( color ) + r, 0xff ) ) );
}

u32	add_color_g( u32 color, u32 g )
{
	return ( switch_color_g( color, mm::min_i( get_color_a( color ) + g, 0xff ) ) );
}

u32	add_color_b( u32 color, u32 b )
{
	return ( switch_color_b( color, mm::min_i( get_color_a( color ) + b, 0xff ) ) );
}

u32	sub_color_a( u32 color, u32 a )
{
	return ( switch_color_a( color, mm::max_i( static_cast<s32>( get_color_a( color ) ) - a, 0 ) ) );
}

u32	sub_color_r( u32 color, u32 r )
{
	return ( switch_color_r( color, mm::max_i( static_cast<s32>( get_color_r( color ) ) - r, 0 ) ) );
}

u32	sub_color_g( u32 color, u32 g )
{
	return ( switch_color_g( color, mm::max_i( static_cast<s32>( get_color_g( color ) ) - g, 0 ) ) );
}

u32	sub_color_b( u32 color, u32 b )
{
	return ( switch_color_b( color, mm::max_i( static_cast<s32>( get_color_b( color ) ) - b, 0 ) ) );
}

u32	get_color_a( u32 color )
{
	return ( color >> 24 );
}

u32	get_color_r( u32 color )
{
	return ( ( color >> 16 ) & 0xff );
}

u32	get_color_g( u32 color )
{
	return ( ( color >> 8 ) & 0xff );
}

u32	get_color_b( u32 color )
{
	return ( color & 0xff );
}

/***************************************************************************
	mm( namespace )
****************************************************************************/

color_t::color_t()
{
}

color_t::color_t( u32 in_r, u32 in_g, u32 in_b, u32 in_a )
{
	m_color = set_color_rgba( in_r, in_g, in_b, in_a );
}

color_t::color_t( f32 in_r, f32 in_g, f32 in_b, f32 in_a )
{
	color_t(
		SCAST< u32 >( in_r * SCAST< f32 >( 0xff ) ),
		SCAST< u32 >( in_g * SCAST< f32 >( 0xff ) ),
		SCAST< u32 >( in_b * SCAST< f32 >( 0xff ) ),
		SCAST< u32 >( in_a * SCAST< f32 >( 0xff ) )
		);
}


void color_t::set( u32 in_r, u32 in_g, u32 in_b, u32 in_a )
{
	m_color = set_color_rgba( in_r, in_g, in_b, in_a );
}

void color_t::switch_r( u32 in_r )
{
	m_color = switch_color_r( m_color, in_r );
}

void color_t::switch_g( u32 in_g )
{
	m_color = switch_color_g( m_color, in_g );
}

void color_t::switch_b( u32 in_b )
{
	m_color = switch_color_b( m_color, in_b );
}

void color_t::switch_a( u32 in_a )
{
	m_color = switch_color_a( m_color, in_a );
}

void color_t::add_r( u32 r )
{
	m_color = add_color_r( m_color, r );
}

void color_t::add_g( u32 g )
{
	m_color = add_color_g( m_color, g );
}

void color_t::add_b( u32 b )
{
	m_color = add_color_b( m_color, b );
}

void color_t::add_a( u32 a )
{
	m_color = add_color_a( m_color, a );
}

void color_t::sub_r( u32 r )
{
	m_color = sub_color_r( m_color, r );
}

void color_t::sub_g( u32 g )
{
	m_color = sub_color_g( m_color, g );
}

void color_t::sub_b( u32 b )
{
	m_color = sub_color_b( m_color, b );
}

void color_t::sub_a( u32 a )
{
	m_color = sub_color_a( m_color, a );
}

u32 color_t::get_raw()	const
{
	return m_color;
}

u32	color_t::get_r()	const
{
	return get_color_r( m_color );
}

u32	color_t::get_g()	const
{
	return get_color_g( m_color );
}

u32	color_t::get_b()	const
{
	return get_color_b( m_color );
}

u32	color_t::get_a()	const
{
	return get_color_a( m_color );
}

u32	get_time()
{
#ifdef	DX
	return timeGetTime();	//~bP
#else	//if GL
	return glutGet( GLUT_ELAPSED_TIME );
#endif
}

f32 dot_to_meter( f32 dot )
{
	return ( dot / 7.0f );
}

f32 meter_to_dot( f32 meter )
{
	return ( meter * 7.0f );
}

