/***************************************************************************/
/** @file       mm_matrix.cpp
    @brief      Zp֐
    @author     shom
****************************************************************************/

#include "pch_util.h"

#include "mm.h"


/***************************************************************************
	mm( namespace )
****************************************************************************/

void	mm::identify_x( matrix& io_mtx )
{
	D3DXMatrixIdentity( &io_mtx );
}

void	mm::scaling_x( matrix& io_mtx, const vec3f& in_v3_scale )
{
	D3DXMatrixScaling( &io_mtx, VEC3_ARGS( in_v3_scale ) );
}

void	mm::rotation_z_x( matrix& io_mtx, f32 in_rad_z )
{
	D3DXMatrixRotationZ( &io_mtx, in_rad_z );
}

void	mm::translation_x( matrix& io_mtx, const vec3f& in_v3_offset )
{
	D3DXMatrixTranslation( &io_mtx, VEC3_ARGS( in_v3_offset ) );
}

