/***************************************************************************/
/** @file       mm_angle.h
    @brief      Zp֐
    @author     shom
****************************************************************************/

#pragma once


namespace mm
{
	const f32 sc_fPi = 3.141592654f;

	__declspec( dllexport )	angle	degree_to_angle( f32 deg );
	__declspec( dllexport )	f32		degree_to_radian( f32 deg );
	__declspec( dllexport )	vec2f	degree_to_v2( f32 deg );
	__declspec( dllexport )	f32		angle_to_degree( angle ang );
	__declspec( dllexport )	f32		angle_to_radian( angle ang );
	__declspec( dllexport )	vec2f	angle_to_v2( angle ang );
	__declspec( dllexport )	f32		radian_to_degree( f32 rad );
	__declspec( dllexport )	angle	radian_to_angle( f32 rad );
	__declspec( dllexport )	vec2f	radian_to_v2( f32 rad );
	__declspec( dllexport )	f32		v2_to_degree( const vec2f& v );
	__declspec( dllexport )	angle	v2_to_angle( const vec2f& v );
	__declspec( dllexport )	f32		v2_to_radian( const vec2f& v );

	__declspec( dllexport )	vec2f	inverse_dir(
		const vec2f& v2_dir,
		b32 b_inverse_x = TRUE, b32 b_inverse_y = TRUE
		);

	__declspec( dllexport )	f32		sin( f32 in_rad );
	__declspec( dllexport )	f64		sin( f64 in_rad );
	__declspec( dllexport )	f32		cos( f32 in_rad );
	__declspec( dllexport )	f64		cos( f64 in_rad );
	__declspec( dllexport )	f32		tan( f32 in_rad );
	__declspec( dllexport )	f64		tan( f64 in_rad );
}

