/***************************************************************************/
/** @file       FontGdi.h
    @brief      font rendering by gdi
    @author     shom
    @internal
****************************************************************************/

#pragma once

#include "d3dx9core.h"
#include "d3d9types.h"

class crender;

class cfont_gdi
{
public:
	cfont_gdi();

	void SetDefault();

	void SetSize( u32 height, u32 width = 0 );
	void SetStyle(
		b32 b_italic,
		b32 b_weight,
		b32 b_use_ansi/*,
		b32 b_shadow*/
		);

	void Create( LPD3DXFONT* pp_out, crender* in_p_render );

	void Draw(
		const	LPD3DXFONT		p_d3dx_font,
		const	LPCWSTR			sz_msg,
				RECT			rect,
				u32				color		= COLOR_BLACK,
				b32				b_shadow	= FALSE,
		const	LPD3DXSPRITE	p_sprite	= NULL
		);

private:
	D3DXFONT_DESC m_font_desc;
};
