/***************************************************************************/
/** @file       font.h
    @brief      
    @author     shom
    @internal
****************************************************************************/

#pragma once

class crender;
class cimage_board;


namespace font_def
{
	struct font_context_t
	{
		explicit font_context_t(
			const vec2f& in_v2_pos = vec2f( 0.0f, 0.0f ),
			const vec2f& in_v2_size = vec2f( 32.0f, 32.0f ),
			u32 in_color = set_color_rgba( 0, 0, 0, 255 )//,
			)
		:
		v2_pos( in_v2_pos ),
		v2_size( in_v2_size ),
		color( in_color )//,
		{	
		}

		vec2f v2_pos;
		vec2f v2_size;
		u32 color;
	};
}


class cfont_character_base
{
public:
	cfont_character_base();

	virtual void	Initialize(
		crender* in_p_render,
		const TCHAR* sz_path_texture
		);
	virtual void	Finalize();

	virtual void	SetContext( const font_def::font_context_t& in_context );

	virtual void	Draw( crender* in_p_render, u32 in_character, const vec2f& in_v2_pos );

protected:
	virtual void	calc_texture_uv(
		u32 in_character,
		vec2f& out_v2_start, vec2f& out_v2_end
		) = 0;

	SPTR_T( cimage_board )	m_p_iboard_font;
};

class cfont_character_ascii
:
public cfont_character_base
{
public:
	cfont_character_ascii();

	virtual void	Initialize( crender* in_p_render );

protected:
	virtual void	calc_texture_uv(
		u32 in_character,
		vec2f& out_v2_start, vec2f& out_v2_end
		);
};

class cfont_character_sjis
:
public cfont_character_base
{
public:
	cfont_character_sjis();

	virtual void	Initialize( crender* in_p_render );

protected:
	virtual void	calc_texture_uv(
		u32 in_character,
		vec2f& out_v2_start, vec2f& out_v2_end
		);
};


class cfont
{
public:
	cfont();

	void	Initialize( crender* in_p_render );
	void	Finalize();

	void	Draw( crender* in_p_render, const char* const in_sz_msg, const font_def::font_context_t& in_context );

private:
	SPTR_T( cfont_character_ascii )	m_p_character_ascii;
	SPTR_T( cfont_character_sjis )	m_p_character_sjis;
};
