/***************************************************************************/
/** @file       fps_counter.cpp
    @brief      
    @author     shom
    @internal
----------------------------------------------------------------------------
    $id
****************************************************************************/

#include "pch_core.h"

#include "fps_counter.h"

#ifdef _DEBUG

#include "core/font/font.h"

#include "core/app.h"	//g_kFps


///--	O[oϐC̒`

namespace
{
	u32	s_uTimeBefore	= timeGetTime();
	u32	s_uCounter	= 0;
	
	u32	s_uFps = 0;

	font_def::font_context_t	s_FontCntext;
}

///--


/**
 * 
 */
void	fps_counter::fps_counter_init()
{
	s_FontCntext.v2_pos = mm::get_v( 10.f, 10.f );
	s_FontCntext.v2_size = mm::get_v2_all( 20.f );
	s_FontCntext.color = COLOR_WHITE;
}

/**
 * FPSv 
 */
namespace
{
	const u32 sc_uTimeMeasuringInterval = 1000;
}

void	fps_counter::fps_counter_update()
{
	///--	count
	++s_uCounter;
	///--

	///--	measure fps
	ct u32 uTimeNow = timeGetTime();
	ct u32 uTimeElapsed = uTimeNow - s_uTimeBefore;

	if( uTimeElapsed >= sc_uTimeMeasuringInterval )
	{
		//--	calculate
		s_uFps = sc_uTimeMeasuringInterval * s_uCounter / uTimeElapsed + 1/*_ȉ؂グҌ*/;
		//--

		//--	clear
		s_uTimeBefore = uTimeNow;
		s_uCounter = 0;
		//--
	}
	///--
}

/**
 * FPSeLXg`
 */
void	fps_counter::fps_counter_draw()
{
#if 0
	if( s_uFps < app::g_kFps )
	{
		char szMsg[256];
		sprintf_s( szMsg, 256, "FPS:%d", s_uFps );
	
		in_pFont->Draw( szMsg, s_FontCntext );
	}
#endif
}

#endif
