<?php

/*
  ┌─────────────────────────────────────────────────┐
  │      *クラス名       : compile
  │       *概要     ：自作のテンプレートエンジンです。
 * 
 * 
 * 
 * 
  │
  │
  │       *作成者        ：shie.plus*2 椎本
  │
  │   ***********＜＜記録＞＞***********
  │     YYYY/MM/DD 新規作成
  │
  │
  └─────────────────────────────────────────────────┘
 */

class template {

	var $view_dir = '/view'; //indexからの相対パス。
	var $base_url = 'http://localhost/test/template'; //indexのURLパス。
	var $temp_ext = 'php';   //テンプレートファイルの拡張子。
	var $comp_file_dir = '/comp'; //コンパイル後のphpファイルを保存するパスです。
	var $comp_file_name = ''; //コンパイル後のファイル名
	var $comp_file_path = ''; //コンパイル後のファイルのパス　ファイル名月
	var $temp_file_name = ''; //コンパイル前のファイル名
	var $temp_file_path = ''; //コンパイル前のファイルのパス　ファイル名月
	var $temp_str;

	/*
	 * 特殊ファンクション名
	 */
	var $filter = array(
		'p' => 'print'
	);


	/*
	 * 
	 */
	var $php_start = '<?php ';
	var $php_end = ' ?>';

	/*
	 * ▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽
	 * 	No		:	1
	 * 	title	: temp
	 * 	説明		: テンプレートファイルをコンパイルして、表示する。
	 * 	@params	:	$file(str) : 使用するファイル名
	 * 			:	$date(array) : 変換する関数
	 * 			:	$bool(bool)=tRUE : html文字列を返すか返さないか？
	 * 								　　TRUE	 ：返さずに表示する。		
	 * 								　　FALSE ：返す。	
	 * 	@return	:	$html(str) : $bool=FALSEの場合にhtml文字列を返す。
	 * -----------------------------------------------------------------
	 */

	public function conpile($file, $data, $bool = TRUE) {
		//情報の整理
		$this->__set_hash($file);


		//ふぁいるをコンパイルする。
		$this->__compile_temp();
		print $this->temp_str;
//		if ($bool === TRUE) {
//			//表示する。
//			print $html;
//		} else {
//			return $html;
//		}
	}

	/*
	 * コンパイル関係の関数
	  ▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽
	  ▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽
	 */

	/**
	 * コンパイルコントローラー
	 */
	private function __compile_temp() {
		//読み込み
		$this->temp_str = file_get_contents($this->temp_file_path);
		//ifとforeachをコンパイル
		$this->temp_str = $this->__if_compile();
		$this->temp_str = $this->__for_compile();
		//{関数}と{{関数}}をコンパイル
		$this->temp_str = $this->__func_compile();
		//{hoge}と{{hoge}}をコンパイル
		$this->temp_str = $this->__hash_compile();
	}

	/*
	 * {関数}と{{関数}}をコンパイル
	 */

	private function __func_compile() {
		$temp_str = $this->temp_str;
		/* {{func(hoge)}}<?php func(hoge); ?>にする。 */
		$need = '/{{[\s\t]*\w+[\(].+[\)][\s\t]*}}/';
		$temp_str = preg_replace_callback($need, array($this, '__ret_php_func'), $temp_str);
		//{hoge}を$hogeにする。
		$need = '/{[\s\t]*\w+[\(].+[\)][\s\t]*}/';
		$temp_str = preg_replace_callback($need, array($this, '__ret_plain_func'), $temp_str);
		return $temp_str;
	}

	/*
	 * {{func(hoge)}}<?php func(hoge); ?>にするコールバック関数
	 */

	private function __ret_php_func($macth) {
		$str = $macth[0];
		$need = array('/^{{[\s\t]*/', '/[\s\t]*}}$/');
		$str = preg_replace($need, '', $str);
		$str = $this->php_start . $this->__make_func_str($str) . $this->php_end;
		return $str;
	}

	/*
	 * {func(hoge)}を func(hoge) にするコールバック関数
	 */

	private function __ret_plain_func($macth) {
		$str = $macth[0];
		$need = array('/^{[\s\t]*/', '/[\s\t]*}$/');
		$str = preg_replace($need, '', $str);
		$str = $this->__make_func_str($str,FALSE);
		return $str;
	}

	/*
	 * func(hoge)をfunc(hoge);にする
	 */

	private function __make_func_str($str, $end = TRUE) {
		//$end = TRUE=>最後に「;」を付ける。FALSE＝＞付けない
		$ret = '';
		$kanma = (strpos($str, ',') === FALSE) ? mb_strlen($str) : strpos($str, ',');
		$cakko = (strpos($str, '(') === FALSE) ? mb_strlen($str) : strpos($str, '(');
		if ($kanma === mb_strlen($str) && $cakko === mb_strlen($str)) {
			$ret .= $this->__make_hash_str($str);
		} elseif ($kanma < $cakko) {
			$ret .=$this->__separate(',', $str);
		} else {
			$ret .=$this->__separate('(', $str);
		}
		if ($end === TRUE) {
			$ret .= ';';
		}
		return $ret;
	}

	private function __separate($sep, $str) {
		$ret = '';
		$array = explode($sep, $str, 2);
		if ($sep == ',') {
			$ret .= $this->__make_hash_str($array[0]) . ',';
			$ret .= $this->__make_func_str($array[1], FALSE);
		} else {
			$ret .= $this->__make_func_name($array[0]);
			$ret .= $this->__make_func_str($array[1], FALSE);
		}
		return $ret;
	}

	private function __make_func_name($str) {
		$need = array(
			'/^p$/' => 'print('
		);
		$key = array_keys($need);
		$val = array_values($need);
		return preg_replace($key, $val, $str);
	}

	/*
	 * {hoge}と{{}}をコンパイル
	 */

	/* ▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽ */

	private function __hash_compile() {

		$temp_str = $this->temp_str;
		/* {{hoge}}を<?php $hoge; ?>にする。 */
		$need = '/{{[\s\t]*(.+)[\s\t]*}}/';
		$temp_str = preg_replace_callback($need, array($this, '__ret_php_hash'), $temp_str);
		//{hoge}を$hogeにする。
		$need = '/{[\s\t]*(.+)[\s\t]*}/';
		$temp_str = preg_replace_callback($need, array($this, '__ret_plain_hash'), $temp_str);
		return $temp_str;
	}

	/*
	 * 	/*{{hoge}}を<?php $hoge; ?>にする
	 */

	private function __ret_php_hash($str) {
		return $this->php_start . $this->__make_hash_str($str[1]) . $this->php_end;
	}

	/*
	 * {hoge}を形に
	 */

	private function __ret_plain_hash($str) {
		return $this->__make_hash_str($str[1], FALSE);
	}

	private function __make_hash_str($str, $end = FALSE) {
		$array = explode('.', $str);
		$hash = '';
		foreach ($array as $key => $val) {
			if ($key === 0) {
				if (preg_match('/^(\'|\"|<|\$)\w+(\'|\"|>)$/', $val)) {
					$hash .= preg_replace(array('/^</', '/>$/'), '', $val);
				} else {
					if (preg_match('/^\w+[\)]*$/', $val)) {
						$hash .= '$' . $val;
					} else {
						$hash .= $val;
					}
				}
			} else {
				$hash .= '[\'' . $val . '\']';
			}
		}
		if ($end === TRUE) {
			$hash .= ';';
		}
		return $hash;
	}

	/*
	 * forをコンパイル
	 */

	private function __for_compile() {
		$need = array(
			'/{{[\s\t]*foreach[\s\t]+(.+)[\s\t]+}}/' => '<?php foreach ($1) ?>'
		);
		return preg_replace(array_keys($need), array_values($need), $this->temp_str);
	}

	/*
	 * 　ifを形に。 
	 */

	private function __if_compile() {
		$need = array(
			'/{{[\s\t]*if[\s\t]+(.+)[\s\t]+}}/' => '<?php if ($1) ?>'
		);
		return preg_replace(array_keys($need), array_values($need), $this->temp_str);
	}

	/*
	 * ファイル関係の関数
	  ▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽
	  ▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽▼▽
	 */

	/**
	 * 各情報の整理
	 */
	private function __set_hash($file) {
		$this->temp_file_name = $file . '.' . $this->temp_ext;
		$this->temp_file_path = "{$this->base_url}{$this->view_dir}/{$this->temp_file_name}";
	}
	
	

}

?>
