/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application.session;

import java.awt.Component;
import javax.swing.JSplitPane;
import org.jdesktop.application.session.PropertySupport;
import org.jdesktop.application.session.SplitPaneState;

public class SplitPaneProperty
implements PropertySupport {
    private void checkComponent(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("null component");
        }
        if (!(component instanceof JSplitPane)) {
            throw new IllegalArgumentException("invalid component");
        }
    }

    @Override
    public Object getSessionState(Component c) {
        this.checkComponent(c);
        JSplitPane p = (JSplitPane)c;
        return new SplitPaneState(p.getUI().getDividerLocation(p), p.getOrientation());
    }

    @Override
    public void setSessionState(Component c, Object state) {
        this.checkComponent(c);
        if (state == null) {
            return;
        }
        if (state instanceof SplitPaneState) {
            JSplitPane p = (JSplitPane)c;
            SplitPaneState sps = (SplitPaneState)state;
            if (p.getOrientation() == sps.getOrientation()) {
                p.setDividerLocation(sps.getDividerLocation());
            }
        } else {
            throw new IllegalArgumentException("invalid state");
        }
    }
}

