/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package textkeymatcher.util.log;

import java.awt.Dimension;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import textkeymatcher.ui.ErrorDialog;

/**
 * EDTでハンドルされていない例外が発生した場合のハンドラ.<br>
 * @author seraphy
 */
public class AWTExceptionLoggingHandler {
    
    /**
     * ロガー
     */
    private static final Logger logger = Logger.getLogger(AWTExceptionLoggingHandler.class.getName());

    /**
     * AWTに対してハンドルされていない例外が発生した場合のハンドラとしてクラス名を指定するシステムプロパティのキー.<br>
     */
    public static final String PROPERTY_AWT_EXCEPTION_HANDLER = "sun.awt.exception.handler";

    /**
     * AWTに対してハンドルされていない例外が発生した場合のハンドラとして、
     * このハンドラを使うようにシステムプロパティに設定する.<bf>
     */
    public static void initSystemProperty() {
        System.setProperty(PROPERTY_AWT_EXCEPTION_HANDLER,
                AWTExceptionLoggingHandler.class.getName());
    }

    /**
     * 例外のハンドル.<br>
     * @param ex 例外
     */
    public void handle(Throwable ex) {
        // まずはロギング
        logger.log(Level.SEVERE, "exception occurred on the event dispatch thread.  " + ex, ex);

        // エラーダイアログの表示
        ErrorDialog.showErrorDialog(ex);
    }
}
