/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package textkeymatcher.service;

import textkeymatcher.ui.model.ImportDataDialogModel;

/**
 *
 * @author seraphy
 */
public class LineDataBuilderFactory {
    
    private ColumnSplitterFactory columnSplitterFactory = new ColumnSplitterFactory();

    public LineDataBuilder createLineDataBuilder(ImportDataDialogModel dlgModel) {
        if (dlgModel == null) {
            throw new IllegalArgumentException();
        }
        
        ColumnSplitter columnSplitter = columnSplitterFactory.createColumnSplitter(dlgModel);
        
        LineDataBuilder builder = new DefaultLineDataBuilder(
                columnSplitter,
                dlgModel.getKeyColumn(),
                dlgModel.isFullLine() ? -1 : dlgModel.getValueColumn()
                );
        return builder;
    }
    
}
