/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package textkeymatcher.entity;

import java.io.Serializable;

/**
 *
 * @author seraphy
 */
public class LineData implements Serializable {

    private final String key;
    
    private String value;
    
    public LineData(String key) {
        this(key, null);
    }
    
    public LineData(String key, String value) {
        this.key = (key == null) ? "" : key;
        setValue(value);
    }
    
    public final String getKey() {
        return key;
    }
    
    public final String getValue() {
        return value;
    }
    
    public final void setValue(String value) {
        this.value = (value == null) ? "" : value;
    }
    
    @Override
    public int hashCode() {
        return key.hashCode();
    }
    
    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj instanceof LineData) {
            LineData o = (LineData) obj;
            return o.key.equals(this.key);
        }
        return false;
    }

    @Override
    public String toString() {
        return "(" + key + "=" + value + ")";
    }
}
