/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * ImportDataDialog.java
 *
 * Created on 2011/10/09, 14:31:15
 */
package textkeymatcher.ui;

import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.application.Action;
import textkeymatcher.service.PredefinedSimpleSplitCharColumnSplitter;
import textkeymatcher.ui.model.ImportDataDialogModel;

/**
 *
 * @author seraphy
 */
public class ImportDataDialog extends javax.swing.JDialog {
    
    private static final Logger logger = Logger.getLogger(ImportDataDialog.class.getName());

    /** Creates new form ImportDataDialog */
    public ImportDataDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        afterInitComponents();
        syncUI();
    }
    
    private void afterInitComponents() {
        // デフォルトボタン
        JRootPane root = getRootPane();
        root.setDefaultButton(this.importButton);
        
        // キャンセルボタン
        javax.swing.Action actCancel = cancelButton.getAction();
        InputMap im = root.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW);
        im.put(KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), actCancel);

        if (System.getProperty("os.name").toLowerCase().indexOf("mac os x") >= 0) {
            im.put(KeyStroke.getKeyStroke(KeyEvent.VK_W, InputEvent.META_DOWN_MASK), actCancel);
        }
        
        root.getActionMap().put(actCancel, actCancel);
    }
    
    private ComboBoxModel createSimpleSplitCharsModel() {
        // 列挙子をコンボボックスに設定する
        return new DefaultComboBoxModel(PredefinedSimpleSplitCharColumnSplitter.values());
    }
    
    private ComboBoxModel createCharsetComboboxModel() {
        // 可能なキャラクターセット一覧をコンボボックスに設定する.
        List<Charset> charsets = new ArrayList<Charset>(Charset.availableCharsets().values());
        return new DefaultComboBoxModel(charsets.toArray(new Charset[charsets.size()]));
    }
    
    public ListCellRenderer createSimpleSplitCharsRenderer() {
        // コンボボックスに表示する列挙子の表記をリソースから取得するレンダラ
        final org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application
                .getInstance(textkeymatcher.TextKeyMatcherApp.class).getContext()
                .getResourceMap(ImportDataDialog.class);
        return new DefaultListCellRenderer() {
            @Override
            public Component getListCellRendererComponent(JList jlist, Object o, int i, boolean bln, boolean bln1) {
                String disp = "";
                if (o != null) {
                    if (o instanceof PredefinedSimpleSplitCharColumnSplitter) {
                        PredefinedSimpleSplitCharColumnSplitter typ = (PredefinedSimpleSplitCharColumnSplitter) o;
                        disp = resourceMap.getString(typ.name() + ".text");
                    }
                    if (StringUtils.isEmpty(disp)) {
                        disp = o.toString();
                    }
                }
                return super.getListCellRendererComponent(jlist, disp, i, bln, bln1);
            }
            
        };
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        inputSourceButtonGroup = new javax.swing.ButtonGroup();
        dataFormatButtonGroup = new javax.swing.ButtonGroup();
        importDataDialogModel = new textkeymatcher.ui.model.ImportDataDialogModel();
        inputSourcePanel = new javax.swing.JPanel();
        loadTextRadioButton = new javax.swing.JRadioButton();
        loadFileTextField = new javax.swing.JTextField();
        loadFileButton = new javax.swing.JButton();
        directRadioButton = new javax.swing.JRadioButton();
        directTextAreaSP = new javax.swing.JScrollPane();
        directTextArea = new javax.swing.JTextArea();
        jLabel3 = new javax.swing.JLabel();
        charsetComboBox = new javax.swing.JComboBox();
        dataFormatPanel = new javax.swing.JPanel();
        simpleSplitRadioButton = new javax.swing.JRadioButton();
        simpleSplitComboBox = new javax.swing.JComboBox();
        regularExpRadioButton = new javax.swing.JRadioButton();
        regularExpTextField = new javax.swing.JTextField();
        btnPanel = new javax.swing.JPanel();
        filler1 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0), new java.awt.Dimension(0, 0), new java.awt.Dimension(32767, 0));
        cancelButton = new javax.swing.JButton();
        importButton = new javax.swing.JButton();
        KeyValueColumnPanel = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        fullLineCheckBox = new javax.swing.JCheckBox();
        keyColumnSpinner = new javax.swing.JSpinner();
        valueColumnSpinner = new javax.swing.JSpinner();
        jLabel4 = new javax.swing.JLabel();
        titleTextField = new javax.swing.JTextField();

        importDataDialogModel.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                importDataDialogModelPropertyChange(evt);
            }
        });

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(textkeymatcher.TextKeyMatcherApp.class).getContext().getResourceMap(ImportDataDialog.class);
        setTitle(resourceMap.getString("ImportDataDialog.title")); // NOI18N
        setModal(true);
        setName("ImportDataDialog"); // NOI18N
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });

        inputSourcePanel.setBorder(javax.swing.BorderFactory.createTitledBorder(resourceMap.getString("inputSourcePanel.border.title"))); // NOI18N
        inputSourcePanel.setName("inputSourcePanel"); // NOI18N

        inputSourceButtonGroup.add(loadTextRadioButton);
        loadTextRadioButton.setText(resourceMap.getString("loadTextRadioButton.text")); // NOI18N
        loadTextRadioButton.setName("loadTextRadioButton"); // NOI18N

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, importDataDialogModel, org.jdesktop.beansbinding.ELProperty.create("${loadFile}"), loadTextRadioButton, org.jdesktop.beansbinding.BeanProperty.create("selected"));
        bindingGroup.addBinding(binding);

        loadFileTextField.setName("loadFileTextField"); // NOI18N

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, importDataDialogModel, org.jdesktop.beansbinding.ELProperty.create("${sourceFile}"), loadFileTextField, org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        javax.swing.ActionMap actionMap = org.jdesktop.application.Application.getInstance(textkeymatcher.TextKeyMatcherApp.class).getContext().getActionMap(ImportDataDialog.class, this);
        loadFileButton.setAction(actionMap.get("onBrowseFile")); // NOI18N
        loadFileButton.setText(resourceMap.getString("loadFileButton.text")); // NOI18N
        loadFileButton.setName("loadFileButton"); // NOI18N

        inputSourceButtonGroup.add(directRadioButton);
        directRadioButton.setText(resourceMap.getString("directRadioButton.text")); // NOI18N
        directRadioButton.setName("directRadioButton"); // NOI18N

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, importDataDialogModel, org.jdesktop.beansbinding.ELProperty.create("${direct}"), directRadioButton, org.jdesktop.beansbinding.BeanProperty.create("selected"));
        bindingGroup.addBinding(binding);

        directTextAreaSP.setName("directTextAreaSP"); // NOI18N

        directTextArea.setColumns(20);
        directTextArea.setRows(5);
        directTextArea.setName("directTextArea"); // NOI18N

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, importDataDialogModel, org.jdesktop.beansbinding.ELProperty.create("${directText}"), directTextArea, org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        directTextAreaSP.setViewportView(directTextArea);

        jLabel3.setText(resourceMap.getString("jLabel3.text")); // NOI18N
        jLabel3.setName("jLabel3"); // NOI18N

        charsetComboBox.setModel(createCharsetComboboxModel());
        charsetComboBox.setName("charsetComboBox"); // NOI18N

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, importDataDialogModel, org.jdesktop.beansbinding.ELProperty.create("${charset}"), charsetComboBox, org.jdesktop.beansbinding.BeanProperty.create("selectedItem"));
        bindingGroup.addBinding(binding);

        javax.swing.GroupLayout inputSourcePanelLayout = new javax.swing.GroupLayout(inputSourcePanel);
        inputSourcePanel.setLayout(inputSourcePanelLayout);
        inputSourcePanelLayout.setHorizontalGroup(
            inputSourcePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(inputSourcePanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(inputSourcePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, inputSourcePanelLayout.createSequentialGroup()
                        .addGap(29, 29, 29)
                        .addComponent(directTextAreaSP, javax.swing.GroupLayout.DEFAULT_SIZE, 397, Short.MAX_VALUE))
                    .addComponent(loadTextRadioButton)
                    .addGroup(inputSourcePanelLayout.createSequentialGroup()
                        .addGap(29, 29, 29)
                        .addGroup(inputSourcePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addGroup(javax.swing.GroupLayout.Alignment.LEADING, inputSourcePanelLayout.createSequentialGroup()
                                .addComponent(jLabel3)
                                .addGap(18, 18, 18)
                                .addComponent(charsetComboBox, 0, 226, Short.MAX_VALUE))
                            .addComponent(loadFileTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 313, Short.MAX_VALUE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(loadFileButton))
                    .addComponent(directRadioButton))
                .addContainerGap())
        );
        inputSourcePanelLayout.setVerticalGroup(
            inputSourcePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(inputSourcePanelLayout.createSequentialGroup()
                .addComponent(loadTextRadioButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(inputSourcePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(loadFileTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(loadFileButton))
                .addGap(1, 1, 1)
                .addGroup(inputSourcePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(charsetComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(directRadioButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(directTextAreaSP)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        dataFormatPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(resourceMap.getString("dataFormatPanel.border.title"))); // NOI18N
        dataFormatPanel.setName("dataFormatPanel"); // NOI18N

        dataFormatButtonGroup.add(simpleSplitRadioButton);
        simpleSplitRadioButton.setText(resourceMap.getString("simpleSplitRadioButton.text")); // NOI18N
        simpleSplitRadioButton.setName("simpleSplitRadioButton"); // NOI18N

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, importDataDialogModel, org.jdesktop.beansbinding.ELProperty.create("${simpleSplit}"), simpleSplitRadioButton, org.jdesktop.beansbinding.BeanProperty.create("selected"));
        bindingGroup.addBinding(binding);

        simpleSplitComboBox.setModel(createSimpleSplitCharsModel());
        simpleSplitComboBox.setName("simpleSplitComboBox"); // NOI18N
        simpleSplitComboBox.setRenderer(createSimpleSplitCharsRenderer());

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, importDataDialogModel, org.jdesktop.beansbinding.ELProperty.create("${simpleSplitType}"), simpleSplitComboBox, org.jdesktop.beansbinding.BeanProperty.create("selectedItem"));
        bindingGroup.addBinding(binding);

        dataFormatButtonGroup.add(regularExpRadioButton);
        regularExpRadioButton.setText(resourceMap.getString("regularExpRadioButton.text")); // NOI18N
        regularExpRadioButton.setName("regularExpRadioButton"); // NOI18N

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, importDataDialogModel, org.jdesktop.beansbinding.ELProperty.create("${regExp}"), regularExpRadioButton, org.jdesktop.beansbinding.BeanProperty.create("selected"));
        bindingGroup.addBinding(binding);

        regularExpTextField.setName("regularExpTextField"); // NOI18N

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, importDataDialogModel, org.jdesktop.beansbinding.ELProperty.create("${regExpText}"), regularExpTextField, org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        javax.swing.GroupLayout dataFormatPanelLayout = new javax.swing.GroupLayout(dataFormatPanel);
        dataFormatPanel.setLayout(dataFormatPanelLayout);
        dataFormatPanelLayout.setHorizontalGroup(
            dataFormatPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(dataFormatPanelLayout.createSequentialGroup()
                .addGroup(dataFormatPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(dataFormatPanelLayout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(dataFormatPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(dataFormatPanelLayout.createSequentialGroup()
                                .addComponent(simpleSplitRadioButton)
                                .addGap(38, 38, 38)
                                .addComponent(simpleSplitComboBox, 0, 278, Short.MAX_VALUE))
                            .addComponent(regularExpRadioButton)))
                    .addGroup(dataFormatPanelLayout.createSequentialGroup()
                        .addGap(39, 39, 39)
                        .addComponent(regularExpTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 404, Short.MAX_VALUE)))
                .addContainerGap())
        );
        dataFormatPanelLayout.setVerticalGroup(
            dataFormatPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(dataFormatPanelLayout.createSequentialGroup()
                .addGroup(dataFormatPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(simpleSplitRadioButton)
                    .addComponent(simpleSplitComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(regularExpRadioButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(regularExpTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        btnPanel.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 1, 24));
        btnPanel.setName("btnPanel"); // NOI18N
        btnPanel.setLayout(new java.awt.GridBagLayout());

        filler1.setName("filler1"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        btnPanel.add(filler1, gridBagConstraints);

        cancelButton.setAction(actionMap.get("onCancel")); // NOI18N
        cancelButton.setText(resourceMap.getString("cancelButton.text")); // NOI18N
        cancelButton.setName("cancelButton"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        btnPanel.add(cancelButton, gridBagConstraints);

        importButton.setAction(actionMap.get("onAccept")); // NOI18N
        importButton.setText(resourceMap.getString("importButton.text")); // NOI18N
        importButton.setName("importButton"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        btnPanel.add(importButton, gridBagConstraints);

        KeyValueColumnPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(resourceMap.getString("KeyValueColumnPanel.border.title"))); // NOI18N
        KeyValueColumnPanel.setName("KeyValueColumnPanel"); // NOI18N

        jLabel1.setText(resourceMap.getString("jLabel1.text")); // NOI18N
        jLabel1.setName("jLabel1"); // NOI18N

        jLabel2.setText(resourceMap.getString("jLabel2.text")); // NOI18N
        jLabel2.setName("jLabel2"); // NOI18N

        fullLineCheckBox.setText(resourceMap.getString("fullLineCheckBox.text")); // NOI18N
        fullLineCheckBox.setName("fullLineCheckBox"); // NOI18N

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, importDataDialogModel, org.jdesktop.beansbinding.ELProperty.create("${fullLine}"), fullLineCheckBox, org.jdesktop.beansbinding.BeanProperty.create("selected"));
        bindingGroup.addBinding(binding);

        keyColumnSpinner.setModel(new javax.swing.SpinnerNumberModel(Integer.valueOf(0), Integer.valueOf(0), null, Integer.valueOf(1)));
        keyColumnSpinner.setName("keyColumnSpinner"); // NOI18N

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, importDataDialogModel, org.jdesktop.beansbinding.ELProperty.create("${keyColumn}"), keyColumnSpinner, org.jdesktop.beansbinding.BeanProperty.create("value"));
        bindingGroup.addBinding(binding);

        valueColumnSpinner.setModel(new javax.swing.SpinnerNumberModel(Integer.valueOf(0), Integer.valueOf(0), null, Integer.valueOf(1)));
        valueColumnSpinner.setName("valueColumnSpinner"); // NOI18N

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, importDataDialogModel, org.jdesktop.beansbinding.ELProperty.create("${valueColumn}"), valueColumnSpinner, org.jdesktop.beansbinding.BeanProperty.create("value"));
        bindingGroup.addBinding(binding);

        javax.swing.GroupLayout KeyValueColumnPanelLayout = new javax.swing.GroupLayout(KeyValueColumnPanel);
        KeyValueColumnPanel.setLayout(KeyValueColumnPanelLayout);
        KeyValueColumnPanelLayout.setHorizontalGroup(
            KeyValueColumnPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(KeyValueColumnPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addGap(18, 18, 18)
                .addComponent(keyColumnSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, 63, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel2)
                .addGap(2, 2, 2)
                .addComponent(valueColumnSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, 58, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(fullLineCheckBox)
                .addContainerGap(104, Short.MAX_VALUE))
        );
        KeyValueColumnPanelLayout.setVerticalGroup(
            KeyValueColumnPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(KeyValueColumnPanelLayout.createSequentialGroup()
                .addGroup(KeyValueColumnPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(KeyValueColumnPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jLabel1)
                        .addComponent(jLabel2)
                        .addComponent(fullLineCheckBox))
                    .addComponent(keyColumnSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(valueColumnSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jLabel4.setText(resourceMap.getString("jLabel4.text")); // NOI18N
        jLabel4.setName("jLabel4"); // NOI18N

        titleTextField.setName("titleTextField"); // NOI18N

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, importDataDialogModel, org.jdesktop.beansbinding.ELProperty.create("${title}"), titleTextField, org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel4)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(titleTextField, javax.swing.GroupLayout.DEFAULT_SIZE, 356, Short.MAX_VALUE)
                .addContainerGap())
            .addComponent(btnPanel, javax.swing.GroupLayout.DEFAULT_SIZE, 475, Short.MAX_VALUE)
            .addComponent(KeyValueColumnPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addComponent(dataFormatPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addComponent(inputSourcePanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel4)
                    .addComponent(titleTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(inputSourcePanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(dataFormatPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(KeyValueColumnPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(btnPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        bindingGroup.bind();

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
     * モデルが変更された場合に呼び出されるハンドラ
     * @param evt 
     */
    private void importDataDialogModelPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_importDataDialogModelPropertyChange
        syncUI();
    }//GEN-LAST:event_importDataDialogModelPropertyChange

    private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
        onCancel();
    }//GEN-LAST:event_formWindowClosing

    /**
     * モデルの状態で入力・ボタンフィールドの有効・無効を設定する.
     */
    private void syncUI() {
        loadFileTextField.setEnabled(importDataDialogModel.isLoadFile());
        loadFileButton.setEnabled(importDataDialogModel.isLoadFile());
        directTextAreaSP.setEnabled(importDataDialogModel.isDirect());
        directTextArea.setEnabled(importDataDialogModel.isDirect());
        charsetComboBox.setEnabled(importDataDialogModel.isLoadFile());

        simpleSplitComboBox.setEnabled(importDataDialogModel.isSimpleSplit());
        regularExpTextField.setEnabled(importDataDialogModel.isRegExp());
        
        valueColumnSpinner.setEnabled( !importDataDialogModel.isFullLine());
        keyColumnSpinner.setEnabled(true);
        
        setEnableAccept(importDataDialogModel.isValid());
    }
    
    private ImportDataDialogModel resultModel;
    
    @Action(enabledProperty = "enableAccept")
    public void onAccept() {
        resultModel = new ImportDataDialogModel();
        importDataDialogModel.copyTo(resultModel);
        dispose();
    }

    @Action
    public void onCancel() {
        resultModel = null;
        dispose();
    }
    
    public ImportDataDialogModel getResultModel() {
        return resultModel;
    }
    
    public void setModel(ImportDataDialogModel model) {
        if (model == null) {
            throw new IllegalArgumentException();
        }
        model.copyTo(importDataDialogModel);
    }

    private boolean enableAccept = false;
    public boolean isEnableAccept() {
        return enableAccept;
    }

    public void setEnableAccept(boolean b) {
        boolean old = isEnableAccept();
        this.enableAccept = b;
        firePropertyChange("enableAccept", old, isEnableAccept());
    }

    
    /**
     * テキストファイル拡張子フィルタ
     */
    private static final FileFilter TEXT_FILE_FILTER = new FileFilter() {

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String name = file.getName();
            return name.toLowerCase().endsWith(".txt");
        }

        @Override
        public String getDescription() {
            return "Text (*.txt)";
        }
    };
    
    /**
     * 最後に使用したディレクトリ
     */
    private File lastUseDirectory;
    
    public File getLastUseDirectory() {
        return lastUseDirectory;
    }
    
    public void setLastUseDirectory(File lastUseDirectory) {
        this.lastUseDirectory = lastUseDirectory;
    }

    /**
     * ファイルを選択する
     */
    @Action
    public void onBrowseFile() {
        JFileChooser fileChooser = new JFileChooser(lastUseDirectory);
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.addChoosableFileFilter(TEXT_FILE_FILTER);
        fileChooser.setFileFilter(TEXT_FILE_FILTER);
        int ret = fileChooser.showOpenDialog(this);
        if (ret != JFileChooser.APPROVE_OPTION) {
            // cancel
            return;
        }
        
        File selectedFile = fileChooser.getSelectedFile();
        lastUseDirectory = selectedFile.getParentFile();

        importDataDialogModel.setSourceFile(selectedFile.getPath());
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel KeyValueColumnPanel;
    private javax.swing.JPanel btnPanel;
    private javax.swing.JButton cancelButton;
    private javax.swing.JComboBox charsetComboBox;
    private javax.swing.ButtonGroup dataFormatButtonGroup;
    private javax.swing.JPanel dataFormatPanel;
    private javax.swing.JRadioButton directRadioButton;
    private javax.swing.JTextArea directTextArea;
    private javax.swing.JScrollPane directTextAreaSP;
    private javax.swing.Box.Filler filler1;
    private javax.swing.JCheckBox fullLineCheckBox;
    private javax.swing.JButton importButton;
    private textkeymatcher.ui.model.ImportDataDialogModel importDataDialogModel;
    private javax.swing.ButtonGroup inputSourceButtonGroup;
    private javax.swing.JPanel inputSourcePanel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JSpinner keyColumnSpinner;
    private javax.swing.JButton loadFileButton;
    private javax.swing.JTextField loadFileTextField;
    private javax.swing.JRadioButton loadTextRadioButton;
    private javax.swing.JRadioButton regularExpRadioButton;
    private javax.swing.JTextField regularExpTextField;
    private javax.swing.JComboBox simpleSplitComboBox;
    private javax.swing.JRadioButton simpleSplitRadioButton;
    private javax.swing.JTextField titleTextField;
    private javax.swing.JSpinner valueColumnSpinner;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables
}
