package kisscelltopng.logic;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Caches<T> extends AbstractMap<String, T> {

	private Map<String, Reference<T>> caches = new HashMap<String, Reference<T>>();
	
	@Override
	public int size() {
		return caches.size();
	}
	
	@Override
	public void clear() {
		caches.clear();
	}
	
	protected Reference<T> createReference(T value) {
		return new SoftReference<T>(value);
	}
	
	@Override
	public T put(String key, T value) {
		Reference<T> ref = createReference(value);
		Reference<T> oldref = caches.put(key, ref);
		return oldref == null ? null : oldref.get();
	}
	
	@Override
	public T get(Object key) {
		Reference<T> ref = caches.get(key);
		if (ref == null) {
			return null;
		}
		return ref.get();
	}
	
	@Override
	public Set<Map.Entry<String, T>> entrySet() {
		return new AbstractSet<Map.Entry<String, T>>() {
			@Override
			public int size() {
				return caches.size();
			}
			@Override
			public Iterator<Map.Entry<String, T>> iterator() {
				final Iterator<Map.Entry<String, Reference<T>>> ite = caches.entrySet().iterator();
				return new Iterator<Map.Entry<String, T>>() {
					public boolean hasNext() {
						return ite.hasNext();
					}
					public Map.Entry<String, T> next() {
						final Map.Entry<String, Reference<T>> entry = ite.next();
						return new Map.Entry<String, T>() {
							public String getKey() {
								return entry.getKey();
							}
							public T getValue() {
								Reference<T> ref = entry.getValue();
								return ref == null ? null : ref.get();
							}
							public T setValue(T value) {
								Reference<T> oldref = entry.getValue();
								Reference<T> ref = createReference(value);
								entry.setValue(ref);
								return oldref == null ? null : oldref.get();
							}
						};
					}
					public void remove() {
						ite.remove();
					}
				};
			}
		};
	}
}
