package kisscelltopng.logic;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import kisscelltopng.ui.model.CellsTableItem;
import kisscelltopng.ui.model.CellsTablePaneModel;

public abstract class AbstractDataConverter implements DataConverter {

	public void save(File destDir, CellsTablePaneModel model) throws IOException {
		if (destDir == null || !destDir.isDirectory()) {
			throw new IllegalArgumentException();
		}

		int mx = model.getRowCount();
		for (int idx = 0; idx < mx; idx++) {
			CellsTableItem item = model.get(idx);
			if (!item.isSelected()) {
				continue;
			}
			
			String cellName = item.getCellName();
			if (cellName == null || cellName.trim().length() == 0) {
				continue;
			}

			BufferedImage img = getImage(item);

			String outDirName = item.getOutdir();
			File outDir;
			if (outDirName != null && outDirName.trim().length() > 0) {
				outDir = new File(destDir, outDirName.trim());
			} else {
				outDir = destDir;
			}
			
			if ( !outDir.exists()) {
				outDir.mkdirs();
			}
			
			writeImage(outDir, cellName, img);
		}
	}
	
	protected abstract void writeImage(File outDir, String cellName, BufferedImage img) throws IOException;

}
