package kisscelltopng;

import kisscelltopng.ui.MainFrame;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;

/**
 * Mac OS X用のメインフレームサポートクラス.<br>
 * スクリーンメニューのハンドラなどを接続している.<br>
 * @author seraphy
 */
public class SetupMacScreenMenu {

	public static void connect(final MainFrame mainFrame) {
		if (mainFrame == null) {
			throw new IllegalArgumentException();
		}

		Application app = Application.getApplication();

		app.setEnabledAboutMenu(true);
		app.setEnabledPreferencesMenu(false);

		ApplicationAdapter listener = new ApplicationAdapter() {
			public void handleAbout(ApplicationEvent arg0) {
				mainFrame.onAbout();
				arg0.setHandled(true);
			}

			public void handleQuit(ApplicationEvent arg0) {
				mainFrame.onClose();
				arg0.setHandled(true);
				// JVMを明示的にシャットダウンする. (何もしないと強制終了になるため。)
				System.exit(0);
			}

			public void handlePreferences(ApplicationEvent arg0) {
				arg0.setHandled(true);
			}
		};
		app.addApplicationListener(listener);

//		try {
//			Class<?> clz = app.getClass();
//			Method mtd = clz.getMethod("setDockIconImage",
//					new Class[] { Image.class });
//			mtd.invoke(app, new Object[] { mainFrame.icon });
//
//		} catch (NoSuchMethodException ex) {
//			// メソッドがない = Tiger以前の失敗であろうから、単に無視するだけで良い.
//			logger.log(Level.CONFIG, "dockIcon not supported.", ex);
//
//		} catch (Exception ex) {
//			// 実行時の失敗だが、DockIconが設定できないだけなので継続する.
//			logger.log(Level.WARNING, "dockIcon failed.", ex);
//		}
	}

}
