/*
 *  The MIT License
 * 
 *  Copyright 2011 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 * 
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 * 
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 * 
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package org.routine_work.simple_battery_logger;

import android.os.BatteryManager;

/**
 *
 * @author sawai
 */
public interface BatteryConstants
{

	String PACKAGE_NAME = "org.routine_work.simple_battery_logger";
	// Action and Extra key for BroadcastIntent
	String EXPORT_ONE_DAY_DATA_CSV_FILE_COMPLETED_ACTION = PACKAGE_NAME + ".EXPORT_ONE_DAY_DATA_CSV_FILE_COMPLETED";
	String DELETE_ALL_CSV_FILE_COMPLETED_ACTION = PACKAGE_NAME + ".DELETE_ALL_CSV_FILE_COMPLETED";
	String DELETE_ALL_DATA_COMPLETED_ACTION = PACKAGE_NAME + ".DELETE_ALL_DATA_COMPLETED";
	String EXTRA_RESULT = PACKAGE_NAME + ".RESULT";
	String EXTRA_DATE = PACKAGE_NAME + ".DATE";
	String EXTRA_CSV_FILE_PATH = PACKAGE_NAME + ".CSV_FILE_PATH";
	//  Extra keys for Intent.ACTION_BATTERY_CHANGED
	String EXTRA_STATUS = "status";
	String EXTRA_HEALTH = "health";
	String EXTRA_PLUGGED = "plugged";
	String EXTRA_ICON_SMALL = "icon-small";
	String EXTRA_LEVEL = "level";
	String EXTRA_SCALE = "scale";
	String EXTRA_VOLTAGE = "voltage";
	String EXTRA_TEMPERATURE = "temperature";
	String EXTRA_TECHNOLOGY = "technology";
	// BatteryManager
	// BATTERY_STATUS
	int BATTERY_STATUS_UNKNOWN = BatteryManager.BATTERY_STATUS_UNKNOWN;
	int BATTERY_STATUS_CHARGING = BatteryManager.BATTERY_STATUS_CHARGING;
	int BATTERY_STATUS_DISCHARGING = BatteryManager.BATTERY_STATUS_DISCHARGING;
	int BATTERY_STATUS_NOT_CHARGING = BatteryManager.BATTERY_STATUS_NOT_CHARGING;
	int BATTERY_STATUS_FULL = BatteryManager.BATTERY_STATUS_FULL;
	// BATTERY_HEALTH
	int BATTERY_HEALTH_UNKNOWN = BatteryManager.BATTERY_HEALTH_UNKNOWN;
	int BATTERY_HEALTH_GOOD = BatteryManager.BATTERY_HEALTH_GOOD;
	int BATTERY_HEALTH_OVERHEAT = BatteryManager.BATTERY_HEALTH_OVERHEAT;
	int BATTERY_HEALTH_DEAD = BatteryManager.BATTERY_HEALTH_DEAD;
	int BATTERY_HEALTH_OVER_VOLTAGE = BatteryManager.BATTERY_HEALTH_OVER_VOLTAGE;
	int BATTERY_HEALTH_UNSPECIFIED_FAILURE = BatteryManager.BATTERY_HEALTH_UNSPECIFIED_FAILURE;
	int BATTERY_HEALTH_COLD = 0x00000007; // BatteryManager.BATTERY_HEALTH_COLD : Added in API Level 11
	// BATTERY_PLUGGED
	int BATTERY_PLUGGED_AC = BatteryManager.BATTERY_PLUGGED_AC;
	int BATTERY_PLUGGED_USB = BatteryManager.BATTERY_PLUGGED_USB;
	int BATTERY_PLUGGED_WIRELESS = 0x00000004; // BatteryManager.BATTERY_PLUGGED_WIRELESS : Added in API Level 17
}
