#include "testApp.h"

static bool bRecording = false;
//--------------------------------------------------------------
void testApp::setup(){

	saver.listCodecs();
    saver.setCodecType(4); //ZACH FIX see recording quicktime with sound in sync on of forum　←エンコード設定
    saver.setCodecQualityLevel(OF_QT_SAVER_CODEC_QUALITY_MAX);
	const string name = "/Users/samb/output.mov";
    saver.setup(1024, 768, name);
    bRecording = !bRecording;
	
#if 0
	// video
	camWidth 		= 320;	// try to grab at this size. 
	camHeight 		= 240;
	
	vidGrabber.setVerbose(true);
	vidGrabber.initGrabber(camWidth,camHeight);
	
	videoInverted 	= new unsigned char[camWidth*camHeight*3];
	//videoTexture.allocate(camWidth,camHeight, GL_RGB);
	
	// create a unique file name for this movie file
	createFileName();
	
	// initialize a timestamp which we'll use to properly
	// time the frame as they're added to the movie
	mTimestamp = ofGetElapsedTimef();
	
	// init the movie saver
    mVidSaver.setCodecQualityLevel(OF_QT_SAVER_CODEC_QUALITY_NORMAL);
    mVidSaver.setup(camWidth, camHeight, mFileName);
#endif

	
	ofBackground(34, 34, 34);

	// 2 output channels,
	// 0 input channels
	// 22050 samples per second
	// 512 samples per buffer
	// 4 num buffers (latency)
	
	int bufferSize		= 512;
	sampleRate 			= 44100;
	phase 				= 0;
	phaseAdder 			= 0.0f;
	phaseAdderTarget 	= 0.0f;
	volume				= 0.1f;
	bNoise 				= false;

	lAudio.assign(bufferSize, 0.0);
	rAudio.assign(bufferSize, 0.0);
	
	//soundStream.listDevices();
	
	//if you want to set the device id to be different than the default
	//soundStream.setDeviceID(1); 	//note some devices are input only and some are output only 

	soundStream.setup(this, 2, 0, sampleRate, bufferSize, 4);


	cnt = 0;

	//-- of dir
	dir.listDir("/Users/samb/Pictures/pict_data_mknakami/");
	dir.sort();

	if( dir.size() ) {
		images.assign( dir.size(), ofImage() );
	}

	for( int i = 0; i < (int) dir.size(); i++ ) {
		printf("get path : %s\n", dir.getPath(i).c_str());
		images[i].loadImage( dir.getPath( i ) );
	}

	
	ofSetFrameRate(60);
}


//--------------------------------------------------------------
void testApp::update(){
#if 0
	vidGrabber.grabFrame();
	
	if (vidGrabber.isFrameNew()){
		// figure out how much time elapsed since the last frame
		float time = ofGetElapsedTimef() - mTimestamp;
		
		// add this frame to the movie
		mVidSaver.addFrame(vidGrabber.getPixels(), time);
		
		// update the timestamp to the current time
		mTimestamp = ofGetElapsedTimef();
	}
#endif
}

//--------------------------------------------------------------
void testApp::draw() {

	grabbedImage.grabScreen(0, 0, 1600,900);// copy!
    if (bRecording == true){
        saver.addFrame(grabbedImage.getPixels(), 4.0f / 30.0f);
        //  you can also pass in the frameRate:
        //  saver.addFrame(vidGrabber.getPixels(), 1.0f / 30.0f);  // 30 fps for this frame
        //  saver.addFrame(vidGrabber.getPixels(), 1.0f / 5.0f);   // 5 fps for this frame, etc....
 
    }

	//ofSetColor(255);
	cnt++;

	ofNoFill();

	ofPushMatrix();
	ofTranslate(0, 0, 0);
	
#if 0
	// video
	vidGrabber.draw(0,0);
#endif
	
	int h = ofGetViewportHeight();
	int w = ofGetViewportWidth();


	glEnable(GL_DEPTH);

	float accel = 8.0;
	accel = (accel * 0.6) + (1.0 * 0.2);
	float speedPixelPerFrame = 5 * accel;
	int x_offset = cnt * speedPixelPerFrame * -1;
	int pictSizeX = 50;
	int pictSizeY = 50;
	int pictPosZ = -500;
	double pictSpan = 0.2;
	
	for( int i = 0; i < (int) dir.size(); i++ ) {
		x_offset += pictSizeX * (1.0 + pictSpan);
		if( -w < x_offset && x_offset < w*2) {
			images[i].draw( x_offset, h/2, pictPosZ, pictSizeX, pictSizeY );
		}
	}
		
#if 0
	ofSetColor(225);
	ofDrawBitmapString("AUDIO OUTPUT EXAMPLE", 32, 32);
	ofDrawBitmapString("press 's' to unpause the audio\npress 'e' to pause the audio", 31, 92);

	ofNoFill();

	
	
	// draw the left channel:
	ofPushStyle();
		ofPushMatrix();
		ofTranslate(32, 150, 0);
			
		ofSetColor(225);
		ofDrawBitmapString("Left Channel", 4, 18);
		
		ofSetLineWidth(1);	
		ofRect(0, 0, 900, 200);

		ofSetColor(245, 58, 135);
		ofSetLineWidth(3);
					
			ofBeginShape();
			for (int i = 0; i < lAudio.size(); i++){
				float x =  ofMap(i, 0, lAudio.size(), 0, 900, true);
				ofVertex(x, 100 -lAudio[i]*180.0f);
			}
			ofEndShape(false);
			
		ofPopMatrix();
	ofPopStyle();

	// draw the right channel:
	ofPushStyle();
		ofPushMatrix();
		ofTranslate(32, 350, 0);
			
		ofSetColor(225);
		ofDrawBitmapString("Right Channel", 4, 18);
		
		ofSetLineWidth(1);	
		ofRect(0, 0, 900, 200);

		ofSetColor(245, 58, 135);
		ofSetLineWidth(3);
					
			ofBeginShape();
			for (int i = 0; i < rAudio.size(); i++){
				float x =  ofMap(i, 0, rAudio.size(), 0, 900, true);
				ofVertex(x, 100 -rAudio[i]*180.0f);
			}
			ofEndShape(false);
			
		ofPopMatrix();
	ofPopStyle();
	
		
	ofSetColor(225);
	string reportString = "volume: ("+ofToString(volume, 2)+") modify with -/+ keys\npan: ("+ofToString(pan, 2)+") modify with mouse x\nsynthesis: ";
	if( !bNoise ){
		reportString += "sine wave (" + ofToString(targetFrequency, 2) + "hz) modify with mouse y";
	}else{
		reportString += "noise";	
	}
	ofDrawBitmapString(reportString, 32, 579);

#endif // 0

}

#if 0
void testApp::createFileName(void)
{
    // create a uniqe file name
	ostringstream oss;
	oss << ofGetYear() << "-";
	oss << setw(2) << setfill('0') << ofGetMonth() << "-";
	oss << setw(2) << setfill('0') << ofGetDay() << "-";
	oss << setw(2) << setfill('0') << ofGetHours() << "-";
	oss << setw(2) << setfill('0') << ofGetMinutes() << "-";
	oss << setw(2) << setfill('0') << ofGetSeconds() << ".mov";
	mFileName = oss.str();	
}
#endif

//--------------------------------------------------------------
void testApp::keyPressed  (int key){
	if (key == '-' || key == '_' ){
		volume -= 0.05;
		volume = MAX(volume, 0);
	} else if (key == '+' || key == '=' ){
		volume += 0.05;
		volume = MIN(volume, 1);
	}
	
	if( key == 's' ){
		soundStream.start();
	}
	
	if( key == 'e' ){
		soundStream.stop();
	}
	
}

//--------------------------------------------------------------
void testApp::keyReleased  (int key){
	saver.finishMovie();
	bRecording = false;
}

//--------------------------------------------------------------
void testApp::mouseMoved(int x, int y ){
	int width = ofGetWidth();
	pan = (float)x / (float)width;
	float height = (float)ofGetHeight();
	float heightPct = ((height-y) / height);
	targetFrequency = 2000.0f * heightPct;
	phaseAdderTarget = (targetFrequency / (float) sampleRate) * TWO_PI;
}

//--------------------------------------------------------------
void testApp::mouseDragged(int x, int y, int button){
	int width = ofGetWidth();
	pan = (float)x / (float)width;
}

//--------------------------------------------------------------
void testApp::mousePressed(int x, int y, int button){
	bNoise = true;
}


//--------------------------------------------------------------
void testApp::mouseReleased(int x, int y, int button){
	bNoise = false;
}

//--------------------------------------------------------------
void testApp::windowResized(int w, int h){

}

//--------------------------------------------------------------
void testApp::audioOut(float * output, int bufferSize, int nChannels){

#if 0
	//pan = 0.5f;
	float leftScale = 1 - pan;
	float rightScale = pan;

	// sin (n) seems to have trouble when n is very large, so we
	// keep phase in the range of 0-TWO_PI like this:
	while (phase > TWO_PI){
		phase -= TWO_PI;
	}

	if ( bNoise == true){
		// ---------------------- noise --------------
		for (int i = 0; i < bufferSize; i++){
			lAudio[i] = output[i*nChannels    ] = ofRandom(0, 1) * volume * leftScale;
			rAudio[i] = output[i*nChannels + 1] = ofRandom(0, 1) * volume * rightScale;
		}
	} else {
		phaseAdder = 0.95f * phaseAdder + 0.05f * phaseAdderTarget;
		for (int i = 0; i < bufferSize; i++){
			phase += phaseAdder;
			float sample = sin(phase);
			lAudio[i] = output[i*nChannels    ] = sample * volume * leftScale;
			rAudio[i] = output[i*nChannels + 1] = sample * volume * rightScale;
		}
	}
#endif
}

//--------------------------------------------------------------
void testApp::gotMessage(ofMessage msg){

}

//--------------------------------------------------------------
void testApp::dragEvent(ofDragInfo dragInfo){ 

}
