//
//  GrUnit.cpp
//  myNewApp
//
//  Created by 三分一 修 on 2012/10/05.
//
//

#include "common.h"
#include "GrUnit.h"
#include "GrPort.h"

using namespace std;

GrUnit::~GrUnit()
{
    printfunc;
    
    // ここで消したらダメ？
    unitPortMap.clear();
    
    // grPortはDeadListener登録されているので、このオブジェクトが消滅したタイミングで
    // ~DeadNotifier()が呼び出されて、GrPortにDead通知が飛ぶ
}

GrPort *GrUnit::getPortByName(const std::string &key)
{
    map<string, ofPtr<GrPort> >::iterator itr = unitPortMap.find(key);
    if(itr != unitPortMap.end()) // nameをkeyとする値が登録されている
    {
//        return ((ofPtr<GrPort>)((*itr).second)).get();
        return (*itr).second.get();
    }
    return NULL;
}

bool GrUnit::setPortValue(const std::string &key, float value)
{
    map<string, ofPtr<GrPort> >::iterator itr = unitPortMap.find(key);
    if(itr != unitPortMap.end())
    {
        (*itr).second->set(value);
        return true;
    }
    return false;
}

void GrUnit::addPort(string portName, GrPort *grPort)
{
    unitPortMap.insert(map<string, GrPort*>::value_type(portName, grPort));
	// Release from ofPtr -> delete ??
    //addDeadListener((DeadListener*)grPort); // null pointer?
}
