//
//  GrMain.cpp
//  myNewApp
//
//  Created by 三分一 修 on 2012/09/19.
//
//

#include <vector>
#include <stdio.h>
#include "GrMain.h"
#include "GrDrawer.h"
#include "GrUpdater.h"
#include "GrPoint.h"
#include "GrGrab.h"
#include "GrMouse.h"

GrMain::GrMain()
{
    ofLogToConsole();
}

#pragma mark -- Loop Proc --
void GrMain::update()
{
    // add preAdd Member
    mPreAddLock.lock();
    for(std::vector<GrBase*>::iterator itr = mPreAddMember.begin(); itr != mPreAddMember.end(); itr++)
    {
        addMemberImpl((GrBase*)*itr);
    }
    mPreAddMember.clear();
    mPreAddLock.unlock();

    // update GrUpdater
    for(std::vector<GrUpdater*>::iterator itr = mGrUpdates.begin(); itr != mGrUpdates.end(); itr++)
    {
        ((GrUpdater*)*itr)->update();
    }
}

/* -- Draw -- */
void GrMain::draw()
{
    // draw GrDrawer
    for(std::vector<GrDrawer*>::iterator itr = mGrDraws.begin(); itr != mGrDraws.end(); itr++)
    {
        ((GrDrawer*)*itr)->draw();
    }
}

/* -- Mouse -- */
void GrMain::mouseMoved(int x, int y)
{
	for(std::vector<GrMouse*>::iterator itr = mGrMouses.begin(); itr != mGrMouses.end(); itr++) {
		((GrMouse*)*itr)->mouseMoved(x, y);
	}
}

void GrMain::mouseDragged(int x, int y, int button)
{
	for(std::vector<GrMouse*>::iterator itr = mGrMouses.begin(); itr != mGrMouses.end(); itr++) {
		((GrMouse*)*itr)->mouseDragged(x, y, button);
	}
}

void GrMain::mousePressed(int x, int y, int button)
{
	for(std::vector<GrMouse*>::iterator itr = mGrMouses.begin(); itr != mGrMouses.end(); itr++) {
		((GrMouse*)*itr)->mousePressed(x, y, button);
	}
}

void GrMain::mouseReleased(int x, int y, int button)
{
	for(std::vector<GrMouse*>::iterator itr = mGrMouses.begin(); itr != mGrMouses.end(); itr++) {
		((GrMouse*)*itr)->mouseReleased(x, y, button);
	}
}

// add member routine
void GrMain::add(GrBase *grBase)
{
    mPreAddLock.lock();
    mPreAddMember.push_back(grBase);
    mPreAddLock.unlock();
}

# pragma mark --- private method ---
void GrMain::addMemberImpl(GrBase *grBase)
{
	// Add Member All
	mGrBase.push_back(ofPtr<GrBase>(grBase));
	
    // Add Member Drawer ( GrDraw )
    GrDrawer *drawer = dynamic_cast<GrDrawer*>(grBase);
    if(NULL != drawer)
    {
        mGrDraws.push_back((GrDrawer*)drawer);
    }
    
    // Add Member Updater ( GrUpdater )
    GrUpdater *updater = dynamic_cast<GrUpdater*>(grBase);
    if(NULL != updater)
    {
        mGrUpdates.push_back((GrUpdater*)updater);
    }

    // Add Member Mouse ( GrMouse )
    GrMouse *mouse = dynamic_cast<GrMouse*>(grBase);
    if(NULL != mouse)
    {
        mGrMouses.push_back((GrMouse*)mouse);
    }
}

inline void ofLoggingTouchEvent(char *name, ofTouchEventArgs &touch)
{
    ofLog(OF_LOG_ERROR, "%s,%d,%d,%f,%f,%d", name, touch.id, touch.time, touch.x, touch.y, touch.numTouches);
}
