//
//  GrDraw.h
//  myNewApp
//
//  Created by 三分一 修 on 2012/10/02.
//
//

#ifndef __myNewApp__GrDraw__
#define __myNewApp__GrDraw__

#include <iostream>

#include "GrBase.h"

#pragma mark --- GrDraw Interface ---
class GrDrawer : public virtual GrBase {
public:
    virtual void draw() = 0;
};

#pragma mark --- GrDraw Implements ---

#include "ofMain.h"

class GrLine : public GrDrawer {
public:
    void draw();
};

class GrCircle : public GrDrawer {
private:
    ofVec2f mXy;
    float mSize;
    
public:
    GrCircle(float x, float y, float size);
    void setLocation(ofVec2f &vec);
    const ofVec2f &getLocation() const;
    void draw();
};


#endif /* defined(__myNewApp__GrDraw__) */
