//
//  AuMain.h
//  myNewApp
//
//  Created by 三分一 修 on 2012/09/11.
//
//

#ifndef __myNewApp__AuMain__
#define __myNewApp__AuMain__

#include <iostream>
#include <queue>

#include "SineWave.h"

class PGen {
public:
    virtual double tick() = 0;
};

class PGenValue : public PGen {
private:
    double mValue;
public:
    PGenValue(double value) : mValue(value) {}
    PGenValue &operator =(double value) {
        mValue = value;
        return *this;
    }
    double tick() {
        return mValue;
    }
};

class PPort {
private:
    PGenValue mValue;
    PGen *gen;
public:
    PPort() : mValue(0), gen( &mValue ) {}
    explicit PPort(double value) : mValue(value), gen( &mValue ) {}
    
    void set(PGen *gen) { this->gen = gen; }
    void set(double value) {
        this->gen = &mValue;
        mValue = value;
    }
    
    double get() {
        return gen->tick();
    }
    operator double() {
        return get();
    }
};

class PMlt : public PGen {
public:
    PMlt() : a(1), b(1) {}
    PPort a, b;
    double tick() {
        return ( a.get() * b.get() );
    }
};

class PAdd : public PGen {
public:
    PAdd() : a(1), b(1) {}
    PPort a, b;
    double tick() {
        return ( a.get() + b.get() );
    }
};


class PStkSin : public PGen {
private:
    stk::SineWave mSin;
public:
    PStkSin(double freq = 440, double amp = 1.0) : freq(freq), amp(amp) {}
    PPort freq, amp;
    double tick() {
        mSin.setFrequency( freq );
        return ( amp.get() * mSin.tick() );
    }
};

class PAudioMessage {
public:
    void *port;
    long tickTime;
    double value;
};

class AuMain {
private:
    unsigned int mSamplingRate;
    unsigned int mBufferSize;
    PStkSin *sin1, *sin2, *sin3;
    PMlt mlt;
    PAdd add;
    float mVolume;
    float mPan;
    
public:
    AuMain(unsigned int bufferSize);
    void audioOut(float *output, int size, int channels);
    
    float volume() { return mVolume; }
    float pan() { return mPan; }
};

#endif /* defined(__myNewApp__AuMain__) */
