//
//  AuMain.cpp
//  myNewApp
//
//  Created by 三分一 修 on 2012/09/11.
//
//
#include "AuMain.h"
#include <math.h>

using namespace stk;

AuMain::AuMain(unsigned int bufferSize) :
    mSamplingRate(44100),
    mBufferSize(bufferSize),
    mVolume(1.0),
    mPan(0.5)
{
    sin1 = new PStkSin(880, 0.5);
    sin2 = new PStkSin(1, 0.3);
    
    add.a.set(1.0);
    add.b.set(sin2);
    
    sin1->amp.set(&add);
}

void AuMain::audioOut(float *output, int size, int channels)
{
    if(channels == 1) { // mono
        for(int i = 0; i < size; i++) {
            double v = sin1->tick();
            output[i] = v * mVolume;
        }
    } else { // stereo
        for(int i = 0; i < size; i++) {
            double v = sin1->tick();
            output[i*channels  ] = v * mVolume * (1.0 - mPan);
            output[i*channels+1] = v * mVolume * mPan;
        }
    }
}

static void audioOutSinTest(double *output, int size, int channels)
{
    static float oscPhase = 0;
    static float oscFreq = 440;
    static float oscGain = 0.5;
    
    for(int i = 0; i < size; i++)
    {
        float x = sin(oscPhase) * oscGain;
        oscPhase += oscFreq / 44100 * TWO_PI;
        output[i*2  ] = x;
        output[i*2+1] = x;
        
        if(oscPhase > TWO_PI)
        {
            oscPhase -= TWO_PI;
        }
    }
}
