/*
 * Colorful.h
 *
 *  Created on: 2009/03/06
 *      Author: ox
 */

#ifndef COLORFUL_H_
#define COLORFUL_H_

#include "ColorPort.h"
#include "graphic/DeadNotifier.h"

class Colorful : public virtual DeadNotifier {
public:
	Colorful(float red = 0.5, float green = 0.5, float blue = 0.5, float alpha = 0.7);
	virtual ~Colorful();

	void *setColor(Colorful *color);

	void setColor(float r, float g, float b, float a);

	//! setter
	void setR(float r);
	void setG(float g);
	void setB(float b);
	void setA(float a);

	//! getter
	float getR();
	float getG();
	float getB();
	float getA();

	//! get port
	RPort *newRPort();
	GPort *newGPort();
	BPort *newBPort();
	APort *newAPort();

protected:
	float r, g, b, a;	//! color
};

#endif /* COLORFUL_H_ */
