#include "testApp.h"
#include "GrDrawer.h"
#include "testCodePool.h"

#include "GrPoint.h"

testApp::testApp() :
    sampleRate(44100),
    initialBufferSize(1024),
    bufferLch(new float[initialBufferSize]),
    bufferRch(new float[initialBufferSize]),
    am(initialBufferSize)
	//b1(0.8, 0.1, 0.05, 0.05)
{
    // check grDraw
    //    ofPtr<GrBase> grPtr = ofPtr<GrBase>(grBase);
    //    ofPtr<GrDrawer> drawPtr = grPtr;
}

void testApp::audioOut(float *output, int size, int channels)
{
    am.audioOut(output, size, channels);
    for (int i = 0; i < size; i++) {
        bufferLch[i] = output[i * 2];
        bufferRch[i] = output[i * 2 + 1];
    }
}

//--------------------------------------------------------------
void testApp::setup()
{
    // of Logging Level
    ofSetLogLevel(OF_LOG_VERBOSE);

    // audio setup
    ofSoundStreamSetup(2, 0, this, 44100, initialBufferSize, 4);
    
	// background color
	ofBackground(255,255,255);
    
	// true type font
	//myFont.loadFont("frabk.ttf", 100);
	
    ofSetFrameRate(60);

	//gm.add(&b1);
	gm.add(b1 = new GrButton(0.8, 0.1, 0.05, 0.05));
	b1->addButtonListener(this);
}

//--------------------------------------------------------------
void testApp::update()
{
    gm.update();
}


//--------------------------------------
// ofVertex (Rect Ring)
//--------------------------------------
static const int numFig1Vert = 10;
double fig1Vert[numFig1Vert][2] = {
	{0.1, 0.1},
	{0.1, 0.9},
	{0.9, 0.9},
	{0.9, 0.1},
	{0.1, 0.1},
	{0.2, 0.2},
	{0.8, 0.2},
	{0.8, 0.8},
	{0.2, 0.8},
	{0.2, 0.2}
};

//--------------------------------------------------------------
void testApp::draw()
{
	int width = ofGetWidth();
	int height = ofGetHeight();

	ofEnableSmoothing();
	//myFont.drawString("box test", 100, 100);
	
	//--------------------------------------
	// box test
	//--------------------------------------
	if(0){
		ofNoFill();
		ofSetColor(0, 0, 255);
		double w = width * 0.25;
		double h = height * 0.25;
		double size = (width + height) / 2 * 0.1;
		ofBox(w, h, size);
	}
	
#if 0
	//--------------------------------------
	// ofVertex (Rect Ring)
	//--------------------------------------
	{
		int i = 0;
		double w = height * 0.8;
		double h = height * 0.8;
		
		ofFill();
		ofSetColor(255, 0, 0);
		ofSetPolyMode(OF_POLY_WINDING_ODD);
		ofBeginShape();
		double (*v)[2] = fig1Vert;
		for(i = 0; i < numFig1Vert; i++) {
			ofVertex(w * v[i][0], h * v[i][1]);
		}
		ofEndShape();
	}
	
	
	//--------------------------------------
	// ofVertex (Ring)
	//--------------------------------------
	{
		int i = 0;
		double w = height * 0.8;
		double h = height * 0.8;
		double width = 0.04;
		ofFill();
		ofSetColor(255, 255, 0);
		ofSetPolyMode(OF_POLY_WINDING_ODD);
		ofBeginShape();
		double (*v)[2] = fig1Vert;
		for(i = 0; i < numFig1Vert; i++) {
			ofVertex(w * v[i][0], h * v[i][1]);
		}
		ofEndShape();
	}
#endif
	
	//
	// ---
	// |
	// 
	{
		int i = 0;
		double w = ofGetWidth();
		double h = ofGetHeight();

		ofPushMatrix();
		ofTranslate(w * 0.5, h * 0.5, 0);
		ofScale(ofGetWidth(), ofGetHeight(), 0);

		ofFill();
		ofSetColor(0, 0, 255);
		ofSetPolyMode(OF_POLY_WINDING_ODD);
		ofBeginShape();
		ofVertex(0.0, 0.0);
		ofVertex(0.0, 0.2);
		ofVertex(0.1, 0.2);
		ofVertex(0.1, 0.1);
		ofVertex(0.3, 0.1);
		ofVertex(0.3, 0.0);
		ofVertex(0.0, 0.0);
		ofEndShape();
		ofPopMatrix();
	}
	gm.draw();
}

void testApp::exit()
{

}

//--------------------------------------------------------------
void testApp::keyPressed  (int key)
{

}

//--------------------------------------------------------------
void testApp::keyReleased  (int key)
{

}

//--------------------------------------------------------------
void testApp::mouseMoved(int x, int y)
{
	gm.mouseMoved(x, y);
}

//--------------------------------------------------------------
void testApp::mouseDragged(int x, int y, int button)
{
	gm.mouseDragged(x, y, button);
}

//--------------------------------------------------------------
void testApp::mousePressed(int x, int y, int button)
{
	gm.mousePressed(x, y, button);
}

//--------------------------------------------------------------
void testApp::mouseReleased(int x, int y, int button)
{
	gm.mouseReleased(x, y, button);
}

//--------------------------------------------------------------
void testApp::gotMessage(ofMessage msg)
{

}

//--------------------------------------------------------------
void testApp::dragEvent(ofDragInfo dragInfo)
{ 

}

void testApp::windowResized(int w, int h)
{
	
}

void testApp::buttonNotify(eGrButtonEventKind kind, GrButton *button)
{
	if(button == b1) {
		if(kind == GR_BUTTON_PRESSED) {
			button->setColor(100, 150, 200);
		}
	}
}

