//
//  GrButton.h
//  myNewApp
//
//  Created by 三分一 修 on 2013/06/22.
//
//

#ifndef __GrButton__
#define __GrButton__

#include "GrMain.h"
#include "GrDrawer.h"
#include "GrUpdater.h"
#include "GrMouse.h"

typedef enum gr_button_event_kind
{
	GR_BUTTON_PRESSED,
	GR_BUTTON_RELEASED,
	GR_BUTTON_ENTERED,
	GR_BUTTON_OUT
} eGrButtonEventKind;

class GrButton;

class GrButtonListener
{
public:
	virtual void buttonNotify(eGrButtonEventKind kind, GrButton *button) = 0;
};

class GrButton : public GrDrawer, GrUpdater, GrMouse
{
public:
	GrButton(double x, double y, double w, double h);
	
	virtual void update();
	virtual void draw();

	virtual void mouseMoved(int x, int y );
	virtual void mouseDragged(int x, int y, int button);
	virtual void mousePressed(int x, int y, int button);
	virtual void mouseReleased(int x, int y, int button);

	void setColor(int r, int g, int b);
	void addButtonListener(GrButtonListener *listener);

private:
	double mx, my, mw, mh;
	int mr, mg, mb;
	std::vector<ofPtr<GrButtonListener> > mButtonListeners;
};

#endif // __GrButton__
