//
//  testCodePool.cpp
//  myNewApp
//
//  Created by 三分一 修 on 2012/10/02.
//
//

#include "testCodePool.h"

#include <Poco/RegularExpression.h>

#define FileLogTouchPath "/Users/samb/work/OpenFrameworks/of_preRelease_v007_iphone/apps/iPhoneExamples/myNewApp/FileLogTouch.log"
//#define FileLogTouchPath "FileLogTouch.log"

#define FileLog(name, fmt, ...) { \
static FILE *fp = NULL; \
if(fp == NULL) { \
fp = fopen(name, "rw"); \
} \
if(fp != NULL) {\
fprintf(fp, fmt, __VA_ARGS__); \
}\
}
#include "ofMain.h"

#pragma mark --- Test shared_pointerの動作確認
#include "GrPoint.h"

/**
 * shared_pointerの動作確認
 */
void testSharedPointerSub(GrPoint *goPtr)
{
    ofPtr<GrPoint> sp(goPtr);
    
    // GoPointのインスタンス消滅？
}

void testSharedPointer()
{
    GrPoint *goPtr = new GrPoint();
    printf("a");
    
    ofPtr<GrBase> sp(goPtr); // shared_pointer GoPoint as superclass Pointer
    printf("b");
    
    testSharedPointerSub(goPtr);
    
    printf("c");
    
    goPtr->draw(); // ここでNULL pointer
}

void testSpDynamicCast()
{
    // コンパイルエラー
    //    ofPtr<GrObject> grPtr = ofPtr<GrObject>(grObject);
    //    ofPtr<GrDrawer> drawPtr = dynamic_cast<ofPtr<GrDrawer> >(grPtr);
}

#pragma mark --- Test LogFile
void testLogFile()
{
    FILE *mFp;
    
    if((mFp = fopen(FileLogTouchPath, "rw")) == NULL) {
        ofLog(OF_LOG_ERROR, "File open error.");
    }
    fprintf(mFp, "test"); // In iOS, FILE can't use?
}

void testPoco()
{
    // runtime error infinite loop
    //    Poco::RegularExpression regex("my name is osamu");
    //    regex.match("name", 2, Poco::RegularExpression::RE_MULTILINE);
}
