#ifndef __FFTW_CONTAINER__
#define __FFTW_CONTAINER__

#include <fftw3.h>

// FFT frequency domain singnal manipulation interface
class FftManipulation {
public:
	void exec(fftw_complex *sig);
};

template <int N>
class FftContainer {
public:
	FftContainer();
	~FftContainer();
	
	double tick(double value);

	void setManipulation(FftManipulation *m) {
		this->manipulation = m;
	}

private:
	double       timeSigBuffer[N];
	fftw_complex freqSigBuffer[N];
	double       timeSigOutBuffer[N];

	int bufferIndex;

	fftw_plan plan_r2c;
	fftw_plan plan_c2r;

	FftManipulation *manipulation;
};

#endif // __FFTW_CONTAINER__
