#include <stdio.h>
#include <math.h>
#include "cwaveguide.h"

#include "wavread.h"

static const char *inFile = "/Users/samb/Sound/raw/3FX00006.raw";
static const char *inWav = "/Users/samb/Sound/wav/short-SFX/1EX00001.WAV";
static const char *outFile = "./out.pcm";

void Test_cwaveguide()
{
	cwaveguide delay;
	FILE *fh, *fho;

	float feedbackValue = 0.9f; // TODO check
	double delayValue = 1024;
	
	if((fh = fopen(inFile, "rb")) == NULL) {
		printf("file open error : %s\n", inFile);
		return;
	}
	
	if((fho = fopen(outFile, "wb")) == NULL) {
		printf("file open error : %s\n", outFile);
		return;
	}
	
	short s;
	while (1 == fread(&s, sizeof(short), 1, fh)) {
		float out = delay.feed(s, feedbackValue, delayValue);

		// TODO write out
		printf("%.8x, %f\n", s, out);

		s = (short) out;
		fwrite(&s, sizeof(short), 1, fho);
	}
	
	fclose(fh);
	fclose(fho);
}

int main(int argc, char *argv[])
{
	WAVReader wavread(inWav);
	printf("WAVReader\n");
	printf("+ size : %d\n", wavread.size());
	
 	Test_cwaveguide();
	return 0;
}
