#include "stdafx.h"
#include "setupapi.h"
#include "compat_w95.h"

#define ORDER 9999

static HANDLE hInst; /* Instance handle of TTX*.DLL */

typedef struct {
	PTTSet ts;
	PComVar cv;
} TInstVar;

static TInstVar FAR * pvar;
static TInstVar InstVar;
static const char s_szClassName[] = "TTXComMonitorClass";
static HWND s_hWnd = NULL;
static char s_last_com_str[256];
static BOOL s_disconnected = FALSE;

static int InitMonitor(void);
static LRESULT CALLBACK WindowProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
static void DeviceChanged(void);
static void CheckDisconnect(void);
static void CheckReconnect(void);
static BOOL CheckCOM(const char *name);

static void PASCAL FAR TTXInit(PTTSet ts, PComVar cv) {
	pvar->ts = ts;
	pvar->cv = cv;

	InitMonitor();
}

static int InitMonitor(void)
{
	HWND       hwnd;
	WNDCLASSEX wc;

	wc.cbSize = sizeof(WNDCLASSEX);
	wc.style = 0;
	wc.lpfnWndProc = WindowProc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = hInst;
	wc.hIcon = NULL;
	wc.hCursor = NULL;
	wc.hbrBackground = NULL;
	wc.lpszMenuName = NULL;
	wc.lpszClassName = s_szClassName;
	wc.hIconSm = NULL;

	if (RegisterClassEx(&wc) == 0) {
		return FALSE;
	}

	hwnd = CreateWindowEx(	0,
							s_szClassName,
							NULL,
							WS_OVERLAPPEDWINDOW,
							0,
							0,
							0,
							0,
							NULL,
							NULL,
							hInst,
							NULL);
	if (hwnd == NULL) {
		return FALSE;
	}

	s_hWnd = hwnd;

	return TRUE;
}

static LRESULT CALLBACK WindowProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg) {
	case WM_DEVICECHANGE:
		///OutputDebugString("DeviceChange\n");
		DeviceChanged();
		break;
	default:
		break;

	}

	return DefWindowProc(hwnd, uMsg, wParam, lParam);
}

static void DeviceChanged(void)
{
	if (pvar->ts->PortType == IdSerial && pvar->cv->Open != 0) {
		CheckDisconnect();
	}
	else {
		CheckReconnect();
	}
}

static void CheckDisconnect(void)
{
	_snprintf_s(s_last_com_str, sizeof(s_last_com_str), _TRUNCATE, "COM%d", pvar->cv->ComPort);

	if (CheckCOM(s_last_com_str) == FALSE) {
		s_disconnected = TRUE;
		PostMessage(pvar->cv->HWin, WM_COMMAND, ID_FILE_DISCONNECT, 0);
		return;
	}
}

static void CheckReconnect(void)
{
	if (s_disconnected == FALSE) {
		return;
	}
	if (CheckCOM(s_last_com_str) == TRUE) {
		s_disconnected = FALSE;
		PostMessage(pvar->cv->HWin, WM_COMMAND, ID_FILE_NEWCONNECTION, 0);
		return;
	}
}

static BOOL CheckCOM(const char *name)
{
	BOOL ret;
	char devbuff[65535];
	GUID ClassGuid[1];
	DWORD dwRequiredSize;
	HDEVINFO hDevInfo = NULL;
	SP_DEVINFO_DATA DevInfoData;
	BOOL found = FALSE;

	if (QueryDosDevice(name, devbuff, sizeof(devbuff)) == 0) {
		return FALSE;
	}

	ret = SetupDiClassGuidsFromName("PORTS", (LPGUID)&ClassGuid[0], 1, &dwRequiredSize);
	if (ret == FALSE) {
		return FALSE;
	}

	hDevInfo = SetupDiGetClassDevs(&ClassGuid[0], NULL, NULL, DIGCF_PRESENT | DIGCF_PROFILE);
	if (hDevInfo == NULL) {
		return FALSE;
	}

	if (hDevInfo) {
		DWORD member = 0;
		HKEY hKey = NULL;
		char szPortName[MAX_PATH];
		DWORD bufSize;
		DWORD dwType;

		member = 0;
		DevInfoData.cbSize = sizeof(SP_DEVINFO_DATA);
		while (SetupDiEnumDeviceInfo(hDevInfo, member, &DevInfoData)) {
			hKey = SetupDiOpenDevRegKey(hDevInfo, &DevInfoData, DICS_FLAG_GLOBAL, 0, DIREG_DEV, KEY_READ);
			if (hKey) {
				long lRet;
				bufSize = sizeof(szPortName);
				lRet = RegQueryValueEx(hKey, "PortName", 0, &dwType, (LPBYTE)& szPortName, &bufSize);
				RegCloseKey(hKey);
				///OutputDebugString(szPortName);
				///OutputDebugString("\n");
				if (strcmp(szPortName, name) == 0) {
					found = TRUE;
					break;
				}
			}
			member++;
		}
	}
	///OutputDebugString("-------------\n");

	SetupDiDestroyDeviceInfoList(hDevInfo);

	return found;
}

static TTXExports Exports = {
	sizeof(TTXExports),
	ORDER,

	TTXInit,
	NULL, // TTXGetUIHooks,
	NULL, // TTXGetSetupHooks,
	NULL, // TTXOpenTCP,
	NULL, // TTXCloseTCP,
	NULL, // TTXSetWinSize,
	NULL, // TTXModifyMenu
	NULL, // TTXModifyPopupMenu,
	NULL, // TTXProcessCommand
	NULL, // TTXEnd
};

BOOL __declspec(dllexport) PASCAL FAR TTXBind(WORD Version, TTXExports FAR * exports) {
	int size = sizeof(Exports) - sizeof(exports->size);

	if (size > exports->size) {
		size = exports->size;
	}
	memcpy((char FAR *)exports + sizeof(exports->size),
		(char FAR *)&Exports + sizeof(exports->size),
		size);
	return TRUE;
}

BOOL WINAPI DllMain(HANDLE hInstance,
	ULONG ul_reason_for_call,
	LPVOID lpReserved)
{
	switch (ul_reason_for_call) {
	case DLL_THREAD_ATTACH:
		/* do thread initialization */
		break;
	case DLL_THREAD_DETACH:
		/* do thread cleanup */
		break;
	case DLL_PROCESS_ATTACH:
		/* do process initialization */
		DoCover_IsDebuggerPresent();
		hInst = hInstance;
		pvar = &InstVar;
		break;
	case DLL_PROCESS_DETACH:
		/* do process cleanup */
		break;
	}
	return TRUE;
}
