#include "ctype.h"
#include <oak/oak.h>
#include <oak/debug.h>

static std::set<uint32_t> east_asian_width_fixed ()
{
	static uint32_t Fixed[] = { 0x1100, 0x1101, 0x1102, 0x1103, 0x1104, 0x1105, 0x1106, 0x1107, 0x1108, 0x1109, 0x110A, 0x110B, 0x110C, 0x110D, 0x110E, 0x110F, 0x1110, 0x1111, 0x1112, 0x1113, 0x1114, 0x1115, 0x1116, 0x1117, 0x1118, 0x1119, 0x111A, 0x111B, 0x111C, 0x111D, 0x111E, 0x111F, 0x1120, 0x1121, 0x1122, 0x1123, 0x1124, 0x1125, 0x1126, 0x1127, 0x1128, 0x1129, 0x112A, 0x112B, 0x112C, 0x112D, 0x112E, 0x112F, 0x1130, 0x1131, 0x1132, 0x1133, 0x1134, 0x1135, 0x1136, 0x1137, 0x1138, 0x1139, 0x113A, 0x113B, 0x113C, 0x113D, 0x113E, 0x113F, 0x1140, 0x1141, 0x1142, 0x1143, 0x1144, 0x1145, 0x1146, 0x1147, 0x1148, 0x1149, 0x114A, 0x114B, 0x114C, 0x114D, 0x114E, 0x114F, 0x1150, 0x1151, 0x1152, 0x1153, 0x1154, 0x1155, 0x1156, 0x1157, 0x1158, 0x1159, 0x115A, 0x115B, 0x115C, 0x115D, 0x115E, 0x115F, 0x11A3, 0x11A4, 0x11A5, 0x11A6, 0x11A7, 0x11FA, 0x11FB, 0x11FC, 0x11FD, 0x11FE, 0x11FF, 0x2329, 0x232A, 0x2E80, 0x2E81, 0x2E82, 0x2E83, 0x2E84, 0x2E85, 0x2E86, 0x2E87, 0x2E88, 0x2E89, 0x2E8A, 0x2E8B, 0x2E8C, 0x2E8D, 0x2E8E, 0x2E8F, 0x2E90, 0x2E91, 0x2E92, 0x2E93, 0x2E94, 0x2E95, 0x2E96, 0x2E97, 0x2E98, 0x2E99, 0x2E9B, 0x2E9C, 0x2E9D, 0x2E9E, 0x2E9F, 0x2EA0, 0x2EA1, 0x2EA2, 0x2EA3, 0x2EA4, 0x2EA5, 0x2EA6, 0x2EA7, 0x2EA8, 0x2EA9, 0x2EAA, 0x2EAB, 0x2EAC, 0x2EAD, 0x2EAE, 0x2EAF, 0x2EB0, 0x2EB1, 0x2EB2, 0x2EB3, 0x2EB4, 0x2EB5, 0x2EB6, 0x2EB7, 0x2EB8, 0x2EB9, 0x2EBA, 0x2EBB, 0x2EBC, 0x2EBD, 0x2EBE, 0x2EBF, 0x2EC0, 0x2EC1, 0x2EC2, 0x2EC3, 0x2EC4, 0x2EC5, 0x2EC6, 0x2EC7, 0x2EC8, 0x2EC9, 0x2ECA, 0x2ECB, 0x2ECC, 0x2ECD, 0x2ECE, 0x2ECF, 0x2ED0, 0x2ED1, 0x2ED2, 0x2ED3, 0x2ED4, 0x2ED5, 0x2ED6, 0x2ED7, 0x2ED8, 0x2ED9, 0x2EDA, 0x2EDB, 0x2EDC, 0x2EDD, 0x2EDE, 0x2EDF, 0x2EE0, 0x2EE1, 0x2EE2, 0x2EE3, 0x2EE4, 0x2EE5, 0x2EE6, 0x2EE7, 0x2EE8, 0x2EE9, 0x2EEA, 0x2EEB, 0x2EEC, 0x2EED, 0x2EEE, 0x2EEF, 0x2EF0, 0x2EF1, 0x2EF2, 0x2EF3, 0x2F00, 0x2F01, 0x2F02, 0x2F03, 0x2F04, 0x2F05, 0x2F06, 0x2F07, 0x2F08, 0x2F09, 0x2F0A, 0x2F0B, 0x2F0C, 0x2F0D, 0x2F0E, 0x2F0F, 0x2F10, 0x2F11, 0x2F12, 0x2F13, 0x2F14, 0x2F15, 0x2F16, 0x2F17, 0x2F18, 0x2F19, 0x2F1A, 0x2F1B, 0x2F1C, 0x2F1D, 0x2F1E, 0x2F1F, 0x2F20, 0x2F21, 0x2F22, 0x2F23, 0x2F24, 0x2F25, 0x2F26, 0x2F27, 0x2F28, 0x2F29, 0x2F2A, 0x2F2B, 0x2F2C, 0x2F2D, 0x2F2E, 0x2F2F, 0x2F30, 0x2F31, 0x2F32, 0x2F33, 0x2F34, 0x2F35, 0x2F36, 0x2F37, 0x2F38, 0x2F39, 0x2F3A, 0x2F3B, 0x2F3C, 0x2F3D, 0x2F3E, 0x2F3F, 0x2F40, 0x2F41, 0x2F42, 0x2F43, 0x2F44, 0x2F45, 0x2F46, 0x2F47, 0x2F48, 0x2F49, 0x2F4A, 0x2F4B, 0x2F4C, 0x2F4D, 0x2F4E, 0x2F4F, 0x2F50, 0x2F51, 0x2F52, 0x2F53, 0x2F54, 0x2F55, 0x2F56, 0x2F57, 0x2F58, 0x2F59, 0x2F5A, 0x2F5B, 0x2F5C, 0x2F5D, 0x2F5E, 0x2F5F, 0x2F60, 0x2F61, 0x2F62, 0x2F63, 0x2F64, 0x2F65, 0x2F66, 0x2F67, 0x2F68, 0x2F69, 0x2F6A, 0x2F6B, 0x2F6C, 0x2F6D, 0x2F6E, 0x2F6F, 0x2F70, 0x2F71, 0x2F72, 0x2F73, 0x2F74, 0x2F75, 0x2F76, 0x2F77, 0x2F78, 0x2F79, 0x2F7A, 0x2F7B, 0x2F7C, 0x2F7D, 0x2F7E, 0x2F7F, 0x2F80, 0x2F81, 0x2F82, 0x2F83, 0x2F84, 0x2F85, 0x2F86, 0x2F87, 0x2F88, 0x2F89, 0x2F8A, 0x2F8B, 0x2F8C, 0x2F8D, 0x2F8E, 0x2F8F, 0x2F90, 0x2F91, 0x2F92, 0x2F93, 0x2F94, 0x2F95, 0x2F96, 0x2F97, 0x2F98, 0x2F99, 0x2F9A, 0x2F9B, 0x2F9C, 0x2F9D, 0x2F9E, 0x2F9F, 0x2FA0, 0x2FA1, 0x2FA2, 0x2FA3, 0x2FA4, 0x2FA5, 0x2FA6, 0x2FA7, 0x2FA8, 0x2FA9, 0x2FAA, 0x2FAB, 0x2FAC, 0x2FAD, 0x2FAE, 0x2FAF, 0x2FB0, 0x2FB1, 0x2FB2, 0x2FB3, 0x2FB4, 0x2FB5, 0x2FB6, 0x2FB7, 0x2FB8, 0x2FB9, 0x2FBA, 0x2FBB, 0x2FBC, 0x2FBD, 0x2FBE, 0x2FBF, 0x2FC0, 0x2FC1, 0x2FC2, 0x2FC3, 0x2FC4, 0x2FC5, 0x2FC6, 0x2FC7, 0x2FC8, 0x2FC9, 0x2FCA, 0x2FCB, 0x2FCC, 0x2FCD, 0x2FCE, 0x2FCF, 0x2FD0, 0x2FD1, 0x2FD2, 0x2FD3, 0x2FD4, 0x2FD5, 0x2FF0, 0x2FF1, 0x2FF2, 0x2FF3, 0x2FF4, 0x2FF5, 0x2FF6, 0x2FF7, 0x2FF8, 0x2FF9, 0x2FFA, 0x2FFB, 0x3001, 0x3002, 0x3003, 0x3004, 0x3005, 0x3006, 0x3007, 0x3008, 0x3009, 0x300A, 0x300B, 0x300C, 0x300D, 0x300E, 0x300F, 0x3010, 0x3011, 0x3012, 0x3013, 0x3014, 0x3015, 0x3016, 0x3017, 0x3018, 0x3019, 0x301A, 0x301B, 0x301C, 0x301D, 0x301E, 0x301F, 0x3020, 0x3021, 0x3022, 0x3023, 0x3024, 0x3025, 0x3026, 0x3027, 0x3028, 0x3029, 0x302A, 0x302B, 0x302C, 0x302D, 0x302E, 0x302F, 0x3030, 0x3031, 0x3032, 0x3033, 0x3034, 0x3035, 0x3036, 0x3037, 0x3038, 0x3039, 0x303A, 0x303B, 0x303C, 0x303D, 0x303E, 0x3041, 0x3042, 0x3043, 0x3044, 0x3045, 0x3046, 0x3047, 0x3048, 0x3049, 0x304A, 0x304B, 0x304C, 0x304D, 0x304E, 0x304F, 0x3050, 0x3051, 0x3052, 0x3053, 0x3054, 0x3055, 0x3056, 0x3057, 0x3058, 0x3059, 0x305A, 0x305B, 0x305C, 0x305D, 0x305E, 0x305F, 0x3060, 0x3061, 0x3062, 0x3063, 0x3064, 0x3065, 0x3066, 0x3067, 0x3068, 0x3069, 0x306A, 0x306B, 0x306C, 0x306D, 0x306E, 0x306F, 0x3070, 0x3071, 0x3072, 0x3073, 0x3074, 0x3075, 0x3076, 0x3077, 0x3078, 0x3079, 0x307A, 0x307B, 0x307C, 0x307D, 0x307E, 0x307F, 0x3080, 0x3081, 0x3082, 0x3083, 0x3084, 0x3085, 0x3086, 0x3087, 0x3088, 0x3089, 0x308A, 0x308B, 0x308C, 0x308D, 0x308E, 0x308F, 0x3090, 0x3091, 0x3092, 0x3093, 0x3094, 0x3095, 0x3096, 0x3099, 0x309A, 0x309B, 0x309C, 0x309D, 0x309E, 0x309F, 0x30A0, 0x30A1, 0x30A2, 0x30A3, 0x30A4, 0x30A5, 0x30A6, 0x30A7, 0x30A8, 0x30A9, 0x30AA, 0x30AB, 0x30AC, 0x30AD, 0x30AE, 0x30AF, 0x30B0, 0x30B1, 0x30B2, 0x30B3, 0x30B4, 0x30B5, 0x30B6, 0x30B7, 0x30B8, 0x30B9, 0x30BA, 0x30BB, 0x30BC, 0x30BD, 0x30BE, 0x30BF, 0x30C0, 0x30C1, 0x30C2, 0x30C3, 0x30C4, 0x30C5, 0x30C6, 0x30C7, 0x30C8, 0x30C9, 0x30CA, 0x30CB, 0x30CC, 0x30CD, 0x30CE, 0x30CF, 0x30D0, 0x30D1, 0x30D2, 0x30D3, 0x30D4, 0x30D5, 0x30D6, 0x30D7, 0x30D8, 0x30D9, 0x30DA, 0x30DB, 0x30DC, 0x30DD, 0x30DE, 0x30DF, 0x30E0, 0x30E1, 0x30E2, 0x30E3, 0x30E4, 0x30E5, 0x30E6, 0x30E7, 0x30E8, 0x30E9, 0x30EA, 0x30EB, 0x30EC, 0x30ED, 0x30EE, 0x30EF, 0x30F0, 0x30F1, 0x30F2, 0x30F3, 0x30F4, 0x30F5, 0x30F6, 0x30F7, 0x30F8, 0x30F9, 0x30FA, 0x30FB, 0x30FC, 0x30FD, 0x30FE, 0x30FF, 0x3105, 0x3106, 0x3107, 0x3108, 0x3109, 0x310A, 0x310B, 0x310C, 0x310D, 0x310E, 0x310F, 0x3110, 0x3111, 0x3112, 0x3113, 0x3114, 0x3115, 0x3116, 0x3117, 0x3118, 0x3119, 0x311A, 0x311B, 0x311C, 0x311D, 0x311E, 0x311F, 0x3120, 0x3121, 0x3122, 0x3123, 0x3124, 0x3125, 0x3126, 0x3127, 0x3128, 0x3129, 0x312A, 0x312B, 0x312C, 0x312D, 0x3131, 0x3132, 0x3133, 0x3134, 0x3135, 0x3136, 0x3137, 0x3138, 0x3139, 0x313A, 0x313B, 0x313C, 0x313D, 0x313E, 0x313F, 0x3140, 0x3141, 0x3142, 0x3143, 0x3144, 0x3145, 0x3146, 0x3147, 0x3148, 0x3149, 0x314A, 0x314B, 0x314C, 0x314D, 0x314E, 0x314F, 0x3150, 0x3151, 0x3152, 0x3153, 0x3154, 0x3155, 0x3156, 0x3157, 0x3158, 0x3159, 0x315A, 0x315B, 0x315C, 0x315D, 0x315E, 0x315F, 0x3160, 0x3161, 0x3162, 0x3163, 0x3164, 0x3165, 0x3166, 0x3167, 0x3168, 0x3169, 0x316A, 0x316B, 0x316C, 0x316D, 0x316E, 0x316F, 0x3170, 0x3171, 0x3172, 0x3173, 0x3174, 0x3175, 0x3176, 0x3177, 0x3178, 0x3179, 0x317A, 0x317B, 0x317C, 0x317D, 0x317E, 0x317F, 0x3180, 0x3181, 0x3182, 0x3183, 0x3184, 0x3185, 0x3186, 0x3187, 0x3188, 0x3189, 0x318A, 0x318B, 0x318C, 0x318D, 0x318E, 0x3190, 0x3191, 0x3192, 0x3193, 0x3194, 0x3195, 0x3196, 0x3197, 0x3198, 0x3199, 0x319A, 0x319B, 0x319C, 0x319D, 0x319E, 0x319F, 0x31A0, 0x31A1, 0x31A2, 0x31A3, 0x31A4, 0x31A5, 0x31A6, 0x31A7, 0x31A8, 0x31A9, 0x31AA, 0x31AB, 0x31AC, 0x31AD, 0x31AE, 0x31AF, 0x31B0, 0x31B1, 0x31B2, 0x31B3, 0x31B4, 0x31B5, 0x31B6, 0x31B7, 0x31B8, 0x31B9, 0x31BA, 0x31C0, 0x31C1, 0x31C2, 0x31C3, 0x31C4, 0x31C5, 0x31C6, 0x31C7, 0x31C8, 0x31C9, 0x31CA, 0x31CB, 0x31CC, 0x31CD, 0x31CE, 0x31CF, 0x31D0, 0x31D1, 0x31D2, 0x31D3, 0x31D4, 0x31D5, 0x31D6, 0x31D7, 0x31D8, 0x31D9, 0x31DA, 0x31DB, 0x31DC, 0x31DD, 0x31DE, 0x31DF, 0x31E0, 0x31E1, 0x31E2, 0x31E3, 0x31F0, 0x31F1, 0x31F2, 0x31F3, 0x31F4, 0x31F5, 0x31F6, 0x31F7, 0x31F8, 0x31F9, 0x31FA, 0x31FB, 0x31FC, 0x31FD, 0x31FE, 0x31FF, 0x3200, 0x3201, 0x3202, 0x3203, 0x3204, 0x3205, 0x3206, 0x3207, 0x3208, 0x3209, 0x320A, 0x320B, 0x320C, 0x320D, 0x320E, 0x320F, 0x3210, 0x3211, 0x3212, 0x3213, 0x3214, 0x3215, 0x3216, 0x3217, 0x3218, 0x3219, 0x321A, 0x321B, 0x321C, 0x321D, 0x321E, 0x3220, 0x3221, 0x3222, 0x3223, 0x3224, 0x3225, 0x3226, 0x3227, 0x3228, 0x3229, 0x322A, 0x322B, 0x322C, 0x322D, 0x322E, 0x322F, 0x3230, 0x3231, 0x3232, 0x3233, 0x3234, 0x3235, 0x3236, 0x3237, 0x3238, 0x3239, 0x323A, 0x323B, 0x323C, 0x323D, 0x323E, 0x323F, 0x3240, 0x3241, 0x3242, 0x3243, 0x3244, 0x3245, 0x3246, 0x3247, 0x3250, 0x3251, 0x3252, 0x3253, 0x3254, 0x3255, 0x3256, 0x3257, 0x3258, 0x3259, 0x325A, 0x325B, 0x325C, 0x325D, 0x325E, 0x325F, 0x3260, 0x3261, 0x3262, 0x3263, 0x3264, 0x3265, 0x3266, 0x3267, 0x3268, 0x3269, 0x326A, 0x326B, 0x326C, 0x326D, 0x326E, 0x326F, 0x3270, 0x3271, 0x3272, 0x3273, 0x3274, 0x3275, 0x3276, 0x3277, 0x3278, 0x3279, 0x327A, 0x327B, 0x327C, 0x327D, 0x327E, 0x327F, 0x3280, 0x3281, 0x3282, 0x3283, 0x3284, 0x3285, 0x3286, 0x3287, 0x3288, 0x3289, 0x328A, 0x328B, 0x328C, 0x328D, 0x328E, 0x328F, 0x3290, 0x3291, 0x3292, 0x3293, 0x3294, 0x3295, 0x3296, 0x3297, 0x3298, 0x3299, 0x329A, 0x329B, 0x329C, 0x329D, 0x329E, 0x329F, 0x32A0, 0x32A1, 0x32A2, 0x32A3, 0x32A4, 0x32A5, 0x32A6, 0x32A7, 0x32A8, 0x32A9, 0x32AA, 0x32AB, 0x32AC, 0x32AD, 0x32AE, 0x32AF, 0x32B0, 0x32B1, 0x32B2, 0x32B3, 0x32B4, 0x32B5, 0x32B6, 0x32B7, 0x32B8, 0x32B9, 0x32BA, 0x32BB, 0x32BC, 0x32BD, 0x32BE, 0x32BF, 0x32C0, 0x32C1, 0x32C2, 0x32C3, 0x32C4, 0x32C5, 0x32C6, 0x32C7, 0x32C8, 0x32C9, 0x32CA, 0x32CB, 0x32CC, 0x32CD, 0x32CE, 0x32CF, 0x32D0, 0x32D1, 0x32D2, 0x32D3, 0x32D4, 0x32D5, 0x32D6, 0x32D7, 0x32D8, 0x32D9, 0x32DA, 0x32DB, 0x32DC, 0x32DD, 0x32DE, 0x32DF, 0x32E0, 0x32E1, 0x32E2, 0x32E3, 0x32E4, 0x32E5, 0x32E6, 0x32E7, 0x32E8, 0x32E9, 0x32EA, 0x32EB, 0x32EC, 0x32ED, 0x32EE, 0x32EF, 0x32F0, 0x32F1, 0x32F2, 0x32F3, 0x32F4, 0x32F5, 0x32F6, 0x32F7, 0x32F8, 0x32F9, 0x32FA, 0x32FB, 0x32FC, 0x32FD, 0x32FE, 0x3300, 0x3301, 0x3302, 0x3303, 0x3304, 0x3305, 0x3306, 0x3307, 0x3308, 0x3309, 0x330A, 0x330B, 0x330C, 0x330D, 0x330E, 0x330F, 0x3310, 0x3311, 0x3312, 0x3313, 0x3314, 0x3315, 0x3316, 0x3317, 0x3318, 0x3319, 0x331A, 0x331B, 0x331C, 0x331D, 0x331E, 0x331F, 0x3320, 0x3321, 0x3322, 0x3323, 0x3324, 0x3325, 0x3326, 0x3327, 0x3328, 0x3329, 0x332A, 0x332B, 0x332C, 0x332D, 0x332E, 0x332F, 0x3330, 0x3331, 0x3332, 0x3333, 0x3334, 0x3335, 0x3336, 0x3337, 0x3338, 0x3339, 0x333A, 0x333B, 0x333C, 0x333D, 0x333E, 0x333F, 0x3340, 0x3341, 0x3342, 0x3343, 0x3344, 0x3345, 0x3346, 0x3347, 0x3348, 0x3349, 0x334A, 0x334B, 0x334C, 0x334D, 0x334E, 0x334F, 0x3350, 0x3351, 0x3352, 0x3353, 0x3354, 0x3355, 0x3356, 0x3357, 0x3358, 0x3359, 0x335A, 0x335B, 0x335C, 0x335D, 0x335E, 0x335F, 0x3360, 0x3361, 0x3362, 0x3363, 0x3364, 0x3365, 0x3366, 0x3367, 0x3368, 0x3369, 0x336A, 0x336B, 0x336C, 0x336D, 0x336E, 0x336F, 0x3370, 0x3371, 0x3372, 0x3373, 0x3374, 0x3375, 0x3376, 0x3377, 0x3378, 0x3379, 0x337A, 0x337B, 0x337C, 0x337D, 0x337E, 0x337F, 0x3380, 0x3381, 0x3382, 0x3383, 0x3384, 0x3385, 0x3386, 0x3387, 0x3388, 0x3389, 0x338A, 0x338B, 0x338C, 0x338D, 0x338E, 0x338F, 0x3390, 0x3391, 0x3392, 0x3393, 0x3394, 0x3395, 0x3396, 0x3397, 0x3398, 0x3399, 0x339A, 0x339B, 0x339C, 0x339D, 0x339E, 0x339F, 0x33A0, 0x33A1, 0x33A2, 0x33A3, 0x33A4, 0x33A5, 0x33A6, 0x33A7, 0x33A8, 0x33A9, 0x33AA, 0x33AB, 0x33AC, 0x33AD, 0x33AE, 0x33AF, 0x33B0, 0x33B1, 0x33B2, 0x33B3, 0x33B4, 0x33B5, 0x33B6, 0x33B7, 0x33B8, 0x33B9, 0x33BA, 0x33BB, 0x33BC, 0x33BD, 0x33BE, 0x33BF, 0x33C0, 0x33C1, 0x33C2, 0x33C3, 0x33C4, 0x33C5, 0x33C6, 0x33C7, 0x33C8, 0x33C9, 0x33CA, 0x33CB, 0x33CC, 0x33CD, 0x33CE, 0x33CF, 0x33D0, 0x33D1, 0x33D2, 0x33D3, 0x33D4, 0x33D5, 0x33D6, 0x33D7, 0x33D8, 0x33D9, 0x33DA, 0x33DB, 0x33DC, 0x33DD, 0x33DE, 0x33DF, 0x33E0, 0x33E1, 0x33E2, 0x33E3, 0x33E4, 0x33E5, 0x33E6, 0x33E7, 0x33E8, 0x33E9, 0x33EA, 0x33EB, 0x33EC, 0x33ED, 0x33EE, 0x33EF, 0x33F0, 0x33F1, 0x33F2, 0x33F3, 0x33F4, 0x33F5, 0x33F6, 0x33F7, 0x33F8, 0x33F9, 0x33FA, 0x33FB, 0x33FC, 0x33FD, 0x33FE, 0x33FF, 0xA000, 0xA001, 0xA002, 0xA003, 0xA004, 0xA005, 0xA006, 0xA007, 0xA008, 0xA009, 0xA00A, 0xA00B, 0xA00C, 0xA00D, 0xA00E, 0xA00F, 0xA010, 0xA011, 0xA012, 0xA013, 0xA014, 0xA015, 0xA016, 0xA017, 0xA018, 0xA019, 0xA01A, 0xA01B, 0xA01C, 0xA01D, 0xA01E, 0xA01F, 0xA020, 0xA021, 0xA022, 0xA023, 0xA024, 0xA025, 0xA026, 0xA027, 0xA028, 0xA029, 0xA02A, 0xA02B, 0xA02C, 0xA02D, 0xA02E, 0xA02F, 0xA030, 0xA031, 0xA032, 0xA033, 0xA034, 0xA035, 0xA036, 0xA037, 0xA038, 0xA039, 0xA03A, 0xA03B, 0xA03C, 0xA03D, 0xA03E, 0xA03F, 0xA040, 0xA041, 0xA042, 0xA043, 0xA044, 0xA045, 0xA046, 0xA047, 0xA048, 0xA049, 0xA04A, 0xA04B, 0xA04C, 0xA04D, 0xA04E, 0xA04F, 0xA050, 0xA051, 0xA052, 0xA053, 0xA054, 0xA055, 0xA056, 0xA057, 0xA058, 0xA059, 0xA05A, 0xA05B, 0xA05C, 0xA05D, 0xA05E, 0xA05F, 0xA060, 0xA061, 0xA062, 0xA063, 0xA064, 0xA065, 0xA066, 0xA067, 0xA068, 0xA069, 0xA06A, 0xA06B, 0xA06C, 0xA06D, 0xA06E, 0xA06F, 0xA070, 0xA071, 0xA072, 0xA073, 0xA074, 0xA075, 0xA076, 0xA077, 0xA078, 0xA079, 0xA07A, 0xA07B, 0xA07C, 0xA07D, 0xA07E, 0xA07F, 0xA080, 0xA081, 0xA082, 0xA083, 0xA084, 0xA085, 0xA086, 0xA087, 0xA088, 0xA089, 0xA08A, 0xA08B, 0xA08C, 0xA08D, 0xA08E, 0xA08F, 0xA090, 0xA091, 0xA092, 0xA093, 0xA094, 0xA095, 0xA096, 0xA097, 0xA098, 0xA099, 0xA09A, 0xA09B, 0xA09C, 0xA09D, 0xA09E, 0xA09F, 0xA0A0, 0xA0A1, 0xA0A2, 0xA0A3, 0xA0A4, 0xA0A5, 0xA0A6, 0xA0A7, 0xA0A8, 0xA0A9, 0xA0AA, 0xA0AB, 0xA0AC, 0xA0AD, 0xA0AE, 0xA0AF, 0xA0B0, 0xA0B1, 0xA0B2, 0xA0B3, 0xA0B4, 0xA0B5, 0xA0B6, 0xA0B7, 0xA0B8, 0xA0B9, 0xA0BA, 0xA0BB, 0xA0BC, 0xA0BD, 0xA0BE, 0xA0BF, 0xA0C0, 0xA0C1, 0xA0C2, 0xA0C3, 0xA0C4, 0xA0C5, 0xA0C6, 0xA0C7, 0xA0C8, 0xA0C9, 0xA0CA, 0xA0CB, 0xA0CC, 0xA0CD, 0xA0CE, 0xA0CF, 0xA0D0, 0xA0D1, 0xA0D2, 0xA0D3, 0xA0D4, 0xA0D5, 0xA0D6, 0xA0D7, 0xA0D8, 0xA0D9, 0xA0DA, 0xA0DB, 0xA0DC, 0xA0DD, 0xA0DE, 0xA0DF, 0xA0E0, 0xA0E1, 0xA0E2, 0xA0E3, 0xA0E4, 0xA0E5, 0xA0E6, 0xA0E7, 0xA0E8, 0xA0E9, 0xA0EA, 0xA0EB, 0xA0EC, 0xA0ED, 0xA0EE, 0xA0EF, 0xA0F0, 0xA0F1, 0xA0F2, 0xA0F3, 0xA0F4, 0xA0F5, 0xA0F6, 0xA0F7, 0xA0F8, 0xA0F9, 0xA0FA, 0xA0FB, 0xA0FC, 0xA0FD, 0xA0FE, 0xA0FF, 0xA100, 0xA101, 0xA102, 0xA103, 0xA104, 0xA105, 0xA106, 0xA107, 0xA108, 0xA109, 0xA10A, 0xA10B, 0xA10C, 0xA10D, 0xA10E, 0xA10F, 0xA110, 0xA111, 0xA112, 0xA113, 0xA114, 0xA115, 0xA116, 0xA117, 0xA118, 0xA119, 0xA11A, 0xA11B, 0xA11C, 0xA11D, 0xA11E, 0xA11F, 0xA120, 0xA121, 0xA122, 0xA123, 0xA124, 0xA125, 0xA126, 0xA127, 0xA128, 0xA129, 0xA12A, 0xA12B, 0xA12C, 0xA12D, 0xA12E, 0xA12F, 0xA130, 0xA131, 0xA132, 0xA133, 0xA134, 0xA135, 0xA136, 0xA137, 0xA138, 0xA139, 0xA13A, 0xA13B, 0xA13C, 0xA13D, 0xA13E, 0xA13F, 0xA140, 0xA141, 0xA142, 0xA143, 0xA144, 0xA145, 0xA146, 0xA147, 0xA148, 0xA149, 0xA14A, 0xA14B, 0xA14C, 0xA14D, 0xA14E, 0xA14F, 0xA150, 0xA151, 0xA152, 0xA153, 0xA154, 0xA155, 0xA156, 0xA157, 0xA158, 0xA159, 0xA15A, 0xA15B, 0xA15C, 0xA15D, 0xA15E, 0xA15F, 0xA160, 0xA161, 0xA162, 0xA163, 0xA164, 0xA165, 0xA166, 0xA167, 0xA168, 0xA169, 0xA16A, 0xA16B, 0xA16C, 0xA16D, 0xA16E, 0xA16F, 0xA170, 0xA171, 0xA172, 0xA173, 0xA174, 0xA175, 0xA176, 0xA177, 0xA178, 0xA179, 0xA17A, 0xA17B, 0xA17C, 0xA17D, 0xA17E, 0xA17F, 0xA180, 0xA181, 0xA182, 0xA183, 0xA184, 0xA185, 0xA186, 0xA187, 0xA188, 0xA189, 0xA18A, 0xA18B, 0xA18C, 0xA18D, 0xA18E, 0xA18F, 0xA190, 0xA191, 0xA192, 0xA193, 0xA194, 0xA195, 0xA196, 0xA197, 0xA198, 0xA199, 0xA19A, 0xA19B, 0xA19C, 0xA19D, 0xA19E, 0xA19F, 0xA1A0, 0xA1A1, 0xA1A2, 0xA1A3, 0xA1A4, 0xA1A5, 0xA1A6, 0xA1A7, 0xA1A8, 0xA1A9, 0xA1AA, 0xA1AB, 0xA1AC, 0xA1AD, 0xA1AE, 0xA1AF, 0xA1B0, 0xA1B1, 0xA1B2, 0xA1B3, 0xA1B4, 0xA1B5, 0xA1B6, 0xA1B7, 0xA1B8, 0xA1B9, 0xA1BA, 0xA1BB, 0xA1BC, 0xA1BD, 0xA1BE, 0xA1BF, 0xA1C0, 0xA1C1, 0xA1C2, 0xA1C3, 0xA1C4, 0xA1C5, 0xA1C6, 0xA1C7, 0xA1C8, 0xA1C9, 0xA1CA, 0xA1CB, 0xA1CC, 0xA1CD, 0xA1CE, 0xA1CF, 0xA1D0, 0xA1D1, 0xA1D2, 0xA1D3, 0xA1D4, 0xA1D5, 0xA1D6, 0xA1D7, 0xA1D8, 0xA1D9, 0xA1DA, 0xA1DB, 0xA1DC, 0xA1DD, 0xA1DE, 0xA1DF, 0xA1E0, 0xA1E1, 0xA1E2, 0xA1E3, 0xA1E4, 0xA1E5, 0xA1E6, 0xA1E7, 0xA1E8, 0xA1E9, 0xA1EA, 0xA1EB, 0xA1EC, 0xA1ED, 0xA1EE, 0xA1EF, 0xA1F0, 0xA1F1, 0xA1F2, 0xA1F3, 0xA1F4, 0xA1F5, 0xA1F6, 0xA1F7, 0xA1F8, 0xA1F9, 0xA1FA, 0xA1FB, 0xA1FC, 0xA1FD, 0xA1FE, 0xA1FF, 0xA200, 0xA201, 0xA202, 0xA203, 0xA204, 0xA205, 0xA206, 0xA207, 0xA208, 0xA209, 0xA20A, 0xA20B, 0xA20C, 0xA20D, 0xA20E, 0xA20F, 0xA210, 0xA211, 0xA212, 0xA213, 0xA214, 0xA215, 0xA216, 0xA217, 0xA218, 0xA219, 0xA21A, 0xA21B, 0xA21C, 0xA21D, 0xA21E, 0xA21F, 0xA220, 0xA221, 0xA222, 0xA223, 0xA224, 0xA225, 0xA226, 0xA227, 0xA228, 0xA229, 0xA22A, 0xA22B, 0xA22C, 0xA22D, 0xA22E, 0xA22F, 0xA230, 0xA231, 0xA232, 0xA233, 0xA234, 0xA235, 0xA236, 0xA237, 0xA238, 0xA239, 0xA23A, 0xA23B, 0xA23C, 0xA23D, 0xA23E, 0xA23F, 0xA240, 0xA241, 0xA242, 0xA243, 0xA244, 0xA245, 0xA246, 0xA247, 0xA248, 0xA249, 0xA24A, 0xA24B, 0xA24C, 0xA24D, 0xA24E, 0xA24F, 0xA250, 0xA251, 0xA252, 0xA253, 0xA254, 0xA255, 0xA256, 0xA257, 0xA258, 0xA259, 0xA25A, 0xA25B, 0xA25C, 0xA25D, 0xA25E, 0xA25F, 0xA260, 0xA261, 0xA262, 0xA263, 0xA264, 0xA265, 0xA266, 0xA267, 0xA268, 0xA269, 0xA26A, 0xA26B, 0xA26C, 0xA26D, 0xA26E, 0xA26F, 0xA270, 0xA271, 0xA272, 0xA273, 0xA274, 0xA275, 0xA276, 0xA277, 0xA278, 0xA279, 0xA27A, 0xA27B, 0xA27C, 0xA27D, 0xA27E, 0xA27F, 0xA280, 0xA281, 0xA282, 0xA283, 0xA284, 0xA285, 0xA286, 0xA287, 0xA288, 0xA289, 0xA28A, 0xA28B, 0xA28C, 0xA28D, 0xA28E, 0xA28F, 0xA290, 0xA291, 0xA292, 0xA293, 0xA294, 0xA295, 0xA296, 0xA297, 0xA298, 0xA299, 0xA29A, 0xA29B, 0xA29C, 0xA29D, 0xA29E, 0xA29F, 0xA2A0, 0xA2A1, 0xA2A2, 0xA2A3, 0xA2A4, 0xA2A5, 0xA2A6, 0xA2A7, 0xA2A8, 0xA2A9, 0xA2AA, 0xA2AB, 0xA2AC, 0xA2AD, 0xA2AE, 0xA2AF, 0xA2B0, 0xA2B1, 0xA2B2, 0xA2B3, 0xA2B4, 0xA2B5, 0xA2B6, 0xA2B7, 0xA2B8, 0xA2B9, 0xA2BA, 0xA2BB, 0xA2BC, 0xA2BD, 0xA2BE, 0xA2BF, 0xA2C0, 0xA2C1, 0xA2C2, 0xA2C3, 0xA2C4, 0xA2C5, 0xA2C6, 0xA2C7, 0xA2C8, 0xA2C9, 0xA2CA, 0xA2CB, 0xA2CC, 0xA2CD, 0xA2CE, 0xA2CF, 0xA2D0, 0xA2D1, 0xA2D2, 0xA2D3, 0xA2D4, 0xA2D5, 0xA2D6, 0xA2D7, 0xA2D8, 0xA2D9, 0xA2DA, 0xA2DB, 0xA2DC, 0xA2DD, 0xA2DE, 0xA2DF, 0xA2E0, 0xA2E1, 0xA2E2, 0xA2E3, 0xA2E4, 0xA2E5, 0xA2E6, 0xA2E7, 0xA2E8, 0xA2E9, 0xA2EA, 0xA2EB, 0xA2EC, 0xA2ED, 0xA2EE, 0xA2EF, 0xA2F0, 0xA2F1, 0xA2F2, 0xA2F3, 0xA2F4, 0xA2F5, 0xA2F6, 0xA2F7, 0xA2F8, 0xA2F9, 0xA2FA, 0xA2FB, 0xA2FC, 0xA2FD, 0xA2FE, 0xA2FF, 0xA300, 0xA301, 0xA302, 0xA303, 0xA304, 0xA305, 0xA306, 0xA307, 0xA308, 0xA309, 0xA30A, 0xA30B, 0xA30C, 0xA30D, 0xA30E, 0xA30F, 0xA310, 0xA311, 0xA312, 0xA313, 0xA314, 0xA315, 0xA316, 0xA317, 0xA318, 0xA319, 0xA31A, 0xA31B, 0xA31C, 0xA31D, 0xA31E, 0xA31F, 0xA320, 0xA321, 0xA322, 0xA323, 0xA324, 0xA325, 0xA326, 0xA327, 0xA328, 0xA329, 0xA32A, 0xA32B, 0xA32C, 0xA32D, 0xA32E, 0xA32F, 0xA330, 0xA331, 0xA332, 0xA333, 0xA334, 0xA335, 0xA336, 0xA337, 0xA338, 0xA339, 0xA33A, 0xA33B, 0xA33C, 0xA33D, 0xA33E, 0xA33F, 0xA340, 0xA341, 0xA342, 0xA343, 0xA344, 0xA345, 0xA346, 0xA347, 0xA348, 0xA349, 0xA34A, 0xA34B, 0xA34C, 0xA34D, 0xA34E, 0xA34F, 0xA350, 0xA351, 0xA352, 0xA353, 0xA354, 0xA355, 0xA356, 0xA357, 0xA358, 0xA359, 0xA35A, 0xA35B, 0xA35C, 0xA35D, 0xA35E, 0xA35F, 0xA360, 0xA361, 0xA362, 0xA363, 0xA364, 0xA365, 0xA366, 0xA367, 0xA368, 0xA369, 0xA36A, 0xA36B, 0xA36C, 0xA36D, 0xA36E, 0xA36F, 0xA370, 0xA371, 0xA372, 0xA373, 0xA374, 0xA375, 0xA376, 0xA377, 0xA378, 0xA379, 0xA37A, 0xA37B, 0xA37C, 0xA37D, 0xA37E, 0xA37F, 0xA380, 0xA381, 0xA382, 0xA383, 0xA384, 0xA385, 0xA386, 0xA387, 0xA388, 0xA389, 0xA38A, 0xA38B, 0xA38C, 0xA38D, 0xA38E, 0xA38F, 0xA390, 0xA391, 0xA392, 0xA393, 0xA394, 0xA395, 0xA396, 0xA397, 0xA398, 0xA399, 0xA39A, 0xA39B, 0xA39C, 0xA39D, 0xA39E, 0xA39F, 0xA3A0, 0xA3A1, 0xA3A2, 0xA3A3, 0xA3A4, 0xA3A5, 0xA3A6, 0xA3A7, 0xA3A8, 0xA3A9, 0xA3AA, 0xA3AB, 0xA3AC, 0xA3AD, 0xA3AE, 0xA3AF, 0xA3B0, 0xA3B1, 0xA3B2, 0xA3B3, 0xA3B4, 0xA3B5, 0xA3B6, 0xA3B7, 0xA3B8, 0xA3B9, 0xA3BA, 0xA3BB, 0xA3BC, 0xA3BD, 0xA3BE, 0xA3BF, 0xA3C0, 0xA3C1, 0xA3C2, 0xA3C3, 0xA3C4, 0xA3C5, 0xA3C6, 0xA3C7, 0xA3C8, 0xA3C9, 0xA3CA, 0xA3CB, 0xA3CC, 0xA3CD, 0xA3CE, 0xA3CF, 0xA3D0, 0xA3D1, 0xA3D2, 0xA3D3, 0xA3D4, 0xA3D5, 0xA3D6, 0xA3D7, 0xA3D8, 0xA3D9, 0xA3DA, 0xA3DB, 0xA3DC, 0xA3DD, 0xA3DE, 0xA3DF, 0xA3E0, 0xA3E1, 0xA3E2, 0xA3E3, 0xA3E4, 0xA3E5, 0xA3E6, 0xA3E7, 0xA3E8, 0xA3E9, 0xA3EA, 0xA3EB, 0xA3EC, 0xA3ED, 0xA3EE, 0xA3EF, 0xA3F0, 0xA3F1, 0xA3F2, 0xA3F3, 0xA3F4, 0xA3F5, 0xA3F6, 0xA3F7, 0xA3F8, 0xA3F9, 0xA3FA, 0xA3FB, 0xA3FC, 0xA3FD, 0xA3FE, 0xA3FF, 0xA400, 0xA401, 0xA402, 0xA403, 0xA404, 0xA405, 0xA406, 0xA407, 0xA408, 0xA409, 0xA40A, 0xA40B, 0xA40C, 0xA40D, 0xA40E, 0xA40F, 0xA410, 0xA411, 0xA412, 0xA413, 0xA414, 0xA415, 0xA416, 0xA417, 0xA418, 0xA419, 0xA41A, 0xA41B, 0xA41C, 0xA41D, 0xA41E, 0xA41F, 0xA420, 0xA421, 0xA422, 0xA423, 0xA424, 0xA425, 0xA426, 0xA427, 0xA428, 0xA429, 0xA42A, 0xA42B, 0xA42C, 0xA42D, 0xA42E, 0xA42F, 0xA430, 0xA431, 0xA432, 0xA433, 0xA434, 0xA435, 0xA436, 0xA437, 0xA438, 0xA439, 0xA43A, 0xA43B, 0xA43C, 0xA43D, 0xA43E, 0xA43F, 0xA440, 0xA441, 0xA442, 0xA443, 0xA444, 0xA445, 0xA446, 0xA447, 0xA448, 0xA449, 0xA44A, 0xA44B, 0xA44C, 0xA44D, 0xA44E, 0xA44F, 0xA450, 0xA451, 0xA452, 0xA453, 0xA454, 0xA455, 0xA456, 0xA457, 0xA458, 0xA459, 0xA45A, 0xA45B, 0xA45C, 0xA45D, 0xA45E, 0xA45F, 0xA460, 0xA461, 0xA462, 0xA463, 0xA464, 0xA465, 0xA466, 0xA467, 0xA468, 0xA469, 0xA46A, 0xA46B, 0xA46C, 0xA46D, 0xA46E, 0xA46F, 0xA470, 0xA471, 0xA472, 0xA473, 0xA474, 0xA475, 0xA476, 0xA477, 0xA478, 0xA479, 0xA47A, 0xA47B, 0xA47C, 0xA47D, 0xA47E, 0xA47F, 0xA480, 0xA481, 0xA482, 0xA483, 0xA484, 0xA485, 0xA486, 0xA487, 0xA488, 0xA489, 0xA48A, 0xA48B, 0xA48C, 0xA490, 0xA491, 0xA492, 0xA493, 0xA494, 0xA495, 0xA496, 0xA497, 0xA498, 0xA499, 0xA49A, 0xA49B, 0xA49C, 0xA49D, 0xA49E, 0xA49F, 0xA4A0, 0xA4A1, 0xA4A2, 0xA4A3, 0xA4A4, 0xA4A5, 0xA4A6, 0xA4A7, 0xA4A8, 0xA4A9, 0xA4AA, 0xA4AB, 0xA4AC, 0xA4AD, 0xA4AE, 0xA4AF, 0xA4B0, 0xA4B1, 0xA4B2, 0xA4B3, 0xA4B4, 0xA4B5, 0xA4B6, 0xA4B7, 0xA4B8, 0xA4B9, 0xA4BA, 0xA4BB, 0xA4BC, 0xA4BD, 0xA4BE, 0xA4BF, 0xA4C0, 0xA4C1, 0xA4C2, 0xA4C3, 0xA4C4, 0xA4C5, 0xA4C6, 0xA960, 0xA961, 0xA962, 0xA963, 0xA964, 0xA965, 0xA966, 0xA967, 0xA968, 0xA969, 0xA96A, 0xA96B, 0xA96C, 0xA96D, 0xA96E, 0xA96F, 0xA970, 0xA971, 0xA972, 0xA973, 0xA974, 0xA975, 0xA976, 0xA977, 0xA978, 0xA979, 0xA97A, 0xA97B, 0xA97C, 0xD7B0, 0xD7B1, 0xD7B2, 0xD7B3, 0xD7B4, 0xD7B5, 0xD7B6, 0xD7B7, 0xD7B8, 0xD7B9, 0xD7BA, 0xD7BB, 0xD7BC, 0xD7BD, 0xD7BE, 0xD7BF, 0xD7C0, 0xD7C1, 0xD7C2, 0xD7C3, 0xD7C4, 0xD7C5, 0xD7C6, 0xD7CB, 0xD7CC, 0xD7CD, 0xD7CE, 0xD7CF, 0xD7D0, 0xD7D1, 0xD7D2, 0xD7D3, 0xD7D4, 0xD7D5, 0xD7D6, 0xD7D7, 0xD7D8, 0xD7D9, 0xD7DA, 0xD7DB, 0xD7DC, 0xD7DD, 0xD7DE, 0xD7DF, 0xD7E0, 0xD7E1, 0xD7E2, 0xD7E3, 0xD7E4, 0xD7E5, 0xD7E6, 0xD7E7, 0xD7E8, 0xD7E9, 0xD7EA, 0xD7EB, 0xD7EC, 0xD7ED, 0xD7EE, 0xD7EF, 0xD7F0, 0xD7F1, 0xD7F2, 0xD7F3, 0xD7F4, 0xD7F5, 0xD7F6, 0xD7F7, 0xD7F8, 0xD7F9, 0xD7FA, 0xD7FB, 0xF900, 0xF901, 0xF902, 0xF903, 0xF904, 0xF905, 0xF906, 0xF907, 0xF908, 0xF909, 0xF90A, 0xF90B, 0xF90C, 0xF90D, 0xF90E, 0xF90F, 0xF910, 0xF911, 0xF912, 0xF913, 0xF914, 0xF915, 0xF916, 0xF917, 0xF918, 0xF919, 0xF91A, 0xF91B, 0xF91C, 0xF91D, 0xF91E, 0xF91F, 0xF920, 0xF921, 0xF922, 0xF923, 0xF924, 0xF925, 0xF926, 0xF927, 0xF928, 0xF929, 0xF92A, 0xF92B, 0xF92C, 0xF92D, 0xF92E, 0xF92F, 0xF930, 0xF931, 0xF932, 0xF933, 0xF934, 0xF935, 0xF936, 0xF937, 0xF938, 0xF939, 0xF93A, 0xF93B, 0xF93C, 0xF93D, 0xF93E, 0xF93F, 0xF940, 0xF941, 0xF942, 0xF943, 0xF944, 0xF945, 0xF946, 0xF947, 0xF948, 0xF949, 0xF94A, 0xF94B, 0xF94C, 0xF94D, 0xF94E, 0xF94F, 0xF950, 0xF951, 0xF952, 0xF953, 0xF954, 0xF955, 0xF956, 0xF957, 0xF958, 0xF959, 0xF95A, 0xF95B, 0xF95C, 0xF95D, 0xF95E, 0xF95F, 0xF960, 0xF961, 0xF962, 0xF963, 0xF964, 0xF965, 0xF966, 0xF967, 0xF968, 0xF969, 0xF96A, 0xF96B, 0xF96C, 0xF96D, 0xF96E, 0xF96F, 0xF970, 0xF971, 0xF972, 0xF973, 0xF974, 0xF975, 0xF976, 0xF977, 0xF978, 0xF979, 0xF97A, 0xF97B, 0xF97C, 0xF97D, 0xF97E, 0xF97F, 0xF980, 0xF981, 0xF982, 0xF983, 0xF984, 0xF985, 0xF986, 0xF987, 0xF988, 0xF989, 0xF98A, 0xF98B, 0xF98C, 0xF98D, 0xF98E, 0xF98F, 0xF990, 0xF991, 0xF992, 0xF993, 0xF994, 0xF995, 0xF996, 0xF997, 0xF998, 0xF999, 0xF99A, 0xF99B, 0xF99C, 0xF99D, 0xF99E, 0xF99F, 0xF9A0, 0xF9A1, 0xF9A2, 0xF9A3, 0xF9A4, 0xF9A5, 0xF9A6, 0xF9A7, 0xF9A8, 0xF9A9, 0xF9AA, 0xF9AB, 0xF9AC, 0xF9AD, 0xF9AE, 0xF9AF, 0xF9B0, 0xF9B1, 0xF9B2, 0xF9B3, 0xF9B4, 0xF9B5, 0xF9B6, 0xF9B7, 0xF9B8, 0xF9B9, 0xF9BA, 0xF9BB, 0xF9BC, 0xF9BD, 0xF9BE, 0xF9BF, 0xF9C0, 0xF9C1, 0xF9C2, 0xF9C3, 0xF9C4, 0xF9C5, 0xF9C6, 0xF9C7, 0xF9C8, 0xF9C9, 0xF9CA, 0xF9CB, 0xF9CC, 0xF9CD, 0xF9CE, 0xF9CF, 0xF9D0, 0xF9D1, 0xF9D2, 0xF9D3, 0xF9D4, 0xF9D5, 0xF9D6, 0xF9D7, 0xF9D8, 0xF9D9, 0xF9DA, 0xF9DB, 0xF9DC, 0xF9DD, 0xF9DE, 0xF9DF, 0xF9E0, 0xF9E1, 0xF9E2, 0xF9E3, 0xF9E4, 0xF9E5, 0xF9E6, 0xF9E7, 0xF9E8, 0xF9E9, 0xF9EA, 0xF9EB, 0xF9EC, 0xF9ED, 0xF9EE, 0xF9EF, 0xF9F0, 0xF9F1, 0xF9F2, 0xF9F3, 0xF9F4, 0xF9F5, 0xF9F6, 0xF9F7, 0xF9F8, 0xF9F9, 0xF9FA, 0xF9FB, 0xF9FC, 0xF9FD, 0xF9FE, 0xF9FF, 0xFA00, 0xFA01, 0xFA02, 0xFA03, 0xFA04, 0xFA05, 0xFA06, 0xFA07, 0xFA08, 0xFA09, 0xFA0A, 0xFA0B, 0xFA0C, 0xFA0D, 0xFA0E, 0xFA0F, 0xFA10, 0xFA11, 0xFA12, 0xFA13, 0xFA14, 0xFA15, 0xFA16, 0xFA17, 0xFA18, 0xFA19, 0xFA1A, 0xFA1B, 0xFA1C, 0xFA1D, 0xFA1E, 0xFA1F, 0xFA20, 0xFA21, 0xFA22, 0xFA23, 0xFA24, 0xFA25, 0xFA26, 0xFA27, 0xFA28, 0xFA29, 0xFA2A, 0xFA2B, 0xFA2C, 0xFA2D, 0xFA2E, 0xFA2F, 0xFA30, 0xFA31, 0xFA32, 0xFA33, 0xFA34, 0xFA35, 0xFA36, 0xFA37, 0xFA38, 0xFA39, 0xFA3A, 0xFA3B, 0xFA3C, 0xFA3D, 0xFA3E, 0xFA3F, 0xFA40, 0xFA41, 0xFA42, 0xFA43, 0xFA44, 0xFA45, 0xFA46, 0xFA47, 0xFA48, 0xFA49, 0xFA4A, 0xFA4B, 0xFA4C, 0xFA4D, 0xFA4E, 0xFA4F, 0xFA50, 0xFA51, 0xFA52, 0xFA53, 0xFA54, 0xFA55, 0xFA56, 0xFA57, 0xFA58, 0xFA59, 0xFA5A, 0xFA5B, 0xFA5C, 0xFA5D, 0xFA5E, 0xFA5F, 0xFA60, 0xFA61, 0xFA62, 0xFA63, 0xFA64, 0xFA65, 0xFA66, 0xFA67, 0xFA68, 0xFA69, 0xFA6A, 0xFA6B, 0xFA6C, 0xFA6D, 0xFA70, 0xFA71, 0xFA72, 0xFA73, 0xFA74, 0xFA75, 0xFA76, 0xFA77, 0xFA78, 0xFA79, 0xFA7A, 0xFA7B, 0xFA7C, 0xFA7D, 0xFA7E, 0xFA7F, 0xFA80, 0xFA81, 0xFA82, 0xFA83, 0xFA84, 0xFA85, 0xFA86, 0xFA87, 0xFA88, 0xFA89, 0xFA8A, 0xFA8B, 0xFA8C, 0xFA8D, 0xFA8E, 0xFA8F, 0xFA90, 0xFA91, 0xFA92, 0xFA93, 0xFA94, 0xFA95, 0xFA96, 0xFA97, 0xFA98, 0xFA99, 0xFA9A, 0xFA9B, 0xFA9C, 0xFA9D, 0xFA9E, 0xFA9F, 0xFAA0, 0xFAA1, 0xFAA2, 0xFAA3, 0xFAA4, 0xFAA5, 0xFAA6, 0xFAA7, 0xFAA8, 0xFAA9, 0xFAAA, 0xFAAB, 0xFAAC, 0xFAAD, 0xFAAE, 0xFAAF, 0xFAB0, 0xFAB1, 0xFAB2, 0xFAB3, 0xFAB4, 0xFAB5, 0xFAB6, 0xFAB7, 0xFAB8, 0xFAB9, 0xFABA, 0xFABB, 0xFABC, 0xFABD, 0xFABE, 0xFABF, 0xFAC0, 0xFAC1, 0xFAC2, 0xFAC3, 0xFAC4, 0xFAC5, 0xFAC6, 0xFAC7, 0xFAC8, 0xFAC9, 0xFACA, 0xFACB, 0xFACC, 0xFACD, 0xFACE, 0xFACF, 0xFAD0, 0xFAD1, 0xFAD2, 0xFAD3, 0xFAD4, 0xFAD5, 0xFAD6, 0xFAD7, 0xFAD8, 0xFAD9, 0xFE10, 0xFE11, 0xFE12, 0xFE13, 0xFE14, 0xFE15, 0xFE16, 0xFE17, 0xFE18, 0xFE19, 0xFE30, 0xFE31, 0xFE32, 0xFE33, 0xFE34, 0xFE35, 0xFE36, 0xFE37, 0xFE38, 0xFE39, 0xFE3A, 0xFE3B, 0xFE3C, 0xFE3D, 0xFE3E, 0xFE3F, 0xFE40, 0xFE41, 0xFE42, 0xFE43, 0xFE44, 0xFE45, 0xFE46, 0xFE47, 0xFE48, 0xFE49, 0xFE4A, 0xFE4B, 0xFE4C, 0xFE4D, 0xFE4E, 0xFE4F, 0xFE50, 0xFE51, 0xFE52, 0xFE54, 0xFE55, 0xFE56, 0xFE57, 0xFE58, 0xFE59, 0xFE5A, 0xFE5B, 0xFE5C, 0xFE5D, 0xFE5E, 0xFE5F, 0xFE60, 0xFE61, 0xFE62, 0xFE63, 0xFE64, 0xFE65, 0xFE66, 0xFE68, 0xFE69, 0xFE6A, 0xFE6B, 0x1B000, 0x1B001, 0x1F200, 0x1F201, 0x1F202, 0x1F210, 0x1F211, 0x1F212, 0x1F213, 0x1F214, 0x1F215, 0x1F216, 0x1F217, 0x1F218, 0x1F219, 0x1F21A, 0x1F21B, 0x1F21C, 0x1F21D, 0x1F21E, 0x1F21F, 0x1F220, 0x1F221, 0x1F222, 0x1F223, 0x1F224, 0x1F225, 0x1F226, 0x1F227, 0x1F228, 0x1F229, 0x1F22A, 0x1F22B, 0x1F22C, 0x1F22D, 0x1F22E, 0x1F22F, 0x1F230, 0x1F231, 0x1F232, 0x1F233, 0x1F234, 0x1F235, 0x1F236, 0x1F237, 0x1F238, 0x1F239, 0x1F23A, 0x1F240, 0x1F241, 0x1F242, 0x1F243, 0x1F244, 0x1F245, 0x1F246, 0x1F247, 0x1F248, 0x1F250, 0x1F251, 0x2F800, 0x2F801, 0x2F802, 0x2F803, 0x2F804, 0x2F805, 0x2F806, 0x2F807, 0x2F808, 0x2F809, 0x2F80A, 0x2F80B, 0x2F80C, 0x2F80D, 0x2F80E, 0x2F80F, 0x2F810, 0x2F811, 0x2F812, 0x2F813, 0x2F814, 0x2F815, 0x2F816, 0x2F817, 0x2F818, 0x2F819, 0x2F81A, 0x2F81B, 0x2F81C, 0x2F81D, 0x2F81E, 0x2F81F, 0x2F820, 0x2F821, 0x2F822, 0x2F823, 0x2F824, 0x2F825, 0x2F826, 0x2F827, 0x2F828, 0x2F829, 0x2F82A, 0x2F82B, 0x2F82C, 0x2F82D, 0x2F82E, 0x2F82F, 0x2F830, 0x2F831, 0x2F832, 0x2F833, 0x2F834, 0x2F835, 0x2F836, 0x2F837, 0x2F838, 0x2F839, 0x2F83A, 0x2F83B, 0x2F83C, 0x2F83D, 0x2F83E, 0x2F83F, 0x2F840, 0x2F841, 0x2F842, 0x2F843, 0x2F844, 0x2F845, 0x2F846, 0x2F847, 0x2F848, 0x2F849, 0x2F84A, 0x2F84B, 0x2F84C, 0x2F84D, 0x2F84E, 0x2F84F, 0x2F850, 0x2F851, 0x2F852, 0x2F853, 0x2F854, 0x2F855, 0x2F856, 0x2F857, 0x2F858, 0x2F859, 0x2F85A, 0x2F85B, 0x2F85C, 0x2F85D, 0x2F85E, 0x2F85F, 0x2F860, 0x2F861, 0x2F862, 0x2F863, 0x2F864, 0x2F865, 0x2F866, 0x2F867, 0x2F868, 0x2F869, 0x2F86A, 0x2F86B, 0x2F86C, 0x2F86D, 0x2F86E, 0x2F86F, 0x2F870, 0x2F871, 0x2F872, 0x2F873, 0x2F874, 0x2F875, 0x2F876, 0x2F877, 0x2F878, 0x2F879, 0x2F87A, 0x2F87B, 0x2F87C, 0x2F87D, 0x2F87E, 0x2F87F, 0x2F880, 0x2F881, 0x2F882, 0x2F883, 0x2F884, 0x2F885, 0x2F886, 0x2F887, 0x2F888, 0x2F889, 0x2F88A, 0x2F88B, 0x2F88C, 0x2F88D, 0x2F88E, 0x2F88F, 0x2F890, 0x2F891, 0x2F892, 0x2F893, 0x2F894, 0x2F895, 0x2F896, 0x2F897, 0x2F898, 0x2F899, 0x2F89A, 0x2F89B, 0x2F89C, 0x2F89D, 0x2F89E, 0x2F89F, 0x2F8A0, 0x2F8A1, 0x2F8A2, 0x2F8A3, 0x2F8A4, 0x2F8A5, 0x2F8A6, 0x2F8A7, 0x2F8A8, 0x2F8A9, 0x2F8AA, 0x2F8AB, 0x2F8AC, 0x2F8AD, 0x2F8AE, 0x2F8AF, 0x2F8B0, 0x2F8B1, 0x2F8B2, 0x2F8B3, 0x2F8B4, 0x2F8B5, 0x2F8B6, 0x2F8B7, 0x2F8B8, 0x2F8B9, 0x2F8BA, 0x2F8BB, 0x2F8BC, 0x2F8BD, 0x2F8BE, 0x2F8BF, 0x2F8C0, 0x2F8C1, 0x2F8C2, 0x2F8C3, 0x2F8C4, 0x2F8C5, 0x2F8C6, 0x2F8C7, 0x2F8C8, 0x2F8C9, 0x2F8CA, 0x2F8CB, 0x2F8CC, 0x2F8CD, 0x2F8CE, 0x2F8CF, 0x2F8D0, 0x2F8D1, 0x2F8D2, 0x2F8D3, 0x2F8D4, 0x2F8D5, 0x2F8D6, 0x2F8D7, 0x2F8D8, 0x2F8D9, 0x2F8DA, 0x2F8DB, 0x2F8DC, 0x2F8DD, 0x2F8DE, 0x2F8DF, 0x2F8E0, 0x2F8E1, 0x2F8E2, 0x2F8E3, 0x2F8E4, 0x2F8E5, 0x2F8E6, 0x2F8E7, 0x2F8E8, 0x2F8E9, 0x2F8EA, 0x2F8EB, 0x2F8EC, 0x2F8ED, 0x2F8EE, 0x2F8EF, 0x2F8F0, 0x2F8F1, 0x2F8F2, 0x2F8F3, 0x2F8F4, 0x2F8F5, 0x2F8F6, 0x2F8F7, 0x2F8F8, 0x2F8F9, 0x2F8FA, 0x2F8FB, 0x2F8FC, 0x2F8FD, 0x2F8FE, 0x2F8FF, 0x2F900, 0x2F901, 0x2F902, 0x2F903, 0x2F904, 0x2F905, 0x2F906, 0x2F907, 0x2F908, 0x2F909, 0x2F90A, 0x2F90B, 0x2F90C, 0x2F90D, 0x2F90E, 0x2F90F, 0x2F910, 0x2F911, 0x2F912, 0x2F913, 0x2F914, 0x2F915, 0x2F916, 0x2F917, 0x2F918, 0x2F919, 0x2F91A, 0x2F91B, 0x2F91C, 0x2F91D, 0x2F91E, 0x2F91F, 0x2F920, 0x2F921, 0x2F922, 0x2F923, 0x2F924, 0x2F925, 0x2F926, 0x2F927, 0x2F928, 0x2F929, 0x2F92A, 0x2F92B, 0x2F92C, 0x2F92D, 0x2F92E, 0x2F92F, 0x2F930, 0x2F931, 0x2F932, 0x2F933, 0x2F934, 0x2F935, 0x2F936, 0x2F937, 0x2F938, 0x2F939, 0x2F93A, 0x2F93B, 0x2F93C, 0x2F93D, 0x2F93E, 0x2F93F, 0x2F940, 0x2F941, 0x2F942, 0x2F943, 0x2F944, 0x2F945, 0x2F946, 0x2F947, 0x2F948, 0x2F949, 0x2F94A, 0x2F94B, 0x2F94C, 0x2F94D, 0x2F94E, 0x2F94F, 0x2F950, 0x2F951, 0x2F952, 0x2F953, 0x2F954, 0x2F955, 0x2F956, 0x2F957, 0x2F958, 0x2F959, 0x2F95A, 0x2F95B, 0x2F95C, 0x2F95D, 0x2F95E, 0x2F95F, 0x2F960, 0x2F961, 0x2F962, 0x2F963, 0x2F964, 0x2F965, 0x2F966, 0x2F967, 0x2F968, 0x2F969, 0x2F96A, 0x2F96B, 0x2F96C, 0x2F96D, 0x2F96E, 0x2F96F, 0x2F970, 0x2F971, 0x2F972, 0x2F973, 0x2F974, 0x2F975, 0x2F976, 0x2F977, 0x2F978, 0x2F979, 0x2F97A, 0x2F97B, 0x2F97C, 0x2F97D, 0x2F97E, 0x2F97F, 0x2F980, 0x2F981, 0x2F982, 0x2F983, 0x2F984, 0x2F985, 0x2F986, 0x2F987, 0x2F988, 0x2F989, 0x2F98A, 0x2F98B, 0x2F98C, 0x2F98D, 0x2F98E, 0x2F98F, 0x2F990, 0x2F991, 0x2F992, 0x2F993, 0x2F994, 0x2F995, 0x2F996, 0x2F997, 0x2F998, 0x2F999, 0x2F99A, 0x2F99B, 0x2F99C, 0x2F99D, 0x2F99E, 0x2F99F, 0x2F9A0, 0x2F9A1, 0x2F9A2, 0x2F9A3, 0x2F9A4, 0x2F9A5, 0x2F9A6, 0x2F9A7, 0x2F9A8, 0x2F9A9, 0x2F9AA, 0x2F9AB, 0x2F9AC, 0x2F9AD, 0x2F9AE, 0x2F9AF, 0x2F9B0, 0x2F9B1, 0x2F9B2, 0x2F9B3, 0x2F9B4, 0x2F9B5, 0x2F9B6, 0x2F9B7, 0x2F9B8, 0x2F9B9, 0x2F9BA, 0x2F9BB, 0x2F9BC, 0x2F9BD, 0x2F9BE, 0x2F9BF, 0x2F9C0, 0x2F9C1, 0x2F9C2, 0x2F9C3, 0x2F9C4, 0x2F9C5, 0x2F9C6, 0x2F9C7, 0x2F9C8, 0x2F9C9, 0x2F9CA, 0x2F9CB, 0x2F9CC, 0x2F9CD, 0x2F9CE, 0x2F9CF, 0x2F9D0, 0x2F9D1, 0x2F9D2, 0x2F9D3, 0x2F9D4, 0x2F9D5, 0x2F9D6, 0x2F9D7, 0x2F9D8, 0x2F9D9, 0x2F9DA, 0x2F9DB, 0x2F9DC, 0x2F9DD, 0x2F9DE, 0x2F9DF, 0x2F9E0, 0x2F9E1, 0x2F9E2, 0x2F9E3, 0x2F9E4, 0x2F9E5, 0x2F9E6, 0x2F9E7, 0x2F9E8, 0x2F9E9, 0x2F9EA, 0x2F9EB, 0x2F9EC, 0x2F9ED, 0x2F9EE, 0x2F9EF, 0x2F9F0, 0x2F9F1, 0x2F9F2, 0x2F9F3, 0x2F9F4, 0x2F9F5, 0x2F9F6, 0x2F9F7, 0x2F9F8, 0x2F9F9, 0x2F9FA, 0x2F9FB, 0x2F9FC, 0x2F9FD, 0x2F9FE, 0x2F9FF, 0x2FA00, 0x2FA01, 0x2FA02, 0x2FA03, 0x2FA04, 0x2FA05, 0x2FA06, 0x2FA07, 0x2FA08, 0x2FA09, 0x2FA0A, 0x2FA0B, 0x2FA0C, 0x2FA0D, 0x2FA0E, 0x2FA0F, 0x2FA10, 0x2FA11, 0x2FA12, 0x2FA13, 0x2FA14, 0x2FA15, 0x2FA16, 0x2FA17, 0x2FA18, 0x2FA19, 0x2FA1A, 0x2FA1B, 0x2FA1C, 0x2FA1D };

	std::set<uint32_t> res;
	iterate(ch, Fixed)
		res.insert(*ch);
	return res;
}

static std::map<uint32_t, bool> east_asian_width_ranges ()
{
	static uint32_t RangeBegin[] = { 0x3400, 0x4DB6, 0x4E00, 0x9FCD, 0xAC00, 0xFA6E, 0xFADA, 0x20000, 0x2A6D7, 0x2A700, 0x2B735, 0x2B740, 0x2B81E, 0x2FA1E, 0x30000 };
	static uint32_t RangeEnd[]   = { 0x4DB5, 0x4DBF, 0x9FCC, 0x9FFF, 0xD7A3, 0xFA6F, 0xFAFF, 0x2A6D6, 0x2A6FF, 0x2B734, 0x2B73F, 0x2B81D, 0x2F7FF, 0x2FFFD, 0x3FFFD };

	std::map<uint32_t, bool> res;
	iterate(ch, RangeEnd)
		res.insert(std::make_pair(*ch + 1, false));
	iterate(ch, RangeBegin)
		res.insert(std::make_pair(*ch, true));
	return res;
}

namespace text
{
	bool is_east_asian_width (uint32_t ch)
	{
		if(ch < 0x1100)
			return false;

		static std::set<uint32_t> const fixed = east_asian_width_fixed();
		if(fixed.find(ch) != fixed.end())
			return true;

		static std::map<uint32_t, bool> const ranges = east_asian_width_ranges();
		auto it = ranges.lower_bound(ch);
		if(it != ranges.end())
			return it->first == ch ? it->second : !it->second;

		return false;
	}

} /* text */