unit Setting;

interface

uses
	SysUtils, Classes, Graphics, Forms, Math, IniFiles, UCryptAuto, UBase64,
	ComCtrls;

const
	MAIN_COOLBAND_COUNT = 4;		//CCoolBand̐
	LIST_COOLBAND_COUNT = 2;		//CoolBand̐
	BROWSER_COOLBAND_COUNT = 3;	//uEUCoolBand̐

type
	TGikoTabPosition = (gtpTop, gtpBottom);								// ^uʒu
	TGikoTabAppend = (gtaFirst, gtpLast);									// ^uǉʒu
	TGikoTabStyle = (gtsTab, gtsButton, gtsFlat);					// ^uX^C
	TGikoListOrientation = (gloHorizontal, gloVertical);	// XgE
	TGikoListState = (glsMax, glsNormal, glsMin);					// XgTCY
																												// |bvAbv\ʒu
	TGikoPopupPosition = (gppRightTop, gppTop, gppLeftTop,
												gppRight, gppCenter, gppLeft,
												gppRightBottom, gppBottom, gppLeftBottom);
																												//vr[TCY
	TGikoPreviewSize = (gpsXLarge, gpsLarge, gpsMedium, gpsSmall, gpsXSmall);

	//CoolBarݒ背R[h
	TCoolSet = record
		FCoolID: Integer;
		FCoolWidth: Integer;
		FCoolBreak: Boolean;
	end;

	TSetting = class(TObject)
	private
		//Mobt@TCY
		FRecvBufferSize: Integer;
		//HTTP1.1gp
		FProtocol: Boolean;
		//vLVڑHTTP1.1gp
		FProxyProtocol: Boolean;

		//vLViǍpj
		FReadProxy: Boolean;
		FReadProxyAddress: string;
		FReadProxyPort: Integer;
		FReadProxyUserID: string;
		FReadProxyPassword: string;

		//vLVipj
		FWriteProxy: Boolean;
		FWriteProxyAddress: string;
		FWriteProxyPort: Integer;
		FWriteProxyUserID: string;
		FWriteProxyPassword: string;

		//Lrlbg
		FCabinetFontName: string;
		FCabinetFontSize: Integer;
		FCabinetFontBold: Boolean;
		FCabinetFontItalic: Boolean;
		FCabinetFontColor: TColor;
		FCabinetBackColor: TColor;

		//Xg
		FListFontName: string;
		FListFontSize: Integer;
		FListFontBold: Boolean;
		FListFontItalic: Boolean;
		FListFontColor: TColor;
		FListBackColor: TColor;

		//uEU
		//FBrowserFontColor: TColor;
		//FBrowserBackColor: TColor;
		//FBrowserFontSize: Integer;

		//GfB^
		FEditorFontName: string;
		FEditorFontSize: Integer;
		FEditorFontBold: Boolean;
		FEditorFontItalic: Boolean;
		FEditorFontColor: TColor;
		FEditorBackColor: TColor;

		//^utHg
		FBrowserTabFontName: string;
		FBrowserTabFontSize: Integer;
		FBrowserTabFontBold: Boolean;
		FBrowserTabFontItalic: Boolean;

		//qgEBhE
		FHintFontName: string;
		FHintFontSize: Integer;
		//FHintFontBold: Boolean;
		//FHintFontItalic: Boolean;
		FHintFontColor: TColor;
		FHintBackColor: TColor;

		//EBhETCY
		FWindowTop: Integer;
		FWindowLeft: Integer;
		FWindowHeight: Integer;
		FWindowWidth: Integer;
		FWindowMax: Boolean;
		//Xgr[X^C
		FListStyle: TViewStyle;

		//c[o[\
		FStdToolBarVisible: Boolean;
		FAddressBarVisible: Boolean;
		FLinkBarVisible: Boolean;
		FListToolBarVisible: Boolean;
		FListNameBarVisible: Boolean;
		FBrowserToolBarVisible: Boolean;
		FBrowserNameBarVisible: Boolean;

		//uEU^u
		FBrowserTabVisible: Boolean;
		FBrowserTabPosition: TGikoTabPosition;
		FBrowserTabAppend: TGikoTabAppend;
		FBrowserTabStyle: TGikoTabStyle;

		//bZ[Wo[
		FMessageBarVisible: Boolean;
		FMessegeBarHeight: Integer;

		//Xe[^Xo[
		FStatusBarVisible: Boolean;

		//LrlbgETCY
		FCabinetVisible: Boolean;
		FCabinetWidth: Integer;

		//XgEuEUTCY
		FListOrientation: TGikoListOrientation;
		FListHeight: Integer;
		FListHeightState: TGikoListState;
		FListWidth: Integer;
		FListWidthState: TGikoListState;
//		FListHeightMax: Boolean;
//		FListWidthMax: Boolean;

		//MpOE[
		FNameList: TStringList;
		FMailList: TStringList;

		//GfB^[EBhETCY
		FEditWindowTop: Integer;
		FEditWindowLeft: Integer;
		FEditWindowHeight: Integer;
		FEditWindowWidth: Integer;
		FEditWindowMax: Boolean;

		//Xgԍ\
		FListViewNo: Boolean;
		//CSS\
		FUseCSS: Boolean;
		//CSSt@C
		FCSSFileName: string;
		//mail\
		FShowMail: Boolean;
		//ANeBuX|bvAbv\
		FUnActivePopup: Boolean;
		//X|bvAbvwb_[{[h
		FResPopupHeaderBold: Boolean;

		//OtH_
		FLogFolder: string;
		FNewLogFolder: string;

		//XgJwb_[TCY
		FBBSColumnWidth: array[0..0] of Integer;
		FCategoryColumnWidth: array[0..3] of Integer;
		FBoardColumnWidth: array[0..6] of Integer;

		//iݕ
		FSelectTextList: TStringList;

		//ꗗURL
		FBoardURL2ch: string;

		//[UIDEpX[h
		FUserID: string;
		FPassword: string;
		FAutoLogin: Boolean;

		//URLNbNNAv
		FURLApp: Boolean;
		FURLAppFile: string;

		//mailtoNbN
		FOpenMailer: Boolean;

		//폜mF
		FDeleteMsg: Boolean;

		//CoolBariCEEuEUj
		FMainCoolBar: array[0..MAIN_COOLBAND_COUNT - 1] of TCoolSet;
		FListCoolBar: array[0..LIST_COOLBAND_COUNT - 1] of TCoolSet;
		FBrowserCoolBar: array[0..BROWSER_COOLBAND_COUNT - 1] of TCoolSet;

		//ToolBar Wrapable
		FListToolBarWrapable: Boolean;
		FBrowserToolBarWrapable: Boolean;

		//|bvAbvʒu
		FPopupPosition: TGikoPopupPosition;

		//AhXo[
		FURLDisplay: Boolean;
		FAddressBarTabStop: Boolean;
		FLinkAddAddressBar: Boolean;
		FAddressHistoryCount: Integer;

		//摜vr[
		FPreviewVisible: Boolean;
		FPreviewSize: TGikoPreviewSize;
		FPreviewWait: Integer;

		//XbhꗗXVACR\
		FListIconVisible: Boolean;

		//ݎ}VԎgpݒ
		FUseMachineTime: Boolean;
		FTimeAdjustSec: Integer;
		FTimeAdjust: Boolean;

        //ځ`
        FAbonDeleterlo : Boolean; //&rlo;邩
        FAbonReplaceul : Boolean; //<ul>^O<br>^Oɒu邩
        FPopUpAbon     : Boolean; //X|bvAbv̂ځ`L

    // XbhitB[h̕
    FSelectComboBoxWidth : Integer;

		function GetMainCoolSet(Index: Integer): TCoolSet;
		function GetBoardCoolSet(Index: Integer): TCoolSet;
		function GetBrowserCoolSet(Index: Integer): TCoolSet;
		procedure SetMainCoolSet(Index: Integer; CoolSet: TCoolSet);
		procedure SetBoardCoolSet(Index: Integer; CoolSet: TCoolSet);
		procedure SetBrowserCoolSet(Index: Integer; CoolSet: TCoolSet);

		function GetBBSColumnWidth(index: Integer): Integer;
		function GetCategoryColumnWidth(index: Integer): Integer;
		function GetBoardColumnWidth(index: Integer): Integer;
		procedure SetBBSColumnWidth(index: Integer; value: Integer);
		procedure SetCategoryColumnWidth(index: Integer; value: Integer);
		procedure SetBoardColumnWidth(index: Integer; value: Integer);

		function GetSoundName(Index: Integer): string;
		function GetSoundViewName(Index: Integer): string;
		function GetSoundFileName(Index: Integer): string;
		procedure SetSoundFileName(Index: Integer; value: string);
		function Encrypt(s: string): string;
		function Decrypt(s: string): string;
	protected

	public
		constructor Create;
		destructor Destroy; override;
		function GetFileName: string;
		procedure ReadSettingFile;
		procedure WriteSystemSettingFile;
		procedure WriteWindowSettingFile;
		procedure WriteNameMailSettingFile;
		procedure WriteFolderSettingFile();
		function GetSoundCount: Integer;
		function FindSoundFileName(Name: string): string;

		//Mobt@TCY
		property RecvBufferSize: Integer read FRecvBufferSize write FRecvBufferSize;
		//HTTP1.1gp
		property Protocol: Boolean read FProtocol write FProtocol;
		//vLVڑHTTP1.1gp
		property ProxyProtocol: Boolean read FProxyProtocol write FProxyProtocol;

		property ReadProxy: Boolean read FReadProxy write FReadProxy;
		property ReadProxyAddress: string read FReadProxyAddress write FReadProxyAddress;
		property ReadProxyPort: Integer read FReadProxyPort write FReadProxyPort;
		property ReadProxyUserID: string read FReadProxyUserID write FReadProxyUserID;
		property ReadProxyPassword: string read FReadProxyPassword write FReadProxyPassword;

		property WriteProxy: Boolean read FWriteProxy write FWriteProxy;
		property WriteProxyAddress: string read FWriteProxyAddress write FWriteProxyAddress;
		property WriteProxyPort: Integer read FWriteProxyPort write FWriteProxyPort;
		property WriteProxyUserID: string read FWriteProxyUserID write FWriteProxyUserID;
		property WriteProxyPassword: string read FWriteProxyPassword write FWriteProxyPassword;

		property CabinetFontName: string read FCabinetFontName write FCabinetFontName;
		property CabinetFontSize: Integer read FCabinetFontSize write FCabinetFontSize;
		property CabinetFontBold: Boolean read FCabinetFontBold write FCabinetFontBold;
		property CabinetFontItalic: Boolean read FCabinetFontItalic write FCabinetFontItalic;
		property CabinetFontColor: TColor read FCabinetFontColor write FCabinetFontColor;
		property CabinetBackColor: TColor read FCabinetBackColor write FCabinetBackColor;

		property ListFontName: string read FListFontName write FListFontName;
		property ListFontSize: Integer read FListFontSize write FListFontSize;
		property ListFontBold: Boolean read FListFontBold write FListFontBold;
		property ListFontItalic: Boolean read FListFontItalic write FListFontItalic;
		property ListFontColor: TColor read FListFontColor write FListFontColor;
		property ListBackColor: TColor read FListBackColor write FListBackColor;

//		property BrowserFontColor: TColor read FBrowserFontColor write FBrowserFontColor;
//		property BrowserBackColor: TColor read FBrowserBackColor write FBrowserBackColor;
//		property BrowserFontSize: Integer read FBrowserFontSize write FBrowserFontSize;

		property EditorFontName: string read FEditorFontName write FEditorFontName;
		property EditorFontSize: Integer read FEditorFontSize write FEditorFontSize;
		property EditorFontBold: Boolean read FEditorFontBold write FEditorFontBold;
		property EditorFontItalic: Boolean read FEditorFontItalic write FEditorFontItalic;
		property EditorFontColor: TColor read FEditorFontColor write FEditorFontColor;
		property EditorBackColor: TColor read FEditorBackColor write FEditorBackColor;

		property BrowserTabFontName: string read FBrowserTabFontName write FBrowserTabFontName;
		property BrowserTabFontSize: Integer read FBrowserTabFontSize write FBrowserTabFontSize;
		property BrowserTabFontBold: Boolean read FBrowserTabFontBold write FBrowserTabFontBold;
		property BrowserTabFontItalic: Boolean read FBrowserTabFontItalic write FBrowserTabFontItalic;

		property HintFontName: string read FHintFontName write FHintFontName;
		property HintFontSize: Integer read FHintFontSize write FHintFontSize;
		//property HintFontBold: Boolean read FHintFontBold write FHintFontBold;
		//property HintFontItalic: Boolean read FHintFontItalic write FHintFontItalic;
		property HintFontColor: TColor read FHintFontColor write FHintFontColor;
		property HintBackColor: TColor read FHintBackColor write FHintBackColor;

		property WindowTop: Integer read FWindowTop write FWindowTop;
		property WindowLeft: Integer read FWindowLeft write FWindowLeft;
		property WindowHeight: Integer read FWindowHeight write FWindowHeight;
		property WindowWidth: Integer read FWindowWidth write FWindowWidth;
		property WindowMax: Boolean read FWindowMax write FWindowMax;
		property ListStyle: TViewStyle read FListStyle write FListStyle;

		property StdToolBarVisible: Boolean read FStdToolBarVisible write FStdToolBarVisible;
		property AddressBarVisible: Boolean read FAddressBarVisible write FAddressBarVisible;
		property LinkBarVisible: Boolean read FLinkBarVisible write FLinkBarVisible;
		property ListToolBarVisible: Boolean read FListToolBarVisible write FListToolBarVisible;
		property ListNameBarVisible: Boolean read FListNameBarVisible write FListNameBarVisible;
		property BrowserToolBarVisible: Boolean read FBrowserToolBarVisible write FBrowserToolBarVisible;
		property BrowserNameBarVisible: Boolean read FBrowserNameBarVisible write FBrowserNameBarVisible;

		property BrowserTabVisible: Boolean read FBrowserTabVisible write FBrowserTabVisible;
		property BrowserTabPosition: TGikoTabPosition read FBrowserTabPosition write FBrowserTabPosition;
		property BrowserTabAppend: TGikoTabAppend read FBrowserTabAppend write FBrowserTabAppend;
		property BrowserTabStyle: TGikoTabStyle read FBrowserTabStyle write FBrowserTabStyle;

		property MessageBarVisible: Boolean read FMessageBarVisible write FMessageBarVisible;
		property MessegeBarHeight: Integer read FMessegeBarHeight write FMessegeBarHeight;

		property StatusBarVisible: Boolean read FStatusBarVisible write FStatusBarVisible;

		property CabinetVisible: Boolean read FCabinetVisible write FCabinetVisible;
		property CabinetWidth: Integer read FCabinetWidth write FCabinetWidth;

		property ListOrientation: TGikoListOrientation read FListOrientation write FListOrientation;
		property ListHeight: Integer read FListHeight write FListHeight;
		property ListHeightState: TGikoListState read FListHeightState write FListHeightState;
		property ListWidth: Integer read FListWidth write FListWidth;
		property ListWidthState: TGikoListState read FListWidthState write FListWidthState;
//		property ListHeightMax: Boolean read FListHeightMax write FListHeightMax;
//		property ListWidthMax: Boolean read FListWidthMax write FListWidthMax;

		property NameList: TStringList read FNameList write FNameList;
		property MailList: TStringList read FMailList write FMailList;
		property SelectTextList: TStringList read FSelectTextList write FSelectTextList;

		property EditWindowTop: Integer read FEditWindowTop write FEditWindowTop;
		property EditWindowLeft: Integer read FEditWindowLeft write FEditWindowLeft;
		property EditWindowHeight: Integer read FEditWindowHeight write FEditWindowHeight;
		property EditWindowWidth: Integer read FEditWindowWidth write FEditWindowWidth;
		property EditWindowMax: Boolean read FEditWindowMax write FEditWindowMax;

		property ListViewNo: Boolean read FListViewNo write FListViewNo;
		property UseCSS: Boolean read FUseCSS write FUseCSS;
		property CSSFileName: string read FCSSFileName write FCSSFileName;

		property ShowMail: Boolean read FShowMail write FShowMail;
		property UnActivePopup: Boolean read FUnActivePopup write FUnActivePopup;
		property ResPopupHeaderBold: Boolean read FResPopupHeaderBold write FResPopupHeaderBold;

		property LogFolder: string read FLogFolder write FLogFolder;
		property NewLogFolder: string read FNewLogFolder write FNewLogFolder;

		property BBSColumnWidth[index: Integer]: Integer read GetBBSColumnWidth write SetBBSColumnWidth;
		property CategoryColumnWidth[index: Integer]: Integer read GetCategoryColumnWidth write SetCategoryColumnWidth;
		property BoardColumnWidth[index: Integer]: Integer read GetBoardColumnWidth write SetBoardColumnWidth;

		property SoundName[index: Integer]: string read GetSoundName;
		property SoundViewName[index: Integer]: string read GetSoundViewName;
		property SoundFileName[index: Integer]: string read GetSoundFileName write SetSoundFileName;

		property BoardURL2ch: string read FBoardURL2ch write FBoardURL2ch;

		property UserID: string read FUserID write FUserID;
		property Password: string read FPassword write FPassword;
		property AutoLogin: Boolean read FAutoLogin write FAutoLogin;

		property URLApp: Boolean read FURLApp write FURLApp;
		property URLAppFile: string read FURLAppFile write FURLAppFile;

		property OpenMailer: Boolean read FOpenMailer write FOpenMailer;

		property DeleteMsg: Boolean read FDeleteMsg write FDeleteMsg;

		property MainCoolSet[Index: Integer]: TCoolSet read GetMainCoolSet write SetMainCoolSet;
		property ListCoolSet[Index: Integer]: TCoolSet read GetBoardCoolSet write SetBoardCoolSet;
		property BrowserCoolSet[Index: Integer]: TCoolSet read GetBrowserCoolSet write SetBrowserCoolSet;

		property ListToolBarWrapable: Boolean read FListToolBarWrapable write FListToolBarWrapable;
		property BrowserToolBarWrapable: Boolean read FBrowserToolBarWrapable write FBrowserToolBarWrapable;

		property PopupPosition: TGikoPopupPosition read FPopupPosition write FPopupPosition;

		property URLDisplay: Boolean read FURLDisplay write FURLDisplay;
		property AddressBarTabStop: Boolean read FAddressBarTabStop write FAddressBarTabStop;
		property LinkAddAddressBar: Boolean read FLinkAddAddressBar write FLinkAddAddressBar;
		property AddressHistoryCount: Integer read FAddressHistoryCount write FAddressHistoryCount;

		property PreviewVisible: Boolean read FPreviewVisible write FPreviewVisible;
		property PreviewSize: TGikoPreviewSize read FPreviewSize write FPreviewSize;
		property PreviewWait: Integer read FPreviewWait write FPreviewWait;

		property ListIconVisible: Boolean read FListIconVisible write FListIconVisible;

		property UseMachineTime: Boolean read FUseMachineTime write FUseMachineTime;
		property TimeAdjustSec: Integer read FTimeAdjustSec write FTimeAdjustSec;
		property TimeAdjust: Boolean read FTimeAdjust write FTimeAdjust;

        //ځ`
        property AbonDeleterlo : Boolean read FAbonDeleterlo write FAbonDeleterlo;
        property AbonReplaceul : Boolean read FAbonReplaceul write FAbonReplaceul;
        property PopUpAbon     : Boolean read FPopUpAbon write FPopUpAbon;

    // XbhitB[h̕
    property SelectComboBoxWidth : Integer read FSelectComboBoxWidth write FSelectComboBoxWidth;

	end;



implementation

type
	TSoundName = record
		Name: string;
		ViewName: string;
		FileName: string;
	end;

const
	INI_FILE_NAME: string         = 'gikoNavi.ini';
	DEFAULT_FONT_NAME: string     = 'lr oSVbN';
	DEFAULT_FONT_SIZE: Integer    = 9;
	DEFAULT_FONT_COLOR: string    = 'clWindowText';
	DEFAULT_WINDOW_COLOR: string  = 'clWindow';
	DEFAULT_TAB_FONT_NAME: string     = 'lr oSVbN';
	DEFAULT_TAB_FONT_SIZE: Integer    = 9;
	DEFAULT_2CH_BOARD_URL: string = 'http://www6.ocn.ne.jp/~mirv/2chmenu.html';
																//'http://www.2ch.net/newbbsmenu.html';
	GIKO_ENCRYPT_TEXT: string     = 'gikoNaviEncryptText';

var
	SOUND_NAME: array[0..4] of TSoundName = (
		(Name: 'New';        ViewName: '擾';           FileName: ''),
		(Name: 'NewDiff';    ViewName: '擾()';     FileName: ''),
		(Name: 'NoChange';   ViewName: 'XV';             FileName: ''),
//		(Name: 'RoundEnd';   ViewName: 'I(擾)'; FileName: ''),
//		(Name: 'RoundNone';  ViewName: 'I(擾Ȃ)'; FileName: ''),
		(Name: 'ResEnd';     ViewName: 'XM';       FileName: ''),
		(Name: 'Error';      ViewName: 'G[';             FileName: ''));

//RXgN^
constructor TSetting.Create();
begin
	FNameList := TStringList.Create;
	FMailList := TStringList.Create;
	FSelectTextList := TStringList.Create;

	FNameList.Duplicates := dupIgnore;
	FMailList.Duplicates := dupIgnore;
	FSelectTextList.Duplicates := dupIgnore;
	ReadSettingFile();
end;

//fXgN^
destructor TSetting.Destroy();
begin
	inherited;
	FSelectTextList.Free;
	FMailList.Free;
	FNameList.Free;
end;

//t@C擾ipX{t@Cj
function TSetting.GetFileName(): string;
begin
	Result := ExtractFilePath(Application.ExeName) + INI_FILE_NAME;
end;

//ݒt@CǍ
procedure TSetting.ReadSettingFile();
const
	DEFAULT_BBS_WIDTH: array[0..0] of Integer = (140);
	DEFAULT_CATEGORY_WIDTH: array[0..2] of Integer = (150, 80, 130);
	DEFAULT_BOARD_WIDTH: array[0..6] of Integer = (350, 60, 60, 60, 60, 80, 130);
var
	ini: TMemIniFile;
	i: Integer;
	wkList: TStringList;
	wkStr: string;
	Exists: Boolean;
	s: string;
//	id: Integer;
	CoolSet: TCoolSet;
begin
	Exists := FileExists(GetFileName);
	ini := TMemIniFile.Create(GetFileName);
	try
		//Mobt@TCY
		FRecvBufferSize := ini.ReadInteger('HTTP', 'RecvBufferSize', 4096);
		//HTTP1.1gp
		FProtocol := ini.ReadBool('HTTP', 'Protocol', True);
		//vLVڑHTTP1.1gp
		FProxyProtocol := ini.ReadBool('HTTP', 'ProxyProtocol', False);

		FReadProxy := ini.ReadBool('ReadProxy', 'Proxy', false);
		FReadProxyAddress := ini.ReadString('ReadProxy', 'Address', '');
		FReadProxyPort := ini.ReadInteger('ReadProxy', 'Port', 0);
		FReadProxyUserID := ini.ReadString('ReadProxy', 'UserID', '');
		FReadProxyPassword := ini.ReadString('ReadProxy', 'Password', '');

		FWriteProxy := ini.ReadBool('WriteProxy', 'Proxy', false);
		FWriteProxyAddress := ini.ReadString('WriteProxy', 'Address', '');
		FWriteProxyPort := ini.ReadInteger('WriteProxy', 'Port', 0);
		FWriteProxyUserID := ini.ReadString('WriteProxy', 'UserID', '');
		FWriteProxyPassword := ini.ReadString('WriteProxy', 'Password', '');

		FCabinetFontName := ini.ReadString('Window', 'CabinetFontName', DEFAULT_FONT_NAME);
		FCabinetFontSize := ini.ReadInteger('Window', 'CabinetFontSize', DEFAULT_FONT_SIZE);
		FCabinetFontBold := ini.ReadBool('Window', 'CabinetFontBold', False);
		FCabinetFontItalic := ini.ReadBool('Window', 'CabinetFontItalic', False);
		FCabinetFontColor := StringToColor(ini.ReadString('Window', 'CabinetFontColor', DEFAULT_FONT_COLOR));
		FCabinetBackColor := StringToColor(ini.ReadString('Window', 'CabinetBackColor', DEFAULT_WINDOW_COLOR));

		FListFontName := ini.ReadString('Window', 'ListFontName', DEFAULT_FONT_NAME);
		FListFontSize := ini.ReadInteger('Window', 'ListFontSize', DEFAULT_FONT_SIZE);
		FListFontBold := ini.ReadBool('Window', 'ListFontBold', False);
		FListFontItalic := ini.ReadBool('Window', 'ListFontItalic', False);
		FListFontColor := StringToColor(ini.ReadString('Window', 'ListFontColor', DEFAULT_FONT_COLOR));
		FListBackColor := StringToColor(ini.ReadString('Window', 'ListBackColor', DEFAULT_WINDOW_COLOR));

		FEditorFontName := ini.ReadString('Window', 'EditorFontName', DEFAULT_FONT_NAME);
		FEditorFontSize := ini.ReadInteger('Window', 'EditorFontSize', DEFAULT_FONT_SIZE);
		FEditorFontBold := ini.ReadBool('Window', 'EditorFontBold', False);
		FEditorFontItalic := ini.ReadBool('Window', 'EditorFontItalic', False);
		FEditorFontColor := StringToColor(ini.ReadString('Window', 'EditorFontColor', DEFAULT_FONT_COLOR));
		FEditorBackColor := StringToColor(ini.ReadString('Window', 'EditorBackColor', DEFAULT_WINDOW_COLOR));

		FBrowserTabFontName := ini.ReadString('Window', 'BrowserTabFontName', DEFAULT_TAB_FONT_NAME);
		FBrowserTabFontSize := ini.ReadInteger('Window', 'BrowserTabFontSize', DEFAULT_TAB_FONT_SIZE);
		FBrowserTabFontBold := ini.ReadBool('Window', 'BrowserTabFontBold', False);
		FBrowserTabFontItalic := ini.ReadBool('Window', 'BrowserTabFontItalic', False);

		FHintFontName := ini.ReadString('Window', 'HintFontName', Screen.HintFont.Name);
		FHintFontSize := ini.ReadInteger('Window', 'HintFontSize', Screen.HintFont.Size);
		//FHintFontBold := ini.ReadBool('Window', 'HintFontBold', False);
		//FHintFontItalic := ini.ReadBool('Window', 'HintFontItalic', False);
		FHintFontColor := StringToColor(ini.ReadString('Window', 'HintFontColor', DEFAULT_FONT_COLOR));
		FHintBackColor := StringToColor(ini.ReadString('Window', 'HintBackColor', 'clInfoBk'));

		FWindowTop := ini.ReadInteger('WindowSize', 'Top', -1);
		FWindowLeft := ini.ReadInteger('WindowSize', 'Left', -1);
		FWindowHeight := ini.ReadInteger('WindowSize', 'Height', -1);
		FWindowWidth := ini.ReadInteger('WindowSize', 'Width', -1);
		FWindowMax := ini.ReadBool('WindowSize', 'Max', false);

		if FWindowHeight <= 0 then	FWindowHeight := 400;
		if FWindowWidth <= 0 then FWindowWidth := 600;

		FListStyle := TViewStyle(ini.ReadInteger('ViewStyle', 'ListView', Ord(vsReport)));

		FEditWindowTop := ini.ReadInteger('EditorWindowSize', 'Top', -1);
		FEditWindowLeft := ini.ReadInteger('EditorWindowSize', 'Left', -1);
		FEditWindowHeight := ini.ReadInteger('EditorWindowSize', 'Height', -1);
		FEditWindowWidth := ini.ReadInteger('EditorWindowSize', 'Width', -1);
		FEditWindowMax := ini.ReadBool('EditorWindowSize', 'Max', False);

		//c[o[
		FStdToolBarVisible := ini.ReadBool('ToolBar', 'StdVisible', True);
		FAddressBarVisible := ini.ReadBool('ToolBar', 'AddressVisible', True);
		FLinkBarVisible := ini.ReadBool('ToolBar', 'LinkVisible', True);
		FListToolBarVisible := ini.ReadBool('ToolBar', 'ListVisible', True);
		FListNameBarVisible := ini.ReadBool('ToolBar', 'ListNameVisible', True);
		FBrowserToolBarVisible := ini.ReadBool('ToolBar', 'BrowserVisible', True);
		FBrowserNameBarVisible := ini.ReadBool('ToolBar', 'BrowserNameVisible', True);
		//c[o[Wrapable
		FListToolBarWrapable := ini.ReadBool('ToolBar', 'ListWrapable', False);
		FBrowserToolBarWrapable := ini.ReadBool('ToolBar', 'BrowserWrapable', False);

		FBrowserTabVisible := ini.ReadBool('Tab', 'BrowserTabVisible', True);
		FBrowserTabPosition := TGikoTabPosition(ini.ReadInteger('Tab', 'BrowserTabPosition', Ord(gtpTop)));
		FBrowserTabAppend := TGikoTabAppend(ini.ReadInteger('Tab', 'BrowserTabAppend', Ord(gtaFirst)));
		FBrowserTabStyle := TGikoTabStyle(ini.ReadInteger('Tab', 'BrowserTabStyle', Ord(gtsFlat)));

		FMessageBarVisible := ini.ReadBool('MessageBar', 'Visible', True);
		FMessegeBarHeight := ini.ReadInteger('MessageBar', 'Height', 30);

		FStatusBarVisible := ini.ReadBool('StatusBar', 'Visible', True);

		FCabinetVisible := ini.ReadBool('Cabinet', 'Visible', True);
		FCabinetWidth := ini.ReadInteger('Cabinet', 'Width', 200);

		FListOrientation := TGikoListOrientation(ini.ReadInteger('List', 'Orientation', Ord(gloHorizontal)));
		FListHeight := ini.ReadInteger('List', 'Height', 180);
		FListHeightState := TGikoListState(ini.ReadInteger('List', 'HeightState', Ord(glsNormal)));
		FListWidth := ini.ReadInteger('List', 'Width', 180);
		FListWidthState := TGikoListState(ini.ReadInteger('List', 'WidthState', Ord(glsNormal)));
//		FListHeightMax := ini.ReadBool('List', 'HeightMax', False);
//		FListWidthMax := ini.ReadBool('List', 'WidthMax', False);

		wkList := TStringList.Create;
		try
			ini.ReadSection('Name', wkList);
			for i := 0 to wkList.Count - 1 do begin
				wkStr := ini.ReadString('Name', wkList[i], '');
				if (wkStr <> '') and (FNameList.IndexOf(wkStr) = -1) then
					FNameList.Add(wkStr);
			end;
			ini.ReadSection('Mail', wkList);
			for i := 0 to wkList.Count - 1 do begin
				wkStr := ini.ReadString('Mail', wkList[i], '');
				if (wkStr <> '') and (FMailList.IndexOf(wkStr) = -1) then
					FMailList.Add(wkStr);
			end;
			ini.ReadSection('SelectText', wkList);
			for i := 0 to wkList.Count - 1 do begin
				wkStr := ini.ReadString('SelectText', wkList[i], '');
				if (wkStr <> '') and (FSelectTextList.IndexOf(wkStr) = -1) then
					FSelectTextList.Add(wkStr);
			end;
		finally
			wkList.Free;
		end;

		//XgJ
		wkList := TStringList.Create;
		try
			ini.ReadSection('BBSColumnWidth', wkList);
			if Length(FBBSColumnWidth) <> wkList.Count then begin
				ini.EraseSection('BBSColumnWidth');
			end;
			for i := 0 to Length(FBBSColumnWidth) - 1 do begin
				BBSColumnWidth[i] := ini.ReadInteger('BBSColumnWidth', 'ID' + IntToStr(i), DEFAULT_BBS_WIDTH[i]);
			end;
			ini.ReadSection('CategoryColumnWidth', wkList);
			if Length(FCategoryColumnWidth) <> wkList.Count then begin
				ini.EraseSection('CategoryColumnWidth');
			end;
			for i := 0 to Length(FCategoryColumnWidth) - 1 do begin
				CategoryColumnWidth[i] := ini.ReadInteger('CategoryColumnWidth', 'ID' + IntToStr(i), DEFAULT_CATEGORY_WIDTH[i]);
			end;
			ini.ReadSection('BoardColumnWidth', wkList);
			if Length(FBoardColumnWidth) <> wkList.Count then begin
				ini.EraseSection('BoardColumnWidth');
			end;
			for i := 0 to Length(FBoardColumnWidth) - 1 do begin
				BoardColumnWidth[i] := ini.ReadInteger('BoardColumnWidth', 'ID' + IntToStr(i), DEFAULT_BOARD_WIDTH[i]);
			end;
		finally
			wkList.Free;
		end;


		//Xgԍ
		FListViewNo := ini.ReadBool('Function', 'ListViewNo', True);
		//CSS
		FUseCSS := ini.ReadBool('CSS', 'UseCSS', True);
		//CSSt@C
		FCSSFileName := ini.ReadString('CSS', 'FileName', 'default.css');

		//Mail\
		FShowMail := ini.ReadBool('Thread', 'ShowMail', True);
		//ANeBuX|bvAbv\
		FUnActivePopup := ini.ReadBool('Thread', 'UnActivePopup', False);
		//X|bvAbvwb_[{[h
		FResPopupHeaderBold := ini.ReadBool('Thread', 'ResPopupHeaderBold', True);

		//폜mF
		FDeleteMsg := ini.ReadBool('Function', 'LogDeleteMessage', True);

		//OtH_
		FLogFolder := ini.ReadString('Folder', 'LogFolder', ExtractFilePath(Application.ExeName) + 'Log');
		NewLogFolder := '';

		//URL
		FBoardURL2ch := ini.ReadString('BoardURL', '2ch', DEFAULT_2CH_BOARD_URL);

		//Fؗp[UIDEpX[h
		FUserID := ini.ReadString('Attestation', 'UserID', '');
		FPassword := Decrypt(ini.ReadString('Attestation', 'Password', ''));
		FAutoLogin := ini.ReadBool('Attestation', 'AutoLogin', False);

		//URLNbNNAv
		FURLApp := ini.ReadBool('URLApp', 'Select', False);
		FURLAppFile := ini.ReadString('URLApp', 'File', '');

		//mailtoNbN
		FOpenMailer := ini.ReadBool('Mailto', 'Open', True);

		//|bvAbvʒu
		FPopupPosition := TGikoPopupPosition(ini.ReadInteger('Browser', 'PopupPosition', Ord(gppLeftBottom)));

		//AhXo[
		FURLDisplay := ini.ReadBool('AddressBar', 'URLDisplay', False);
		FAddressBarTabStop := ini.ReadBool('AddressBar', 'TabStop', True);
		FLinkAddAddressBar := ini.ReadBool('AddressBar', 'LinkAdd', False);
		FAddressHistoryCount := ini.ReadInteger('AddressBar', 'HistoryCount', 100);

		//摜vr[
		FPreviewVisible := ini.ReadBool('Browser', 'PreviewVisible', True);
		FPreviewSize := TGikoPreviewSize(ini.ReadInteger('Browser', 'PreviewSize', Ord(gpsMedium)));
		FPreviewWait := ini.ReadInteger('Browser', 'PreviewWait', 500);

		//XbhꗗXVACR
		FListIconVisible := ini.ReadBool('ThreadList', 'StateIconVisible', True);

		//ݎ}Vgpݒ
		FUseMachineTime := ini.ReadBool('PostTime', 'UseMachineTime', False);
		FTimeAdjustSec := ini.ReadInteger('PostTime', 'TimeAdjustSec', 0);
		FTimeAdjust := ini.ReadBool('PostTime', 'TimeAdjust', True);

		//TEh
		if Exists then begin
			for i := 0 to GetSoundCount - 1 do begin
				SoundFileName[i] := ini.ReadString('Sound', SoundName[i], '');
				if not FileExists(SoundFileName[i]) then
					SoundFileName[i] := '';
			end;
		end else begin
			s := ExtractFileDir(Application.ExeName) + '\sound\';
			SoundFileName[0] := s + '擾.wav';
			SoundFileName[1] := s + '擾().wav';
			SoundFileName[2] := s + 'XV.wav';
			SoundFileName[3] := '';
			SoundFileName[4] := s + 'G[.wav';
		end;

		//N[o[
		for i := 0 to MAIN_COOLBAND_COUNT - 1 do begin
			CoolSet.FCoolID := ini.ReadInteger('MainCoolBar', 'ID' + IntToStr(i), -1);
			CoolSet.FCoolWidth := ini.ReadInteger('MainCoolBar', 'Width' + IntToStr(i), -1);
			CoolSet.FCoolBreak := ini.ReadBool('MainCoolBar', 'Break' + IntToStr(i), False);
			MainCoolSet[i] := CoolSet;
		end;
    FSelectComboBoxWidth := ini.ReadInteger( 'ListCoolBar', 'SelectWidth', 127 );
		for i := 0 to LIST_COOLBAND_COUNT - 1 do begin
			CoolSet.FCoolID := ini.ReadInteger('ListCoolBar', 'ID' + IntToStr(i), -1);
			CoolSet.FCoolWidth := ini.ReadInteger('ListCoolBar', 'Width' + IntToStr(i), -1);
			CoolSet.FCoolBreak := ini.ReadBool('ListCoolBar', 'Break' + IntToStr(i), False);
			ListCoolSet[i] := CoolSet;
		end;
		for i := 0 to BROWSER_COOLBAND_COUNT - 1 do begin
			CoolSet.FCoolID := ini.ReadInteger('BrowserCoolBar', 'ID' + IntToStr(i), -1);
			CoolSet.FCoolWidth := ini.ReadInteger('BrowserCoolBar', 'Width' + IntToStr(i), -1);
			CoolSet.FCoolBreak := ini.ReadBool('BrowserCoolBar', 'Break' + IntToStr(i), False);
			BrowserCoolSet[i] := CoolSet;
		end;

        //ځ`
        FAbonDeleterlo := ini.ReadBool('Abon','Deleterlo',false);
        FAbonReplaceul := ini.ReadBool('Abon','Replaceul',false);
        FPopUpAbon     := ini.ReadBool('abon','Popup',false);
	finally
		ini.Free;
	end;
end;

//ݒt@Cۑ(system)
procedure TSetting.WriteSystemSettingFile();
var
	ini: TMemIniFile;
begin
	ini := TMemIniFile.Create(GetFileName());
	try
		//Mobt@TCY
		ini.WriteInteger('HTTP', 'RecvBufferSize', FRecvBufferSize);
		//HTTP1.1gp
		ini.WriteBool('HTTP', 'Protocol', FProtocol);
		//vLVڑHTTP1.1gp
		ini.WriteBool('HTTP', 'ProxyProtocol', FProxyProtocol);

		ini.WriteBool('ReadProxy', 'Proxy', FReadProxy);
		ini.WriteString('ReadProxy', 'Address', FReadProxyAddress);
		ini.WriteInteger('ReadProxy', 'Port', FReadProxyPort);
		ini.WriteString('ReadProxy', 'UserID', FReadProxyUserID);
		ini.WriteString('ReadProxy', 'Password', FReadProxyPassword);

		ini.WriteBool('WriteProxy', 'Proxy', FWriteProxy);
		ini.WriteString('WriteProxy', 'Address', FWriteProxyAddress);
		ini.WriteInteger('WriteProxy', 'Port', FWriteProxyPort);
		ini.WriteString('WriteProxy', 'UserID', FWriteProxyUserID);
		ini.WriteString('WriteProxy', 'Password', FWriteProxyPassword);

		ini.WriteString('Window', 'CabinetFontName', FCabinetFontName);
		ini.WriteInteger('Window', 'CabinetFontSize', FCabinetFontSize);
		ini.WriteString('Window', 'CabinetFontColor', ColorToString(FCabinetFontColor));
		ini.WriteString('Window', 'CabinetBackColor', ColorToString(FCabinetBackColor));

		ini.WriteString('Window', 'ListFontName', FListFontName);
		ini.WriteInteger('Window', 'ListFontSize', FListFontSize);
		ini.WriteString('Window', 'ListFontColor', ColorToString(FListFontColor));
		ini.WriteString('Window', 'ListBackColor', ColorToString(FListBackColor));

		ini.WriteString('Window', 'EditorFontName', FEditorFontName);
		ini.WriteInteger('Window', 'EditorFontSize', FEditorFontSize);
		ini.WriteString('Window', 'EditorFontColor', ColorToString(FEditorFontColor));
		ini.WriteString('Window', 'EditorBackColor', ColorToString(FEditorBackColor));

		ini.WriteString('Window', 'BrowserTabFontName', FBrowserTabFontName);
		ini.WriteInteger('Window', 'BrowserTabFontSize', FBrowserTabFontSize);
		ini.WriteBool('Window', 'BrowserTabFontBold', FBrowserTabFontBold);
		ini.WriteBool('Window', 'BrowserTabFontItalic', FBrowserTabFontItalic);

		ini.WriteString('Window', 'HintFontName', FHintFontName);
		ini.WriteInteger('Window', 'HintFontSize', FHintFontSize);
		ini.WriteString('Window', 'HintFontColor', ColorToString(FHintFontColor));
		ini.WriteString('Window', 'HintBackColor', ColorToString(FHintBackColor));

		ini.UpdateFile;
	finally
		ini.Free;
	end;
end;

//ݒt@Cۑ(window)
procedure TSetting.WriteWindowSettingFile();
var
	i: Integer;
	ini: TMemIniFile;
	CoolSet: TCoolSet;
begin
	ini := TMemIniFile.Create(GetFileName());
	try
		ini.WriteInteger('WindowSize', 'Top', WindowTop);
		ini.WriteInteger('WindowSize', 'Left', WindowLeft);
		ini.WriteInteger('WindowSize', 'Height', WindowHeight);
		ini.WriteInteger('WindowSize', 'Width', WindowWidth);
		ini.WriteBool('WindowSize', 'Max', WindowMax);

		ini.WriteInteger('ViewStyle', 'ListView', Ord(ListStyle));

		ini.WriteInteger('EditorWindowSize', 'Top', EditWindowTop);
		ini.WriteInteger('EditorWindowSize', 'Left', EditWindowLeft);
		ini.WriteInteger('EditorWindowSize', 'Height', EditWindowHeight);
		ini.WriteInteger('EditorWindowSize', 'Width', EditWindowWidth);
		ini.WriteBool('EditorWindowSize', 'Max', EditWindowMax);

		//c[o[
		ini.WriteBool('ToolBar', 'StdVisible', FStdToolBarVisible);
		ini.WriteBool('ToolBar', 'AddressVisible', FAddressBarVisible);
		ini.WriteBool('ToolBar', 'LinkVisible', FLinkBarVisible);
		ini.WriteBool('ToolBar', 'ListVisible', FListToolBarVisible);
		ini.WriteBool('ToolBar', 'ListNameVisible', FListNameBarVisible);
		ini.WriteBool('ToolBar', 'BrowserVisible', FBrowserToolBarVisible);
		ini.WriteBool('ToolBar', 'BrowserNameVisible', FBrowserNameBarVisible);
		//c[o[Wrapable
		ini.WriteBool('ToolBar', 'ListWrapable', FListToolBarWrapable);
		ini.WriteBool('ToolBar', 'BrowserWrapable', FBrowserToolBarWrapable);

		//^u
		ini.WriteBool('Tab', 'BrowserTabVisible', FBrowserTabVisible);
		ini.WriteInteger('Tab', 'BrowserTabPosition', Ord(FBrowserTabPosition));
		ini.WriteInteger('Tab', 'BrowserTabAppend', Ord(FBrowserTabAppend));
		ini.WriteInteger('Tab', 'BrowserTabStyle', Ord(FBrowserTabStyle));

		//bZ[Wo[
		ini.WriteBool('MessageBar', 'Visible', FMessageBarVisible);
		ini.WriteInteger('MessageBar', 'Height', FMessegeBarHeight);

		//Xe[^Xo[
		ini.WriteBool('StatusBar', 'Visible', FStatusBarVisible);

		//Lrlbg
		ini.WriteBool('Cabinet', 'Visible', FCabinetVisible);
		ini.WriteInteger('Cabinet', 'Width', FCabinetWidth);

		//Xg̃TCYƐ
		ini.WriteInteger('List', 'Orientation', Ord(FListOrientation));
		ini.WriteInteger('List', 'Height', FListHeight);
		ini.WriteInteger('List', 'HeightState', Ord(FListHeightState));
		ini.WriteInteger('List', 'Width', FListWidth);
		ini.WriteInteger('List', 'WidthState', Ord(FListWidthState));
//		ini.WriteBool('List', 'HeightMax', FListHeightMax);
//		ini.WriteBool('List', 'WidthMax', FListWidthMax);


//		ini.WriteInteger('Window', 'BrowserFontSize', BrowserFontSize);

		//Xgԍ\
		ini.WriteBool('Function', 'ListViewNo', FListViewNo);
		//CSSgp
		ini.WriteBool('CSS', 'UseCSS', FUseCSS);
		//CSSt@C
		ini.WriteString('CSS', 'FileName', FCSSFileName);
		//Mail\
		ini.WriteBool('Thread', 'ShowMail', FShowMail);
		//O폜mF
		ini.WriteBool('Function', 'LogDeleteMessage', FDeleteMsg);
		//ANeBu|bvAbv\
		ini.WriteBool('Thread', 'UnActivePopup', FUnActivePopup);
		//X|bvAbvwb_[{[h
		ini.WriteBool('Thread', 'ResPopupHeaderBold', FResPopupHeaderBold);

		ini.WriteString('BoardURL', '2ch', FBoardURL2ch);

		//Fؗp[UIDEpX[h
		ini.WriteString('Attestation', 'UserID', FUserID);
		ini.WriteString('Attestation', 'Password', Encrypt(FPassword));
		ini.WriteBool('Attestation', 'AutoLogin', FAutoLogin);

		//URLNbNNAv
		ini.WriteBool('URLApp', 'Select', FURLApp);
		ini.WriteString('URLApp', 'File', FURLAppFile);

		//mailtoNbN
		ini.WriteBool('Mailto', 'Open', FOpenMailer);

		//|bvAbvʒu
		ini.WriteInteger('Browser', 'PopupPosition', Ord(FPopupPosition));

		//AhXo[
		ini.WriteBool('AddressBar', 'URLDisplay', FURLDisplay);
		ini.WriteBool('AddressBar', 'TabStop', FAddressBarTabStop);
		ini.WriteBool('AddressBar', 'LinkAdd', FLinkAddAddressBar);
		ini.WriteInteger('AddressBar', 'HistoryCount', FAddressHistoryCount);

		//摜vr[
		ini.WriteBool('Browser', 'PreviewVisible', FPreviewVisible);
		ini.WriteInteger('Browser', 'PreviewSize', Ord(FPreviewSize));
		ini.WriteInteger('Browser', 'PreviewWait', FPreviewWait);

		//XbhꗗXVACR
		ini.WriteBool('ThreadList', 'StateIconVisible', FListIconVisible);

		//ݎ}Vgpݒ
		ini.WriteBool('PostTime', 'UseMachineTime', FUseMachineTime);
		ini.WriteInteger('PostTime', 'TimeAdjustSec', FTimeAdjustSec);
		ini.WriteBool('PostTime', 'TimeAdjust', FTimeAdjust);

		//XgJ
		for i := 0 to Length(FBBSColumnWidth) - 1 do begin
			ini.WriteInteger('BBSColumnWidth', 'ID' + IntToStr(i), FBBSColumnWidth[i]);
		end;
		for i := 0 to Length(FCategoryColumnWidth) - 1 do begin
			ini.WriteInteger('CategoryColumnWidth', 'ID' + IntToStr(i), FCategoryColumnWidth[i]);
		end;
		for i := 0 to Length(FBoardColumnWidth) - 1 do begin
			ini.WriteInteger('BoardColumnWidth', 'ID' + IntToStr(i), FBoardColumnWidth[i]);
		end;

		//TEh
		for i := 0 to GetSoundCount - 1 do begin
			if not FileExists(SoundFileName[i]) then
				SoundFileName[i] := '';
			ini.WriteString('Sound', SoundName[i], SoundFileName[i]);
		end;

		//CoolBar
		ini.EraseSection('MainCoolBar');
		for i := 0 to MAIN_COOLBAND_COUNT - 1 do begin
			CoolSet := MainCoolSet[i];
			ini.WriteInteger('MainCoolBar', 'ID' + IntToStr(i), CoolSet.FCoolID);
			ini.WriteInteger('MainCoolBar', 'Width' + IntToStr(i), CoolSet.FCoolWidth);
			ini.WriteBool('MainCoolBar', 'Break' + IntToStr(i), CoolSet.FCoolBreak);
		end;
		ini.EraseSection('ListCoolBar');
    ini.WriteInteger( 'ListCoolBar', 'SelectWidth', FSelectComboBoxWidth );
		for i := 0 to LIST_COOLBAND_COUNT - 1 do begin
			CoolSet := ListCoolSet[i];
			ini.WriteInteger('ListCoolBar', 'ID' + IntToStr(i), CoolSet.FCoolID);
			ini.WriteInteger('ListCoolBar', 'Width' + IntToStr(i), CoolSet.FCoolWidth);
			ini.WriteBool('ListCoolBar', 'Break' + IntToStr(i), CoolSet.FCoolBreak);
		end;
		ini.EraseSection('BrowserCoolBar');
		for i := 0 to BROWSER_COOLBAND_COUNT - 1 do begin
			CoolSet := BrowserCoolSet[i];
			ini.WriteInteger('BrowserCoolBar', 'ID' + IntToStr(i), CoolSet.FCoolID);
			ini.WriteInteger('BrowserCoolBar', 'Width' + IntToStr(i), CoolSet.FCoolWidth);
			ini.WriteBool('BrowserCoolBar', 'Break' + IntToStr(i), CoolSet.FCoolBreak);
		end;

        //ځ`
        ini.WriteBool('Abon','Deleterlo',FAbonDeleterlo);
        ini.WriteBool('Abon','Replaceul',FAbonReplaceul);
        ini.WriteBool('abon','Popup',FPopUpAbon);

		ini.UpdateFile;
	finally
		ini.Free;
	end;
end;

//ݒt@Cۑ(name & mail)
procedure TSetting.WriteNameMailSettingFile();
var
	i: Integer;
	ini: TMemIniFile;
begin
	ini := TMemIniFile.Create(GetFileName());
	try
		ini.EraseSection('Name');
		ini.EraseSection('Mail');
		ini.EraseSection('SelectText');
		for i := 0 to FNameList.Count - 1 do begin
			ini.WriteString('Name', Format('%.2d', [i + 1]), FNameList[i]);
			if i >= 39 then
				Break;
		end;
		for i := 0 to FMailList.Count - 1 do begin
			ini.WriteString('Mail', Format('%.2d', [i + 1]), FMailList[i]);
			if i >= 39 then
				Break;
		end;
		for i := 0 to FSelectTextList.Count - 1 do begin
			ini.WriteString('SelectText', Format('%.2d', [i + 1]), FSelectTextList[i]);
			if i >= 39 then
				Break;
		end;
		ini.UpdateFile;
	finally
		ini.Free;
	end;
end;

procedure TSetting.WriteFolderSettingFile();
var
	ini: TMemIniFile;
begin
	ini := TMemIniFile.Create(GetFileName());
	try
		if ExtractFilePath(Application.ExeName) + 'Log' = NewLogFolder then
			ini.DeleteKey('Folder', 'LogFolder')
		else
			ini.WriteString('Folder', 'LogFolder', NewLogFolder);
		ini.UpdateFile;
	finally
		ini.Free;
	end;
end;

//XgJwb_[
function TSetting.GetBBSColumnWidth(index: Integer): Integer;
begin
	Result := IfThen(index in [0..Length(FBBSColumnWidth) - 1], FBBSColumnWidth[index], 0);
end;

function TSetting.GetCategoryColumnWidth(index: Integer): Integer;
begin
	Result := IfThen(index in [0..Length(FCategoryColumnWidth) - 1], FCategoryColumnWidth[index], 0);
end;

function TSetting.GetBoardColumnWidth(index: Integer): Integer;
begin
	Result := IfThen(index in [0..Length(FBoardColumnWidth) - 1], FBoardColumnWidth[index], 0);
end;

procedure TSetting.SetBBSColumnWidth(index: Integer; value: Integer);
begin
	if index in [0..Length(FBBSColumnWidth) - 1] then
		FBBSColumnWidth[index] := value;
end;

procedure TSetting.SetCategoryColumnWidth(index: Integer; value: Integer);
begin
	if index in [0..Length(FCategoryColumnWidth) - 1] then
		FCategoryColumnWidth[index] := value;
end;

procedure TSetting.SetBoardColumnWidth(index: Integer; value: Integer);
begin
	if index in [0..Length(FBoardColumnWidth) - 1] then
		FBoardColumnWidth[index] := value;
end;

function TSetting.GetSoundCount: Integer;
begin
	Result := Length(SOUND_NAME);
end;

function TSetting.GetSoundName(Index: Integer): string;
begin
	if (Index < GetSoundCount) and (Index >= 0) then
		Result := SOUND_NAME[Index].Name
	else
		Result := '';
end;

function TSetting.GetSoundViewName(Index: Integer): string;
begin
	if (Index < GetSoundCount) and (Index >= 0) then
		Result := SOUND_NAME[Index].ViewName
	else
		Result := '';
end;

function TSetting.GetSoundFileName(Index: Integer): string;
begin
	if (Index < GetSoundCount) and (Index >= 0) then
		Result := SOUND_NAME[Index].FileName
	else
		Result := '';
end;

procedure TSetting.SetSoundFileName(Index: Integer; value: string);
begin
	if (Index < GetSoundCount) and (Index >= 0) then
		SOUND_NAME[Index].FileName := value;
end;

function TSetting.FindSoundFileName(Name: string): string;
var
	i: Integer;
begin
	for i := 0 to GetSoundCount - 1 do begin
		if SoundName[i] = Name then begin
			Result := SoundFileName[i];
			Exit;
		end;
	end;
	Result := '';
end;

function TSetting.Encrypt(s: string): string;
var
	cryptObj: THogeCryptAuto;
	inputStream, outputStream: TStringStream;
begin
	inputStream := TStringStream.Create(s);
	outputStream := TStringStream.Create('');
	cryptObj := THogeCryptAuto.Create;
	try
		// Í
		cryptObj.Encrypt(inputStream, GIKO_ENCRYPT_TEXT, outputStream);

		// oCiȂ̂ŕKvɉăeLXgɕϊ
		Result := HogeBase64Encode(outputStream.DataString);
	finally
		cryptObj.Free;
		outputStream.Free;
		inputStream.Free;
	end;
end;

function TSetting.Decrypt(s: string): string;
var
	cryptObj: THogeCryptAuto;
	inputStream, outputStream: TStringStream;
begin
	try
		inputStream := TStringStream.Create(HogeBase64Decode(s));
	except
		Result := '';
		Exit;
	end;
	outputStream := TStringStream.Create('');
	cryptObj := THogeCryptAuto.Create;
	try
		// 
		cryptObj.Decrypt(inputStream, GIKO_ENCRYPT_TEXT, outputStream);
		Result := outputStream.DataString;
	finally
		cryptObj.Free;
		outputStream.Free;
		inputStream.Free;
	end;
end;

function TSetting.GetMainCoolSet(Index: Integer): TCoolSet;
begin
	if Index in [0..MAIN_COOLBAND_COUNT - 1] then
		Result := FMainCoolBar[Index]
	else begin
		Result.FCoolID := -1;
		Result.FCoolWidth := -1;
		Result.FCoolBreak := False;
	end;
end;

function TSetting.GetBoardCoolSet(Index: Integer): TCoolSet;
begin
	if Index in [0..LIST_COOLBAND_COUNT - 1] then
		Result := FListCoolBar[Index]
	else begin
		Result.FCoolID := -1;
		Result.FCoolWidth := -1;
		Result.FCoolBreak := False;
	end;
end;

function TSetting.GetBrowserCoolSet(Index: Integer): TCoolSet;
begin
	if Index in [0..BROWSER_COOLBAND_COUNT - 1] then
		Result := FBrowserCoolBar[Index]
	else begin
		Result.FCoolID := -1;
		Result.FCoolWidth := -1;
		Result.FCoolBreak := False;
	end;
end;

procedure TSetting.SetMainCoolSet(Index: Integer; CoolSet: TCoolSet);
begin
	if Index in [0..MAIN_COOLBAND_COUNT - 1] then
		FMainCoolBar[Index] := CoolSet;
end;

procedure TSetting.SetBoardCoolSet(Index: Integer; CoolSet: TCoolSet);
begin
	if Index in [0..LIST_COOLBAND_COUNT - 1] then
		FListCoolBar[Index] := CoolSet;
end;

procedure TSetting.SetBrowserCoolSet(Index: Integer; CoolSet: TCoolSet);
begin
	if Index in [0..BROWSER_COOLBAND_COUNT - 1] then
		FBrowserCoolBar[Index] := CoolSet;
end;


end.

