unit Search;

interface

uses
	Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
	Dialogs, StdCtrls, ExtCtrls, ComCtrls,
	BoardGroup, GikoSystem;

type
	TSearchDialog = class(TForm)
		BoardListView: TListView;
		BoardLabel: TLabel;
		OkBotton: TButton;
		CancelBotton: TButton;
		Label1: TLabel;
		ComboBox1: TComboBox;
		CategoryListView: TListView;
		AllReleaseButton: TButton;
		AllSelectButton: TButton;
		GroupBox1: TGroupBox;
		CheckBox1: TCheckBox;
		CheckBox2: TCheckBox;
		CheckBox3: TCheckBox;
		CheckBox4: TCheckBox;
		procedure FormCreate(Sender: TObject);
		procedure CategoryListViewSelectItem(Sender: TObject; Item: TListItem;
			Selected: Boolean);
		procedure BoardListViewChange(Sender: TObject; Item: TListItem;
			Change: TItemChange);
		procedure AllSelectButtonClick(Sender: TObject);
		procedure AllReleaseButtonClick(Sender: TObject);
		procedure OkBottonClick(Sender: TObject);
	private
		{ Private 錾 }
		FChkItem: TObject;
		procedure SetCategoryList;
		procedure SetBoardList(Item: TListItem);
		procedure CheckItem(Item: TObject);
	public
		{ Public 錾 }
//		constructor Create(AOwner: TComponent); overload; override;
		constructor Create(AOwner: TComponent; ChkItem: TObject); virtual; //overload;
	end;

var
	SearchDialog: TSearchDialog;

implementation

{$R *.dfm}

{constructor TSearchDialog.Create(AOwner: TComponent);
begin
	Create(AOwner, nil);
end;}

constructor TSearchDialog.Create(AOwner: TComponent; ChkItem: TObject);
begin
	inherited Create(AOwner);
	FChkItem := ChkItem;
end;

procedure TSearchDialog.FormCreate(Sender: TObject);
begin
	SetCategoryList;
	if (FChkItem is TCategory) or (FChkItem is TBoard) then
		CheckItem(FChkItem);
end;

procedure TSearchDialog.CategoryListViewSelectItem(Sender: TObject;
	Item: TListItem; Selected: Boolean);
begin
	if not Selected then Exit;
	SetBoardList(Item);
end;

procedure TSearchDialog.SetCategoryList;
var
	i, j: integer;
	Item: TListItem;
begin
	Item := CategoryListView.Items.Add;
	Item.Caption := 'iׂāj';
	Item.Data := nil;
	for i := 0 to BBS2ch.Count - 1 do begin
		Item := CategoryListView.Items.Add;
		Item.Caption := BBS2ch.Items[i].Title;
		Item.Data := BBS2ch.Items[i];
		for j := 0 to BBS2ch.Items[i].Count - 1 do
			BBS2ch.Items[i].Items[j].BoolData := False;
	end;
end;

procedure TSearchDialog.SetBoardList(Item: TListItem);
var
	i, j: Integer;
	NewItem: TListItem;
	Category: TCategory;
begin
	BoardListView.Clear;
	if Item.Data = nil then begin
		for i := 0 to BBS2ch.Count - 1 do begin
			Category := BBS2ch.Items[i];
			for j := 0 to Category.Count - 1 do begin
				NewItem := BoardListView.Items.Add;
				NewItem.Caption := Category.Items[j].Title;
				NewItem.Checked := Category.Items[j].BoolData;
				NewItem.Data := Category.Items[j];
			end;
		end;
	end else if TObject(Item.Data) is TCategory then begin
		Category := TCategory(Item.Data);
		for i := 0 to Category.Count - 1 do begin
			NewItem := BoardListView.Items.Add;
			NewItem.Caption := Category.Items[i].Title;
			NewItem.Checked := Category.Items[i].BoolData;
			NewItem.Data := Category.Items[i];
		end;
	end;
end;

procedure TSearchDialog.CheckItem(Item: TObject);
var
	i: Integer;
	Category: TCategory;
	Board: TBoard;
begin
	if Item is TCategory then begin
		Category := TCategory(Item);
		for i := 0 to CategoryListView.Items.Count - 1 do begin
			if TObject(CategoryListView.Items[i].Data) is TCategory then
				if TCategory(CategoryListView.Items[i].Data) = Category then begin
					CategoryListView.Items[i].Selected := True;
					CategoryListView.Items[i].MakeVisible(False);
				end;
		end;
	end else if Item is TBoard then begin
		Board := TBoard(Item);
		Category := Board.ParentCategory;
		Board.BoolData := True;
		for i := 0 to CategoryListView.Items.Count - 1 do begin
			if TObject(CategoryListView.Items[i].Data) is TCategory then begin
				if TCategory(CategoryListView.Items[i].Data) = Category then begin
					CategoryListView.Items[i].Selected := True;
					CategoryListView.Items[i].MakeVisible(False);
				end;
			end;
		end;
	end;
end;

procedure TSearchDialog.BoardListViewChange(Sender: TObject;
	Item: TListItem; Change: TItemChange);
var
	Board: TBoard;
begin
	if TObject(Item.Data) is TBoard then begin
		Board := TBoard(Item.Data);
		Board.BoolData := Item.Checked;
	end;
end;

procedure TSearchDialog.AllSelectButtonClick(Sender: TObject);
var
	i: Integer;
	Board: TBoard;
begin
	for i := 0 to BoardListView.Items.Count - 1 do begin
		if TObject(BoardListView.Items[i].Data) is TBoard then begin
			Board := TBoard(BoardListView.Items[i].Data);
			BoardListView.Items[i].Checked := True;
		end;
	end;
end;

procedure TSearchDialog.AllReleaseButtonClick(Sender: TObject);
var
	i: Integer;
	Board: TBoard;
begin
	for i := 0 to BoardListView.Items.Count - 1 do begin
		if TObject(BoardListView.Items[i].Data) is TBoard then begin
			Board := TBoard(BoardListView.Items[i].Data);
			BoardListView.Items[i].Checked := False;
		end;
	end;
end;

procedure TSearchDialog.OkBottonClick(Sender: TObject);
var
	i, j, k: Integer;
	Board: TBoard;
	ThreadItem: TThreadItem;
	List: TList;
	sl: TStringList;
begin
	Screen.Cursor := crHourglass;
	sl := TStringList.Create;
	List := TList.Create;
	try
		BoardListView.Clear;
		for i := 0 to BBS2ch.Count - 1 do begin
			for j := 0 to BBS2ch.Items[i].Count - 1 do begin
				Board := TBoard(BBS2ch.Items[i]);
				if not Board.IsThreadDatRead then
					GikoSys.ReadSubjectFile(Board);
				for k := 0 to Board.Count - 1 do begin
					ThreadItem := Board.Items[k];
					if FileExists(ThreadItem.FileName) then begin
						sl.LoadFromFile(ThreadItem.FileName);
					end;
				end;
			end
		end;
	finally
		sl.Free;
		List.Free;
		Screen.Cursor := crDefault;
	end;
end;


end.
