unit FavoriteAdd;

interface

uses
	Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
	Dialogs, ComCtrls, StdCtrls, Favorite, ImgList, BoardGroup, NewFavoriteFolder;

type
	TFavoriteAddDialog = class(TForm)
    TitleLabel: TLabel;
    NameLabel: TLabel;
		Label3: TLabel;
    NameEdit: TEdit;
		CaptionEdit: TEdit;
		OKButton: TButton;
		CancelButton: TButton;
		NewFolderButton: TButton;
		FolderTreeView: TTreeView;
		Label4: TLabel;
		procedure FormCreate(Sender: TObject);
		procedure OKButtonClick(Sender: TObject);
		procedure CancelButtonClick(Sender: TObject);
		procedure NewFolderButtonClick(Sender: TObject);
	private
		{ Private 錾 }
		FBoard: TBoard;
		FThreadItem: TThreadItem;
//		procedure PrepareFavoriteTree(Favo: TFavoriteItem; Node: TTreeNode);
		function GetGikoFavoriteNode(FavFolder: TFavoriteFolder): TTreeNode;
	public
		{ Public 錾 }
		procedure SetBoard(Board: TBoard);
		procedure SetThreadItem(ThreadItem: TThreadItem);
	end;

var
	FavoriteAddDialog: TFavoriteAddDialog;

implementation

uses Giko;

{$R *.dfm}

procedure TFavoriteAddDialog.FormCreate(Sender: TObject);
var
	i: Integer;
begin
	FolderTreeView.Items := FavoriteDM.TreeView.Items;

	for i := FolderTreeView.Items.Count - 1 downto 0 do begin
		if not (TObject(FolderTreeView.Items[i].Data) is TFavoriteFolder) then
			FolderTreeView.Items[i].Delete;
	end;

	if FolderTreeView.Items.GetFirstNode <> nil then begin
		FolderTreeView.Items.GetFirstNode.Expanded := True;
		FolderTreeView.Items.GetFirstNode.Selected := True;
	end;
{	Node := FolderTreeView.Items.AddChild(nil, GikoForm.Favorite.Root.Title);
	Node.ImageIndex := 0;
	Node.Data := GikoForm.Favorite.Root;
	PrepareFavoriteTree(GikoForm.Favorite.Root, Node);
	Node.Expanded := True;
	Node.Selected := True;}
end;


{procedure TFavoriteAddDialog.PrepareFavoriteTree(Favo: TFavoriteItem; Node: TTreeNode);
var
	i: Integer;
	ChildFavo: TFavoriteItem;
	ChildNode: TTreeNode;
begin
	for i := 0 to TFavoriteFolder(Favo).Count - 1 do begin

		ChildFavo := TFavoriteFolder(Favo).Items[i];
		if ChildFavo is TFavoriteFolder then begin
			ChildNode := FolderTreeView.Items.AddChild(Node, ChildFavo.Title);
			ChildNode.ImageIndex := 0;
			ChildNode.Data := ChildFavo;
			PrepareFavoriteTree(ChildFavo, ChildNode);
		end else if ChildFavo is TFavoriteBoardItem then begin
		end else if ChildFavo is TFavoriteThreadItem then begin
		end;
	end;
end;}

procedure TFavoriteAddDialog.OKButtonClick(Sender: TObject);
var
	i: Integer;
	Node: TTreeNode;
	FavoBoardItem: TFavoriteBoardItem;
	FavoThreadItem: TFavoriteThreadItem;
	FavNode: TTreeNode;
begin
	if FolderTreeView.Selected = nil then
		Exit;

	for i := 0 to FolderTreeView.Items.Count - 1 do begin

		FavNode := GetGikoFavoriteNode(FolderTreeView.Items[i].Data);
		if FavNode = nil then begin
			FavNode := GetGikoFavoriteNode(FolderTreeView.Items[i].Parent.Data);
			if FavNode <> nil then
				Node := FavoriteDM.TreeView.Items.AddChildObject(FavNode, FolderTreeView.Items[i].Text, FolderTreeView.Items[i].Data);
				Node.ImageIndex := 14;
				Node.SelectedIndex := 14;
		end;
	end;


	FavNode := GetGikoFavoriteNode(FolderTreeView.Selected.Data);
	if FavNode <> nil then begin
		if FBoard <> nil then begin
			FavoBoardItem := TFavoriteBoardItem.Create;
			FavoBoardItem.BBSID := FBoard.BBSID;
			FavoBoardItem.BoardName := FBoard.Title;
			Node := FavoriteDM.TreeView.Items.AddChildObject(FavNode, CaptionEdit.Text, FavoBoardItem);
			Node.ImageIndex := 15;
			Node.SelectedIndex := 15;
		end else if FThreadItem <> nil then begin
			FavoThreadItem := TFavoriteThreadItem.Create;
			FavoThreadItem.BBSID := FThreadItem.ParentBoard.BBSID;
			FavoThreadItem.ThreadID := FThreadItem.FileName;
			FavoThreadItem.ThreadName := FThreadItem.Title;
			Node := FavoriteDM.TreeView.Items.AddChildObject(FavNode, CaptionEdit.Text, FavoThreadItem);
			Node.ImageIndex := 16;
			Node.SelectedIndex := 16;
		end;
	end;

	FavoriteDM.WriteFavorite;
	Close;
end;

procedure TFavoriteAddDialog.CancelButtonClick(Sender: TObject);
begin
	Close;
end;

procedure TFavoriteAddDialog.NewFolderButtonClick(Sender: TObject);
var
	Dlg: TNewFavoriteFolderDialog;
	Node: TTreeNode;
	FavFolder: TFavoriteFolder;
begin
	if FolderTreeView.Selected = nil then
		Exit;

	Dlg := TNewFavoriteFolderDialog.Create(Self);
	try
		Dlg.ShowModal;
		if Dlg.ModalResult = mrOK then begin
			if Length(Dlg.FolderEdit.Text) = 0 then
				Exit;
			FavFolder := TFavoriteFolder.Create;
			Node := FolderTreeView.Items.AddChildObject(FolderTreeView.Selected, Dlg.FolderEdit.Text, FavFolder);
			Node.ImageIndex := 14;
			Node.SelectedIndex := 14;
			FolderTreeView.Selected := Node;
		end;
	finally
		Dlg.Free;
	end;
end;

procedure TFavoriteAddDialog.SetBoard(Board: TBoard);
begin
	FBoard := Board;
	if Board = nil then Exit;

	NameEdit.Text := Board.Title;
	CaptionEdit.Text := Board.Title;
	TitleLabel.Caption := '̔Cɓɒǉ܂';
	NameLabel.Caption := ':';
end;

procedure TFavoriteAddDialog.SetThreadItem(ThreadItem: TThreadItem);
begin
	FThreadItem := ThreadItem;
	if ThreadItem = nil then Exit;

	NameEdit.Text := ThreadItem.Title;
	CaptionEdit.Text := ThreadItem.Title;
	TitleLabel.Caption := '̃XbhCɓɒǉ܂';
	NameLabel.Caption := 'Xbh:';
end;

function TFavoriteAddDialog.GetGikoFavoriteNode(FavFolder: TFavoriteFolder): TTreeNode;
var
	i: Integer;
begin
	Result := nil;
	for i := 0 to FavoriteDM.TreeView.Items.Count - 1 do begin
		if FavoriteDM.TreeView.Items[i].Data = FavFolder then begin
			Result := FavoriteDM.TreeView.Items[i];
			Exit;
		end;
	end;
end;

end.
