unit Editor;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	Dialogs, StdCtrls, ComCtrls, ExtCtrls, ToolWin, Menus, OleCtrls,
{$IF Defined(DELPRO) }
	SHDocVw,
{$ELSE}
	SHDocVw_TLB,
{$IFEND}
	ActiveX, {HTTPApp,} YofUtils, IniFiles, StrUtils,
	GikoSystem, GikoUtil, ImgList, Clipbrd, BoardGroup,
	IdAntiFreezeBase,	IdAntiFreeze, IdBaseComponent, IdComponent,
	IdTCPConnection, IdTCPClient, IdHTTP, ActnList, StdActns, IdIntercept,
	IdLogBase, IdLogDebug, IdException;

type
//	TSetLayeredWindowAttributes = function(wnd: HWND; crKey: DWORD; bAlpha: BYTE; dwFlag: DWORD): Boolean; stdcall;
	//ݖ߂l^Cv
	TGikoResultType = (grtOK, grtCookie, grtCheck, grtError);

	TEditorForm = class(TForm)
		MainMenu: TMainMenu;
		FileMenu: TMenuItem;
		PostMessage: TMenuItem;
		SaveMessage: TMenuItem;
		CloseMenu: TMenuItem;
		N01: TMenuItem;
		StatusBar: TStatusBar;
		EditorPage: TPageControl;
		EditorTab: TTabSheet;
		PreviewTab: TTabSheet;
		Browser: TWebBrowser;
		EditMenu: TMenuItem;
		UndoMenu: TMenuItem;
		CutMenu: TMenuItem;
		CopyMenu: TMenuItem;
		PasteMenu: TMenuItem;
		N02: TMenuItem;
		ToolBarImageList: TImageList;
		HotToobarImageList: TImageList;
		BodyEdit: TMemo;
		NameBasePanel: TPanel;
		NameLabel: TLabel;
		MailLabel: TLabel;
		NameComboBox: TComboBox;
		MailComboBox: TComboBox;
		ToolBar: TToolBar;
		SendToolButton: TToolButton;
		OutBoxToolButton: TToolButton;
		ToolButton5: TToolButton;
		UndoToolButton: TToolButton;
		CutToolButton: TToolButton;
		CopyToolButton: TToolButton;
		PasteToolButton: TToolButton;
		ToolButton3: TToolButton;
		TransToolButton: TToolButton;
		TopToolButton: TToolButton;
		Indy: TIdHTTP;
		IdAntiFreeze: TIdAntiFreeze;
		ToolButton1: TToolButton;
		ToolButton2: TToolButton;
		ActionList: TActionList;
		SendAction: TAction;
		SaveAction: TAction;
		CloseAction: TAction;
		UndoAction: TAction;
		CutAction: TAction;
		CopyAction: TAction;
		PasteAction: TAction;
		AbortAction: TAction;
		TopAction: TAction;
		Show1: TMenuItem;
		T1: TMenuItem;
		N1: TMenuItem;
		S1: TMenuItem;
		SageCheckBox: TCheckBox;
		IdLogDebug: TIdLogDebug;
		TransAction: TAction;
		A1: TMenuItem;
		KotehanCheckBox: TCheckBox;
    TitlePanel: TPanel;
		Label1: TLabel;
		TitleEdit: TEdit;
    SelectAllAction: TAction;
    N2: TMenuItem;
    SelectAll1: TMenuItem;
		procedure EditorPageChange(Sender: TObject);
		procedure FormCreate(Sender: TObject);
		procedure BrowserStatusTextChange(Sender: TObject;
			const Text: WideString);
		procedure FormClose(Sender: TObject; var Action: TCloseAction);
		procedure FormDestroy(Sender: TObject);
		procedure SendActionExecute(Sender: TObject);
		procedure SaveActionExecute(Sender: TObject);
		procedure AbortActionExecute(Sender: TObject);
		procedure CloseActionExecute(Sender: TObject);
		procedure UndoActionExecute(Sender: TObject);
		procedure CutActionExecute(Sender: TObject);
		procedure CopyActionExecute(Sender: TObject);
		procedure PasteActionExecute(Sender: TObject);
		procedure SendActionUpdate(Sender: TObject);
		procedure SaveActionUpdate(Sender: TObject);
		procedure CloseActionUpdate(Sender: TObject);
		procedure UndoActionUpdate(Sender: TObject);
		procedure CutActionUpdate(Sender: TObject);
		procedure CopyActionUpdate(Sender: TObject);
		procedure PasteActionUpdate(Sender: TObject);
		procedure TopActionExecute(Sender: TObject);
		procedure TopActionUpdate(Sender: TObject);
		procedure SageCheckBoxClick(Sender: TObject);
		procedure MailComboBoxChange(Sender: TObject);
		procedure TransActionExecute(Sender: TObject);
		procedure TransActionUpdate(Sender: TObject);
		procedure IdLogDebugReceive(ASender: TIdConnectionIntercept;
			AStream: TStream);
		procedure IdLogDebugSend(ASender: TIdConnectionIntercept;
			AStream: TStream);
    procedure SelectAllActionExecute(Sender: TObject);
	private
		FThreadItem: TThreadItem;
		FBoard: TBoard;
		FNameComboEdit: THandle;
		FMailComboEdit: THandle;
		FAbort: Boolean;
		FWork: Boolean;
		FStatusCode: Integer;
		FDebugStrReceive: string;
		FDebugStrSend: string;

		procedure Preview;
		function RepHtml(s: string): string;
		function Check: Boolean;
		procedure SetNameList(sName, sMail: string);
//		procedure Send(SendType: TGikoSendType; SPID: string; PON: string; FirstWriting: Boolean);
		procedure Send(SPID: string; PON: string; FirstWriting: Boolean);

		function GetActiveControlHandle: THandle;
//		function GetSendData: string;
//		procedure GetSendData(Source: TStringStream);
		procedure GetSendData(Source: TStringStream);
		procedure SaveSendFile;
		procedure SetContent(Content: string);
		function GetSPID(CookieLine: string): string;
		function GetPON(CookieLine: string): string;
		function GetResultType(ResponseText: string): TGikoResultType;
	protected
		procedure CreateParams(var Params: TCreateParams); override;
	public
		procedure SetFont;
		procedure SetThreadItem(Item: TThreadItem);
		procedure SetBoard(Item: TBoard);
	end;

implementation

uses
	Giko, ItemDownload;
const
	CAPTION_NAME_NEW: string = 'MRir XăGfB^';
	CAPTION_NAME_RES: string = 'MRir XGfB^';

	//DAXض!(LM)
	READCGI_ERR		 	= '-ERR';
	READCGI_INCR		= '-INCR';
	READCGI_OK			= '+OK';
	READCGI_PARTIAL = '+PARTIAL';
	READCGI_ERR_FOUND_KAKO	= '-ERR ߋOqɂŔ';
	READCGI_ERR_NOT_HTML		= '-ERR html҂';
	READCGI_ERR_NOT_FOUND	 	= '-ERR ȔorXbhȂłB';
	READCGI_ERR_ABONE			 	= '-ERR ǂłځ[񂪂݂łB';
	READCGI_ERR_TIMEOUT		 	= '-ERR w莞Ԃ߂܂B';
	READCGI_ERR_CANTUSE		 	= '-ERR @܂';
	RES2CH_TRUE			 	= '<!-- 2ch_X:true -->';
	RES2CH_FALSE			= '<!-- 2ch_X:false -->';
	RES2CH_ERROR			= '<!-- 2ch_X:error -->';
	RES2CH_CHECK			= '<!-- 2ch_X:check -->';
	RES2CH_COOKIE		 	= '<!-- 2ch_X:cookie -->';

type
	TSelection = record
		StartPos, EndPos: Integer;
	end;

{$R *.DFM}

{constructor TEditorForm.Create(AOwner: TComponent; Item: TBoard);
begin
	inherited Create(AOwner);
end;}

procedure TEditorForm.CreateParams(var Params: TCreateParams);
begin
	inherited;
	if FormStyle in [fsNormal, fsStayOnTop] then
		if BorderStyle in [bsSingle, bsSizeable] then begin
			Params.ExStyle := Params.ExStyle or WS_EX_APPWINDOW;
			Params.WndParent := 0;
		end;
end;

{procedure TEditorForm.CreateParams(var Params: TCreateParams);
begin
	inherited CreateParams(Params);
	Params.ExStyle := Params.ExStyle or WS_EX_APPWINDOW;
end;}

procedure TEditorForm.FormCreate(Sender: TObject);
var
//	i: Integer;
	u32: Boolean;
	wp: TWindowPlacement;
begin
	FWork := False;
	Browser.Navigate('about:blank');

	FBoard := nil;
	FThreadItem := nil;

	//EBhËʒuݒ
{	i := GikoSys.Setting.EditWindowLeft +
			 GikoSys.Setting.EditWindowTop +
			 GikoSys.Setting.EditWindowWidth +
			 GikoSys.Setting.EditWindowHeight;
	if i > 0 then begin
		SetBounds(GikoSys.Setting.EditWindowLeft, GikoSys.Setting.EditWindowTop,
							GikoSys.Setting.EditWindowWidth, GikoSys.Setting.EditWindowHeight);
		if GikoSys.Setting.EditWindowMax then
			WindowState := wsMaximized;
	end;}
	//EBhËʒuݒ
	wp.length := sizeof(wp);
	wp.rcNormalPosition.Top := GikoSys.Setting.EditWindowTop;
	wp.rcNormalPosition.Left := GikoSys.Setting.EditWindowLeft;
	wp.rcNormalPosition.Bottom := GikoSys.Setting.EditWindowTop + GikoSys.Setting.EditWindowHeight;
	wp.rcNormalPosition.Right := GikoSys.Setting.EditWindowLeft + GikoSys.Setting.EditWindowWidth;
	wp.showCmd := SW_HIDE;
	SetWindowPlacement(Handle, @wp);

	if GikoSys.Setting.EditWindowMax then
		WindowState := wsMaximized;

	//EBhEʊOȂʓɈړ
	if (Left + Width) > Screen.Width then
		Left := Screen.Width - Width;
	if (Top + Height) > Screen.Height then
		Top := Screen.Height - Height;
	if Left < 0 then
		Left := 0;
	if Top < 0 then
		Top := 0;

	//ƍ0Ȃ傫
	if GikoSys.Setting.EditWindowHeight < 0 then
		Height := 400;
	if GikoSys.Setting.EditWindowWidth < 0 then
		Width := 600;

	EditorPage.ActivePage := EditorTab;
	FNameComboEdit := GetWindow(NameComboBox.Handle, GW_CHILD);
	FMailComboEdit := GetWindow(MailComboBox.Handle, GW_CHILD);
	NameComboBox.Items.Assign(GikoSys.Setting.NameList);
	MailComboBox.Items.Assign(GikoSys.Setting.MailList);
	SetFont;
	u32 := GetModuleHandle('User32.dll') <> 0;
	TransAction.Enabled := u32;
end;

procedure TEditorForm.SetBoard(Item: TBoard);
begin
	FBoard := Item;
	Caption := CAPTION_NAME_NEW + ' - [' + Item.Title + ']';
	NameComboBox.Text := FBoard.KotehanName;
	MailComboBox.Text := FBoard.KotehanMail;
	SageCheckBox.Checked := AnsiPos('sage', MailComboBox.Text) <> 0;
	TitlePanel.Visible := True;
end;

procedure TEditorForm.SetThreadItem(Item: TThreadItem);
begin
	FThreadItem := Item;
	Caption := CAPTION_NAME_RES + ' - [' + FThreadItem.Title + ']';
	NameComboBox.Text := FThreadItem.ParentBoard.KotehanName;
	MailComboBox.Text := FThreadItem.ParentBoard.KotehanMail;
	SageCheckBox.Checked := AnsiPos('sage', MailComboBox.Text) <> 0;
	TitlePanel.Visible := False;
end;

procedure TEditorForm.SetFont;
begin
	BodyEdit.Font.Name := GikoSys.Setting.EditorFontName;
	BodyEdit.Font.Size := GikoSys.Setting.EditorFontSize;
	BodyEdit.Font.Color := GikoSys.Setting.EditorFontColor;
	BodyEdit.Color := GikoSys.Setting.EditorBackColor;
end;

procedure TEditorForm.Preview;
var
	Title: string;
	No: string;
	Mail: string;
	Namae: string;
	DateTime: string;
	Body: string;
	s: string;

				posTrip : Integer;
				tripOrigin : string;
begin
	if FThreadItem = nil then begin
		No := '1';
		Title := RepHtml(TitleEdit.Text);
	end else begin
		No := IntToStr(FThreadItem.Count + 1);
		Title := RepHtml(FThreadItem.Title);
	end;

	Namae := RepHtml(NameComboBox.Text);
	Mail := RepHtml(MailComboBox.Text);
	Body := RepHtml(BodyEdit.Text);
	Body := StringReplace(Body, #13#10, '<br>', [rfReplaceAll]);
	DateTime := FormatDateTime('yyyy/mm/dd(aaa) hh:nn', now);

	if Trim(Namae) = '' then
		Namae := '';

	s := '<HTML><HEAD>' + #13#10
			+ '<META http-equiv="Content-Type" content="text/html; charset=Shift_JIS">' + #13#10
			+ '<TITLE>' + title + '</TITLE>' + #13#10
//			+ '<STYLE><!--BODY{font-size : 9pt;font-family : "lr oSVbN";}--></STYLE>' + #13#10
			+ '</HEAD>' + #13#10
			+ '<BODY text="#000000" bgcolor="#EFEFEF" link="#0000FF" alink="#FF0000" vlink="#660099">' + #13#10
			+ '<FONT COLOR="#FF0000">' + title + '</FONT>' + #13#10
			+ '<DL>' + #13#10;
				posTrip := Pos( '#', Namae );
				if posTrip > 0 then
				begin
								tripOrigin := Copy( Namae, posTrip + 1, Length( Namae ) );
								Namae :=
												Copy( Namae, 1, posTrip - 1 ) + '</B> ' +
												get_2ch_trip( PChar( tripOrigin ) ) + '<B>';
				end;
	if Mail = '' then
		s := s + '<DT>' + No + ' F <FONT color="forestgreen"><B>' + Namae + '</B></FONT> F ' + DateTime+ '<BR><DD>' + Body + '<BR><BR><BR>' + #13#10
	else
		s := s + '<DT>' + No + ' F <A href="mailto:' + Mail + '"><B>' + Namae + '</B></A> [' + Mail + ']F ' + DateTime+ '<BR><DD>' + Body + '<BR><BR><BR>' + #13#10;
	s := s + '</BODY></HTML>';
	SetContent(s);
end;

function TEditorForm.RepHtml(s: string): string;
begin
//	s := StringReplace(s, '&', '&amp;', [rfReplaceAll]);
	s := StringReplace(s, '<', '&lt;', [rfReplaceAll]);
	s := StringReplace(s, '>', '&gt;', [rfReplaceAll]);
//	s := StringReplace(s, ' ', '&nbsp;', [rfReplaceAll]);  //dlύXɂ&nbsp;gps
	s := StringReplace(s, '"', '&quot;', [rfReplaceAll]);
	Result := s;
end;

procedure TEditorForm.EditorPageChange(Sender: TObject);
begin
	if EditorPage.ActivePage = PreviewTab then begin
		Preview;
	end else begin
		Browser.Navigate('about:blank');
	end;
end;

procedure TEditorForm.BrowserStatusTextChange(Sender: TObject;
	const Text: WideString);
begin
	if EditorPage.ActivePage = PreviewTab then begin
		StatusBar.Panels[0].Text := Text;
	end else begin
		StatusBar.Panels[0].Text := '';
	end;
end;

function TEditorForm.Check: Boolean;
var
	Msg: string;
	rc: Integer;
	Board: TBoard;
begin
	Result := True;
	if FThreadItem = nil then
		Board := FBoard
	else
		Board := FThreadItem.ParentBoard;

	if (not GikoSys.Setting.UseMachineTime) and
		 ((Board.LastGetTime = 0) or
			(Board.LastGetTime = ZERO_DATE)) then begin
		Msg := 'T[o̎Ȃ߁AMo܂'#13#10
				 + 'XbhXVi擾jA15b҂Ă瑗MĂ';
		MsgBox(Handle, Msg, 'G[', MB_OK or MB_ICONSTOP);
		Result := False;
	end else if BodyEdit.Text = '' then begin
		Msg := '{͂Ă܂B';
		MsgBox(Handle, Msg, 'G[', MB_OK or MB_ICONSTOP);
		Result := False;
	end else if (FBoard <> nil) and (Trim(TitleEdit.Text) = '') then begin
		Msg := '^Cg͂Ă܂B';
		MsgBox(Handle, Msg, 'G[', MB_OK or MB_ICONSTOP);
		Result := False;
	end else begin
		if (not GikoSys.Dolib.Connected) and (AnsiPos('', NameComboBox.Text) <> 0) then begin
			Msg := 'OCĂȂ̂Ł̋@\͗po܂B'#13#10
					 + '̂܂ܑMĂ낵łH';
			rc := MsgBox(Handle, Msg, 'mF', MB_YESNO or MB_ICONQUESTION);
			Result := (rc = IDYES);
		end;
	end;
end;

procedure TEditorForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
	Action := caFree;
end;

procedure TEditorForm.FormDestroy(Sender: TObject);
var
	wp: TWindowPlacement;
begin
	//ő剻EEBhEʒuۑ
	wp.length := sizeof(wp);
	GetWindowPlacement(Handle, @wp);

	GikoSys.Setting.EditWindowTop := wp.rcNormalPosition.Top;
	GikoSys.Setting.EditWindowLeft := wp.rcNormalPosition.Left;
	GikoSys.Setting.EditWindowHeight := wp.rcNormalPosition.Bottom - wp.rcNormalPosition.Top;
	GikoSys.Setting.EditWindowWidth := wp.rcNormalPosition.Right - wp.rcNormalPosition.Left;
	GikoSys.Setting.EditWindowMax := WindowState = wsMaximized;
end;

procedure TEditorForm.SetNameList(sName, sMail: string);
begin
	if Trim(sName) <> '' then begin
		if GikoSys.Setting.NameList.IndexOf(sName) = -1 then
			GikoSys.Setting.NameList.Insert(0, sName);
	end;
	if Trim(sMail) <> '' then begin
		if GikoSys.Setting.MailList.IndexOf(sMail) = -1 then
			GikoSys.Setting.MailList.Insert(0, sMail);
	end;
end;

function TEditorForm.GetActiveControlHandle: THandle;
begin
	if EditorPage.ActivePage = EditorTab then begin
		if ActiveControl = NameComboBox then
			Result := FNameComboEdit
		else if ActiveControl = MailComboBox then
			Result := FMailComboEdit
		else if ActiveControl = BodyEdit then
			Result := BodyEdit.Handle
		else if ActiveControl = TitleEdit then
			Result := TitleEdit.Handle
		else
			Result := 0;
	end else
		Result := 0;
end;

procedure TEditorForm.SetContent(Content: string);
var
	doc : Variant;
begin
	doc := Browser.Document;
	doc.Clear;
	doc.open;
	doc.charset := 'Shift_JIS';
	doc.Write(Content);
	doc.Close;
end;

procedure TEditorForm.Send(SPID: string; PON: string; FirstWriting: Boolean);
var
	TextStream: TStringStream;
	Source: TStringStream;
	ResponseText: string;
	URL: string;
	RefURL: string;
	State: TGikoDownloadState;
	ResultType: TGikoResultType;
	MsgResult: Integer;
	Cookie: string;
	Board: TBoard;
begin
	FAbort := False;
	State := gdsError;
	if FThreadItem = nil then
		Board := FBoard
	else
		Board := FThreadItem.ParentBoard;

	Indy.Request.Clear;
	Indy.ProxyParams.BasicAuthentication := False;
	if GikoSys.Setting.WriteProxy then begin
		Indy.ProxyParams.ProxyServer := GikoSys.Setting.WriteProxyAddress;
		Indy.ProxyParams.ProxyPort := GikoSys.Setting.WriteProxyPort;
		Indy.ProxyParams.ProxyUsername := GikoSys.Setting.WriteProxyUserID;
		Indy.ProxyParams.ProxyPassword := GikoSys.Setting.WriteProxyPassword;
		if GikoSys.Setting.ReadProxyUserID <> '' then
			Indy.ProxyParams.BasicAuthentication := True;
	end else begin
		Indy.ProxyParams.ProxyServer := '';
		Indy.ProxyParams.ProxyPort := 80;
		Indy.ProxyParams.ProxyUsername := '';
		Indy.ProxyParams.ProxyPassword := '';
	end;
	if FThreadItem = nil then begin
		URL := FBoard.GetSendURL;
		RefURL := GikoSys.UrlToServer(FBoard.URL) + 'test/bbs.cgi';
	end else begin
		URL := FThreadItem.GetSendURL;
		RefURL := GikoSys.UrlToServer(FThreadItem.ParentBoard.URL)
						+ 'test/read.cgi/'
						+ FThreadItem.ParentBoard.BBSID
						+ '/' + ChangeFileExt(FThreadItem.FileName, '')
						+ '/l50';
	end;
	Indy.Request.UserAgent := GikoSys.GetUserAgent;
	Indy.Request.Referer := RefURL;
	Indy.Request.AcceptEncoding := '';

	Cookie := '';
	if SPID <> '' then
		Cookie := Cookie + 'SPID=' + SPID + '; ';
	if PON <> '' then
		Cookie := Cookie + 'PON=' + PON + '; ';
	Cookie := 'Cookie: ' + Cookie + 'NAME=' + NameComboBox.Text + '; MAIL=' + MailComboBox.Text;

	Indy.Request.CustomHeaders.Clear;
//	Indy.Request.CacheControl := 'no-cache';
	Indy.Request.CustomHeaders.Add('Pragma: no-cache');
	Indy.Request.AcceptLanguage := 'ja';
	Indy.Request.Accept := 'image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, */*';
	Indy.Request.ContentType := 'application/x-www-form-urlencoded';
	Indy.Request.CustomHeaders.Add(Cookie);
	TextStream := TStringStream.Create('');
	Source := TStringStream.Create('');
	try
		try
			FDebugStrReceive := '';
			FDebugStrSend := '';
			GetSendData(Source);
			Indy.Post(URL, Source, TextStream);
			ResponseText := TextStream.DataString;

			ResultType := GetResultType(ResponseText);

			if ResultType = grtOK then
				State := gdsComplete
			else if ResultType = grtCookie then begin
				//[vh~
				if not FirstWriting then
					raise Exception.Create('');
				MsgResult := MsgBox(
					Handle,
					'Eeꂽe̓Rs[AۑApA]ړꍇ܂B' + #13#10 +
					'EeɊւĔӔC͑Sēe҂ɋA܂B' + #13#10#13#10 +
					'SӔC𕉂Ƃď݂܂H',
					'',
					MB_YESNO or MB_ICONQUESTION);
				if MsgResult = IDYES then begin
					Board.SPID := GetSPID(Indy.Response.RawHeaders.Values['Set-Cookie']);
					Board.PON := GetPON(Indy.Response.RawHeaders.Values['Set-Cookie']);
					if (Board.SPID = '') and (Board.PON = '') then
						raise Exception.Create('');
					//񂱂̃\bh
					Send(Board.SPID, Board.PON, False);
					Exit;
				end else begin
					Board.SPID := '';
					Board.PON := '';
					Exit;
				end;
			end else if ResultType = grtCheck then begin
				//
				//[vh~
				if not FirstWriting then
					raise Exception.Create('');

				MsgResult := MsgBox(
					Handle,
					'݂ɊւĂ͗lXȃO񂪋L^Ă܂B' + #13#10 +
					'eɊւĔӔC͑Sēe҂ɋA܂B' + #13#10 +
					'ǑɔAlɖf鏑݂͍TĉB' + #13#10 +
					'eꂽe̓Rs[EۑEpE]ړꍇ܂B' + #13#10 +
					#13#10 +
					'SӔC𕉂Ƃď݂܂H',
					'mF',
					MB_YESNO or MB_ICONQUESTION);

				if MsgResult = IDYES then begin
					Board.SPID := GetSPID(Indy.Response.RawHeaders.Values['Set-Cookie']);
					Board.PON := GetPON(Indy.Response.RawHeaders.Values['Set-Cookie']);
					if (Board.SPID = '') and (Board.PON = '') then
						raise Exception.Create('');
					Send(Board.SPID, Board.PON, False);
					Exit;
				end else begin
					Board.SPID := '';
					Board.PON := '';
					Exit;
				end;
			end else begin
				State := gdsError;
				raise Exception.Create('');
			end;
		except
			on E: EIdConnectException do begin
				State := gdsError;
				ResponseText := '<html><body>'
											+ '<div>ڑs܂<br>'
											+ 'vLV̏Ԃ𒲂ׂĂ<br></div>'
											+ '<br><br><div>' + E.Message + '</div>'
											+ '</body></html>';
			end;
			on E: Exception do begin
				State := gdsError;

				FDebugStrReceive := AnsiReplaceText(FDebugStrReceive, '<', '&lt;');
				FDebugStrReceive := AnsiReplaceText(FDebugStrReceive, '>', '&gt;');
				FDebugStrSend := AnsiReplaceText(FDebugStrSend, '<', '&lt;');
				FDebugStrSend := AnsiReplaceText(FDebugStrSend, '>', '&gt;');

				ResponseText := '<html><body>' + TextStream.DataString;
				ResponseText := AnsiReplaceText(ResponseText, '</body>', '');
				ResponseText := AnsiReplaceText(ResponseText, '</html>', '');
				ResponseText := ResponseText + '<hr><div align="left"><pre>';
				ResponseText := ResponseText + '<b>MRiȑ</b>'#13#10;
				ResponseText := ResponseText + #13#10'M'#13#10;
				ResponseText := ResponseText + FDebugStrSend;
				ResponseText := ResponseText + #13#10'M'#13#10;
				ResponseText := ResponseText + FDebugStrReceive;
				ResponseText := ResponseText + '</pre></div></body></html>';
			end;
		end;
		FStatusCode := Indy.ResponseCode;
		if FAbort then
			State := gdsAbort;
	finally
		Source.Free;
		TextStream.Free;
	end;

	if State = gdsComplete then begin
		GikoForm.PlaySound('ResEnd');
		SaveSendFile;
		if FThreadItem = nil then
			GikoForm.AddMessageList(FBoard.Title + ' [VXMI]', nil, gmiOK)
		else
			GikoForm.AddMessageList(FThreadItem.Title + ' [XMI]', nil, gmiOK);
		Close;
	end else if State = gdsError then begin
		if FThreadItem = nil then
			GikoForm.AddMessageList(FBoard.Title + ' [VXMs]', nil, gmiNG)
		else
			GikoForm.AddMessageList(FThreadItem.Title + ' [XMs]', nil, gmiNG);
		EditorPage.ActivePage := PreviewTab;
		SetContent(ResponseText);
	end else if State = gdsAbort then begin
		GikoForm.AddMessageList(FThreadItem.Title + ' [f]', nil, gmiSAD);
	end;
end;

function TEditorForm.GetResultType(ResponseText: string): TGikoResultType;
begin
	if AnsiPos('݂I܂', ResponseText) <> 0 then
		Result := grtOK
	else if (AnsiPos('NbL[Ȃ؂ł', ResponseText) > 0) or
					(AnsiPos('<title>NbL[mFI</title>', ResponseText) > 0)  or
					(AnsiPos('<title>NbL[mFI</title>', ResponseText) > 0)  or
					//(AnsiPos('NbL[mF', ResponseText) > 0) or
					(AnsiPos(RES2CH_COOKIE, ResponseText) > 0)  then
		Result := grtCookie
	else if (AnsiPos('<font size=+2 color=#FF0000>݃`FbNI </font>', ResponseText) > 0)  or
					(AnsiPos('<title> ݊mF܂ </title>', ResponseText) > 0)  or
					(AnsiPos('<title>emF</title>', ResponseText) > 0)  or
					(AnsiPos('<b>݊mF</b>', ResponseText) > 0)  or
					(AnsiPos('="../test/subbbs.cgi">', ResponseText) > 0)  or
					(AnsiPos(RES2CH_FALSE, ResponseText) > 0)  then
		Result := grtCheck
	else
		Result := grtError;
end;


procedure TEditorForm.GetSendData(Source: TStringStream);
var
	SessionID: string;
	s: string;
	SendTime: Integer;
	Adjust: Integer;
	Board: TBoard;
begin
	if FThreadItem = nil then
		Board := FBoard
	else
		Board := FThreadItem.ParentBoard;

	if GikoSys.Setting.UseMachineTime then begin
		if GikoSys.Setting.TimeAdjust then
			Adjust := Gikosys.Setting.TimeAdjustSec
		else
			Adjust := GikoSys.Setting.TimeAdjustSec * -1;
		SendTime := GikoSys.DateTimeToInt(Now) - (9 * 60 * 60) + Adjust
	end else begin
		if (Board.LastGetTime = 0) or (Board.LastGetTime = ZERO_DATE) then
			SendTime := GikoSys.DateTimeToInt(Now)
		else
			SendTime := GikoSys.DateTimeToInt(Board.LastGetTime);
	end;
	SessionID := GikoSys.Dolib.SessionID;
	if SessionID <> '' then
		s := 'sid=' + HttpEncode(SessionID) + '&'
	else
		s := '';
	s := s + 'subject=&'
				 + 'FROM=' + HttpEncode(NameComboBox.Text) + '&'
				 + 'mail=' + HttpEncode(MailComboBox.Text) + '&'
				 + 'MESSAGE=' + HttpEncode(BodyEdit.Text) + '&'
				 + 'bbs=' + Board.BBSID + '&'
				 + 'time=' + IntToStr(SendTime) + '&';
	if FThreadItem = nil then begin
		s := s + 'subject=' + HttpEncode(TitleEdit.Text) + '&';
		s := s + 'submit=' + HttpEncode('SӔC𕉂Ƃď') + #13#10;
	end else begin
		s := s + 'key=' + ChangeFileExt(FThreadItem.FileName, '') + '&';
		s := s + 'submit=' + HttpEncode('') + #13#10;
	end;
	Source.WriteString(s);
end;

procedure TEditorForm.SaveSendFile;
var
	sDate: string;
	ini: TMemIniFile;
begin
	ini := TMemIniFile.Create(GikoSys.GetSentFileName);
	try
		sDate := IntToStr(GikoSys.DateTimeToInt(Now));

		ini.WriteString(sDate, 'Name', NameComboBox.Text);
		ini.WriteString(sDate, 'EMail', MailComboBox.Text);
		ini.WriteString(sDate, 'Body', HttpEncode(BodyEdit.Text));
		ini.WriteInteger(sDate, 'Status', FStatusCode);
		ini.WriteDateTime(sDate, 'Date', Now);
		if FThreadItem = nil then begin
			ini.WriteString(sDate, 'Title', TitleEdit.Text);
			ini.WriteString(sDate, 'BBS', FBoard.BBSID);
			ini.WriteInteger(sDate, 'NewThread', 1);
		end else begin
			ini.WriteString(sDate, 'Title', FThreadItem.Title);
			ini.WriteString(sDate, 'BBS', FThreadItem.ParentBoard.BBSID);
			ini.WriteString(sDate, 'Key', ChangeFileExt(FThreadItem.FileName, ''));
		end;

		ini.UpdateFile;
	finally
		ini.Free;
	end;
end;

procedure TEditorForm.SendActionExecute(Sender: TObject);
var
	Board: TBoard;
	rc: Integer;
begin
	if FWork then
		Exit;
	try
		FWork := True;
		SendAction.Enabled := False;
		Application.ProcessMessages;
		if not Check then Exit;

		if FThreadItem = nil then
			Board := FBoard
		else
			Board := FThreadItem.ParentBoard;

		if FThreadItem = nil then begin
			rc := GikoUtil.MsgBox(Handle,
													'u' + Board.Title + 'vɐVXbhĂ܂'#13#10#13#10
													+ 'E̃[݂ł邱ƂmF܂H'#13#10
													+ 'Eɓ悤ȃXbhƂmF܂H'#13#10#13#10
													+ 'u͂vƑM܂',
													'mF',
													MB_ICONQUESTION or MB_YESNO);
			if rc <> ID_YES then
				Exit;
		end;

		SetNameList(NameComboBox.Text, MailComboBox.Text);
		if KotehanCheckBox.Checked then begin
			Board.KotehanName := NameComboBox.Text;
			Board.KotehanMail := MailComboBox.Text;
		end;
		Send(Board.SPID, Board.PON, True);
	finally
		FWork := False;
	end;
end;

procedure TEditorForm.SaveActionExecute(Sender: TObject);
begin
//
end;

procedure TEditorForm.CloseActionExecute(Sender: TObject);
begin
	Close;
end;

procedure TEditorForm.UndoActionExecute(Sender: TObject);
begin
	SendMessage(GetActiveControlHandle, WM_UNDO, 0, 0);
end;

procedure TEditorForm.CutActionExecute(Sender: TObject);
begin
	SendMessage(GetActiveControlHandle, WM_CUT, 0, 0);
end;

procedure TEditorForm.CopyActionExecute(Sender: TObject);
begin
	SendMessage(GetActiveControlHandle, WM_COPY, 0, 0);
end;

procedure TEditorForm.PasteActionExecute(Sender: TObject);
begin
	SendMessage(GetActiveControlHandle, WM_PASTE, 0, 0);
end;

procedure TEditorForm.SelectAllActionExecute(Sender: TObject);
begin
	SendMessage(GetActiveControlHandle, EM_SETSEL, 0, GetWindowTextLength(GetActiveControlHandle));
end;

procedure TEditorForm.TopActionExecute(Sender: TObject);
begin
	if TopAction.Checked then
		FormStyle := fsStayOnTop
	else
		FormStyle := fsNormal;
end;

procedure TEditorForm.AbortActionExecute(Sender: TObject);
begin
	FAbort := True;
end;

procedure TEditorForm.SendActionUpdate(Sender: TObject);
begin
	SendAction.Enabled := not FWork;
end;

procedure TEditorForm.SaveActionUpdate(Sender: TObject);
begin
	SaveAction.Enabled := False;
end;

procedure TEditorForm.CloseActionUpdate(Sender: TObject);
begin
	SendAction.Enabled := not FWork;
end;

procedure TEditorForm.UndoActionUpdate(Sender: TObject);
begin
	UndoAction.Enabled := (GetActiveControlHandle <> 0)
												and (SendMessage(GetActiveControlHandle, EM_CANUNDO, 0, 0) <> 0)
												and (not FWork);
end;

procedure TEditorForm.CutActionUpdate(Sender: TObject);
var
	Selection: TSelection;
	AHandle: THandle;
begin
	AHandle := GetActiveControlHandle;
	SendMessage(AHandle, EM_GETSEL, Longint(@Selection.StartPos), Longint(@Selection.EndPos));
	CutAction.Enabled := (AHandle <> 0)
										and ((Selection.EndPos - Selection.StartPos) <> 0)
										and (not FWork);
end;

procedure TEditorForm.CopyActionUpdate(Sender: TObject);
var
	Selection: TSelection;
	AHandle: THandle;
begin
	AHandle := GetActiveControlHandle;
	SendMessage(AHandle, EM_GETSEL, Longint(@Selection.StartPos), Longint(@Selection.EndPos));
	CopyAction.Enabled := (AHandle <> 0)
										and ((Selection.EndPos - Selection.StartPos) <> 0)
										and (not FWork);
end;

procedure TEditorForm.PasteActionUpdate(Sender: TObject);
begin
	PasteAction.Enabled := (GetActiveControlHandle <> 0)
											and (Clipboard.HasFormat(CF_TEXT))
											and (not FWork);
end;

procedure TEditorForm.TopActionUpdate(Sender: TObject);
begin
	TopAction.Enabled := not FWork;
end;

procedure TEditorForm.SageCheckBoxClick(Sender: TObject);
begin
	if SageCheckBox.Checked then begin
		if AnsiPos('sage', MailComboBox.Text) = 0 then
			MailComboBox.Text := 'sage' + MailComboBox.Text;
	end else begin
		if AnsiPos('sage', MailComboBox.Text) <> 0 then
			MailComboBox.Text := StringReplace(MailComboBox.Text, 'sage', '', [rfReplaceAll]);
	end;
end;

procedure TEditorForm.MailComboBoxChange(Sender: TObject);
begin
	if AnsiPos('sage', MailComboBox.Text) = 0 then
		SageCheckBox.Checked := False
	else
		SageCheckBox.Checked := True;
end;


function TEditorForm.GetSPID(CookieLine: string): string;
var
	s: string;
	i: Integer;
begin
	Result := '';
	i := 0;
	while True do begin
		s := Trim(GikoSys.GetTokenIndex(CookieLine, ';', i));
		if s = '' then
			Break
		else begin
			if Pos('SPID=', s) = 1 then begin
				Result := Trim(Copy(s, 6, Length(s)));
				Break;
			end;
		end;
		inc(i);
	end;
end;

function TEditorForm.GetPON(CookieLine: string): string;
var
	s: string;
	i: Integer;
begin
	Result := '';
	i := 0;
	while True do begin
		s := Trim(GikoSys.GetTokenIndex(CookieLine, ';', i));
		if s = '' then
			Break
		else begin
			if Pos('PON=', s) = 1 then begin
				Result := Trim(Copy(s, 5, Length(s)));
				Break;
			end;
		end;
		inc(i);
	end;
end;

procedure TEditorForm.IdLogDebugReceive(ASender: TIdConnectionIntercept;
	AStream: TStream);
var
	StringStream: TStringStream;
begin
	StringStream := TStringStream.Create('');
	try
		StringStream.CopyFrom(AStream, AStream.Size);
		FDebugStrReceive := FDebugStrReceive + StringStream.DataString;
	finally
		StringStream.Free;
	end;
end;

procedure TEditorForm.IdLogDebugSend(ASender: TIdConnectionIntercept;
	AStream: TStream);
var
	StringStream: TStringStream;
begin
	StringStream := TStringStream.Create('');
	try
		StringStream.CopyFrom(AStream, AStream.Size);
		FDebugStrSend := FDebugStrSend + StringStream.DataString;
	finally
		StringStream.Free;
	end;
end;

procedure TEditorForm.TransActionExecute(Sender: TObject);
begin
	AlphaBlend := TransAction.Checked;
end;

procedure TEditorForm.TransActionUpdate(Sender: TObject);
begin
	TransAction.Enabled := not FWork;
end;

end.

