unit ExternalThreadItem;

interface

uses
	Windows, Classes, SysUtils,
	IdComponent,
	ExternalBoardPlugInMain;

type
	// TThreadItem ̃vpeBݒ^擾 ID
	TThreadItemProperty = (
		tipContext,							// : DWORD			// Rɐݒ肵Ăl
		tipNo,									// : Integer		// ԍ
		tipFileName,						// : string			// Xbht@C
		tipTitle,								// : string			// Xbh^Cg
		tipRoundDate,						// : TDateTime	// Xbh擾ij
		tipLastModified,				// : TDateTime	// XbhXVĂiT[oj
		tipCount,								// : Integer		// XbhJEgi[Jj
		tipAllResCount,					// : Integer		// XbhJEgiT[oj
		tipNewResCount,					// : Integer		// XbhV
		tipSize,								// : Integer		// XbhTCY
		tipRound,								// : Boolean		// tO
		tipRoundName,						// : string			// 
		tipIsLogFile,						// : Boolean		// O݃tO
		tipKokomade,						// : Integer		// RR܂œǂ񂾔ԍ
		tipNewReceive,					// : Integer		// RRVKM
		tipNewArrival,					// : Boolean		// V
		tipUnRead,							// : Boolean		// ǃtO
		tipScrollTop,						// : Integer		// XN[ʒu
		tipDownloadHost,				// : string			// ̃zXgƈႤꍇ̃zXg
		tipAgeSage,							// : TThreadAgeSage	// ACȅグ
		tipURL,									// : string			// XbhuEUŕ\ۂ URL
		tipFilePath							// : string			// ̃XۑĂpX
	);

	// *************************************************************************
	// TThreadItem ꂽ
	// *************************************************************************
	TThreadItemCreate = procedure(
		inInstance : DWORD
	); stdcall;

	// *************************************************************************
	// TThreadItem jꂽ
	// *************************************************************************
	TThreadItemDispose = procedure(
		inInstance : DWORD
	); stdcall;

	// *************************************************************************
	// _E[hw
	// *************************************************************************
	TThreadItemOnDownload = function(
		inInstance	: DWORD					// CX^X
	) : TDownloadState; stdcall;	// _E[hǂ

	// *************************************************************************
	// ݂w
	// *************************************************************************
	TThreadItemOnWrite = function(
		inInstance	: DWORD;				// ThreadItem ̃CX^X
		inName			: PChar;				// O(nh)
		inMail			: PChar;				// [AhX
		inMessage		: PChar					// {
	) : TDownloadState; stdcall;	// ݂ǂ

	// *************************************************************************
	// Xԍ n ɑ΂ html v
	// *************************************************************************
	TThreadItemOnGetRes = function(
		inInstance	: DWORD;		// CX^X
		inNo				: DWORD			// \郌Xԍ
	) : PChar; stdcall;				// \ HTML

	// *************************************************************************
	// Xԍ n ɑ΂ Dat v
	// *************************************************************************
	TThreadItemOnGetDat = function(
		inInstance	: DWORD;		// CX^X
		inNo				: DWORD			// \郌Xԍ
	) : PChar; stdcall;				// Q˂`Dat

	// *************************************************************************
	// Xbh̃wb_ html v
	// *************************************************************************
	TThreadItemOnGetHeader = function(
		inInstance				: DWORD;	// ThreadItem ̃CX^X
		inOptionalHeader	: PChar		// ǉ̃wb_
	) : PChar; stdcall;						// `ꂽ HTML

	// *************************************************************************
	// Xbh̃tb^ html v
	// *************************************************************************
	TThreadItemOnGetFooter = function(
		inInstance				: DWORD;	// ThreadItem ̃CX^X
		inOptionalFooter	: PChar		// ǉ̃tb^
	) : PChar; stdcall;						// `ꂽ HTML

	// *************************************************************************
	//  ThreadItem  URL v
	// *************************************************************************
	TThreadItemOnGetBoardURL = function(
		inInstance	: DWORD					// ThreadItem ̃CX^X
	) : PChar; stdcall;	 					//  URL

function ThreadItemDat2HTML(
	inInstance	: DWORD;		// ThreadItem ̃CX^X
	inDatRes		: PChar;		// O<>[<>tID<>{<> ō\ꂽeLXg
	inResNo			: DWORD;		// Xԍ
	inIsNew			: Boolean		// VXȂ True
) : PChar; stdcall;				// `ꂽ HTML

implementation

uses ExternalBoardManager, GikoSystem, BoardGroup;

// *************************************************************************
// TThreadItem NX̃vpeB擾
// *************************************************************************
function ThreadItemGetLong(
	instance		: DWORD;
	propertyID	: TThreadItemProperty
) : DWORD; stdcall;
var
	threadItem : TThreadItem;
begin

	threadItem := TThreadItem( instance );
	case propertyID of
		tipContext:							// : DWORD			// Rɐݒ肵Ăl
			Result := threadItem.Context;
		tipNo:									// : Integer		// ԍ
			Result := threadItem.No;
		tipFileName:						// : string			// Xbht@C
			Result := DWORD( CreateResultString( threadItem.FileName ) );
		tipTitle:								// : string			// Xbh^Cg
			Result := DWORD( CreateResultString( threadItem.Title ) );
		tipCount:								// : Integer		// XbhJEgi[Jj
			Result := threadItem.Count;
		tipAllResCount:					// : Integer		// XbhJEgiT[oj
			Result := threadItem.AllResCount;
		tipNewResCount:					// : Integer		// XbhV
			Result := threadItem.NewResCount;
		tipSize:								// : Integer		// XbhTCY
			Result := threadItem.Size;
		tipRound:								// : Boolean		// tO
			Result := DWORD( threadItem.Round );
		tipRoundName:						// : string			// 
			Result := DWORD( CreateResultString( threadItem.RoundName ) );
		tipIsLogFile:						// : Boolean		// O݃tO
			Result := DWORD( threadItem.IsLogFile );
		tipKokomade:						// : Integer		// RR܂œǂ񂾔ԍ
			Result := threadItem.Kokomade;
		tipNewReceive:					// : Integer		// RRVKM
			Result := threadItem.NewReceive;
		tipNewArrival:					// : Boolean		// V
			Result := DWORD( threadItem.NewArrival );
		tipUnRead:							// : Boolean		// ǃtO
			Result := DWORD( threadItem.UnRead );
		tipScrollTop:						// : Integer		// XN[ʒu
			Result := threadItem.ScrollTop;
		tipDownloadHost:				// : string			// ̃zXgƈႤꍇ̃zXg
			Result := DWORD( CreateResultString( threadItem.DownloadHost ) );
		tipAgeSage:							// : TThreadAgeSage	// ACȅグ
			Result := DWORD( threadItem.AgeSage );
		tipURL:									// : string			// XbhuEUŕ\ۂ URL
			Result := DWORD( CreateResultString( threadItem.URL ) );
		tipFilePath:														// ̃XۑĂpX
			Result := DWORD( CreateResultString( threadItem.FilePath ) );
	else
		Result := 0;
	end;
end;

// *************************************************************************
// TThreadItem NX̃vpeBݒ肷
// *************************************************************************
procedure ThreadItemSetLong(
	instance		: DWORD;
	propertyID	: TThreadItemProperty;
	param : DWORD
); stdcall;
var
	threadItem	: TThreadItem;
begin

	threadItem := TThreadItem( instance );
	case propertyID of
		tipContext:							// : DWORD			// Rɐݒ肵Ăl
			threadItem.Context			:= param;
		tipNo:									// : Integer		// ԍ
			threadItem.No						:= param;
		tipFileName:						// : string			// Xbht@C
			threadItem.FileName			:= string( PChar( param ) );
		tipTitle:								// : string			// Xbh^Cg
			threadItem.Title				:= string( PChar( param ) );
		tipCount:								// : Integer		// XbhJEgi[Jj
			threadItem.Count				:= param;
		tipAllResCount:					// : Integer		// XbhJEgiT[oj
			threadItem.AllResCount	:= param;
		tipNewResCount:					// : Integer		// XbhV
			threadItem.NewResCount	:= param;
		tipSize:								// : Integer		// XbhTCY
			threadItem.Size					:= param;
		tipRound:								// : Boolean		// tO
			threadItem.Round				:= Boolean( param );
		tipRoundName:						// : string			// 
			threadItem.RoundName		:= string( PChar( param ) );
		tipIsLogFile:						// : Boolean		// O݃tO
			threadItem.IsLogFile		:= Boolean( param );
		tipKokomade:						// : Integer		// RR܂œǂ񂾔ԍ
			threadItem.Kokomade			:= param;
		tipNewReceive:					// : Integer		// RRVKM
			threadItem.NewReceive		:= param;
		tipNewArrival:					// : Boolean		// V
			threadItem.NewArrival		:= Boolean( param );
		tipUnRead:							// : Boolean		// ǃtO
			threadItem.UnRead				:= Boolean( param );
		tipScrollTop:						// : Integer		// XN[ʒu
			threadItem.ScrollTop		 := param;
		tipDownloadHost:				// : string			// ̃zXgƈႤꍇ̃zXg
			threadItem.DownloadHost	:= string( PChar( param ) );
		tipAgeSage:							// : TThreadAgeSage	// ACȅグ
			threadItem.AgeSage			:= TGikoAgeSage( param );
		tipURL:									// : string			// XbhuEUŕ\ۂ URL
			threadItem.URL					:= string( PChar( param ) );
		tipFilePath:						// : string			// ̃XۑĂpX
			threadItem.FilePath			:= string( PChar( param ) );
	end;

end;

// *************************************************************************
// TThreadItem NX̃vpeB擾
// *************************************************************************
function ThreadItemGetDouble(
	instance		: DWORD;
	propertyID	: TThreadItemProperty
) : Double; stdcall;
var
	threadItem : TThreadItem;
begin

	threadItem := TThreadItem( instance );
	case propertyID of
		tipRoundDate:						// : TDateTime	// Xbh擾ij
			Result := threadItem.RoundDate;
		tipLastModified:				// : TDateTime	// XbhXVĂiT[oj
			Result := threadItem.LastModified;
	else
		Result := 0;
	end;

end;

// *************************************************************************
// TThreadItem NX̃vpeBݒ肷
// *************************************************************************
procedure ThreadItemSetDouble(
	instance		: DWORD;
	propertyID	: TThreadItemProperty;
	param				: Double
); stdcall;
var
	threadItem : TThreadItem;
begin

	threadItem := TThreadItem( instance );
	case propertyID of
		tipRoundDate:						// : TDateTime	// Xbh擾ij
			threadItem.RoundDate		:= param;
		tipLastModified:				// : TDateTime	// XbhXVĂiT[oj
			threadItem.LastModified	:= param;
	end;

end;

// *************************************************************************
// TThreadItem NXɂQ˂ dat ` 1 s HTML ɕϊ
// *************************************************************************
function ThreadItemDat2HTML(
	inInstance	: DWORD;		// ThreadItem ̃CX^X
	inDatRes		: PChar;		// O<>[<>tID<>{<> ō\ꂽeLXg
	inResNo			: DWORD;		// Xԍ
	inIsNew			: Boolean		// VXȂ True
) : PChar; stdcall;				// `ꂽ HTML
var
	threadItem : TThreadItem;
	res : TResRec;
	no : string;
begin

	threadItem	:= TThreadItem( inInstance );
	// 𕪉
	res					:= GikoSys.DivideStrLine( string( inDatRes ) );
    if AnsiCompareStr( string( inDatRes ) , '' ) <> 0 then begin
        res.FBody		:= GikoSys.AddAnchorTag( res.FBody );
        res.FBody		:= GikoSys.ConvRes( res.FBody, threadItem.ParentBoard.BBSID, ChangeFileExt( threadItem.FileName, '' ), 'bbs', 'key', 'st', 'to', 'nofirst', 'true');

        no					:= IntToStr( inResNo );

        try
            if GikoSys.Setting.UseSkin then begin
                // XL
                if inIsNew then
                    Result := CreateResultString( GikoSys.SkinedRes(
                        GikoSys.LoadFromSkin(
                            GikoSys.Setting.GetSkinNewResFileName, threadItem, threadItem.Size
                        ), res, no
                    ) )
                else
                    Result := CreateResultString( GikoSys.SkinedRes(
                        GikoSys.LoadFromSkin(
                            GikoSys.Setting.GetSkinResFileName, threadItem, threadItem.Size
                        ), res, no
                    ) );
            end else if GikoSys.Setting.UseCSS then begin
                // CSS
                if res.FName = '' then
                    res.FName := '&nbsp;';
                if res.FMailTo = '' then
                    Result := CreateResultString( '<a name="' + no + '"></a>'
                                    + '<div class="header"><span class="no"><a href="menu:' + No + '">' + no + '</a></span> '
                                    + '<span class="name_label">OF</span> '
                                    + '<span class="name"><b>' + res.FName + '</b></span> '
                                    + '<span class="date_label">eF</span> '
                                    + '<span class="date">' + res.FDateTime+ '</span></div>'
                                    + '<div class="mes">' + res.FBody + ' </div>' )
                else if GikoSys.Setting.ShowMail then
                    Result := CreateResultString( '<a name="' + no + '"></a>'
                                    + '<div class="header"><span class="no"><a href="menu:' + no + '">' + no + '</a></span>'
                                    + '<span class="name_label"> OF </span>'
                                    + '<a class="name_mail" href="mailto:' + res.FMailTo + '">'
                                    + '<b>' + res.FName + '</b></a><span class="mail"> [' + res.FMailTo + ']</span>'
                                    + '<span class="date_label"> eF</span>'
                                    + '<span class="date"> ' + res.FDateTime+ '</span></div>'
                                    + '<div class="mes">' + res.FBody + ' </div>' )
                else
                    Result := CreateResultString( '<a name="' + no + '"></a>'
                                    + '<div class="header"><span class="no"><a href="menu:' + no + '">' + no + '</a></span>'
                                    + '<span class="name_label"> OF </span>'
                                    + '<a class="name_mail" href="mailto:' + res.FMailTo + '">'
                                    + '<b>' + res.FName + '</b></a>'
                                    + '<span class="date_label"> eF</span>'
                                    + '<span class="date"> ' + res.FDateTime+ '</span></div>'
                                    + '<div class="mes">' + res.FBody + ' </div>' );
            end else begin
                // ftHg
                if res.FMailTo = '' then
                    Result := CreateResultString( '<a name="' + no + '"></a><dt><a href="menu:' + no + '">' + no + '</a> OF<font color="forestgreen"><b> ' + res.FName + ' </b></font> eF ' + res.FDateTime+ '<br><dd>' + res.Fbody + ' <br><br><br>' )
                else if GikoSys.Setting.ShowMail then
                    Result := CreateResultString( '<a name="' + no + '"></a><dt><a href="menu:' + no + '">' + no + '</a> OF<a href="mailto:' + res.FMailTo + '"><b> ' + res.FName + ' </B></a> [' + res.FMailTo + '] eF ' + res.FDateTime+ '<br><dd>' + res.Fbody + ' <br><br><br>' )
                else
                    Result := CreateResultString( '<a name="' + no + '"></a><dt><a href="menu:' + no + '">' + no + '</a> OF<a href="mailto:' + res.FMailTo + '"><b> ' + res.FName + ' </B></a> eF ' + res.FDateTime+ '<br><dd>' + res.Fbody + ' <br><br><br>' );
            end;
        except
            Result := nil;
        end;
    end else begin
    	Result := nil;
    end;

end;

// *************************************************************************
// TThreadItem NXɃXbh̃wb_擾
// *************************************************************************
function ThreadItemGetHeader(
	inInstance				: DWORD;	// ThreadItem ̃CX^X
	inOptionalHeader	: PChar		// ǉ̃wb_
) : PChar; stdcall;						// `ꂽ HTML
var
	threadItem				: TThreadItem;
	skinHeader				: string;
	optionalHeader		: string;
begin

	{$IFDEF DEBUG}
	Writeln('ExternalBoardManager.ThreadItemGetHeader');
	{$ENDIF}
	threadItem			:= TThreadItem( inInstance );
	optionalHeader	:= string( inOptionalHeader );

	try
		if GikoSys.Setting.UseSkin then begin
			// XL
			skinHeader := GikoSys.LoadFromSkin( GikoSys.Setting.GetSkinHeaderFileName, threadItem, threadItem.Size );
			if Length( optionalHeader ) > 0 then
				skinHeader :=
					StringReplace( skinHeader, '</head>', optionalHeader + '</head><a name="top"></a>', [] );
		end else if GikoSys.Setting.UseCSS then begin
			// CSS
			skinHeader :=
				'<html><head>' +
				'<title>' + threadItem.Title + '</title>' +
				'<link rel="stylesheet" href="'+ GikoSys.Setting.GetStyleSheetDir + GikoSys.Setting.CSSFileName +'" type="text/css">' +
				optionalHeader +
				'</head>' +
				'<body>' +
				'<a name="top"></a>' +
				'<div class="title">' + threadItem.Title + '</div>';
		end else begin
			// ftHg
			skinHeader :=
				'<html><head>' +
				'<title>' + threadItem.Title + '</title>' +
				optionalHeader +
				'</head>' +
				'<body TEXT="#000000" BGCOLOR="#EFEFEF" link="#0000FF" alink="#FF0000" vlink="#660099">' +
				'<a name="top"></a>' +
				'<font size=+1 color="#FF0000">' + threadItem.Title + '</font>' +
				'<dl>';
		end;
	except
	end;

	Result := CreateResultString( skinHeader );

end;

// *************************************************************************
// TThreadItem NXɃXbh̃tb^擾
// *************************************************************************
function ThreadItemGetFooter(
	inInstance				: DWORD;	// ThreadItem ̃CX^X
	inOptionalFooter	: PChar		// ǉ̃tb^
) : PChar; stdcall;						// `ꂽ HTML
var
	threadItem				: TThreadItem;
	skinFooter				: string;
	optionalFooter		: string;
begin

	{$IFDEF DEBUG}
	Writeln('ExternalBoardManager.ThreadItemGetFooter');
	{$ENDIF}
	threadItem			:= TThreadItem( inInstance );
	optionalFooter	:= string( inOptionalFooter );

	try
		if GikoSys.Setting.UseSkin then begin
			// XL
			skinFooter := GikoSys.LoadFromSkin( GikoSys.Setting.GetSkinFooterFileName, threadItem, threadItem.Size );
			if Length( optionalFooter ) > 0 then
				skinFooter :=
					StringReplace( skinFooter, '</body>', optionalFooter + '</body>', [] );
		end else if GikoSys.Setting.UseCSS then begin
			// CSS
			skinFooter :=
				optionalFooter +
				'</body></html>' +
				'<a name="last"></a>' +
				'</body></html>';
		end else begin
			// ftHg
			skinFooter :=
				'</dl>' +
				optionalFooter +
				'</body></html>' +
				'<a name="last"></a>' +
				'</body></html>';
		end;
	except
	end;

	Result := CreateResultString( skinFooter );

end;

// *************************************************************************
// Xbh̃_E[his
// *************************************************************************
procedure ThreadItemWork(
	inInstance	: DWORD;			// ThreadItem ̃CX^X
	inWorkCount	: Integer			// ݂̐i(JEg)
); stdcall;
begin

	if Assigned( OnWork ) then
		OnWork( TObject( inInstance ), wmRead, inWorkCount );

end;

// *************************************************************************
// Xbh̃_E[hn܂
// *************************************************************************
procedure ThreadItemWorkBegin(
	inInstance			: DWORD;	// ThreadItem ̃CX^X
	inWorkCountMax	: Integer	// ʐM̏IJEg
); stdcall;
begin

	if Assigned( OnWorkBegin ) then
		OnWorkBegin( TObject( inInstance ), wmRead, inWorkCountMax );

end;

// *************************************************************************
// Xbh̃_E[hI
// *************************************************************************
procedure ThreadItemWorkEnd(
	inInstance	: DWORD				// ThreadItem ̃CX^X
); stdcall;
begin

	if Assigned( OnWorkEnd ) then
		OnWorkEnd( TObject( inInstance ), wmRead );

end;

exports
	ThreadItemGetLong,
	ThreadItemSetLong,
	ThreadItemGetDouble,
	ThreadItemSetDouble,
	ThreadItemDat2HTML,
	ThreadItemGetHeader,
	ThreadItemGetFooter,
	ThreadItemWork,
	ThreadItemWorkBegin,
	ThreadItemWorkEnd;

end.
 