unit Setting;


interface

uses
	SysUtils, Classes, Graphics, Forms, {Math, IniFiles, UCryptAuto, UBase64,}
	ComCtrls, GestureModel, IniFiles, SkinFiles;

const
	MAIN_COOLBAND_COUNT = 4;		//CCoolBand̐
	LIST_COOLBAND_COUNT = 2;		//CoolBand̐
	BROWSER_COOLBAND_COUNT = 3;	//uEUCoolBand̐


type
	TGikoTabPosition = (gtpTop, gtpBottom);								// ^uʒu
	TGikoTabAppend = (gtaFirst, gtaLast, gtaRight, gtaLeft);									// ^uǉʒu
	TGikoTabStyle = (gtsTab, gtsButton, gtsFlat);					// ^uX^C
	TGikoListOrientation = (gloHorizontal, gloVertical);	// XgE
	TGikoListState = (glsMax, glsNormal, glsMin);					// XgTCY
																												// |bvAbv\ʒu
	TGikoPopupPosition = (gppLeftTop = 0, gppTop, gppRightTop,
												gppLeft, gppCenter, gppRight,
												gppLeftBottom, gppBottom, gppRightBottom);
																												//vr[TCY
	TGikoPreviewSize = (gpsXLarge, gpsLarge, gpsMedium, gpsSmall, gpsXSmall);
	TGikoBrowserAutoMaximize	= (gbmNone, gbmClick, gbmDoubleClick);
																												// uEUIɍő剻
	/// X\͈́B10 ` 65535 ͍ŐV n XB
	///  201-300 ̂悤Ȕ͈͂\lď 2 byte ͗\B
	TGikoResRange = (grrAll, grrSelect, grrKoko, grrNew);

	/// Xbhꗗ\͈
	TGikoThreadRange = (gtrAll, gtrSelect, gtrLog, gtrNew, gtrLive, gtrArch);

	//! XptB^[ASY
	TGikoSpamFilterAlgorithm = (
		gsfaNone, gsfaPaulGraham, gsfaGaryRobinson, gsfaGaryRobinsonFisher);


	/// JeSXg̃J ID
	type	TGikoBBSColumnID = (gbbscTitle);
	/// JeSXg̃J
	const	GikoBBSColumnCaption : array[0..0] of string =
		( 'JeS' );
	/// JeSXgJz
	type	TGikoBBSColumnList = class( TList )
	private
		function GetItem( index : integer ) : TGikoBBSColumnID;
		procedure SetItem( index : integer; value : TGikoBBSColumnID);
	public
		constructor Create;
		destructor Destroy;	override;
		function Add( value : TGikoBBSColumnID ) : Integer;
		property Items[index : integer]: TGikoBBSColumnID read GetItem write SetItem; default;
	end;
	/// Xg̃J ID
	type	TGikoCategoryColumnID = (gccTitle, gccRoundName, gccLastModified);
	/// Xg̃J
	const GikoCategoryColumnCaption : array[0..2] of string =
		( '', '\', '擾' );
	/// XgJz
	type	TGikoCategoryColumnList = class( TList )
	private
		function GetItem( index : integer ) : TGikoCategoryColumnID;
		procedure SetItem( index : integer; value : TGikoCategoryColumnID);
	public
		constructor Create;
		destructor Destroy;	override;
		function Add( value : TGikoCategoryColumnID ) : Integer;
		property Items[index : integer]: TGikoCategoryColumnID read GetItem write SetItem; default;
	end;
	/// XXg̃J ID
	type	TGikoBoardColumnID = (gbcTitle, gbcAllCount, gbcLocalCount, gbcNonAcqCount,
		gbcNewCount, gbcUnReadCount, gbcRoundName, gbcRoundDate, gbcCreated, gbcLastModified, gbcVigor );{gbcLastModified,}
	/// XXg̃J
	const	GikoBoardColumnCaption : array[0..10] of string =
		( 'Xbh', 'JEg', '擾', '擾', 'V',
		'', '\', '擾', 'X쐬', 'ŏIXV', '' );
	const GikoBoardColumnAlignment : array[0..10] of TAlignment = (
		taLeftJustify, taRightJustify, taRightJustify, taRightJustify,
		taRightJustify, taRightJustify, taLeftJustify, taLeftJustify,
		taLeftJustify, taLeftJustify, taRightJustify);
	/// XXgJz
	type	TGikoBoardColumnList = class( TList )
	private
		function GetItem( index : integer ) : TGikoBoardColumnID;
		procedure SetItem( index : integer; value : TGikoBoardColumnID);
	public
		constructor Create;
		destructor Destroy;	override;
		function Add( value : TGikoBoardColumnID ) : Integer;
		property Items[index : integer]: TGikoBoardColumnID read GetItem write SetItem; default;
	end;

type
	//CoolBarݒ背R[h
	TCoolSet = record
		FCoolID: Integer;
		FCoolWidth: Integer;
		FCoolBreak: Boolean;
	end;

	TSetting = class(TObject)
	private
		//Mobt@TCY
		FRecvBufferSize: Integer;
		//HTTP1.1gp
		FProtocol: Boolean;
		//vLVڑHTTP1.1gp
		FProxyProtocol: Boolean;

		//vLViǍpj
		FReadProxy: Boolean;
		FReadProxyAddress: string;
		FReadProxyPort: Integer;
		FReadProxyUserID: string;
		FReadProxyPassword: string;

		//vLVipj
		FWriteProxy: Boolean;
		FWriteProxyAddress: string;
		FWriteProxyPort: Integer;
		FWriteProxyUserID: string;
		FWriteProxyPassword: string;

		//Lrlbg
		FCabinetFontName: string;
		FCabinetFontSize: Integer;
		FCabinetFontBold: Boolean;
		FCabinetFontItalic: Boolean;
		FCabinetFontColor: TColor;
		FCabinetBackColor: TColor;

		//Xg
		FListFontName: string;
		FListFontSize: Integer;
		FListFontBold: Boolean;
		FListFontItalic: Boolean;
		FListFontColor: TColor;
		FListBackColor: TColor;

		//uEU
		FBrowserFontName: string;			// ''...default
		FBrowserFontSize: Integer;		// 0...default
		FBrowserFontBold: Integer;		// 0...default, -1...False, 1...True
		FBrowserFontItalic: Integer;	// ɓ
		FBrowserFontColor: Integer;		// -1...default
		FBrowserBackColor: Integer;		// ɓ

		//GfB^
		FEditorFontName: string;
		FEditorFontSize: Integer;
		FEditorFontBold: Boolean;
		FEditorFontItalic: Boolean;
		FEditorFontColor: TColor;
		FEditorBackColor: TColor;

		//^utHg
		FBrowserTabFontName: string;
		FBrowserTabFontSize: Integer;
		FBrowserTabFontBold: Boolean;
		FBrowserTabFontItalic: Boolean;

		//qgEBhE
		FHintFontName: string;
		FHintFontSize: Integer;
		//FHintFontBold: Boolean;
		//FHintFontItalic: Boolean;
		FHintFontColor: TColor;
		FHintBackColor: TColor;

		//EBhETCY
		FWindowTop: Integer;
		FWindowLeft: Integer;
		FWindowHeight: Integer;
		FWindowWidth: Integer;
		FWindowMax: Boolean;
		//Xgr[X^C
		FListStyle: TViewStyle;

		//c[o[\
		FStdToolBarVisible: Boolean;
		FAddressBarVisible: Boolean;
		FLinkBarVisible: Boolean;
		FListToolBarVisible: Boolean;
		FListNameBarVisible: Boolean;
		FBrowserToolBarVisible: Boolean;
		FBrowserNameBarVisible: Boolean;

		//uEU^u
		FBrowserTabVisible: Boolean;
		FBrowserTabPosition: TGikoTabPosition;
		FBrowserTabAppend: TGikoTabAppend;
		FBrowserTabStyle: TGikoTabStyle;

		//bZ[Wo[
		FMessageBarVisible: Boolean;
		FMessegeBarHeight: Integer;

		//Xe[^Xo[
		FStatusBarVisible: Boolean;

		//LrlbgETCY
		FCabinetVisible: Boolean;
		FCabinetWidth: Integer;

		//XgEuEUTCY
		FListOrientation: TGikoListOrientation;
		FListHeight: Integer;
		FListHeightState: TGikoListState;
		FListWidth: Integer;
		FListWidthState: TGikoListState;
//		FListHeightMax: Boolean;
//		FListWidthMax: Boolean;

		//MpOE[
		FNameList: TStringList;
		FMailList: TStringList;

		//GfB^[EBhETCY
		FEditWindowTop: Integer;
		FEditWindowLeft: Integer;
		FEditWindowHeight: Integer;
		FEditWindowWidth: Integer;
		FEditWindowMax: Boolean;
                FEditWindowStay: Boolean;
                FEditWindowTranslucent: Boolean;

		//Xgԍ\
		FListViewNo: Boolean;
		//CSS\
		FUseCSS: Boolean;
		// XL\(ꎞIȂ̂ ini ɕۑ͂Ȃ)
		FUseSkin: Boolean;
		//`pSkin𗘗p邩
		FUseKatjushaType : Boolean;
		//mail\
		FShowMail: Boolean;
		/// X\͈
		FResRange			: Longint;
		/// NX\͈͂̌Œ
		FResRangeHold	: Boolean;
		/// Xbhꗗ\͈
		FThreadRange	: TGikoThreadRange;
		//ANeBuX|bvAbv\
		FUnActivePopup: Boolean;
		//X|bvAbvwb_[{[h
		FResPopupHeaderBold: Boolean;

		//OtH_
		FLogFolder: string;
        FLogFolderP: string; //pXpX؂LŏIĂB
		FNewLogFolder: string;

		//XgJwb_[TCY
		FBBSColumnWidth: array[0..0] of Integer;
		FCategoryColumnWidth: array[0..2] of Integer;
		FBoardColumnWidth: array[0..10] of Integer;

		/// JeSXgJ
		FBBSColumnOrder : TGikoBBSColumnList;
		/// XgJ
		FCategoryColumnOrder : TGikoCategoryColumnList;
		/// XXgJ
		FBoardColumnOrder : TGikoBoardColumnList;

		//\[g
		FBBSSortIndex: Integer;
		FBBSSortOrder: Boolean;
		FCategorySortIndex: Integer;
		FCategorySortOrder: Boolean;
		FBoardSortIndex: Integer;
		FBoardSortOrder: Boolean;

		//DatX\[g
		FDatOchiSortIndex: Integer;
		FDatOchiSortOrder: Boolean;

		//iݕ
		FSelectTextList: TStringList;

		//ꗗURL
		//FBoardURL2ch: string;
		FBoardURLs: TStringList;
		FBoardURLSelected: Integer;

		//[UIDEpX[h
		FUserID: string;
		FPassword: string;
		FAutoLogin: Boolean;
                FForcedLogin: Boolean;
		FDolibURL: string;

		//URLNbNNAv
		FURLApp: Boolean;
		FURLAppFile: string;

		//mailtoNbN
		FOpenMailer: Boolean;

		//폜mF
		FDeleteMsg: Boolean;

		//CoolBariCEEuEUj
		FMainCoolBar: array[0..MAIN_COOLBAND_COUNT - 1] of TCoolSet;
		FListCoolBar: array[0..LIST_COOLBAND_COUNT - 1] of TCoolSet;
		FBrowserCoolBar: array[0..BROWSER_COOLBAND_COUNT - 1] of TCoolSet;

		//ToolBar Wrapable
		FListToolBarWrapable: Boolean;
		FBrowserToolBarWrapable: Boolean;

		//|bvAbvʒu
		FPopupPosition: TGikoPopupPosition;

		//AhXo[
		FURLDisplay: Boolean;
		FAddressBarTabStop: Boolean;
		FLinkAddAddressBar: Boolean;
		FAddressHistoryCount: Integer;

		//摜vr[
		FPreviewVisible: Boolean;
		FPreviewSize: TGikoPreviewSize;
		FPreviewWait: Integer;

		// uEU
		FBrowserAutoMaximize: TGikoBrowserAutoMaximize;

		//XbhꗗXVACR\
		FListIconVisible: Boolean;

                //XbhꗗLoĝXbĥ݃X쐬\邩
                FCreationTimeLogs: Boolean;
                //Xbhꗗ̃XŖ̃X̐\Ȃ
		FFutureThread: Boolean;

		//ݎ}VԎgpݒ
		FUseMachineTime: Boolean;
		FTimeAdjustSec: Integer;
		FTimeAdjust: Boolean;

		//ځ`
		FAbonDeleterlo : Boolean; //&rlo;邩
		FAbonReplaceul : Boolean; //<ul>^O<br>^Oɒu邩
		FPopUpAbon		 : Boolean; //X|bvAbv̂ځ`L
		FShowNGLinesNum : Boolean; //Ymf[ht@C̍s\
		FAddResAnchor : Boolean; //NGXւ̃XAJ[ǉ
		FDeleteSyria : Boolean;	//VAuN΍
		FIgnoreKana	: Boolean;	//SpЂJïႢ𖳎邩

		// XbhitB[h̕
		FSelectComboBoxWidth : Integer;

		// ŌɑIꂽIvV_CAÕ^u
		FOptionDialogTabIndex: Integer;

		// ŌɑIꂽLrlbg
		FCabinetIndex: Integer;

		//IɊmF_CAO\邩
		FShowDialogForEnd : Boolean;
		//SẴ^u̂ƂɊmF_CAO\
		FShowDialogForAllTabClose: Boolean;
		//擾XƃXbh̃XقȂƂɒʏwiFƈF̔wiFgp邩
		FUseOddColorOddResNum: Boolean;
		FOddColor: TColor;
		//XɁAIACeɃtH[JXƂɑɂ邩
		FUnFocusedBold : Boolean;

		//Samba24΍@\g
		FUseSamba: Boolean;

		//XAJ[NbNăWv邩
		FResAnchorJamp: Boolean;

                //Tabۑ
                FTabAutoLoadSave : Boolean;
                //ŌɊJĂXbhURL
                FLastCloseTabURL: String;
                //ɂēT|[g@\
                F2chSupport : Boolean;

		// GfB^
		FSpaceToNBSP	: Boolean;	///< pXy[XATab  &nbsp; ɒu
		FAmpToCharRef	: Boolean;	///< '&'  &amp; ɒu

		//uEU^u\̎̃Xꗗł̃J[\L[ړ̖
		FSelectInterval	: Integer;

		//KuroutSettingTab ڍאݒ^uActiveTab
		FKuroutSettingTabIndex: Integer;

		//! }EXWFX`[
		FGestures	: TGestureModel;
		//! }EXWFX`[gp邩ǂ
		FGestureEnabled : Boolean;
        //! }EXWFX`[ReLXg̏Ŗ
        FGestureIgnoreContext : Boolean;
		//tVAigbvݒ
		FLocalTrapAtt : Boolean;
		FRemoteTrapAtt : Boolean;
		FReadTimeOut: Integer;

		//! gpXptB^[
		FSpamFilterAlgorithm : TGikoSpamFilterAlgorithm;
		//~[gĂ邩
		FMute: Boolean;
		//Xi݂Ŗm蕶Lɂ邩
		FUseUndecided: Boolean;

				//Be2ch
                //Fؗp[UIDEpX[h
		FBeUserID: String;
		FBeCode: String;
		FBeAutoLogin: Boolean;
		FBeLogin: Boolean;
		//̍őۑ
		FMaxRecordCount : Integer;

		//Xbhꗗ_E[hɃ\[g邩
		FAutoSortThreadList : Boolean;

		//InputAssisttH[̈ʒu
		FInputAssistFormLeft :Integer;
		FInputAssistFormTop :Integer;
		//InputAssisttH[̃TCY
		FInputAssistFormWidth: Integer;
		FInputAssistFormHeight: Integer;

		//! CookieɕtŒR[h
		FFixedCookie: String;
        //! Nړ̕ێ
        FMoveHistorySize : Integer;
        //! ŏƂɃ^XNgCɊi[邩
        FStoredTaskTray : Boolean;
        //! ^üړŃ[v
        FLoopBrowserTabs : Boolean;
        //! 100X\̐擪\X
        FHeadResCount : Integer;
        //! ֘AL[[hǉtO
        FAddKeywordLink: Boolean;
        //! datuLɂ
        FReplaceDat: Boolean;
        //! sent.init@C̃TCYiPMBj
        FSentIniFileSize: Integer;
        //! NURL擾̑Ώۊgq
        FExtList: String;
        //! Skin֘A
        FSkinFiles: TSkinFiles;
        //! indext@Cǂݎdat
        FCheckDatFile: Boolean;
        //! IDXAJ[\
        FLimitResCountMessage: Boolean;
        //! X|bvAbv\ʒudeltaX
        FRespopupDeltaX: Integer;
        //! X|bvAbv\ʒudeltaY
        FRespopupDeltaY: Integer;
        //! X|bvAbv^C}[
        FRespopupWait: Integer;
        //! [X|bvAbv
        FRespopupMailTo: Boolean;
		function GetMainCoolSet(Index: Integer): TCoolSet;
		function GetBoardCoolSet(Index: Integer): TCoolSet;
		function GetBrowserCoolSet(Index: Integer): TCoolSet;
		procedure SetMainCoolSet(Index: Integer; CoolSet: TCoolSet);
		procedure SetBoardCoolSet(Index: Integer; CoolSet: TCoolSet);
		procedure SetBrowserCoolSet(Index: Integer; CoolSet: TCoolSet);

		function GetBBSColumnWidth(index: Integer): Integer;
		function GetCategoryColumnWidth(index: Integer): Integer;
		function GetBoardColumnWidth(index: Integer): Integer;
		procedure SetBBSColumnWidth(index: Integer; value: Integer);
		procedure SetCategoryColumnWidth(index: Integer; value: Integer);
		procedure SetBoardColumnWidth(index: Integer; value: Integer);

		function GetSoundName(Index: Integer): string;
		function GetSoundViewName(Index: Integer): string;
		function GetSoundFileName(Index: Integer): string;
		procedure SetSoundFileName(Index: Integer; value: string);
		function Encrypt(s: string): string;
		function Decrypt(s: string): string;

		procedure MakeURLIniFile();

		procedure SetUseCSS( value: Boolean );
		procedure SetCSSFileName( fileName: string );
        function GetCSSFileName: string;
        //! vLVݒǂݍ
        procedure ReadProxySettings(memIni: TMemIniFile);
        //! eEBhEݒǂݍ
        procedure ReadWindowSettings(memIni: TMemIniFile);
        //! ͗ǂݍ݁i{[{Oj
        procedure ReadInputHisotrys(memIni: TMemIniFile);
        //! XgJǂݍ
        procedure ReadListColumnWidth(memIni: TMemIniFile);
        //! JeSXgJǂݍ
        procedure ReadOrdColumn(memIni: TMemIniFile);
	protected

	public
		constructor Create;
		destructor Destroy; override;
		function GetFileName: string;
		function GetBoardURLFileName: string;
		procedure ReadSettingFile;
		procedure ReadBoardURLsFile;
		procedure WriteSystemSettingFile;
		procedure WriteWindowSettingFile;
		procedure WriteNameMailSettingFile;
		procedure WriteFolderSettingFile();
		procedure WriteBoardURLSettingFile;
		function GetSoundCount: Integer;
		function FindSoundFileName(Name: string): string;

		function GetBoardFileName: string;
		function GetCustomBoardFileName: string;
		function GetBoardDir: string;
		function GetHtmlTempFileName: string;
		function GetAppDir: string;
		function GetTempFolder: string;
		function GetSentFileName: string;
		function GetConfigDir: string;
		function GetSkinDir: string;
		function GetStyleSheetDir: string;
		function GetOutBoxFileName: string;
		function GetNGWordsDir: string;
		function GetBoardPlugInDir: string;
		function GetSambaFileName: string;
		function GetIgnoreFileName: string;
		function GetGestureFileName : string;
		function GetSpamFilterFileName : string;
		function GetLanguageFileName: string;
		function GetMainKeyFileName: String;
		function GetEditorKeyFileName: String;
		procedure WriteLogFolder(AVal : String);
		function GetInputAssistFileName : String;
        function GetReplaceFileName: String;
        {
        \brief  N̕ێTCYsetter
        \param  AVal    ݒ肷TCY( >0) 
        }
        procedure SetMoveHistorySize(AVal : Integer);
		//Mobt@TCY
		property RecvBufferSize: Integer read FRecvBufferSize write FRecvBufferSize;
		//HTTP1.1gp
		property Protocol: Boolean read FProtocol write FProtocol;
		//vLVڑHTTP1.1gp
		property ProxyProtocol: Boolean read FProxyProtocol write FProxyProtocol;

		property ReadProxy: Boolean read FReadProxy write FReadProxy;
		property ReadProxyAddress: string read FReadProxyAddress write FReadProxyAddress;
		property ReadProxyPort: Integer read FReadProxyPort write FReadProxyPort;
		property ReadProxyUserID: string read FReadProxyUserID write FReadProxyUserID;
		property ReadProxyPassword: string read FReadProxyPassword write FReadProxyPassword;

		property WriteProxy: Boolean read FWriteProxy write FWriteProxy;
		property WriteProxyAddress: string read FWriteProxyAddress write FWriteProxyAddress;
		property WriteProxyPort: Integer read FWriteProxyPort write FWriteProxyPort;
		property WriteProxyUserID: string read FWriteProxyUserID write FWriteProxyUserID;
		property WriteProxyPassword: string read FWriteProxyPassword write FWriteProxyPassword;

		property CabinetFontName: string read FCabinetFontName write FCabinetFontName;
		property CabinetFontSize: Integer read FCabinetFontSize write FCabinetFontSize;
		property CabinetFontBold: Boolean read FCabinetFontBold write FCabinetFontBold;
		property CabinetFontItalic: Boolean read FCabinetFontItalic write FCabinetFontItalic;
		property CabinetFontColor: TColor read FCabinetFontColor write FCabinetFontColor;
		property CabinetBackColor: TColor read FCabinetBackColor write FCabinetBackColor;

		property ListFontName: string read FListFontName write FListFontName;
		property ListFontSize: Integer read FListFontSize write FListFontSize;
		property ListFontBold: Boolean read FListFontBold write FListFontBold;
		property ListFontItalic: Boolean read FListFontItalic write FListFontItalic;
		property ListFontColor: TColor read FListFontColor write FListFontColor;
		property ListBackColor: TColor read FListBackColor write FListBackColor;

		property BrowserFontName: string read FBrowserFontName write FBrowserFontName;
		property BrowserFontSize: Integer read FBrowserFontSize write FBrowserFontSize;
		property BrowserFontBold: Integer read FBrowserFontBold write FBrowserFontBold;
		property BrowserFontItalic: Integer read FBrowserFontItalic write FBrowserFontItalic;
		property BrowserFontColor: Integer read FBrowserFontColor write FBrowserFontColor;
		property BrowserBackColor: Integer read FBrowserBackColor write FBrowserBackColor;

		property EditorFontName: string read FEditorFontName write FEditorFontName;
		property EditorFontSize: Integer read FEditorFontSize write FEditorFontSize;
		property EditorFontBold: Boolean read FEditorFontBold write FEditorFontBold;
		property EditorFontItalic: Boolean read FEditorFontItalic write FEditorFontItalic;
		property EditorFontColor: TColor read FEditorFontColor write FEditorFontColor;
		property EditorBackColor: TColor read FEditorBackColor write FEditorBackColor;

		property BrowserTabFontName: string read FBrowserTabFontName write FBrowserTabFontName;
		property BrowserTabFontSize: Integer read FBrowserTabFontSize write FBrowserTabFontSize;
		property BrowserTabFontBold: Boolean read FBrowserTabFontBold write FBrowserTabFontBold;
		property BrowserTabFontItalic: Boolean read FBrowserTabFontItalic write FBrowserTabFontItalic;

		property HintFontName: string read FHintFontName write FHintFontName;
		property HintFontSize: Integer read FHintFontSize write FHintFontSize;
		//property HintFontBold: Boolean read FHintFontBold write FHintFontBold;
		//property HintFontItalic: Boolean read FHintFontItalic write FHintFontItalic;
		property HintFontColor: TColor read FHintFontColor write FHintFontColor;
		property HintBackColor: TColor read FHintBackColor write FHintBackColor;

		property WindowTop: Integer read FWindowTop write FWindowTop;
		property WindowLeft: Integer read FWindowLeft write FWindowLeft;
		property WindowHeight: Integer read FWindowHeight write FWindowHeight;
		property WindowWidth: Integer read FWindowWidth write FWindowWidth;
		property WindowMax: Boolean read FWindowMax write FWindowMax;
		property ListStyle: TViewStyle read FListStyle write FListStyle;

		property StdToolBarVisible: Boolean read FStdToolBarVisible write FStdToolBarVisible;
		property AddressBarVisible: Boolean read FAddressBarVisible write FAddressBarVisible;
		property LinkBarVisible: Boolean read FLinkBarVisible write FLinkBarVisible;
		property ListToolBarVisible: Boolean read FListToolBarVisible write FListToolBarVisible;
		property ListNameBarVisible: Boolean read FListNameBarVisible write FListNameBarVisible;
		property BrowserToolBarVisible: Boolean read FBrowserToolBarVisible write FBrowserToolBarVisible;
		property BrowserNameBarVisible: Boolean read FBrowserNameBarVisible write FBrowserNameBarVisible;

		property BrowserTabVisible: Boolean read FBrowserTabVisible write FBrowserTabVisible;
		property BrowserTabPosition: TGikoTabPosition read FBrowserTabPosition write FBrowserTabPosition;
		property BrowserTabAppend: TGikoTabAppend read FBrowserTabAppend write FBrowserTabAppend;
		property BrowserTabStyle: TGikoTabStyle read FBrowserTabStyle write FBrowserTabStyle;

		property MessageBarVisible: Boolean read FMessageBarVisible write FMessageBarVisible;
		property MessegeBarHeight: Integer read FMessegeBarHeight write FMessegeBarHeight;

		property StatusBarVisible: Boolean read FStatusBarVisible write FStatusBarVisible;

		property CabinetVisible: Boolean read FCabinetVisible write FCabinetVisible;
		property CabinetWidth: Integer read FCabinetWidth write FCabinetWidth;

		property ListOrientation: TGikoListOrientation read FListOrientation write FListOrientation;
		property ListHeight: Integer read FListHeight write FListHeight;
		property ListHeightState: TGikoListState read FListHeightState write FListHeightState;
		property ListWidth: Integer read FListWidth write FListWidth;
		property ListWidthState: TGikoListState read FListWidthState write FListWidthState;
//		property ListHeightMax: Boolean read FListHeightMax write FListHeightMax;
//		property ListWidthMax: Boolean read FListWidthMax write FListWidthMax;

		property NameList: TStringList read FNameList write FNameList;
		property MailList: TStringList read FMailList write FMailList;
		property SelectTextList: TStringList read FSelectTextList write FSelectTextList;

		property EditWindowTop: Integer read FEditWindowTop write FEditWindowTop;
		property EditWindowLeft: Integer read FEditWindowLeft write FEditWindowLeft;
		property EditWindowHeight: Integer read FEditWindowHeight write FEditWindowHeight;
		property EditWindowWidth: Integer read FEditWindowWidth write FEditWindowWidth;
		property EditWindowMax: Boolean read FEditWindowMax write FEditWindowMax;
		property EditWindowStay: Boolean read FEditWindowStay write FEditWindowStay;
		property EditWindowTranslucent: Boolean read FEditWindowTranslucent write FEditWindowTranslucent;

		property ListViewNo: Boolean read FListViewNo write FListViewNo;
		property UseCSS: Boolean read FUseCSS write SetUseCSS;
		property CSSFileName: string read GetCSSFileName write SetCSSFileName;
		property UseKatjushaType : Boolean read FUseKatjushaType write FUseKatjushaType;
		property UseSkin: Boolean read FUseSkin;

		property ShowMail: Boolean read FShowMail write FShowMail;
		property ResRange : Longint read FResRange write FResRange;
		property ResRangeHold : Boolean read FResRangeHold write FResRangeHold;
		property ThreadRange	: TGikoThreadRange read FThreadRange write FThreadRange;
		property UnActivePopup: Boolean read FUnActivePopup write FUnActivePopup;
		property ResPopupHeaderBold: Boolean read FResPopupHeaderBold write FResPopupHeaderBold;

		property LogFolder: string read FLogFolder write WriteLogFolder;
        property LogFolderP: string read FLogFolderP;
		property NewLogFolder: string read FNewLogFolder write FNewLogFolder;

		property BBSColumnWidth[index: Integer]: Integer read GetBBSColumnWidth write SetBBSColumnWidth;
		property CategoryColumnWidth[index: Integer]: Integer read GetCategoryColumnWidth write SetCategoryColumnWidth;
		property BoardColumnWidth[index: Integer]: Integer read GetBoardColumnWidth write SetBoardColumnWidth;

		property BBSColumnOrder : TGikoBBSColumnList read FBBSColumnOrder write FBBSColumnOrder;
		property CategoryColumnOrder : TGikoCategoryColumnList read FCategoryColumnOrder write FCategoryColumnOrder;
		property BoardColumnOrder : TGikoBoardColumnList read FBoardColumnOrder write FBoardColumnOrder;

		property SoundName[index: Integer]: string read GetSoundName;
		property SoundViewName[index: Integer]: string read GetSoundViewName;
		property SoundFileName[index: Integer]: string read GetSoundFileName write SetSoundFileName;

		property BBSSortIndex: Integer read FBBSSortIndex write FBBSSortIndex;
		property BBSSortOrder: Boolean read FBBSSortOrder write FBBSSortOrder;
		property CategorySortIndex: Integer read FCategorySortIndex write FCategorySortIndex;
		property CategorySortOrder: Boolean read FCategorySortOrder write FCategorySortOrder;
		property BoardSortIndex: Integer read FBoardSortIndex write FBoardSortIndex;
		property BoardSortOrder: Boolean read FBoardSortOrder write FBoardSortOrder;

		property DatOchiSortIndex: Integer read FDatOchiSortIndex write FDatOchiSortIndex;
		property DatOchiSortOrder: Boolean read FDatOchiSortOrder write FDatOchiSortOrder;

		//property BoardURL2ch: string read FBoardURL2ch write FBoardURL2ch;
		property BoardURLs: TStringList read FBoardURLs write FBoardURLs;
		property BoardURLSelected: Integer read FBoardURLSelected write FBoardURLSelected;
		property UserID: string read FUserID write FUserID;
		property Password: string read FPassword write FPassword;
		property AutoLogin: Boolean read FAutoLogin write FAutoLogin;
		property ForcedLogin: Boolean read FForcedLogin write FForcedLogin;
		property DolibURL: string read FDolibURL write FDolibURL;

		property URLApp: Boolean read FURLApp write FURLApp;
		property URLAppFile: string read FURLAppFile write FURLAppFile;

		property OpenMailer: Boolean read FOpenMailer write FOpenMailer;

		property DeleteMsg: Boolean read FDeleteMsg write FDeleteMsg;

		property MainCoolSet[Index: Integer]: TCoolSet read GetMainCoolSet write SetMainCoolSet;
		property ListCoolSet[Index: Integer]: TCoolSet read GetBoardCoolSet write SetBoardCoolSet;
		property BrowserCoolSet[Index: Integer]: TCoolSet read GetBrowserCoolSet write SetBrowserCoolSet;

		property ListToolBarWrapable: Boolean read FListToolBarWrapable write FListToolBarWrapable;
		property BrowserToolBarWrapable: Boolean read FBrowserToolBarWrapable write FBrowserToolBarWrapable;

		property PopupPosition: TGikoPopupPosition read FPopupPosition write FPopupPosition;

		property URLDisplay: Boolean read FURLDisplay write FURLDisplay;
		property AddressBarTabStop: Boolean read FAddressBarTabStop write FAddressBarTabStop;
		property LinkAddAddressBar: Boolean read FLinkAddAddressBar write FLinkAddAddressBar;
		property AddressHistoryCount: Integer read FAddressHistoryCount write FAddressHistoryCount;

		property PreviewVisible: Boolean read FPreviewVisible write FPreviewVisible;
		property PreviewSize: TGikoPreviewSize read FPreviewSize write FPreviewSize;
		property PreviewWait: Integer read FPreviewWait write FPreviewWait;
		property BrowserAutoMaximize: TGikoBrowserAutoMaximize read FBrowserAutoMaximize write FBrowserAutoMaximize;

		property ListIconVisible: Boolean read FListIconVisible write FListIconVisible;
		property CreationTimeLogs: Boolean read FCreationTimeLogs write FCreationTimeLogs;
		property FutureThread: Boolean read FFutureThread write FFutureThread;

		property UseMachineTime: Boolean read FUseMachineTime write FUseMachineTime;
		property TimeAdjustSec: Integer read FTimeAdjustSec write FTimeAdjustSec;
		property TimeAdjust: Boolean read FTimeAdjust write FTimeAdjust;

		//ځ`
		property AbonDeleterlo : Boolean read FAbonDeleterlo write FAbonDeleterlo;
		property AbonReplaceul : Boolean read FAbonReplaceul write FAbonReplaceul;
		property PopUpAbon		 : Boolean read FPopUpAbon write FPopUpAbon;
		property ShowNGLinesNum : Boolean read FShowNGLinesNum write FShowNGLinesNum;
		property AddResAnchor : Boolean read FAddResAnchor write FAddResAnchor;
		property DeleteSyria : Boolean read FDeleteSyria write FDeleteSyria;
		property IgnoreKana : Boolean read FIgnoreKana write FIgnoreKana;
		// XbhitB[h̕
		property SelectComboBoxWidth : Integer read FSelectComboBoxWidth write FSelectComboBoxWidth;

		// ŌɑIꂽIvV_CAÕ^u
		property OptionDialogTabIndex : Integer read FOptionDialogTabIndex write FOptionDialogTabIndex;

		// ŌɑIꂽLrlbg
		property CabinetIndex : Integer read FCabinetIndex write FCabinetIndex;

		//IɊmF_CAO\邩
		property ShowDialogForEnd : Boolean read FShowDialogForEnd write FShowDialogForEnd;
		property ShowDialogForAllTabClose: Boolean read FShowDialogForAllTabClose write FShowDialogForAllTabClose;
		//擾XƃXbh̃XقȂƂɒʏwiFƈF̔wiFgp邩
		property UseOddColorOddResNum: Boolean read FUseOddColorOddResNum write FUseOddColorOddResNum;
		property OddColor: TColor read FOddColor write FOddColor;
		property UnFocusedBold : Boolean read FUnFocusedBold write FUnFocusedBold;
		property UseSamba: Boolean read FUseSamba write FUseSamba;
				property ResAnchorJamp: Boolean read FResAnchorJamp write FResAnchorJamp;

		// GfB^
		property SpaceToNBSP	: Boolean	read FSpaceToNBSP		write FSpaceToNBSP;
		property AmpToCharRef	: Boolean	read FAmpToCharRef	write FAmpToCharRef;

		property SelectInterval	: Integer	read FSelectInterval	write FSelectInterval;
		//Tabۑ
		property TabAutoLoadSave: Boolean           read FTabAutoLoadSave      write FTabAutoLoadSave;
        //^u̕Ƃp
        property LastCloseTabURL: String read FLastCloseTabURL write FLastCloseTabURL;
				//property Gengo: TStringList read F2chLanguage write F2chLanguage;
				property GengoSupport : Boolean read F2chSupport write F2chSupport;
		property KuroutSettingTabIndex: Integer read FKuroutSettingTabIndex write FKuroutSettingTabIndex;
		//! }EXWFX`[
		property Gestures : TGestureModel read FGestures write FGestures;
		//! }EXWFX`[gp邩ǂ
		property GestureEnabled : Boolean read FGestureEnabled write FGestureEnabled;
        property GestureIgnoreContext : Boolean read FGestureIgnoreContext write FGestureIgnoreContext;
		//tVAigbvݒ
		property LocalTrapAtt : Boolean read FLocalTrapAtt write FLocalTrapAtt;
		property RemoteTrapAtt : Boolean read FRemoteTrapAtt write FRemoteTrapAtt;
		property ReadTimeOut: Integer read FReadTimeOut write FReadTimeOut;
		//! gpXptB^
		property SpamFilterAlgorithm : TGikoSpamFilterAlgorithm
			read FSpamFilterAlgorithm write FSpamFilterAlgorithm;
		property Mute: Boolean read FMute write FMute;
		property UseUndecided: Boolean read FUseUndecided write FUseUndecided;

		property BeUserID: string read FBeUserID write FBeUserID;
		property BeCode: string read FBeCode write FBeCode;
		property BeAutoLogin: Boolean read FBeAutoLogin write FBeAutoLogin;
		property BeLogin: Boolean read FBeLogin write FBeLogin;
		property MaxRecordCount : Integer read FMaxRecordCount write FMaxRecordCount;
		//! Xbhꗗ_E[hɃXbhŏ\[g邩
		property AutoSortThreadList : Boolean read FAutoSortThreadList write FAutoSortThreadList;
		//! InputAssisttH[̈ʒu
		property InputAssistFormLeft :Integer read FInputAssistFormLeft write FInputAssistFormLeft;
		property InputAssistFormTop :Integer read FInputAssistFormTop write FInputAssistFormTop;
		//! InputAssisttH[̃TCY
		property InputAssistFormWidth: Integer read FInputAssistFormWidth write FInputAssistFormWidth;
		property InputAssistFormHeight: Integer read FInputAssistFormHeight write FInputAssistFormHeight;
		//! CookieɕtŒR[h
		property FixedCookie: String read FFixedCookie write FFixedCookie;
        //! Nړ̕ێ
        property MoveHistorySize : Integer read FMoveHistorySize write SetMoveHistorySize;
        //! ŏɃ^XNgCɊi[邩
        property StoredTaskTray : Boolean read FStoredTaskTray write FStoredTaskTray;
        //! uEU^ũ[v
        property LoopBrowserTabs : Boolean read FLoopBrowserTabs write FLoopBrowserTabs;
        //! 100X\̐擪\X
        property HeadResCount : Integer read FHeadResCount write FHeadResCount;
        //! ֘AL[[hǉtO
        property AddKeywordLink: Boolean read FAddKeywordLink write FAddKeywordLink;
        //! dat̒uLɂ邩
        property ReplaceDat: Boolean read FReplaceDat write FReplaceDat;
        //! sent.init@C̃TCYiPMBj
        property SentIniFileSize: Integer read FSentIniFileSize write FSentIniFileSize;
        //! NURL擾̑Ώۊgq
        property ExtList: String read FExtList write FExtList;
        //! Skint@CǗ
        property SkinFiles: TSkinFiles read FSkinFiles;
        //! CfbNXǂݍݎdatt@C`FbN
        property CheckDatFile: Boolean read FCheckDatFile write FCheckDatFile;
        property LimitResCountMessage: Boolean read FLimitResCountMessage write FLimitResCountMessage;
        //! X|bvAbv\ʒudeltaX
        property  RespopupDeltaX: Integer read FRespopupDeltaX write FRespopupDeltaX;
        //! X|bvAbv\ʒudeltaY
        property RespopupDeltaY: Integer read FRespopupDeltaY write FRespopupDeltaY;
        //! X|bvAbv^C}[
        property RespopupWait: Integer read FRespopupWait write FRespopupWait;
        property RespopupMailTo: Boolean read FRespopupMailTo write FRespopupMailTo;
end;


const
//	MAIN_COOLBAND_COUNT = 4;		//CCoolBand̐
//	LIST_COOLBAND_COUNT = 2;		//CoolBand̐
//	BROWSER_COOLBAND_COUNT = 3;	//uEUCoolBand̐

	BOARD_FILE_NAME							 	= 'board.2ch';
	CUSTOMBOARD_FILE_NAME				 	= 'custom.2ch';
	BOARD_DIR_NAME								= 'Board';
	KEY_SETTING_FILE_NAME				 	= 'key.ini';
	EKEY_SETTING_FILE_NAME			 	= 'Ekey.ini';
	TEMP_FOLDER									 	= 'Temp';
	OUTBOX_FILE_NAME							= 'outbox.ini';
	SENT_FILE_NAME								= 'sent.ini';
	CONFIG_DIR_NAME							 	= 'config';
	CSS_DIR_NAME									= 'css';
	SKIN_DIR_NAME							 		= 'skin';
	NGWORDs_DIR_NAME : String 		= 'NGwords';
	BOARD_PLUGIN_DIR_NAME					= 'BoardPlugin';
	SAMBATIME_FILE_NAME : String	= 'Samba.ini';
	IGNORE_FILE_NAME : String		= 'Ignore.txt';
//	DOLIB_LOGIN_URL     = '/~tora3n2c/futen.cgi';
	MAX_POPUP_RES : Integer = 10;
	GESTURE_FILE_NAME							= 'Gestures.ini';
	SPAMFILTER_FILE_NAME					= 'SpamFilter.ini';
		LANGUAGE_FILE_NAME    = 'language.ini';
	INPUTASSIST_FILE_NAME	= 'InputAssist.ini';
    FIXED_COOKIE =           'hana=mogera';
    REPLACE_FILE_NAME = 'replace.ini';

implementation

uses
	Math, UCryptAuto, UBase64, Windows,GikoUtil;

type
	TSoundName = record
		Name: string;
		ViewName: string;
		FileName: string;
	end;

const
	INI_FILE_NAME: string				 = 'gikoNavi.ini';
	BOARD_URL_INI_FILE_NAME: string = 'url.ini';
	DEFAULT_FONT_NAME: string		 = 'lr oSVbN';
	DEFAULT_FONT_SIZE: Integer		= 9;
	DEFAULT_FONT_COLOR: string		= 'clWindowText';
	DEFAULT_WINDOW_COLOR: string	= 'clWindow';
	DEFAULT_TAB_FONT_NAME: string		 = 'lr oSVbN';
	DEFAULT_TAB_FONT_SIZE: Integer		= 9;
	DEFAULT_2CH_BOARD_URL1: string = 'http://menu.2ch.net/bbsmenu.html';
	GIKO_ENCRYPT_TEXT: string		 = 'gikoNaviEncryptText';

var
	SOUND_NAME: array[0..4] of TSoundName = (
		(Name: 'New';				ViewName: '擾';					 FileName: ''),
		(Name: 'NewDiff';		ViewName: '擾()';		 FileName: ''),
		(Name: 'NoChange';	 ViewName: 'XV';						 FileName: ''),
//		(Name: 'RoundEnd';	 ViewName: 'I(擾)'; FileName: ''),
//		(Name: 'RoundNone';	ViewName: 'I(擾Ȃ)'; FileName: ''),
		(Name: 'ResEnd';		 ViewName: 'XM';			 FileName: ''),
		(Name: 'Error';			ViewName: 'G[';						 FileName: ''));

constructor TGikoBBSColumnList.Create;
begin
	inherited;
end;

destructor TGikoBBSColumnList.Destroy;
begin
	inherited;
end;

function TGikoBBSColumnList.GetItem( index : integer ) : TGikoBBSColumnID;
begin
	Result := TGikoBBSColumnID( inherited Items[ index ] );
end;

procedure TGikoBBSColumnList.SetItem( index : integer; value : TGikoBBSColumnID);
begin
	inherited Items[ index ] := Pointer( value );
end;

function TGikoBBSColumnList.Add( value : TGikoBBSColumnID ) : Integer;
begin
	Result := inherited Add( Pointer( value ) );
end;

constructor TGikoCategoryColumnList.Create;
begin
	inherited;
end;

destructor TGikoCategoryColumnList.Destroy;
begin
	inherited;
end;

function TGikoCategoryColumnList.GetItem( index : integer ) : TGikoCategoryColumnID;
begin
	Result := TGikoCategoryColumnID( inherited Items[ index ] );
end;

procedure TGikoCategoryColumnList.SetItem( index : integer; value : TGikoCategoryColumnID);
begin
	inherited Items[ index ] := Pointer( value );
end;

function TGikoCategoryColumnList.Add( value : TGikoCategoryColumnID ) : Integer;
begin
	Result := inherited Add( Pointer( value ) );
end;

constructor TGikoBoardColumnList.Create;
begin
	inherited;
end;

destructor TGikoBoardColumnList.Destroy;
begin
	inherited;
end;

function TGikoBoardColumnList.GetItem( index : integer ) : TGikoBoardColumnID;
begin
	Result := TGikoBoardColumnID( inherited Items[ index ] );
end;

procedure TGikoBoardColumnList.SetItem( index : integer; value : TGikoBoardColumnID);
begin
	inherited Items[ index ] := Pointer( value );
end;

function TGikoBoardColumnList.Add( value : TGikoBoardColumnID ) : Integer;
begin
	Result := inherited Add( Pointer( value ) );
end;

//RXgN^
constructor TSetting.Create();
begin
	FNameList := TStringList.Create;
	FMailList := TStringList.Create;
	FSelectTextList := TStringList.Create;
	FBoardURLs := TStringList.Create;
	FBBSColumnOrder := TGikoBBSColumnList.Create;
	FCategoryColumnOrder := TGikoCategoryColumnList.Create;
	FBoardColumnOrder := TGikoBoardColumnList.Create;
	FGestures := TGestureModel.Create;
    FSkinFiles := TSkinFiles.Create;
	FNameList.Duplicates := dupIgnore;
	FMailList.Duplicates := dupIgnore;
	FBoardURLs.Duplicates := dupIgnore;
	FSelectTextList.Duplicates := dupIgnore;
	ReadSettingFile();
	ReadBoardURLsFile();
end;

//fXgN^
destructor TSetting.Destroy();
begin
 	FBoardColumnOrder.Free;
 	FCategoryColumnOrder.Free;
 	FBBSColumnOrder.Free;
 	FSelectTextList.Free;
 	FBoardURLs.Free;
 	FMailList.Free;
 	FNameList.Free;
 	FGestures.Free;
    FSkinFiles.Free;
	inherited;
end;

//t@C擾ipX{t@Cj
function TSetting.GetFileName(): string;
begin
	Result := GetAppDir + INI_FILE_NAME;
end;

//XVpURLݒt@CipX{t@Cj
function TSetting.GetBoardURLFileName(): string;
begin
	Result := GetAppDir + BOARD_URL_INI_FILE_NAME;
end;

//ݒt@CǍ
procedure TSetting.ReadSettingFile();
var
	ini: TMemIniFile;
	i: Integer;
	Exists: Boolean;
	s: string;                                               
	CoolSet: TCoolSet;
    msg: String;
begin
	Exists := FileExists(GetFileName);
	ini := TMemIniFile.Create(GetFileName);
	try
		//Mobt@TCY
		FRecvBufferSize := ini.ReadInteger('HTTP', 'RecvBufferSize', 4096);
		//HTTP1.1gp
		FProtocol := ini.ReadBool('HTTP', 'Protocol', True);
		//vLVڑHTTP1.1gp
		FProxyProtocol := ini.ReadBool('HTTP', 'ProxyProtocol', False);

        // vLVݒǂݍ
        ReadProxySettings( ini );

        // eEBhE̐ݒǂݍ
        ReadWindowSettings( ini );

		FWindowTop := ini.ReadInteger('WindowSize', 'Top', -1);
		FWindowLeft := ini.ReadInteger('WindowSize', 'Left', -1);
		FWindowHeight := ini.ReadInteger('WindowSize', 'Height', -1);
		FWindowWidth := ini.ReadInteger('WindowSize', 'Width', -1);
		FWindowMax := ini.ReadBool('WindowSize', 'Max', false);

		if FWindowHeight <= 0 then	FWindowHeight := 400;
		if FWindowWidth <= 0 then FWindowWidth := 600;

		FListStyle := TViewStyle(ini.ReadInteger('ViewStyle', 'ListView', Ord(vsReport)));

		FEditWindowTop := ini.ReadInteger('EditorWindowSize', 'Top', -1);
		FEditWindowLeft := ini.ReadInteger('EditorWindowSize', 'Left', -1);
		FEditWindowHeight := ini.ReadInteger('EditorWindowSize', 'Height', -1);
		FEditWindowWidth := ini.ReadInteger('EditorWindowSize', 'Width', -1);
		FEditWindowMax := ini.ReadBool('EditorWindowSize', 'Max', False);
		FEditWindowStay := ini.ReadBool('EditorWindowSize', 'Stay', False);
                FEditWindowTranslucent := ini.ReadBool('EditorWindowSize', 'Translucent', False);

		FOptionDialogTabIndex := ini.ReadInteger('OptionDialog', 'TabIndex', 0);

		//c[o[
		FStdToolBarVisible := ini.ReadBool('ToolBar', 'StdVisible', True);
		FAddressBarVisible := ini.ReadBool('ToolBar', 'AddressVisible', True);
		FLinkBarVisible := ini.ReadBool('ToolBar', 'LinkVisible', True);
		FListToolBarVisible := ini.ReadBool('ToolBar', 'ListVisible', True);
		FListNameBarVisible := ini.ReadBool('ToolBar', 'ListNameVisible', True);
		FBrowserToolBarVisible := ini.ReadBool('ToolBar', 'BrowserVisible', True);
		FBrowserNameBarVisible := ini.ReadBool('ToolBar', 'BrowserNameVisible', True);
		//c[o[Wrapable
		FListToolBarWrapable := ini.ReadBool('ToolBar', 'ListWrapable', False);
		FBrowserToolBarWrapable := ini.ReadBool('ToolBar', 'BrowserWrapable', False);

		FBrowserTabVisible := ini.ReadBool('Tab', 'BrowserTabVisible', True);
		FBrowserTabPosition := TGikoTabPosition(ini.ReadInteger('Tab', 'BrowserTabPosition', Ord(gtpTop)));
		FBrowserTabAppend := TGikoTabAppend(ini.ReadInteger('Tab', 'BrowserTabAppend', Ord(gtaFirst)));
		FBrowserTabStyle := TGikoTabStyle(ini.ReadInteger('Tab', 'BrowserTabStyle', Ord(gtsFlat)));

		FMessageBarVisible := ini.ReadBool('MessageBar', 'Visible', True);
		FMessegeBarHeight := ini.ReadInteger('MessageBar', 'Height', 30);

		FStatusBarVisible := ini.ReadBool('StatusBar', 'Visible', True);

		FCabinetVisible := ini.ReadBool('Cabinet', 'Visible', True);
		FCabinetWidth := ini.ReadInteger('Cabinet', 'Width', 200);
		FCabinetIndex := ini.ReadInteger('Cabinet', 'Index', 0);

		FListOrientation := TGikoListOrientation(ini.ReadInteger('List', 'Orientation', Ord(gloHorizontal)));
		FListHeight := ini.ReadInteger('List', 'Height', 180);
		FListHeightState := TGikoListState(ini.ReadInteger('List', 'HeightState', Ord(glsNormal)));
		FListWidth := ini.ReadInteger('List', 'Width', 180);
		FListWidthState := TGikoListState(ini.ReadInteger('List', 'WidthState', Ord(glsNormal)));
//		FListHeightMax := ini.ReadBool('List', 'HeightMax', False);
//		FListWidthMax := ini.ReadBool('List', 'WidthMax', False);

        // ͍ڂ̗ǂݍ
        ReadInputHisotrys( ini );

		// XgJ
        ReadListColumnWidth( ini );

		// JeSXgJ
        ReadOrdColumn( ini );

		//Xgԍ
		FListViewNo := ini.ReadBool('Function', 'ListViewNo', True);
		//CSS
		UseCSS := ini.ReadBool('CSS', 'UseCSS', True);
		//CSSt@C
		CSSFileName := ini.ReadString('CSS', 'FileName', 'default.css');
		//`̃XLg
		FUseKatjushaType := ini.ReadBool('CSS', 'UseKatjushaType', false);

		//Mail\
		FShowMail := ini.ReadBool('Thread', 'ShowMail', True);
		// X\͈
		if ini.ReadBool('Thread', 'OnlyAHundredRes',false) then
			FResRange := 100	// Âݒ̌݊p
		else
			FResRange := ini.ReadInteger( 'Thread', 'ResRange', Ord( grrAll ) );
		FResRangeHold := ini.ReadBool( 'Thread', 'ResRangeHold', False );
        FHeadResCount := ini.ReadInteger('Thread', 'HeadResCount', 1);
		// Xbhꗗ\͈
		FThreadRange := TGikoThreadRange( ini.ReadInteger('ThreadList', 'ThreadRange', Ord( gtrAll )) );
		//ANeBuX|bvAbv\
		FUnActivePopup := ini.ReadBool('Thread', 'UnActivePopup', False);
		//X|bvAbvwb_[{[h
		FResPopupHeaderBold := ini.ReadBool('Thread', 'ResPopupHeaderBold', True);
		//폜mF
		FDeleteMsg := ini.ReadBool('Function', 'LogDeleteMessage', True);
		//ImF
		FShowDialogForEnd := ini.ReadBool('Function','ShowDialogForEnd',false);
		//AllTabClose
		FShowDialogForAllTabClose := ini.ReadBool('Function','ShowDialogForAllTabClose',false);
                //Samba
		FUseSamba := ini.ReadBool('Function','UseSamba', True);
		//ResAnchorjamp
		ResAnchorJamp := ini.ReadBool('Function', 'ResAnchoJamp', True);
		//OtH_
		LogFolder := ini.ReadString('Folder', 'LogFolder', GetAppDir + 'Log');
		NewLogFolder := '';

		//URL
		//o^ł悤ɂFBoardURLsɂ@2003/10/05
		//FBoardURL2ch := ini.ReadString('BoardURL', '2ch', DEFAULT_2CH_BOARD_URL);

		//Fؗp[UIDEpX[h
		FUserID := ini.ReadString('Attestation', 'UserID', '');
		FPassword := Decrypt(ini.ReadString('Attestation', 'Password', ''));
		FAutoLogin := ini.ReadBool('Attestation', 'AutoLogin', False);
		FForcedLogin := ini.ReadBool('Attestation', 'FForcedLogin', False);
//		FDolibURL	:= ini.ReadString('Attestation', 'FDolibURL', DOLIB_LOGIN_URL);

		//URLNbNNAv
		FURLApp := ini.ReadBool('URLApp', 'Select', False);
		FURLAppFile := ini.ReadString('URLApp', 'File', '');

		//mailtoNbN
		FOpenMailer := ini.ReadBool('Mailto', 'Open', True);

		//|bvAbvʒu
		FPopupPosition := TGikoPopupPosition(ini.ReadInteger('Browser', 'PopupPosition', Ord(gppRightTop)));
        // o^56ȑÕAbvf[g΍
        if (FPopupPosition = gppCenter) then begin
            FPopupPosition := gppTop;
        end;
        FRespopupDeltaX := ini.ReadInteger('Browser', 'RespopupDelteX', 5);
        FRespopupDeltaY := ini.ReadInteger('Browser', 'RespopupDelteY', 5);
        FRespopupWait   := ini.ReadInteger('Browser', 'RespopupWait', 1000);
        FRespopupMailTo := ini.ReadBool('Browser', 'RespopupMailTo', true);

		//AhXo[
		FURLDisplay := ini.ReadBool('AddressBar', 'URLDisplay', False);
		FAddressBarTabStop := ini.ReadBool('AddressBar', 'TabStop', True);
		FLinkAddAddressBar := ini.ReadBool('AddressBar', 'LinkAdd', False);
		FAddressHistoryCount := ini.ReadInteger('AddressBar', 'HistoryCount', 100);

		//摜vr[
		FPreviewVisible := ini.ReadBool('Browser', 'PreviewVisible', True);
		FPreviewSize := TGikoPreviewSize(ini.ReadInteger('Browser', 'PreviewSize', Ord(gpsMedium)));
		FPreviewWait := ini.ReadInteger('Browser', 'PreviewWait', 500);

		// uEU
		FBrowserAutoMaximize := TGikoBrowserAutoMaximize(
			ini.ReadInteger('Window', 'BrowserAutoMaximize', Ord(gbmDoubleClick)) );

		//XbhꗗXVACR
		FListIconVisible := ini.ReadBool('ThreadList', 'StateIconVisible', True);
		FCreationTimeLogs := ini.ReadBool('ThreadList', 'CreationTimeLogs', True);
		FFutureThread := ini.ReadBool('ThreadList', 'FutureThread', True);
		FSelectInterval := ini.ReadInteger('ThreadList', 'SelectInterval', 110);
		//\[g
		FBBSSortIndex := ini.ReadInteger('ThreadList', 'BBSSortIndex', 0);
		FBBSSortOrder := ini.ReadBool('ThreadList', 'BBSSortOrder', True);
		FCategorySortIndex := ini.ReadInteger('ThreadList', 'CategorySortIndex', 0);
		FCategorySortOrder := ini.ReadBool('ThreadList', 'CategorySortOrder', True);
		FBoardSortIndex := ini.ReadInteger('ThreadList', 'BoardSortIndex', 0);
		FBoardSortOrder := ini.ReadBool('ThreadList', 'BoardSortOrder', True);
		// DL̎\[g
		FAutoSortThreadList := ini.ReadBool('ThreadList', 'AutoSort', False);
		//DatX\[g
		FDatOchiSortIndex := ini.ReadInteger('ThreadList', 'DatOchiSortIndex', -1);
		FDatOchiSortOrder := ini.ReadBool('ThreadList', 'DatOchiSortOrder', False);

		//ݎ}Vgpݒ
		FUseMachineTime := ini.ReadBool('PostTime', 'UseMachineTime', False);
		FTimeAdjustSec := ini.ReadInteger('PostTime', 'TimeAdjustSec', 0);
		FTimeAdjust := ini.ReadBool('PostTime', 'TimeAdjust', True);

		//TEh
		if Exists then begin
			for i := 0 to GetSoundCount - 1 do begin
				SoundFileName[i] := ini.ReadString('Sound', SoundName[i], '');
				if not FileExists(SoundFileName[i]) then
					SoundFileName[i] := '';
			end;
		end else begin
			s := GetAppDir + '\sound\';
			SoundFileName[0] := s + '擾.wav';
			SoundFileName[1] := s + '擾().wav';
			SoundFileName[2] := s + 'XV.wav';
			SoundFileName[3] := '';
			SoundFileName[4] := s + 'G[.wav';
		end;

		//N[o[
		for i := 0 to MAIN_COOLBAND_COUNT - 1 do begin
			CoolSet.FCoolID := ini.ReadInteger('MainCoolBar', 'ID' + IntToStr(i), -1);
			CoolSet.FCoolWidth := ini.ReadInteger('MainCoolBar', 'Width' + IntToStr(i), -1);
			CoolSet.FCoolBreak := ini.ReadBool('MainCoolBar', 'Break' + IntToStr(i), False);
			MainCoolSet[i] := CoolSet;
		end;
		FSelectComboBoxWidth := ini.ReadInteger( 'ListCoolBar', 'SelectWidth', 127 );
		for i := 0 to LIST_COOLBAND_COUNT - 1 do begin
			CoolSet.FCoolID := ini.ReadInteger('ListCoolBar', 'ID' + IntToStr(i), -1);
			CoolSet.FCoolWidth := ini.ReadInteger('ListCoolBar', 'Width' + IntToStr(i), -1);
			CoolSet.FCoolBreak := ini.ReadBool('ListCoolBar', 'Break' + IntToStr(i), False);
			ListCoolSet[i] := CoolSet;
		end;
		for i := 0 to BROWSER_COOLBAND_COUNT - 1 do begin
			CoolSet.FCoolID := ini.ReadInteger('BrowserCoolBar', 'ID' + IntToStr(i), -1);
			CoolSet.FCoolWidth := ini.ReadInteger('BrowserCoolBar', 'Width' + IntToStr(i), -1);
			CoolSet.FCoolBreak := ini.ReadBool('BrowserCoolBar', 'Break' + IntToStr(i), False);
			BrowserCoolSet[i] := CoolSet;
		end;

		//ځ`
		FAbonDeleterlo := ini.ReadBool('Abon','Deleterlo',false);
		FAbonReplaceul := ini.ReadBool('Abon','Replaceul',false);
		FPopUpAbon		 := ini.ReadBool('Abon','Popup',false);
		FShowNGLinesNum := ini.ReadBool('Abon','ShowNGLines',false);
		FAddResAnchor := ini.ReadBool('Abon','AddResAnchor',false);
		FDeleteSyria :=  ini.ReadBool('Abon','DeleteSyria',false);
		FIgnoreKana  :=  ini.ReadBool('Abon','IgnoreKana',false);

		// GfB^
		FSpaceToNBSP	:= ini.ReadBool( 'Editor', 'SpaceToNBSP', False );
		FAmpToCharRef	:= ini.ReadBool( 'Editor', 'AmpToCharRef', False );

		//TabۑAǂݍ
		FTabAutoLoadSave    := ini.ReadBool('TabAuto', 'TabAutoLoadSave', False);
        FLastCloseTabURL    := ini.ReadString('Thread', 'LastCloseTabURL', '');
		FKuroutSettingTabIndex := ini.ReadInteger('OptionDialog', 'KuroutTabIndex' , 0);

		// }EXWFX`[
		FGestureEnabled := ini.ReadBool( 'Guesture', 'Enabled', False );
        FGestureIgnoreContext := ini.ReadBool( 'Guesture', 'IgnoreContext', False );
		//2chT|
		F2chSupport := ini.ReadBool('2chSupport', 'Support', False);

		//FusianaTrap
		FLocalTrapAtt := ini.ReadBool('Trap', 'LocalTrap', False);
		FRemoteTrapAtt := ini.ReadBool('Trap', 'RemoteTrap', False);
		FReadTimeOut := ini.ReadInteger('HTTP', 'ReadTimeOut', 10000);

		// gpXptB^
		FSpamFilterAlgorithm := TGikoSpamFilterAlgorithm(
			ini.ReadInteger( 'Abon', 'SpamFilterAlgorithm', Ord( gsfaNone ) ) );
		FMute := ini.ReadBool('Function', 'Mute', false);
		FUseUndecided := ini.ReadBool('ThreadList', 'UseUndecided', False);

        //Be2ch
		//Fؗp[UIDEF؃R[h
		FBeUserID := ini.ReadString('Be', 'UserID', '');
		FBeCode := Decrypt(ini.ReadString('Be', 'Code', ''));
		FBeAutoLogin := ini.ReadBool('Be', 'AutoLogin', False);
		//̍őۑ
		FMaxRecordCount := Max(ini.ReadInteger('Recode', 'Max', 100), 1);

		// ̓AVXg
		FInputAssistFormTop := ini.ReadInteger('IAtWindowsSize', 'Top', 0);
		FInputAssistFormLeft := ini.ReadInteger('IAtWindowsSize', 'Left', 0);
		FInputAssistFormWidth := ini.ReadInteger('IAtWindowsSize', 'Width', 400);
		FInputAssistFormHeight := ini.ReadInteger('IAtWindowsSize', 'Height', 460);

		// CookieɕtŒR[h
		FFixedCookie := ini.ReadString('Cookie', 'fixedString', FIXED_COOKIE);

        // Nړ̍őێ
        FMoveHistorySize := ini.ReadInteger('MoveHisotry', 'Max', 20);

        FStoredTaskTray := ini.ReadBool('Function', 'StroedTaskTray', false);
        FLoopBrowserTabs := ini.ReadBool('Function', 'LoopBrowserTabs', false);
        FAddKeywordLink := ini.ReadBool('Thread', 'AddKeywordLink', false);
        if not (ini.ValueExists('Thread', 'ReplaceDat')) then begin
            msg := 'ZLeB\tǧ딽΍܂H'+ #13#10 +
                 'i:͂j'+ #13#10+'ڍאݒ肩ύXł܂B';
 		    if MsgBox(Application.Handle,
                 msg, 'MRir', MB_YESNO or MB_ICONQUESTION) = IDYES	then begin
                 FReplaceDat := True;
            end;
        end else begin
            FReplaceDat := ini.ReadBool('Thread', 'ReplaceDat', False);
        end;

        FSentIniFileSize := ini.ReadInteger('Function', 'SentIniFileSize', 3);
        FExtList := ini.ReadString('Function', 'ExtList', '*.gif;*.jpg;*.jpeg;*.png;*.zip;*.rar');

        FCheckDatFile := ini.ReadBool('ThreadList', 'CheckDatFile', True);
        FLimitResCountMessage := ini.ReadBool('Thread', 'LimitResCountMessage', True);
		ini.UpdateFile;
	finally
		ini.Free;
	end;
end;
//XVpURLǂݍ
procedure TSetting.ReadBoardURLsFile();
var
	ini: TMemIniFile;
	urlNum: Integer;
	i : Integer;
begin
	if not FileExists(GetBoardURLFileName()) then
	MakeURLIniFile();
	ini := TMemIniFile.Create(GetBoardURLFileName());
	try
		urlNum := ini.ReadInteger('URL','count',0);
		BoardURLSelected := ini.ReadInteger('URL','selected',0);
		for i := 0 to urlNum - 1 do begin
			FBoardURLs.Append(ini.ReadString('URL',IntToStr(i+1),''));
		end;
	finally
		ini.Free;
	end;

end;
//ݒt@Cۑ(system)
procedure TSetting.WriteSystemSettingFile();
var
	ini: TMemIniFile;
begin
	ini := TMemIniFile.Create(GetFileName());
	try
		//Mobt@TCY
		ini.WriteInteger('HTTP', 'RecvBufferSize', FRecvBufferSize);
		//HTTP1.1gp
		ini.WriteBool('HTTP', 'Protocol', FProtocol);
		//vLVڑHTTP1.1gp
		ini.WriteBool('HTTP', 'ProxyProtocol', FProxyProtocol);

		ini.WriteBool('ReadProxy', 'Proxy', FReadProxy);
		ini.WriteString('ReadProxy', 'Address', FReadProxyAddress);
		ini.WriteInteger('ReadProxy', 'Port', FReadProxyPort);
		ini.WriteString('ReadProxy', 'UserID', FReadProxyUserID);
		ini.WriteString('ReadProxy', 'Password', FReadProxyPassword);

		ini.WriteBool('WriteProxy', 'Proxy', FWriteProxy);
		ini.WriteString('WriteProxy', 'Address', FWriteProxyAddress);
		ini.WriteInteger('WriteProxy', 'Port', FWriteProxyPort);
		ini.WriteString('WriteProxy', 'UserID', FWriteProxyUserID);
		ini.WriteString('WriteProxy', 'Password', FWriteProxyPassword);

		ini.WriteString('Window', 'BrowserFontName', FBrowserFontName);
		ini.WriteInteger('Window', 'BrowserFontSize', FBrowserFontSize);
		ini.WriteInteger('Window', 'BrowserFontSize', FBrowserFontSize);
		ini.WriteInteger('Window', 'BrowserFontBold', FBrowserFontBold);
		ini.WriteInteger('Window', 'BrowserFontItalic', FBrowserFontItalic);
		ini.WriteInteger('Window', 'BrowserFontColor', FBrowserFontColor);
		ini.WriteInteger('Window', 'BrowserBackColor', FBrowserBackColor);

		ini.WriteString('Window', 'CabinetFontName', FCabinetFontName);
		ini.WriteInteger('Window', 'CabinetFontSize', FCabinetFontSize);
		ini.WriteString('Window', 'CabinetFontColor', ColorToString(FCabinetFontColor));
		ini.WriteBool('Window', 'CabinetFontBold', FCabinetFontBold);
		ini.WriteBool('Window', 'CabinetFontItalic', FCabinetFontItalic);
		ini.WriteString('Window', 'CabinetBackColor', ColorToString(FCabinetBackColor));

		ini.WriteString('Window', 'ListFontName', FListFontName);
		ini.WriteInteger('Window', 'ListFontSize', FListFontSize);
		ini.WriteString('Window', 'ListFontColor', ColorToString(FListFontColor));
		ini.WriteString('Window', 'ListBackColor', ColorToString(FListBackColor));
		ini.WriteBool('Window', 'ListFontBold', FListFontBold);
		ini.WriteBool('Window', 'ListFontItalic', FListFontItalic);
		ini.WriteBool('Window','UseOddColor',FUseOddColorOddResNum);
		ini.WriteString('Window', 'OddColor',ColorToString(FOddColor));
		ini.WriteBool('Window','UnFocusedBold', FUnFocusedBold);

		ini.WriteString('Window', 'EditorFontName', FEditorFontName);
		ini.WriteInteger('Window', 'EditorFontSize', FEditorFontSize);
		ini.WriteString('Window', 'EditorFontColor', ColorToString(FEditorFontColor));
		ini.WriteString('Window', 'EditorBackColor', ColorToString(FEditorBackColor));

		ini.WriteString('Window', 'BrowserTabFontName', FBrowserTabFontName);
		ini.WriteInteger('Window', 'BrowserTabFontSize', FBrowserTabFontSize);
		ini.WriteBool('Window', 'BrowserTabFontBold', FBrowserTabFontBold);
		ini.WriteBool('Window', 'BrowserTabFontItalic', FBrowserTabFontItalic);

		ini.WriteString('Window', 'HintFontName', FHintFontName);
		ini.WriteInteger('Window', 'HintFontSize', FHintFontSize);
		ini.WriteString('Window', 'HintFontColor', ColorToString(FHintFontColor));
		ini.WriteString('Window', 'HintBackColor', ColorToString(FHintBackColor));

		ini.UpdateFile;
	finally
		ini.Free;
	end;
end;

//ݒt@Cۑ(window)
procedure TSetting.WriteWindowSettingFile();
var
	i: Integer;
	ini: TMemIniFile;
	CoolSet: TCoolSet;
	wkList	: TStringList;
begin
	ini := TMemIniFile.Create(GetFileName());
	try
		ini.WriteInteger('WindowSize', 'Top', WindowTop);
		ini.WriteInteger('WindowSize', 'Left', WindowLeft);
		ini.WriteInteger('WindowSize', 'Height', WindowHeight);
		ini.WriteInteger('WindowSize', 'Width', WindowWidth);
		ini.WriteBool('WindowSize', 'Max', WindowMax);

		ini.WriteInteger('ViewStyle', 'ListView', Ord(ListStyle));

		ini.WriteInteger('EditorWindowSize', 'Top', EditWindowTop);
		ini.WriteInteger('EditorWindowSize', 'Left', EditWindowLeft);
		ini.WriteInteger('EditorWindowSize', 'Height', EditWindowHeight);
		ini.WriteInteger('EditorWindowSize', 'Width', EditWindowWidth);
		ini.WriteBool('EditorWindowSize', 'Max', EditWindowMax);
		ini.WriteBool('EditorWindowSize', 'Stay', EditWindowStay);
		ini.WriteBool('EditorWindowSize', 'Translucent', EditWindowTranslucent);

		ini.WriteInteger('OptionDialog', 'TabIndex', FOptionDialogTabIndex);

		// ̓AVXg
		ini.WriteInteger('IAtWindowsSize', 'Top', FInputAssistFormTop);
		ini.WriteInteger('IAtWindowsSize', 'Left', FInputAssistFormLeft);
		ini.WriteInteger('IAtWindowsSize', 'Width', FInputAssistFormWidth);
		ini.WriteInteger('IAtWindowsSize', 'Height', FInputAssistFormHeight);

		//c[o[
		ini.WriteBool('ToolBar', 'StdVisible', FStdToolBarVisible);
		ini.WriteBool('ToolBar', 'AddressVisible', FAddressBarVisible);
		ini.WriteBool('ToolBar', 'LinkVisible', FLinkBarVisible);
		ini.WriteBool('ToolBar', 'ListVisible', FListToolBarVisible);
		ini.WriteBool('ToolBar', 'ListNameVisible', FListNameBarVisible);
		ini.WriteBool('ToolBar', 'BrowserVisible', FBrowserToolBarVisible);
		ini.WriteBool('ToolBar', 'BrowserNameVisible', FBrowserNameBarVisible);
		//c[o[Wrapable
		ini.WriteBool('ToolBar', 'ListWrapable', FListToolBarWrapable);
		ini.WriteBool('ToolBar', 'BrowserWrapable', FBrowserToolBarWrapable);

		//^u
		ini.WriteBool('Tab', 'BrowserTabVisible', FBrowserTabVisible);
		ini.WriteInteger('Tab', 'BrowserTabPosition', Ord(FBrowserTabPosition));
		ini.WriteInteger('Tab', 'BrowserTabAppend', Ord(FBrowserTabAppend));
		ini.WriteInteger('Tab', 'BrowserTabStyle', Ord(FBrowserTabStyle));

		//bZ[Wo[
		ini.WriteBool('MessageBar', 'Visible', FMessageBarVisible);
		ini.WriteInteger('MessageBar', 'Height', FMessegeBarHeight);

		//Xe[^Xo[
		ini.WriteBool('StatusBar', 'Visible', FStatusBarVisible);

		//Lrlbg
		ini.WriteBool('Cabinet', 'Visible', FCabinetVisible);
		ini.WriteInteger('Cabinet', 'Width', FCabinetWidth);
		ini.WriteInteger('Cabinet', 'Index', FCabinetIndex);

		//Xg̃TCYƐ
		ini.WriteInteger('List', 'Orientation', Ord(FListOrientation));
		ini.WriteInteger('List', 'Height', FListHeight);
		ini.WriteInteger('List', 'HeightState', Ord(FListHeightState));
		ini.WriteInteger('List', 'Width', FListWidth);
		ini.WriteInteger('List', 'WidthState', Ord(FListWidthState));
//		ini.WriteBool('List', 'HeightMax', FListHeightMax);
//		ini.WriteBool('List', 'WidthMax', FListWidthMax);


//		ini.WriteInteger('Window', 'BrowserFontSize', BrowserFontSize);

		//Xgԍ\
		ini.WriteBool('Function', 'ListViewNo', FListViewNo);
		//CSSgp
		ini.WriteBool('CSS', 'UseCSS', FUseCSS);
		//`̃XLg
		ini.WriteBool('CSS', 'UseKatjushaType', FUseKatjushaType);
		//CSSt@C
		ini.WriteString('CSS', 'FileName', FSkinFiles.FileName);
		//Mail\
		ini.WriteBool('Thread', 'ShowMail', FShowMail);
		// X\͈
		ini.DeleteKey( 'Thread', 'OnlyAHundredRes' );   // Âݒ̍폜
		ini.WriteInteger('Thread', 'ResRange', FResRange);
		ini.WriteBool('Thread', 'ResRangeHold', FResRangeHold);
        ini.WriteInteger('Thread', 'HeadResCount', FHeadResCount);
		// Xbhꗗ\͈
		ini.WriteInteger('ThreadList', 'ThreadRange', Ord( FThreadRange ));
		//O폜mF
		ini.WriteBool('Function', 'LogDeleteMessage', FDeleteMsg);
		//ImF
		ini.WriteBool('Function','ShowDialogForEnd',FShowDialogForEnd);
		//AllTabClose
		ini.WriteBool('Function','ShowDialogForAllTabClose', FShowDialogForAllTabClose);
		//Samba
		ini.WriteBool('Function','UseSamba', FUseSamba);
		//ResAnchorjamp
		ini.WriteBool('Function', 'ResAnchoJamp', ResAnchorJamp);

		//ANeBu|bvAbv\
		ini.WriteBool('Thread', 'UnActivePopup', FUnActivePopup);
		//X|bvAbvwb_[{[h
		ini.WriteBool('Thread', 'ResPopupHeaderBold', FResPopupHeaderBold);
		//ini.WriteString('BoardURL', '2ch', FBoardURL2ch);

		//Fؗp[UIDEpX[h
		ini.WriteString('Attestation', 'UserID', FUserID);
		ini.WriteString('Attestation', 'Password', Encrypt(FPassword));
		ini.WriteBool('Attestation', 'AutoLogin', FAutoLogin);
		ini.WriteBool('Attestation', 'FForcedLogin', FForcedLogin);
		ini.WriteString('Attestation', 'FDolibURL', FDolibURL);

		//URLNbNNAv
		ini.WriteBool('URLApp', 'Select', FURLApp);
		ini.WriteString('URLApp', 'File', FURLAppFile);

		//mailtoNbN
		ini.WriteBool('Mailto', 'Open', FOpenMailer);

		//|bvAbvʒu
		ini.WriteInteger('Browser', 'PopupPosition', Ord(FPopupPosition));
        ini.WriteInteger('Browser', 'RespopupDelteX', FRespopupDeltaX);
        ini.WriteInteger('Browser', 'RespopupDelteY', FRespopupDeltaY);
        ini.WriteInteger('Browser', 'RespopupWait', FRespopupWait);
        ini.WriteBool('Browser', 'RespopupMailTo', FRespopupMailTo);
        
		//AhXo[
		ini.WriteBool('AddressBar', 'URLDisplay', FURLDisplay);
		ini.WriteBool('AddressBar', 'TabStop', FAddressBarTabStop);
		ini.WriteBool('AddressBar', 'LinkAdd', FLinkAddAddressBar);
		ini.WriteInteger('AddressBar', 'HistoryCount', FAddressHistoryCount);

		//摜vr[
		ini.WriteBool('Browser', 'PreviewVisible', FPreviewVisible);
		ini.WriteInteger('Browser', 'PreviewSize', Ord(FPreviewSize));
		ini.WriteInteger('Browser', 'PreviewWait', FPreviewWait);

		ini.WriteInteger('Window', 'BrowserAutoMaximize', Ord( BrowserAutoMaximize ) );

		//XbhꗗXVACR
		ini.WriteBool('ThreadList', 'StateIconVisible', FListIconVisible);
		ini.WriteBool('ThreadList', 'CreationTimeLogs',FCreationTimeLogs);
		ini.WriteBool('ThreadList', 'FutureThread', FFutureThread);
		ini.WriteInteger('ThreadList', 'SelectInterval', FSelectInterval);
		//\[g
		ini.WriteInteger('ThreadList', 'BBSSortIndex', FBBSSortIndex);
		ini.WriteBool('ThreadList', 'BBSSortOrder', FBBSSortOrder);
		ini.WriteInteger('ThreadList', 'CategorySortIndex', FCategorySortIndex);
		ini.WriteBool('ThreadList', 'CategorySortOrder', FCategorySortOrder);
		ini.WriteInteger('ThreadList', 'BoardSortIndex', FBoardSortIndex);
		ini.WriteBool('ThreadList', 'BoardSortOrder', FBoardSortOrder);
		ini.WriteInteger('ThreadList', 'DatOchiSortIndex', FDatOchiSortIndex);
		ini.WriteBool('ThreadList', 'DatOchiSortOrder', FDatOchiSortOrder);
		// DL̎\[g
		ini.WriteBool('ThreadList', 'AutoSort', FAutoSortThreadList);

		//ݎ}Vgpݒ
		ini.WriteBool('PostTime', 'UseMachineTime', FUseMachineTime);
		ini.WriteInteger('PostTime', 'TimeAdjustSec', FTimeAdjustSec);
		ini.WriteBool('PostTime', 'TimeAdjust', FTimeAdjust);

		// XgJ
		for i := 0 to Length(FBBSColumnWidth) - 1 do begin
			ini.WriteInteger('BBSColumnWidth', 'ID' + IntToStr(i), FBBSColumnWidth[i]);
		end;
		for i := 0 to Length(FCategoryColumnWidth) - 1 do begin
			ini.WriteInteger('CategoryColumnWidth', 'ID' + IntToStr(i), FCategoryColumnWidth[i]);
		end;
		for i := 0 to Length(FBoardColumnWidth) - 1 do begin
			ini.WriteInteger('BoardColumnWidth', 'ID' + IntToStr(i), FBoardColumnWidth[i]);
		end;

		wkList := TStringList.Create;
		try
			// JeSXg
			ini.ReadSection( 'BBSColumnOrder', wkList );
			for i := wkList.Count - 1 downto 0 do
				ini.DeleteKey( 'BBSColumnOrder', wkList[ i ] );
			for i := 0 to FBBSColumnOrder.Count - 1 do
				ini.WriteInteger( 'BBSColumnOrder', 'ID' + IntToStr( i ), Ord( FBBSColumnOrder[ i ] ) );

			// Xg
			ini.ReadSection( 'CategoryColumnOrder', wkList );
			for i := wkList.Count - 1 downto 0 do
				ini.DeleteKey( 'CategoryColumnOrder', wkList[ i ] );
			for i := 0 to FCategoryColumnOrder.Count - 1 do
				ini.WriteInteger( 'CategoryColumnOrder', 'ID' + IntToStr( i ), Ord( FCategoryColumnOrder[ i ] ) );

			// XXg
			ini.ReadSection( 'BoardColumnOrder', wkList );
			for i := wkList.Count - 1 downto 0 do
				ini.DeleteKey( 'BoardColumnOrder', wkList[ i ] );
			for i := 0 to FBoardColumnOrder.Count - 1 do
				ini.WriteInteger( 'BoardColumnOrder', 'ID' + IntToStr( i ), Ord( FBoardColumnOrder[ i ] ) );
		finally
			wkList.Free;
		end;

		//TEh
		for i := 0 to GetSoundCount - 1 do begin
			if not FileExists(SoundFileName[i]) then
				SoundFileName[i] := '';
			ini.WriteString('Sound', SoundName[i], SoundFileName[i]);
		end;

		//CoolBar
		ini.EraseSection('MainCoolBar');
		for i := 0 to MAIN_COOLBAND_COUNT - 1 do begin
			CoolSet := MainCoolSet[i];
			ini.WriteInteger('MainCoolBar', 'ID' + IntToStr(i), CoolSet.FCoolID);
			ini.WriteInteger('MainCoolBar', 'Width' + IntToStr(i), CoolSet.FCoolWidth);
			ini.WriteBool('MainCoolBar', 'Break' + IntToStr(i), CoolSet.FCoolBreak);
		end;
		ini.EraseSection('ListCoolBar');
		ini.WriteInteger( 'ListCoolBar', 'SelectWidth', FSelectComboBoxWidth );
		for i := 0 to LIST_COOLBAND_COUNT - 1 do begin
			CoolSet := ListCoolSet[i];
			ini.WriteInteger('ListCoolBar', 'ID' + IntToStr(i), CoolSet.FCoolID);
			ini.WriteInteger('ListCoolBar', 'Width' + IntToStr(i), CoolSet.FCoolWidth);
			ini.WriteBool('ListCoolBar', 'Break' + IntToStr(i), CoolSet.FCoolBreak);
		end;
		ini.EraseSection('BrowserCoolBar');
		for i := 0 to BROWSER_COOLBAND_COUNT - 1 do begin
			CoolSet := BrowserCoolSet[i];
			ini.WriteInteger('BrowserCoolBar', 'ID' + IntToStr(i), CoolSet.FCoolID);
			ini.WriteInteger('BrowserCoolBar', 'Width' + IntToStr(i), CoolSet.FCoolWidth);
			ini.WriteBool('BrowserCoolBar', 'Break' + IntToStr(i), CoolSet.FCoolBreak);
		end;

		//ځ`
		ini.WriteBool('Abon','Deleterlo',FAbonDeleterlo);
		ini.WriteBool('Abon','Replaceul',FAbonReplaceul);
		ini.WriteBool('Abon','Popup',FPopUpAbon);
		ini.WriteBool('Abon','ShowNGLines',FShowNGLinesNum);
		ini.WriteBool('Abon','AddResAnchor',FAddResAnchor);
		ini.WriteBool('Abon','DeleteSyria',FDeleteSyria);
		ini.WriteBool('Abon','IgnoreKana', FIgnoreKana);

		// GfB^
		ini.WriteBool( 'Editor', 'SpaceToNBSP', FSpaceToNBSP );
		ini.WriteBool( 'Editor', 'AmpToCharRef', FAmpToCharRef );

                //^uۑ
		ini.WriteBool('TabAuto', 'TabAutoLoadSave', FTabAutoLoadSave);
        ini.WriteString('Thread', 'LastCloseTabURL', FLastCloseTabURL); 
                //ڍאݒ
		ini.WriteInteger('OptionDialog', 'KuroutTabIndex', FKuroutSettingTabIndex);

                //ɂē@\
                ini.WriteBool('2chSupport', 'Support', F2chSupport);

		// }EXWFX`[gp邩ǂ
		ini.WriteBool( 'Guesture', 'Enabled', FGestureEnabled );
        ini.WriteBool( 'Guesture', 'IgnoreContext', FGestureIgnoreContext );
		//FusianaTrap
		ini.WriteBool('Trap', 'LocalTrap', FLocalTrapAtt);
		ini.WriteBool('Trap', 'RemoteTrap', FRemoteTrapAtt);
		ini.WriteInteger('HTTP', 'ReadTimeOut', FReadTimeOut);

		// gpXptB^
		ini.WriteInteger( 'Abon', 'SpamFilterAlgorithm', Ord( FSpamFilterAlgorithm ) );
                ini.WriteBool('Function', 'Mute', FMute);
                ini.WriteBool('ThreadList', 'UseUndecided', FUseUndecided);

		//Fؗp[UIDEpX[h
		ini.WriteString('Be', 'UserID', FBeUserID);
		ini.WriteString('Be', 'Code', Encrypt(FBeCode));
		ini.WriteBool('Be', 'AutoLogin', FBeAutoLogin);

		//̍őۑ
		ini.WriteInteger('Recode', 'Max', FMaxRecordCount);
		// ŒCookie
        ini.WriteString('Cookie', 'fixedString', FFixedCookie);

        // Nړ̍őێ
        ini.WriteInteger('MoveHisotry', 'Max', FMoveHistorySize);

        ini.WriteBool('Function', 'StroedTaskTray', FStoredTaskTray);
        ini.WriteBool('Function', 'LoopBrowserTabs', FLoopBrowserTabs);
        ini.WriteBool('Thread', 'AddKeywordLink', FAddKeywordLink);
        ini.WriteBool('Thread', 'ReplaceDat', FReplaceDat);
        ini.WriteInteger('Function', 'SentIniFileSize', FSentIniFileSize);
        ini.WriteString('Function', 'ExtList', FExtList);
        ini.WriteBool('ThreadList', 'CheckDatFile', FCheckDatFile);
        ini.WriteBool('Thread', 'LimitResCountMessage', FLimitResCountMessage);
		ini.UpdateFile;
	finally
		ini.Free;
	end;
end;

//ݒt@Cۑ(name & mail)
procedure TSetting.WriteNameMailSettingFile();
var
	i: Integer;
	ini: TMemIniFile;
begin
	ini := TMemIniFile.Create(GetFileName());
	try
		ini.EraseSection('Name');
		ini.EraseSection('Mail');
		ini.EraseSection('SelectText');
		for i := 0 to FNameList.Count - 1 do begin
			ini.WriteString('Name', Format('%.2d', [i + 1]), FNameList[i]);
			if i >= 39 then
				Break;
		end;
		for i := 0 to FMailList.Count - 1 do begin
			ini.WriteString('Mail', Format('%.2d', [i + 1]), FMailList[i]);
			if i >= 39 then
				Break;
		end;
		for i := 0 to FSelectTextList.Count - 1 do begin
			ini.WriteString('SelectText', Format('%.2d', [i + 1]), FSelectTextList[i]);
			if i >= 39 then
				Break;
		end;
		ini.UpdateFile;
	finally
		ini.Free;
	end;
end;

procedure TSetting.WriteFolderSettingFile();
var
	ini: TMemIniFile;
begin
	ini := TMemIniFile.Create(GetFileName());
	try
		if GetAppDir + 'Log' = NewLogFolder then
			ini.DeleteKey('Folder', 'LogFolder')
		else
			ini.WriteString('Folder', 'LogFolder', NewLogFolder);
		ini.UpdateFile;
	finally
		ini.Free;
	end;
end;
//XVpBoardURLۑ
procedure TSetting.WriteBoardURLSettingFile();
var
	ini: TMemIniFile;
		i : Integer;
		oldcount : Integer;
begin
	ini := TMemIniFile.Create(GetBoardURLFileName());
	try
		oldcount := ini.ReadInteger('URL','count',FBoardURLs.Count);
		ini.WriteInteger('URL','count',FBoardURLs.Count);
		ini.WriteInteger('URL','selected',BoardURLSelected);
		for i := 0 to FBoardURLs.Count -1 do begin
					ini.WriteString('URL',IntToStr(i+1),FBoardURLs.Strings[i]);
		end;
		if oldcount > FBoardURLs.Count then begin
			for i := FBoardURLs.Count to oldcount do begin
				ini.DeleteKey('URL',IntToStr(i+1));
			end;
		end;
		ini.UpdateFile;
	finally
		ini.Free;
	end;
end;

{$R-}
//XgJwb_[
function TSetting.GetBBSColumnWidth(index: Integer): Integer;
begin
	Result := IfThen(index in [0..Length(FBBSColumnWidth) - 1], FBBSColumnWidth[index], 0);
end;

function TSetting.GetCategoryColumnWidth(index: Integer): Integer;
begin
	Result := IfThen(index in [0..Length(FCategoryColumnWidth) - 1], FCategoryColumnWidth[index], 0);
end;

function TSetting.GetBoardColumnWidth(index: Integer): Integer;
begin
	Result := IfThen(index in [0..Length(FBoardColumnWidth) - 1], FBoardColumnWidth[index], 0);
end;
{$IFDEF DEBUG}
{$R+}
{$ENDIF}

procedure TSetting.SetBBSColumnWidth(index: Integer; value: Integer);
begin
	if index in [0..Length(FBBSColumnWidth) - 1] then
		FBBSColumnWidth[index] := value;
end;

procedure TSetting.SetCategoryColumnWidth(index: Integer; value: Integer);
begin
	if index in [0..Length(FCategoryColumnWidth) - 1] then
		FCategoryColumnWidth[index] := value;
end;

procedure TSetting.SetBoardColumnWidth(index: Integer; value: Integer);
begin
	if index in [0..Length(FBoardColumnWidth) - 1] then
		FBoardColumnWidth[index] := value;
end;

function TSetting.GetSoundCount: Integer;
begin
	Result := Length(SOUND_NAME);
end;

function TSetting.GetSoundName(Index: Integer): string;
begin
	if (Index < GetSoundCount) and (Index >= 0) then
		Result := SOUND_NAME[Index].Name
	else
		Result := '';
end;

function TSetting.GetSoundViewName(Index: Integer): string;
begin
	if (Index < GetSoundCount) and (Index >= 0) then
		Result := SOUND_NAME[Index].ViewName
	else
		Result := '';
end;

function TSetting.GetSoundFileName(Index: Integer): string;
begin
	if (Index < GetSoundCount) and (Index >= 0) then
		Result := SOUND_NAME[Index].FileName
	else
		Result := '';
end;

procedure TSetting.SetSoundFileName(Index: Integer; value: string);
begin
	if (Index < GetSoundCount) and (Index >= 0) then
		SOUND_NAME[Index].FileName := value;
end;

function TSetting.FindSoundFileName(Name: string): string;
var
	i: Integer;
begin
	for i := 0 to GetSoundCount - 1 do begin
		if SoundName[i] = Name then begin
			Result := SoundFileName[i];
			Exit;
		end;
	end;
	Result := '';
end;

function TSetting.Encrypt(s: string): string;
var
	cryptObj: THogeCryptAuto;
	inputStream, outputStream: TStringStream;
begin
	inputStream := TStringStream.Create(s);
	outputStream := TStringStream.Create('');
	cryptObj := THogeCryptAuto.Create;
	try
		// Í
		cryptObj.Encrypt(inputStream, GIKO_ENCRYPT_TEXT, outputStream);

		// oCiȂ̂ŕKvɉăeLXgɕϊ
		Result := HogeBase64Encode(outputStream.DataString);
	finally
		cryptObj.Free;
		outputStream.Free;
		inputStream.Free;
	end;
end;

function TSetting.Decrypt(s: string): string;
var
	cryptObj: THogeCryptAuto;
	inputStream, outputStream: TStringStream;
begin
	try
		inputStream := TStringStream.Create(HogeBase64Decode(s));
	except
		Result := '';
		Exit;
	end;
	outputStream := TStringStream.Create('');
	cryptObj := THogeCryptAuto.Create;
	try
		// 
		cryptObj.Decrypt(inputStream, GIKO_ENCRYPT_TEXT, outputStream);
		Result := outputStream.DataString;
	finally
		cryptObj.Free;
		outputStream.Free;
		inputStream.Free;
	end;
end;

function TSetting.GetMainCoolSet(Index: Integer): TCoolSet;
begin
	if Index in [0..MAIN_COOLBAND_COUNT - 1] then
		Result := FMainCoolBar[Index]
	else begin
		Result.FCoolID := -1;
		Result.FCoolWidth := -1;
		Result.FCoolBreak := False;
	end;
end;

function TSetting.GetBoardCoolSet(Index: Integer): TCoolSet;
begin
	if Index in [0..LIST_COOLBAND_COUNT - 1] then
		Result := FListCoolBar[Index]
	else begin
		Result.FCoolID := -1;
		Result.FCoolWidth := -1;
		Result.FCoolBreak := False;
	end;
end;

function TSetting.GetBrowserCoolSet(Index: Integer): TCoolSet;
begin
	if Index in [0..BROWSER_COOLBAND_COUNT - 1] then
		Result := FBrowserCoolBar[Index]
	else begin
		Result.FCoolID := -1;
		Result.FCoolWidth := -1;
		Result.FCoolBreak := False;
	end;
end;

procedure TSetting.SetMainCoolSet(Index: Integer; CoolSet: TCoolSet);
begin
	if Index in [0..MAIN_COOLBAND_COUNT - 1] then
		FMainCoolBar[Index] := CoolSet;
end;

procedure TSetting.SetBoardCoolSet(Index: Integer; CoolSet: TCoolSet);
begin
	if Index in [0..LIST_COOLBAND_COUNT - 1] then
		FListCoolBar[Index] := CoolSet;
end;

procedure TSetting.SetBrowserCoolSet(Index: Integer; CoolSet: TCoolSet);
begin
	if Index in [0..BROWSER_COOLBAND_COUNT - 1] then
		FBrowserCoolBar[Index] := CoolSet;
end;

//url.iniȂƂɐ
procedure TSetting.MakeURLIniFile();
var
	ini: TMemIniFile;
begin
	ini := TMemIniFile.Create(GetBoardURLFileName());
	try
		//XVURL̐
		ini.WriteInteger('URL','count',1);
		//ftHgŎgptqk̃CfbNX
		ini.WriteInteger('URL','selected',1);
		//ȉKvȐAXVtqkǉ
		ini.WriteString('URL','1',DEFAULT_2CH_BOARD_URL1);
		//ini.WriteString('URL','2',DEFAULT_2CH_BOARD_URL2);
		ini.UpdateFile;
	finally
		ini.Free;
	end;
end;

(*************************************************************************
 *{[ht@C擾ipX{t@Cj
 *************************************************************************)
function TSetting.GetBoardFileName: string;
begin
	Result := GetConfigDir + BOARD_FILE_NAME;
end;

(*************************************************************************
 *{[ht@C擾ipX{t@Cj
 *************************************************************************)
function TSetting.GetCustomBoardFileName: string;
begin
	Result := GetConfigDir + CUSTOMBOARD_FILE_NAME;
end;

(*************************************************************************
 *{[hfBNg擾(\ŏI)
 *************************************************************************)
function TSetting.GetBoardDir: string;
begin
	Result := IncludeTrailingPathDelimiter(GetConfigDir + BOARD_DIR_NAME);
end;

(*************************************************************************
 *e|tH_[擾
 *************************************************************************)
function TSetting.GetHtmlTempFileName: string;
begin
	Result := TEMP_FOLDER;
end;


(*************************************************************************
 *st@CtH_擾(Ō\)
 *************************************************************************)
function TSetting.GetAppDir: string;
begin
	Result := ExtractFilePath(Application.ExeName);
end;

(*************************************************************************
 *TempHtmlt@C擾ipX{t@Cj
 *************************************************************************)
function TSetting.GetTempFolder: string;
begin
	Result := GetAppDir + TEMP_FOLDER;
end;

(*************************************************************************
 *sent.init@C擾ipX{t@Cj
 *************************************************************************)
function TSetting.GetSentFileName: string;
begin
	Result := GetAppDir + SENT_FILE_NAME;
end;

(*************************************************************************
 *outbox.init@C擾ipX{t@Cj
 *************************************************************************)
function TSetting.GetOutBoxFileName: string;
begin
	Result := GetAppDir + OUTBOX_FILE_NAME;
end;

(*************************************************************************
 *ConfigtH_擾(\ŏI)
 *************************************************************************)
function TSetting.GetConfigDir: string;
begin
	Result := IncludeTrailingPathDelimiter(GetAppDir + CONFIG_DIR_NAME);
end;
(*************************************************************************
 *CSStH_擾(\ŏI)
 *************************************************************************)
function TSetting.GetStyleSheetDir: string;
begin
	Result := IncludeTrailingPathDelimiter(GetConfigDir + CSS_DIR_NAME);
end;
(*************************************************************************
 *skintH_擾(\ŏI)
 *************************************************************************)
function TSetting.GetSkinDir: string;
begin
	Result := IncludeTrailingPathDelimiter(GetConfigDir + SKIN_DIR_NAME);
end;
(*************************************************************************
 *NG[hfBNg擾(\ŏI)
 *************************************************************************)
function TSetting.GetNGWordsDir: string;
begin
	Result := IncludeTrailingPathDelimiter(GetConfigDir + NGWORDs_DIR_NAME);
end;
(*************************************************************************
 *BoardvOCfBNg擾(\ŏI)
 *************************************************************************)
function TSetting.GetBoardPlugInDir: string;
begin
	Result := IncludeTrailingPathDelimiter(GetConfigDir + BOARD_PLUGIN_DIR_NAME);
end;

procedure TSetting.SetUseCSS( value: Boolean );
begin

	FUseCSS := value;
	// WindowsIɃt@CpX̑啶̈Ⴂ͖̂ŁA
	// RRł̔ł啶̈Ⴂ͖B
	FUseSkin :=
		UseCSS and
		(Pos( AnsiLowerCase(GetSkinDir), AnsiLowerCase(FSkinFiles.FileName) ) > 0) and
		FileExists( FSkinFiles.GetSkinHeaderFileName );

end;

procedure TSetting.SetCSSFileName( fileName: string );
begin
    FSkinFiles.FileName := fileName;
	// WindowsIɃt@CpX̑啶̈Ⴂ͖̂ŁA
	// RRł̔ł啶̈Ⴂ͖B
	FUseSkin :=
		UseCSS and
		(Pos( AnsiLowerCase(GetSkinDir), AnsiLowerCase(FSkinFiles.FileName) ) > 0) and
		FileExists( FSkinFiles.GetSkinHeaderFileName );

end;
(*************************************************************************
 *sambaݒt@C擾
 *************************************************************************)
function TSetting.GetSambaFileName: string;
begin
	Result := GetAppDir + SAMBATIME_FILE_NAME;
end;
//XVOJeSXgۑt@C
function TSetting.GetIgnoreFileName: string;
begin
	Result := GetConfigDir + IGNORE_FILE_NAME;
end;

//! }EXWFX`[t@CpX
function TSetting.GetGestureFileName: string;
begin
	Result := GetConfigDir + GESTURE_FILE_NAME;
end;

//! XptB^wKt@CpX
function TSetting.GetSpamFilterFileName: string;
begin
	Result := GetConfigDir + SPAMFILTER_FILE_NAME;
end;

function TSetting.GetLanguageFileName: string;
begin
    Result := GetConfigDir + LANGUAGE_FILE_NAME;
end;
procedure TSetting.WriteLogFolder(AVal : String);
begin
	FLogFolder := AVal;
	FLogFolderP := IncludeTrailingPathDelimiter(LogFolder);
end;
function TSetting.GetMainKeyFileName: String;
begin
	Result := GetConfigDir + KEY_SETTING_FILE_NAME;
end;
function TSetting.GetEditorKeyFileName: String;
begin
	Result := GetConfigDir + EKEY_SETTING_FILE_NAME;
end;
function TSetting.GetInputAssistFileName : String;
begin
	Result := GetConfigDir + INPUTASSIST_FILE_NAME;
end;
function TSetting.GetReplaceFileName: String;
begin
    Result := GetConfigDir + REPLACE_FILE_NAME;
end;
procedure TSetting.SetMoveHistorySize(AVal : Integer);
begin
    if (AVal > 0) then begin
        FMoveHistorySize := AVal;
    end;
end;
{
\brief vLVݒǂݍ
\param  memIni  init@C
}
procedure TSetting.ReadProxySettings(memIni: TMemIniFile);
const
    READ_SECTION = 'ReadProxy';
    WRITE_SECTION= 'WriteProxy';
    PROXY_KEY = 'Proxy';
    ADDRE_KEY = 'Address';
    PORT_KEY = 'Port';
    UID_KEY  = 'UserID';
    PASS_KEY = 'Password';
begin
    if (memIni <> nil) then begin
		FReadProxy := memIni.ReadBool(READ_SECTION, PROXY_KEY, false);
		FReadProxyAddress := memIni.ReadString(READ_SECTION, ADDRE_KEY, '');
		FReadProxyPort := memIni.ReadInteger(READ_SECTION, PORT_KEY, 0);
		FReadProxyUserID := memIni.ReadString(READ_SECTION, UID_KEY, '');
		FReadProxyPassword := memIni.ReadString(READ_SECTION, PASS_KEY, '');

		FWriteProxy := memIni.ReadBool(WRITE_SECTION, PROXY_KEY, false);
		FWriteProxyAddress := memIni.ReadString(WRITE_SECTION, ADDRE_KEY, '');
		FWriteProxyPort := memIni.ReadInteger(WRITE_SECTION, PORT_KEY, 0);
		FWriteProxyUserID := memIni.ReadString(WRITE_SECTION, UID_KEY, '');
		FWriteProxyPassword := memIni.ReadString(WRITE_SECTION, PASS_KEY, '');
    end;
end;
{
\brief  eEBhEݒǂݍ
\param  menIni  init@C
}
procedure TSetting.ReadWindowSettings(memIni: TMemIniFile);
const
    WINDOW_SECTION = 'Window';
begin
    if (memIni <> nil) then begin
		FBrowserFontName := memIni.ReadString(WINDOW_SECTION, 'BrowserFontName', '');
		FBrowserFontSize := memIni.ReadInteger(WINDOW_SECTION, 'BrowserFontSize', 0);
		FBrowserFontBold := memIni.ReadInteger(WINDOW_SECTION, 'BrowserFontBold', 0);
		FBrowserFontItalic := memIni.ReadInteger(WINDOW_SECTION, 'BrowserFontItalic', 0);
		FBrowserFontColor := memIni.ReadInteger(WINDOW_SECTION, 'BrowserFontColor', -1);
		FBrowserBackColor := memIni.ReadInteger(WINDOW_SECTION, 'BrowserBackColor', -1);

		FCabinetFontName := memIni.ReadString(WINDOW_SECTION, 'CabinetFontName', DEFAULT_FONT_NAME);
		FCabinetFontSize := memIni.ReadInteger(WINDOW_SECTION, 'CabinetFontSize', DEFAULT_FONT_SIZE);
		FCabinetFontBold := memIni.ReadBool(WINDOW_SECTION, 'CabinetFontBold', False);
		FCabinetFontItalic := memIni.ReadBool(WINDOW_SECTION, 'CabinetFontItalic', False);
		FCabinetFontColor := StringToColor(memIni.ReadString(WINDOW_SECTION, 'CabinetFontColor', DEFAULT_FONT_COLOR));
		FCabinetBackColor := StringToColor(memIni.ReadString(WINDOW_SECTION, 'CabinetBackColor', DEFAULT_WINDOW_COLOR));

		FListFontName := memIni.ReadString(WINDOW_SECTION, 'ListFontName', DEFAULT_FONT_NAME);
		FListFontSize := memIni.ReadInteger(WINDOW_SECTION, 'ListFontSize', DEFAULT_FONT_SIZE);
		FListFontBold := memIni.ReadBool(WINDOW_SECTION, 'ListFontBold', False);
		FListFontItalic := memIni.ReadBool(WINDOW_SECTION, 'ListFontItalic', False);
		FListFontColor := StringToColor(memIni.ReadString(WINDOW_SECTION, 'ListFontColor', DEFAULT_FONT_COLOR));
		FListBackColor := StringToColor(memIni.ReadString(WINDOW_SECTION, 'ListBackColor', DEFAULT_WINDOW_COLOR));
		FUseOddColorOddResNum := memIni.ReadBool(WINDOW_SECTION,'UseOddColor', False);
		FOddColor := StringToColor(memIni.ReadString(WINDOW_SECTION, 'OddColor', DEFAULT_WINDOW_COLOR));
		FUnFocusedBold := memIni.ReadBool(WINDOW_SECTION,'UnFocusedBold', False);

		FEditorFontName := memIni.ReadString(WINDOW_SECTION, 'EditorFontName', DEFAULT_FONT_NAME);
		FEditorFontSize := memIni.ReadInteger(WINDOW_SECTION, 'EditorFontSize', DEFAULT_FONT_SIZE);
		FEditorFontBold := memIni.ReadBool(WINDOW_SECTION, 'EditorFontBold', False);
		FEditorFontItalic := memIni.ReadBool(WINDOW_SECTION, 'EditorFontItalic', False);
		FEditorFontColor := StringToColor(memIni.ReadString(WINDOW_SECTION, 'EditorFontColor', DEFAULT_FONT_COLOR));
		FEditorBackColor := StringToColor(memIni.ReadString(WINDOW_SECTION, 'EditorBackColor', DEFAULT_WINDOW_COLOR));

		FBrowserTabFontName := memIni.ReadString(WINDOW_SECTION, 'BrowserTabFontName', DEFAULT_TAB_FONT_NAME);
		FBrowserTabFontSize := memIni.ReadInteger(WINDOW_SECTION, 'BrowserTabFontSize', DEFAULT_TAB_FONT_SIZE);
		FBrowserTabFontBold := memIni.ReadBool(WINDOW_SECTION, 'BrowserTabFontBold', False);
		FBrowserTabFontItalic := memIni.ReadBool(WINDOW_SECTION, 'BrowserTabFontItalic', False);

		FHintFontName := memIni.ReadString(WINDOW_SECTION, 'HintFontName', Screen.HintFont.Name);
		FHintFontSize := memIni.ReadInteger(WINDOW_SECTION, 'HintFontSize', Screen.HintFont.Size);
		//FHintFontBold := memIni.ReadBool(WINDOW_SECTION, 'HintFontBold', False);
		//FHintFontItalic := memIni.ReadBool(WINDOW_SECTION, 'HintFontItalic', False);
		FHintFontColor := StringToColor(memIni.ReadString(WINDOW_SECTION, 'HintFontColor', DEFAULT_FONT_COLOR));
		FHintBackColor := StringToColor(memIni.ReadString(WINDOW_SECTION, 'HintBackColor', 'clInfoBk'));
    end;
end;
{
\brief  ͗ǂݍ݁i{[{Oj
\param  memIni  init@C
}
procedure TSetting.ReadInputHisotrys(memIni: TMemIniFile);
const
    SECTIONS : array[0..2] of string = ('Name', 'Mail', 'SelectText');
var
	wkList : TStringList;
    wkStr : string;
    i, j : Integer;
    listArray : array[0..2] of TStringList;
begin
    if (memIni <> nil) then begin
        listArray[0] := FNameList;
        listArray[1] := FMailList;
        listArray[2] := FSelectTextList;
        wkList := TStringList.Create;
        try
            for i := 0 to High(listArray) do begin
                memIni.ReadSection(SECTIONS[i], wkList);
                for j := 0 to wkList.Count -1 do begin
                    wkStr := memIni.ReadString(SECTIONS[i], wkList[j], '');
                    if (wkStr <> '') and
                        (listArray[i].IndexOf(wkStr) = -1) then begin
                        listArray[i].Add(wkStr);
                    end;
                end;
            end;
        finally
            wkList.Free;
        end;
    end;
end;
{
\breif  XgJǂݍ
\param  memIni  init@C
}
procedure TSetting.ReadListColumnWidth(memIni: TMemIniFile);
const
    SECTIONS : array[0..2] of string =
        ('BBSColumnWidth', 'CategoryColumnWidth', 'BoardColumnWidth');
	DEFAULT_BBS_WIDTH: array[0..0] of Integer = (140);
	DEFAULT_CATEGORY_WIDTH: array[0..2] of Integer = (150, 80, 130);
	DEFAULT_BOARD_WIDTH: array[0..10] of Integer = (350, 60, 60, 60, 60, 60, 80, 130, 130, 130, 60);
	MAX_WIDTH: Integer = 2000;
var
	wkList : TStringList;
    i : Integer;
begin
    if (memIni <> nil) then begin
		// XgJ
		wkList := TStringList.Create;
		try
			memIni.ReadSection(SECTIONS[0], wkList);
			if Length(FBBSColumnWidth) <> wkList.Count then begin
				memIni.EraseSection(SECTIONS[0]);
			end;
			for i := 0 to High(FBBSColumnWidth) do begin
				BBSColumnWidth[i] := memIni.ReadInteger(SECTIONS[0],
                     'ID' + IntToStr(i), DEFAULT_BBS_WIDTH[i]);
				if BBSColumnWidth[i] > MAX_WIDTH then
					BBSColumnWidth[i] := DEFAULT_BBS_WIDTH[i];
			end;
			memIni.ReadSection(SECTIONS[1], wkList);
			if Length(FCategoryColumnWidth) <> wkList.Count then begin
				memIni.EraseSection(SECTIONS[1]);
			end;
			for i := 0 to High(FCategoryColumnWidth) do begin
				CategoryColumnWidth[i] := memIni.ReadInteger(SECTIONS[1],
                     'ID' + IntToStr(i), DEFAULT_CATEGORY_WIDTH[i]);
				if CategoryColumnWidth[i] > MAX_WIDTH then
					CategoryColumnWidth[i] := DEFAULT_CATEGORY_WIDTH[i];
			end;
			memIni.ReadSection(SECTIONS[2], wkList);
			if Length(FBoardColumnWidth) <> wkList.Count then begin
				memIni.EraseSection(SECTIONS[2]);
			end;
			for i := 0 to High(FBoardColumnWidth) do begin
				BoardColumnWidth[i] := memIni.ReadInteger(SECTIONS[2],
                     'ID' + IntToStr(i), DEFAULT_BOARD_WIDTH[i]);
				if BoardColumnWidth[i] > MAX_WIDTH then
					BoardColumnWidth[i] := DEFAULT_BOARD_WIDTH[i];
			end;
		finally
			wkList.Free;
		end;
    end;
end;
//! JeSXgJǂݍ
procedure TSetting.ReadOrdColumn(memIni: TMemIniFile);
var
	wkList : TStringList;
    wkStr : string;
    i, id, code : Integer;
begin
    if (memIni <> nil) then begin
		wkList := TStringList.Create;
		try
			memIni.ReadSection( 'BBSColumnOrder', wkList );
			for i := 0 to wkList.Count - 1 do begin
				wkStr := memIni.ReadString( 'BBSColumnOrder', 'ID' + IntToStr( i ), '' );
				Val( wkStr, id, code );
				if code = 0 then
					FBBSColumnOrder.Add( TGikoBBSColumnID( id ) );
			end;
			if FBBSColumnOrder.Count = 0 then begin
				// ݒ肪̂ō쐬
				for i := 0 to Integer( High( TGikoBBSColumnID ) ) do
					FBBSColumnOrder.Add( TGikoBBSColumnID( i ) );
			end;

			memIni.ReadSection( 'CategoryColumnOrder', wkList );
			for i := 0 to wkList.Count - 1 do begin
				wkStr := memIni.ReadString( 'CategoryColumnOrder', 'ID' + IntToStr( i ), '' );
				Val( wkStr, id, code );
				if code = 0 then
					FCategoryColumnOrder.Add( TGikoCategoryColumnID( id ) );
			end;
			if FCategoryColumnOrder.Count = 0 then begin
				// ݒ肪̂ō쐬
				for i := 0 to Integer( High( TGikoCategoryColumnID ) ) do
					FCategoryColumnOrder.Add( TGikoCategoryColumnID( i ) );
			end;

			memIni.ReadSection( 'BoardColumnOrder', wkList );
			for i := 0 to wkList.Count - 1 do begin
				wkStr := memIni.ReadString( 'BoardColumnOrder', 'ID' + IntToStr( i ), '' );
				Val( wkStr, id, code );
				if code = 0 then
					FBoardColumnOrder.Add( TGikoBoardColumnID( id ) );
			end;
			if FBoardColumnOrder.Count = 0 then begin
				// ݒ肪̂ō쐬
				for i := 0 to Integer( High( TGikoBoardColumnID ) ) do begin
					// ̃J̓ftHgŔ\ɂ
					if ( i <> Ord(gbcVigor) ) then begin
						FBoardColumnOrder.Add( TGikoBoardColumnID( i ) );
					end;
				end;
			end;
		finally
			wkList.Free;
		end;
    end;
end;

function TSetting.GetCSSFileName: string;
begin
    Result := FSkinFiles.FileName;
end;

end.

