package com.rogerfgm;

public class Usi {
	
	private static final String Resign = "resign";
	
	/**
	 * USIR}h̓B
	 * R}ĥ͎݂Ȃ̂ŏXĂvB
	 * @param s
	 */
	public static void usimove(Kyokumen k, String s, boolean b) throws Exception{
		if(s.charAt(1) == '*'){
			// ł
			
			int afY = s.charAt(2) - '0';
			int afT = s.charAt(3) - 'a' + 1;
			char koma = s.charAt(0);
			if(koma == 'P'){ // 
				if(b){
					k.b_fu.addSD(afY, afT);
					k.delFu_b();
				}
				else{
					k.w_fu.addSD(afY, afT);
					k.delFu_w();
				}
			}
			else if(koma == 'L'){
				if(b){
					k.b_kyo.addSD(afY, afT);
					k.delKyo_b();
				}
				else{
					k.w_kyo.addSD(afY, afT);
					k.delKyo_w();
				}
			}
			else if(koma == 'N'){
				if(b){
					k.b_kei.addSD(afY, afT);
					k.delKei_b();
				}
				else{
					k.w_kei.addSD(afY, afT);
					k.delKei_w();
				}
			}
			else if(koma == 'S'){
				if(b){
					k.b_gin.addSD(afY, afT);
					k.delGin_b();
				}
				else{
					k.w_gin.addSD(afY, afT);
					k.delGin_w();
				}
			}
			else if(koma == 'G'){
				if(b){
					k.b_kin.addSD(afY, afT);
					k.delKin_b();
				}
				else{
					k.w_kin.addSD(afY, afT);
					k.delKin_w();
				}
			}
			else if(koma == 'B'){
				if(b){
					k.b_kaku.addSD(afY, afT);
					k.delKaku_b();
				}
				else{
					k.w_kaku.addSD(afY, afT);
					k.delKaku_w();
				}
			}
			else if(koma == 'R'){
				if(b){
					k.b_hisha.addSD(afY, afT);
					k.delHisha_b();
				}
				else{
					k.w_hisha.addSD(afY, afT);
					k.delHisha_w();
				}
			}
			
		}
		else{
			int bfY = s.charAt(0) - '0';
			int bfT = s.charAt(1) - 'a' + 1;
			int afY = s.charAt(2) - '0';
			int afT = s.charAt(3) - 'a' + 1;
			boolean nari = false;
			if(s.length() == 5 && s.charAt(4) == '+'){
				nari = true;
			}
			EachKoma bfk = null;
			EachKoma afk = null;
			boolean debug = false;
			
			if(k.b_fu.existCheckSujiDan(bfY, bfT)){
				bfk = k.b_fu;
				afk = k.b_fu;
				if(nari){
					afk = k.b_to;
				}
				debug = true;
			}
			else if(k.b_kyo.existCheckSujiDan(bfY, bfT)){
				bfk = k.b_kyo;
				afk = k.b_kyo;
				if(nari){
					afk = k.b_narikyo;
				}
				debug = true;
			}
			else if(k.b_kei.existCheckSujiDan(bfY, bfT)){
				bfk = k.b_kei;
				afk = k.b_kei;
				if(nari){
					afk = k.b_narikei;
				}
				debug = true;
			}
			else if(k.b_gin.existCheckSujiDan(bfY, bfT)){
				bfk = k.b_gin;
				afk = k.b_gin;
				if(nari){
					afk = k.b_narigin;
				}
				debug = true;
			}
			else if(k.b_kin.existCheckSujiDan(bfY, bfT)){
				bfk = k.b_kin;
				afk = k.b_kin;
				debug = true;
			}
			else if(k.b_kaku.existCheckSujiDan(bfY, bfT)){
				bfk = k.b_kaku;
				afk = k.b_kaku;
				if(nari){
					afk = k.b_uma;
				}
				debug = true;
			}
			else if(k.b_hisha.existCheckSujiDan(bfY, bfT)){
				bfk = k.b_hisha;
				afk = k.b_hisha;
				if(nari){
					afk = k.b_ryu;
				}
				debug = true;
			}
			else if(k.b_ou.existCheckSujiDan(bfY, bfT)){
				bfk = k.b_ou;
				afk = k.b_ou;
				debug = true;
			}
			else if(k.b_to.existCheckSujiDan(bfY, bfT)){
				bfk = k.b_to;
				afk = k.b_to;
				debug = true;
			}
			else if(k.b_narikyo.existCheckSujiDan(bfY, bfT)){
				bfk = k.b_narikyo;
				afk = k.b_narikyo;
				debug = true;
			}
			else if(k.b_narikei.existCheckSujiDan(bfY, bfT)){
				bfk = k.b_narikei;
				afk = k.b_narikei;
				debug = true;
			}
			else if(k.b_narigin.existCheckSujiDan(bfY, bfT)){
				bfk = k.b_narigin;
				afk = k.b_narigin;
				debug = true;
			}
			else if(k.b_uma.existCheckSujiDan(bfY, bfT)){
				bfk = k.b_uma;
				afk = k.b_uma;
				debug = true;
			}
			else if(k.b_ryu.existCheckSujiDan(bfY, bfT)){
				bfk = k.b_ryu;
				afk = k.b_ryu;
				debug = true;
			}
			else if(k.w_fu.existCheckSujiDan(bfY, bfT)){
				bfk = k.w_fu;
				afk = k.w_fu;
				if(nari){
					afk = k.w_to;
				}
				debug = true;
			}
			else if(k.w_kyo.existCheckSujiDan(bfY, bfT)){
				bfk = k.w_kyo;
				afk = k.w_kyo;
				if(nari){
					afk = k.w_narikyo;
				}
				debug = true;
			}
			else if(k.w_kei.existCheckSujiDan(bfY, bfT)){
				bfk = k.w_kei;
				afk = k.w_kei;
				if(nari){
					afk = k.w_narikei;
				}
				debug = true;
			}
			else if(k.w_gin.existCheckSujiDan(bfY, bfT)){
				bfk = k.w_gin;
				afk = k.w_gin;
				if(nari){
					afk = k.w_narigin;
				}
				debug = true;
			}
			else if(k.w_kin.existCheckSujiDan(bfY, bfT)){
				bfk = k.w_kin;
				afk = k.w_kin;
				debug = true;
			}
			else if(k.w_kaku.existCheckSujiDan(bfY, bfT)){
				bfk = k.w_kaku;
				afk = k.w_kaku;
				if(nari){
					afk = k.w_uma;
				}
				debug = true;
			}
			else if(k.w_hisha.existCheckSujiDan(bfY, bfT)){
				bfk = k.w_hisha;
				afk = k.w_hisha;
				if(nari){
					afk = k.w_ryu;
				}
				debug = true;
			}
			else if(k.w_ou.existCheckSujiDan(bfY, bfT)){
				bfk = k.w_ou;
				afk = k.w_ou;
				debug = true;
			}
			else if(k.w_to.existCheckSujiDan(bfY, bfT)){
				bfk = k.w_to;
				afk = k.w_to;
				debug = true;
			}
			else if(k.w_narikyo.existCheckSujiDan(bfY, bfT)){
				bfk = k.w_narikyo;
				afk = k.w_narikyo;
				debug = true;
			}
			else if(k.w_narikei.existCheckSujiDan(bfY, bfT)){
				bfk = k.w_narikei;
				afk = k.w_narikei;
				debug = true;
			}
			else if(k.w_narigin.existCheckSujiDan(bfY, bfT)){
				bfk = k.w_narigin;
				afk = k.w_narigin;
				debug = true;
			}
			else if(k.w_uma.existCheckSujiDan(bfY, bfT)){
				bfk = k.w_uma;
				afk = k.w_uma;
				debug = true;
			}
			else if(k.w_ryu.existCheckSujiDan(bfY, bfT)){
				bfk = k.w_ryu;
				afk = k.w_ryu;
				debug = true;
			}
			bfk.delSD(bfY, bfT);
			afk.addSD(afY, afT);
			if(b){
				if(k.w_fu.existCheckSujiDan(afY, afT)){
					k.w_fu.delSD(afY, afT);
					k.addFu_b();
				}
				else if(k.w_to.existCheckSujiDan(afY, afT)){
					k.w_to.delSD(afY, afT);
					k.addFu_b();
				}
				else if(k.w_kyo.existCheckSujiDan(afY, afT)){
					k.w_kyo.delSD(afY, afT);
					k.addKyo_b();
				}
				else if(k.w_narikyo.existCheckSujiDan(afY, afT)){
					k.w_narikyo.delSD(afY, afT);
					k.addKyo_b();
				}
				else if(k.w_kei.existCheckSujiDan(afY, afT)){
					k.w_kei.delSD(afY, afT);
					k.addKei_b();
				}
				else if(k.w_narikei.existCheckSujiDan(afY, afT)){
					k.w_narikei.delSD(afY, afT);
					k.addKei_b();
				}
				else if(k.w_gin.existCheckSujiDan(afY, afT)){
					k.w_gin.delSD(afY, afT);
					k.addGin_b();
				}
				else if(k.w_narigin.existCheckSujiDan(afY, afT)){
					k.w_narigin.delSD(afY, afT);
					k.addGin_b();
				}
				else if(k.w_kin.existCheckSujiDan(afY, afT)){
					k.w_kin.delSD(afY, afT);
					k.addKin_b();
				}
				else if(k.w_kaku.existCheckSujiDan(afY, afT)){
					k.w_kaku.delSD(afY, afT);
					k.addKaku_b();
				}
				else if(k.w_uma.existCheckSujiDan(afY, afT)){
					k.w_uma.delSD(afY, afT);
					k.addKaku_b();
				}
				else if(k.w_hisha.existCheckSujiDan(afY, afT)){
					k.w_hisha.delSD(afY, afT);
					k.addHisha_b();
				}
				else if(k.w_ryu.existCheckSujiDan(afY, afT)){
					k.w_ryu.delSD(afY, afT);
					k.addHisha_b();
				}
			}
			else{
				if(k.b_fu.existCheckSujiDan(afY, afT)){
					k.b_fu.delSD(afY, afT);
					k.addFu_w();
				}
				else if(k.b_to.existCheckSujiDan(afY, afT)){
					k.b_to.delSD(afY, afT);
					k.addFu_w();
				}
				else if(k.b_kyo.existCheckSujiDan(afY, afT)){
					k.b_kyo.delSD(afY, afT);
					k.addKyo_w();
				}
				else if(k.b_narikyo.existCheckSujiDan(afY, afT)){
					k.b_narikyo.delSD(afY, afT);
					k.addKyo_w();
				}
				else if(k.b_kei.existCheckSujiDan(afY, afT)){
					k.b_kei.delSD(afY, afT);
					k.addKei_w();
				}
				else if(k.b_narikei.existCheckSujiDan(afY, afT)){
					k.b_narikei.delSD(afY, afT);
					k.addKei_w();
				}
				else if(k.b_gin.existCheckSujiDan(afY, afT)){
					k.b_gin.delSD(afY, afT);
					k.addGin_w();
				}
				else if(k.b_narigin.existCheckSujiDan(afY, afT)){
					k.b_narigin.delSD(afY, afT);
					k.addGin_w();
				}
				else if(k.b_kin.existCheckSujiDan(afY, afT)){
					k.b_kin.delSD(afY, afT);
					k.addKin_w();
				}
				else if(k.b_kaku.existCheckSujiDan(afY, afT)){
					k.b_kaku.delSD(afY, afT);
					k.addKaku_w();
				}
				else if(k.b_uma.existCheckSujiDan(afY, afT)){
					k.b_uma.delSD(afY, afT);
					k.addKaku_w();
				}
				else if(k.b_hisha.existCheckSujiDan(afY, afT)){
					k.b_hisha.delSD(afY, afT);
					k.addHisha_w();
				}
				else if(k.b_ryu.existCheckSujiDan(afY, afT)){
					k.b_ryu.delSD(afY, afT);
					k.addHisha_w();
				}
			}
		}
		k.updAllKoma();
		k.updateHyoka();
	}
	
	/**
	 * ŐǖʂA߁AUSI̎wɂ
	 * @param orgK
	 * @param newK
	 * @param b
	 * @return
	 * @throws Exception
	 */
	public static final String getSasitaUSI(Kyokumen orgK, Kyokumen newK, boolean b) throws Exception {
		if(newK == null){
			return Resign;
		}
		String s = "";
		if (b) {
			if (orgK.getFuNum_b() > newK.getFuNum_b()
					|| orgK.getKyoNum_b() > newK.getKyoNum_b()
					|| orgK.getKeiNum_b() > newK.getKeiNum_b()
					|| orgK.getGinNum_b() > newK.getGinNum_b()
					|| orgK.getKinNum_b() > newK.getKinNum_b()
					|| orgK.getKakuNum_b() > newK.getKakuNum_b()
					|| orgK.getHishaNum_b() > newK.getHishaNum_b()) {
				// ł
				if (orgK.getFuNum_b() > newK.getFuNum_b()) {
					s = "P*";
					if (orgK.b_fu.ue != newK.b_fu.ue) {
						int p = orgK.b_fu.ue ^ newK.b_fu.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (orgK.b_fu.mid != newK.b_fu.mid) {
						int p = orgK.b_fu.mid ^ newK.b_fu.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = orgK.b_fu.sita ^ newK.b_fu.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
				} else if (orgK.getKyoNum_b() > newK.getKyoNum_b()) {
					s = "L*";
					if (orgK.b_kyo.ue != newK.b_kyo.ue) {
						int p = orgK.b_kyo.ue ^ newK.b_kyo.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (orgK.b_kyo.mid != newK.b_kyo.mid) {
						int p = orgK.b_kyo.mid ^ newK.b_kyo.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = orgK.b_kyo.sita ^ newK.b_kyo.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
				} else if (orgK.getKeiNum_b() > newK.getKeiNum_b()) {
					s = "N*";
					if (orgK.b_kei.ue != newK.b_kei.ue) {
						int p = orgK.b_kei.ue ^ newK.b_kei.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (orgK.b_kei.mid != newK.b_kei.mid) {
						int p = orgK.b_kei.mid ^ newK.b_kei.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = orgK.b_kei.sita ^ newK.b_kei.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
				} else if (orgK.getGinNum_b() > newK.getGinNum_b()) {
					s = "S*";
					if (orgK.b_gin.ue != newK.b_gin.ue) {
						int p = orgK.b_gin.ue ^ newK.b_gin.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (orgK.b_gin.mid != newK.b_gin.mid) {
						int p = orgK.b_gin.mid ^ newK.b_gin.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = orgK.b_gin.sita ^ newK.b_gin.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
				} else if (orgK.getKinNum_b() > newK.getKinNum_b()) {
					s = "G*";
					if (orgK.b_kin.ue != newK.b_kin.ue) {
						int p = orgK.b_kin.ue ^ newK.b_kin.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (orgK.b_kin.mid != newK.b_kin.mid) {
						int p = orgK.b_kin.mid ^ newK.b_kin.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = orgK.b_kin.sita ^ newK.b_kin.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
				} else if (orgK.getKakuNum_b() > newK.getKakuNum_b()) {
					s = "B*";
					if (orgK.b_kaku.ue != newK.b_kaku.ue) {
						int p = orgK.b_kaku.ue ^ newK.b_kaku.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (orgK.b_kaku.mid != newK.b_kaku.mid) {
						int p = orgK.b_kaku.mid ^ newK.b_kaku.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = orgK.b_kaku.sita ^ newK.b_kaku.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
				} else if (orgK.getHishaNum_b() > newK.getHishaNum_b()) {
					s = "R*";
					if (orgK.b_hisha.ue != newK.b_hisha.ue) {
						int p = orgK.b_hisha.ue ^ newK.b_hisha.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (orgK.b_hisha.mid != newK.b_hisha.mid) {
						int p = orgK.b_hisha.mid ^ newK.b_hisha.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = orgK.b_hisha.sita ^ newK.b_hisha.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
				}
			} else {
				// Տ̃R}𓮂

				// uv𓮂Ƃ
				if ((orgK.b_fu.ue ^ newK.b_fu.ue) > 0
						|| (orgK.b_fu.mid ^ newK.b_fu.mid) > 0
						|| (orgK.b_fu.sita ^ newK.b_fu.sita) > 0) {
					if (((orgK.b_fu.ue ^ newK.b_fu.ue) & orgK.b_fu.ue) > 0) {
						int p = (orgK.b_fu.ue ^ newK.b_fu.ue) & orgK.b_fu.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.b_fu.mid ^ newK.b_fu.mid) & orgK.b_fu.mid) > 0) {
						int p = (orgK.b_fu.mid ^ newK.b_fu.mid) & orgK.b_fu.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = (orgK.b_fu.sita ^ newK.b_fu.sita)
								& orgK.b_fu.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}

					if (((orgK.b_fu.ue ^ newK.b_fu.ue) & newK.b_fu.ue) > 0) {
						int p = (orgK.b_fu.ue ^ newK.b_fu.ue) & newK.b_fu.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.b_fu.mid ^ newK.b_fu.mid) & newK.b_fu.mid) > 0) {
						int p = (orgK.b_fu.mid ^ newK.b_fu.mid) & newK.b_fu.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else if (((orgK.b_fu.sita ^ newK.b_fu.sita) & newK.b_fu.sita) > 0) {
						int p = (orgK.b_fu.sita ^ newK.b_fu.sita)
								& newK.b_fu.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
					if (((orgK.b_to.ue ^ newK.b_to.ue) & newK.b_to.ue) > 0) {
						int p = (orgK.b_to.ue ^ newK.b_to.ue) & newK.b_to.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p) + "+";
					} else if (((orgK.b_to.mid ^ newK.b_to.mid) & newK.b_to.mid) > 0) {
						int p = (orgK.b_to.mid ^ newK.b_to.mid) & newK.b_to.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p) + "+";
					} else if (((orgK.b_to.sita ^ newK.b_to.sita) & newK.b_to.sita) > 0) {
						int p = (orgK.b_to.sita ^ newK.b_to.sita)
								& newK.b_to.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p) + "+";
					}
				}

				// uƁv𓮂Ƃ
				else if ((orgK.b_to.ue ^ newK.b_to.ue) > 0
						|| (orgK.b_to.mid ^ newK.b_to.mid) > 0
						|| (orgK.b_to.sita ^ newK.b_to.sita) > 0) {
					if (((orgK.b_to.ue ^ newK.b_to.ue) & orgK.b_to.ue) > 0) {
						int p = (orgK.b_to.ue ^ newK.b_to.ue) & orgK.b_to.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.b_to.mid ^ newK.b_to.mid) & orgK.b_to.mid) > 0) {
						int p = (orgK.b_to.mid ^ newK.b_to.mid) & orgK.b_to.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = (orgK.b_to.sita ^ newK.b_to.sita)
								& orgK.b_to.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}

					if (((orgK.b_to.ue ^ newK.b_to.ue) & newK.b_to.ue) > 0) {
						int p = (orgK.b_to.ue ^ newK.b_to.ue) & newK.b_to.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.b_to.mid ^ newK.b_to.mid) & newK.b_to.mid) > 0) {
						int p = (orgK.b_to.mid ^ newK.b_to.mid) & newK.b_to.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else if (((orgK.b_to.sita ^ newK.b_to.sita) & newK.b_to.sita) > 0) {
						int p = (orgK.b_to.sita ^ newK.b_to.sita)
								& newK.b_to.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
				}

				// 𓮂Ƃ
				else if ((orgK.b_kyo.ue ^ newK.b_kyo.ue) > 0
						|| (orgK.b_kyo.mid ^ newK.b_kyo.mid) > 0
						|| (orgK.b_kyo.sita ^ newK.b_kyo.sita) > 0) {
					if (((orgK.b_kyo.ue ^ newK.b_kyo.ue) & orgK.b_kyo.ue) > 0) {
						int p = (orgK.b_kyo.ue ^ newK.b_kyo.ue) & orgK.b_kyo.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.b_kyo.mid ^ newK.b_kyo.mid) & orgK.b_kyo.mid) > 0) {
						int p = (orgK.b_kyo.mid ^ newK.b_kyo.mid)
								& orgK.b_kyo.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = (orgK.b_kyo.sita ^ newK.b_kyo.sita)
								& orgK.b_kyo.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}

					if (((orgK.b_kyo.ue ^ newK.b_kyo.ue) & newK.b_kyo.ue) > 0) {
						int p = (orgK.b_kyo.ue ^ newK.b_kyo.ue) & newK.b_kyo.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.b_kyo.mid ^ newK.b_kyo.mid) & newK.b_kyo.mid) > 0) {
						int p = (orgK.b_kyo.mid ^ newK.b_kyo.mid)
								& newK.b_kyo.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else if (((orgK.b_kyo.sita ^ newK.b_kyo.sita) & newK.b_kyo.sita) > 0) {
						int p = (orgK.b_kyo.sita ^ newK.b_kyo.sita)
								& newK.b_kyo.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
					if (((orgK.b_narikyo.ue ^ newK.b_narikyo.ue) & newK.b_narikyo.ue) > 0) {
						int p = (orgK.b_narikyo.ue ^ newK.b_narikyo.ue)
								& newK.b_narikyo.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p) + "+";
					} else if (((orgK.b_narikyo.mid ^ newK.b_narikyo.mid) & newK.b_narikyo.mid) > 0) {
						int p = (orgK.b_narikyo.mid ^ newK.b_narikyo.mid)
								& newK.b_narikyo.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p) + "+";
					} else if (((orgK.b_narikyo.sita ^ newK.b_narikyo.sita) & newK.b_narikyo.sita) > 0) {
						int p = (orgK.b_narikyo.sita ^ newK.b_narikyo.sita)
								& newK.b_narikyo.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p) + "+";
					}
				}
				// uv𓮂Ƃ
				else if ((orgK.b_narikyo.ue ^ newK.b_narikyo.ue) > 0
						|| (orgK.b_narikyo.mid ^ newK.b_narikyo.mid) > 0
						|| (orgK.b_narikyo.sita ^ newK.b_narikyo.sita) > 0) {
					if (((orgK.b_narikyo.ue ^ newK.b_narikyo.ue) & orgK.b_narikyo.ue) > 0) {
						int p = (orgK.b_narikyo.ue ^ newK.b_narikyo.ue)
								& orgK.b_narikyo.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.b_narikyo.mid ^ newK.b_narikyo.mid) & orgK.b_narikyo.mid) > 0) {
						int p = (orgK.b_narikyo.mid ^ newK.b_narikyo.mid)
								& orgK.b_narikyo.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = (orgK.b_narikyo.sita ^ newK.b_narikyo.sita)
								& orgK.b_narikyo.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}

					if (((orgK.b_narikyo.ue ^ newK.b_narikyo.ue) & newK.b_narikyo.ue) > 0) {
						int p = (orgK.b_narikyo.ue ^ newK.b_narikyo.ue)
								& newK.b_narikyo.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.b_narikyo.mid ^ newK.b_narikyo.mid) & newK.b_narikyo.mid) > 0) {
						int p = (orgK.b_narikyo.mid ^ newK.b_narikyo.mid)
								& newK.b_narikyo.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else if (((orgK.b_narikyo.sita ^ newK.b_narikyo.sita) & newK.b_narikyo.sita) > 0) {
						int p = (orgK.b_narikyo.sita ^ newK.b_narikyo.sita)
								& newK.b_narikyo.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
				}
				// j𓮂Ƃ
				else if ((orgK.b_kei.ue ^ newK.b_kei.ue) > 0
						|| (orgK.b_kei.mid ^ newK.b_kei.mid) > 0
						|| (orgK.b_kei.sita ^ newK.b_kei.sita) > 0) {
					if (((orgK.b_kei.ue ^ newK.b_kei.ue) & orgK.b_kei.ue) > 0) {
						int p = (orgK.b_kei.ue ^ newK.b_kei.ue) & orgK.b_kei.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.b_kei.mid ^ newK.b_kei.mid) & orgK.b_kei.mid) > 0) {
						int p = (orgK.b_kei.mid ^ newK.b_kei.mid)
								& orgK.b_kei.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = (orgK.b_kei.sita ^ newK.b_kei.sita)
								& orgK.b_kei.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}

					if (((orgK.b_kei.ue ^ newK.b_kei.ue) & newK.b_kei.ue) > 0) {
						int p = (orgK.b_kei.ue ^ newK.b_kei.ue) & newK.b_kei.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.b_kei.mid ^ newK.b_kei.mid) & newK.b_kei.mid) > 0) {
						int p = (orgK.b_kei.mid ^ newK.b_kei.mid)
								& newK.b_kei.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else if (((orgK.b_kei.sita ^ newK.b_kei.sita) & newK.b_kei.sita) > 0) {
						int p = (orgK.b_kei.sita ^ newK.b_kei.sita)
								& newK.b_kei.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
					if (((orgK.b_narikei.ue ^ newK.b_narikei.ue) & newK.b_narikei.ue) > 0) {
						int p = (orgK.b_narikei.ue ^ newK.b_narikei.ue)
								& newK.b_narikei.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p) + "+";
					} else if (((orgK.b_narikei.mid ^ newK.b_narikei.mid) & newK.b_narikei.mid) > 0) {
						int p = (orgK.b_narikei.mid ^ newK.b_narikei.mid)
								& newK.b_narikei.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p) + "+";
					} else if (((orgK.b_narikei.sita ^ newK.b_narikei.sita) & newK.b_narikei.sita) > 0) {
						int p = (orgK.b_narikei.sita ^ newK.b_narikei.sita)
								& newK.b_narikei.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p) + "+";
					}
				}
				// ujv𓮂Ƃ
				else if ((orgK.b_narikei.ue ^ newK.b_narikei.ue) > 0
						|| (orgK.b_narikei.mid ^ newK.b_narikei.mid) > 0
						|| (orgK.b_narikei.sita ^ newK.b_narikei.sita) > 0) {
					if (((orgK.b_narikei.ue ^ newK.b_narikei.ue) & orgK.b_narikei.ue) > 0) {
						int p = (orgK.b_narikei.ue ^ newK.b_narikei.ue)
								& orgK.b_narikei.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.b_narikei.mid ^ newK.b_narikei.mid) & orgK.b_narikei.mid) > 0) {
						int p = (orgK.b_narikei.mid ^ newK.b_narikei.mid)
								& orgK.b_narikei.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = (orgK.b_narikei.sita ^ newK.b_narikei.sita)
								& orgK.b_narikei.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}

					if (((orgK.b_narikei.ue ^ newK.b_narikei.ue) & newK.b_narikei.ue) > 0) {
						int p = (orgK.b_narikei.ue ^ newK.b_narikei.ue)
								& newK.b_narikei.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.b_narikei.mid ^ newK.b_narikei.mid) & newK.b_narikei.mid) > 0) {
						int p = (orgK.b_narikei.mid ^ newK.b_narikei.mid)
								& newK.b_narikei.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else if (((orgK.b_narikei.sita ^ newK.b_narikei.sita) & newK.b_narikei.sita) > 0) {
						int p = (orgK.b_narikei.sita ^ newK.b_narikei.sita)
								& newK.b_narikei.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
				}
				// 𓮂Ƃ
				else if ((orgK.b_gin.ue ^ newK.b_gin.ue) > 0
						|| (orgK.b_gin.mid ^ newK.b_gin.mid) > 0
						|| (orgK.b_gin.sita ^ newK.b_gin.sita) > 0) {
					if (((orgK.b_gin.ue ^ newK.b_gin.ue) & orgK.b_gin.ue) > 0) {
						int p = (orgK.b_gin.ue ^ newK.b_gin.ue) & orgK.b_gin.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.b_gin.mid ^ newK.b_gin.mid) & orgK.b_gin.mid) > 0) {
						int p = (orgK.b_gin.mid ^ newK.b_gin.mid)
								& orgK.b_gin.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = (orgK.b_gin.sita ^ newK.b_gin.sita)
								& orgK.b_gin.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}

					if (((orgK.b_gin.ue ^ newK.b_gin.ue) & newK.b_gin.ue) > 0) {
						int p = (orgK.b_gin.ue ^ newK.b_gin.ue) & newK.b_gin.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.b_gin.mid ^ newK.b_gin.mid) & newK.b_gin.mid) > 0) {
						int p = (orgK.b_gin.mid ^ newK.b_gin.mid)
								& newK.b_gin.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else if (((orgK.b_gin.sita ^ newK.b_gin.sita) & newK.b_gin.sita) > 0) {
						int p = (orgK.b_gin.sita ^ newK.b_gin.sita)
								& newK.b_gin.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
					if (((orgK.b_narigin.ue ^ newK.b_narigin.ue) & newK.b_narigin.ue) > 0) {
						int p = (orgK.b_narigin.ue ^ newK.b_narigin.ue)
								& newK.b_narigin.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p) + "+";
					} else if (((orgK.b_narigin.mid ^ newK.b_narigin.mid) & newK.b_narigin.mid) > 0) {
						int p = (orgK.b_narigin.mid ^ newK.b_narigin.mid)
								& newK.b_narigin.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p) + "+";
					} else if (((orgK.b_narigin.sita ^ newK.b_narigin.sita) & newK.b_narigin.sita) > 0) {
						int p = (orgK.b_narigin.sita ^ newK.b_narigin.sita)
								& newK.b_narigin.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p) + "+";
					}
				}
				// uv𓮂Ƃ
				else if ((orgK.b_narigin.ue ^ newK.b_narigin.ue) > 0
						|| (orgK.b_narigin.mid ^ newK.b_narigin.mid) > 0
						|| (orgK.b_narigin.sita ^ newK.b_narigin.sita) > 0) {
					if (((orgK.b_narigin.ue ^ newK.b_narigin.ue) & orgK.b_narigin.ue) > 0) {
						int p = (orgK.b_narigin.ue ^ newK.b_narigin.ue)
								& orgK.b_narigin.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.b_narigin.mid ^ newK.b_narigin.mid) & orgK.b_narigin.mid) > 0) {
						int p = (orgK.b_narigin.mid ^ newK.b_narigin.mid)
								& orgK.b_narigin.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = (orgK.b_narigin.sita ^ newK.b_narigin.sita)
								& orgK.b_narigin.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}

					if (((orgK.b_narigin.ue ^ newK.b_narigin.ue) & newK.b_narigin.ue) > 0) {
						int p = (orgK.b_narigin.ue ^ newK.b_narigin.ue)
								& newK.b_narigin.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.b_narigin.mid ^ newK.b_narigin.mid) & newK.b_narigin.mid) > 0) {
						int p = (orgK.b_narigin.mid ^ newK.b_narigin.mid)
								& newK.b_narigin.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else if (((orgK.b_narigin.sita ^ newK.b_narigin.sita) & newK.b_narigin.sita) > 0) {
						int p = (orgK.b_narigin.sita ^ newK.b_narigin.sita)
								& newK.b_narigin.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
				}

				// uv𓮂Ƃ
				else if ((orgK.b_kin.ue ^ newK.b_kin.ue) > 0
						|| (orgK.b_kin.mid ^ newK.b_kin.mid) > 0
						|| (orgK.b_kin.sita ^ newK.b_kin.sita) > 0) {
					if (((orgK.b_kin.ue ^ newK.b_kin.ue) & orgK.b_kin.ue) > 0) {
						int p = (orgK.b_kin.ue ^ newK.b_kin.ue) & orgK.b_kin.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.b_kin.mid ^ newK.b_kin.mid) & orgK.b_kin.mid) > 0) {
						int p = (orgK.b_kin.mid ^ newK.b_kin.mid)
								& orgK.b_kin.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = (orgK.b_kin.sita ^ newK.b_kin.sita)
								& orgK.b_kin.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}

					if (((orgK.b_kin.ue ^ newK.b_kin.ue) & newK.b_kin.ue) > 0) {
						int p = (orgK.b_kin.ue ^ newK.b_kin.ue) & newK.b_kin.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.b_kin.mid ^ newK.b_kin.mid) & newK.b_kin.mid) > 0) {
						int p = (orgK.b_kin.mid ^ newK.b_kin.mid)
								& newK.b_kin.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else if (((orgK.b_kin.sita ^ newK.b_kin.sita) & newK.b_kin.sita) > 0) {
						int p = (orgK.b_kin.sita ^ newK.b_kin.sita)
								& newK.b_kin.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
				}

				// p𓮂Ƃ
				else if ((orgK.b_kaku.ue ^ newK.b_kaku.ue) > 0
						|| (orgK.b_kaku.mid ^ newK.b_kaku.mid) > 0
						|| (orgK.b_kaku.sita ^ newK.b_kaku.sita) > 0) {
					if (((orgK.b_kaku.ue ^ newK.b_kaku.ue) & orgK.b_kaku.ue) > 0) {
						int p = (orgK.b_kaku.ue ^ newK.b_kaku.ue)
								& orgK.b_kaku.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.b_kaku.mid ^ newK.b_kaku.mid) & orgK.b_kaku.mid) > 0) {
						int p = (orgK.b_kaku.mid ^ newK.b_kaku.mid)
								& orgK.b_kaku.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = (orgK.b_kaku.sita ^ newK.b_kaku.sita)
								& orgK.b_kaku.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}

					if (((orgK.b_kaku.ue ^ newK.b_kaku.ue) & newK.b_kaku.ue) > 0) {
						int p = (orgK.b_kaku.ue ^ newK.b_kaku.ue)
								& newK.b_kaku.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.b_kaku.mid ^ newK.b_kaku.mid) & newK.b_kaku.mid) > 0) {
						int p = (orgK.b_kaku.mid ^ newK.b_kaku.mid)
								& newK.b_kaku.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else if (((orgK.b_kaku.sita ^ newK.b_kaku.sita) & newK.b_kaku.sita) > 0) {
						int p = (orgK.b_kaku.sita ^ newK.b_kaku.sita)
								& newK.b_kaku.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
					if (((orgK.b_uma.ue ^ newK.b_uma.ue) & newK.b_uma.ue) > 0) {
						int p = (orgK.b_uma.ue ^ newK.b_uma.ue) & newK.b_uma.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p) + "+";
					} else if (((orgK.b_uma.mid ^ newK.b_uma.mid) & newK.b_uma.mid) > 0) {
						int p = (orgK.b_uma.mid ^ newK.b_uma.mid)
								& newK.b_uma.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p) + "+";
					} else if (((orgK.b_uma.sita ^ newK.b_uma.sita) & newK.b_uma.sita) > 0) {
						int p = (orgK.b_uma.sita ^ newK.b_uma.sita)
								& newK.b_uma.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p) + "+";
					}
				}
				// unv𓮂Ƃ
				else if ((orgK.b_uma.ue ^ newK.b_uma.ue) > 0
						|| (orgK.b_uma.mid ^ newK.b_uma.mid) > 0
						|| (orgK.b_uma.sita ^ newK.b_uma.sita) > 0) {
					if (((orgK.b_uma.ue ^ newK.b_uma.ue) & orgK.b_uma.ue) > 0) {
						int p = (orgK.b_uma.ue ^ newK.b_uma.ue) & orgK.b_uma.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.b_uma.mid ^ newK.b_uma.mid) & orgK.b_uma.mid) > 0) {
						int p = (orgK.b_uma.mid ^ newK.b_uma.mid)
								& orgK.b_uma.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = (orgK.b_uma.sita ^ newK.b_uma.sita)
								& orgK.b_uma.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}

					if (((orgK.b_uma.ue ^ newK.b_uma.ue) & newK.b_uma.ue) > 0) {
						int p = (orgK.b_uma.ue ^ newK.b_uma.ue) & newK.b_uma.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.b_uma.mid ^ newK.b_uma.mid) & newK.b_uma.mid) > 0) {
						int p = (orgK.b_uma.mid ^ newK.b_uma.mid)
								& newK.b_uma.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else if (((orgK.b_uma.sita ^ newK.b_uma.sita) & newK.b_uma.sita) > 0) {
						int p = (orgK.b_uma.sita ^ newK.b_uma.sita)
								& newK.b_uma.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
				}

				// Ԃ𓮂Ƃ
				else if ((orgK.b_hisha.ue ^ newK.b_hisha.ue) > 0
						|| (orgK.b_hisha.mid ^ newK.b_hisha.mid) > 0
						|| (orgK.b_hisha.sita ^ newK.b_hisha.sita) > 0) {
					if (((orgK.b_hisha.ue ^ newK.b_hisha.ue) & orgK.b_hisha.ue) > 0) {
						int p = (orgK.b_hisha.ue ^ newK.b_hisha.ue)
								& orgK.b_hisha.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.b_hisha.mid ^ newK.b_hisha.mid) & orgK.b_hisha.mid) > 0) {
						int p = (orgK.b_hisha.mid ^ newK.b_hisha.mid)
								& orgK.b_hisha.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = (orgK.b_hisha.sita ^ newK.b_hisha.sita)
								& orgK.b_hisha.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}

					if (((orgK.b_hisha.ue ^ newK.b_hisha.ue) & newK.b_hisha.ue) > 0) {
						int p = (orgK.b_hisha.ue ^ newK.b_hisha.ue)
								& newK.b_hisha.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.b_hisha.mid ^ newK.b_hisha.mid) & newK.b_hisha.mid) > 0) {
						int p = (orgK.b_hisha.mid ^ newK.b_hisha.mid)
								& newK.b_hisha.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else if (((orgK.b_hisha.sita ^ newK.b_hisha.sita) & newK.b_hisha.sita) > 0) {
						int p = (orgK.b_hisha.sita ^ newK.b_hisha.sita)
								& newK.b_hisha.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
					if (((orgK.b_ryu.ue ^ newK.b_ryu.ue) & newK.b_ryu.ue) > 0) {
						int p = (orgK.b_ryu.ue ^ newK.b_ryu.ue) & newK.b_ryu.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p) + "+";
					} else if (((orgK.b_ryu.mid ^ newK.b_ryu.mid) & newK.b_ryu.mid) > 0) {
						int p = (orgK.b_ryu.mid ^ newK.b_ryu.mid)
								& newK.b_ryu.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p) + "+";
					} else if (((orgK.b_ryu.sita ^ newK.b_ryu.sita) & newK.b_ryu.sita) > 0) {
						int p = (orgK.b_ryu.sita ^ newK.b_ryu.sita)
								& newK.b_ryu.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p) + "+";
					}
				}
				// uv𓮂Ƃ
				else if ((orgK.b_ryu.ue ^ newK.b_ryu.ue) > 0
						|| (orgK.b_ryu.mid ^ newK.b_ryu.mid) > 0
						|| (orgK.b_ryu.sita ^ newK.b_ryu.sita) > 0) {
					if (((orgK.b_ryu.ue ^ newK.b_ryu.ue) & orgK.b_ryu.ue) > 0) {
						int p = (orgK.b_ryu.ue ^ newK.b_ryu.ue) & orgK.b_ryu.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.b_ryu.mid ^ newK.b_ryu.mid) & orgK.b_ryu.mid) > 0) {
						int p = (orgK.b_ryu.mid ^ newK.b_ryu.mid)
								& orgK.b_ryu.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = (orgK.b_ryu.sita ^ newK.b_ryu.sita)
								& orgK.b_ryu.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}

					if (((orgK.b_ryu.ue ^ newK.b_ryu.ue) & newK.b_ryu.ue) > 0) {
						int p = (orgK.b_ryu.ue ^ newK.b_ryu.ue) & newK.b_ryu.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.b_ryu.mid ^ newK.b_ryu.mid) & newK.b_ryu.mid) > 0) {
						int p = (orgK.b_ryu.mid ^ newK.b_ryu.mid)
								& newK.b_ryu.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else if (((orgK.b_ryu.sita ^ newK.b_ryu.sita) & newK.b_ryu.sita) > 0) {
						int p = (orgK.b_ryu.sita ^ newK.b_ryu.sita)
								& newK.b_ryu.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
				}

				// uv𓮂Ƃ
				else if ((orgK.b_ou.ue ^ newK.b_ou.ue) > 0
						|| (orgK.b_ou.mid ^ newK.b_ou.mid) > 0
						|| (orgK.b_ou.sita ^ newK.b_ou.sita) > 0) {
					if (((orgK.b_ou.ue ^ newK.b_ou.ue) & orgK.b_ou.ue) > 0) {
						int p = (orgK.b_ou.ue ^ newK.b_ou.ue) & orgK.b_ou.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.b_ou.mid ^ newK.b_ou.mid) & orgK.b_ou.mid) > 0) {
						int p = (orgK.b_ou.mid ^ newK.b_ou.mid) & orgK.b_ou.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = (orgK.b_ou.sita ^ newK.b_ou.sita)
								& orgK.b_ou.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}

					if (((orgK.b_ou.ue ^ newK.b_ou.ue) & newK.b_ou.ue) > 0) {
						int p = (orgK.b_ou.ue ^ newK.b_ou.ue) & newK.b_ou.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.b_ou.mid ^ newK.b_ou.mid) & newK.b_ou.mid) > 0) {
						int p = (orgK.b_ou.mid ^ newK.b_ou.mid) & newK.b_ou.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else if (((orgK.b_ou.sita ^ newK.b_ou.sita) & newK.b_ou.sita) > 0) {
						int p = (orgK.b_ou.sita ^ newK.b_ou.sita)
								& newK.b_ou.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
				}
			}
		} else {
			if (orgK.getFuNum_w() > newK.getFuNum_w()
					|| orgK.getKyoNum_w() > newK.getKyoNum_w()
					|| orgK.getKeiNum_w() > newK.getKeiNum_w()
					|| orgK.getGinNum_w() > newK.getGinNum_w()
					|| orgK.getKinNum_w() > newK.getKinNum_w()
					|| orgK.getKakuNum_w() > newK.getKakuNum_w()
					|| orgK.getHishaNum_w() > newK.getHishaNum_w()) {
				// ł
				if (orgK.getFuNum_w() > newK.getFuNum_w()) {
					s = "P*";
					if (orgK.w_fu.ue != newK.w_fu.ue) {
						int p = orgK.w_fu.ue ^ newK.w_fu.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (orgK.w_fu.mid != newK.w_fu.mid) {
						int p = orgK.w_fu.mid ^ newK.w_fu.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = orgK.w_fu.sita ^ newK.w_fu.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
				} else if (orgK.getKyoNum_w() > newK.getKyoNum_w()) {
					s = "L*";
					if (orgK.w_kyo.ue != newK.w_kyo.ue) {
						int p = orgK.w_kyo.ue ^ newK.w_kyo.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (orgK.w_kyo.mid != newK.w_kyo.mid) {
						int p = orgK.w_kyo.mid ^ newK.w_kyo.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = orgK.w_kyo.sita ^ newK.w_kyo.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
				} else if (orgK.getKeiNum_w() > newK.getKeiNum_w()) {
					s = "N*";
					if (orgK.w_kei.ue != newK.w_kei.ue) {
						int p = orgK.w_kei.ue ^ newK.w_kei.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (orgK.w_kei.mid != newK.w_kei.mid) {
						int p = orgK.w_kei.mid ^ newK.w_kei.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = orgK.w_kei.sita ^ newK.w_kei.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
				} else if (orgK.getGinNum_w() > newK.getGinNum_w()) {
					s = "S*";
					if (orgK.w_gin.ue != newK.w_gin.ue) {
						int p = orgK.w_gin.ue ^ newK.w_gin.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (orgK.w_gin.mid != newK.w_gin.mid) {
						int p = orgK.w_gin.mid ^ newK.w_gin.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = orgK.w_gin.sita ^ newK.w_gin.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
				} else if (orgK.getKinNum_w() > newK.getKinNum_w()) {
					s = "G*";
					if (orgK.w_kin.ue != newK.w_kin.ue) {
						int p = orgK.w_kin.ue ^ newK.w_kin.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (orgK.w_kin.mid != newK.w_kin.mid) {
						int p = orgK.w_kin.mid ^ newK.w_kin.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = orgK.w_kin.sita ^ newK.w_kin.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
				} else if (orgK.getKakuNum_w() > newK.getKakuNum_w()) {
					s = "B*";
					if (orgK.w_kaku.ue != newK.w_kaku.ue) {
						int p = orgK.w_kaku.ue ^ newK.w_kaku.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (orgK.w_kaku.mid != newK.w_kaku.mid) {
						int p = orgK.w_kaku.mid ^ newK.w_kaku.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = orgK.w_kaku.sita ^ newK.w_kaku.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
				} else if (orgK.getHishaNum_w() > newK.getHishaNum_w()) {
					s = "R*";
					if (orgK.w_hisha.ue != newK.w_hisha.ue) {
						int p = orgK.w_hisha.ue ^ newK.w_hisha.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (orgK.w_hisha.mid != newK.w_hisha.mid) {
						int p = orgK.w_hisha.mid ^ newK.w_hisha.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = orgK.w_hisha.sita ^ newK.w_hisha.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
				}
			} else {
				// Տ̃R}𓮂

				// uv𓮂Ƃ
				if ((orgK.w_fu.ue ^ newK.w_fu.ue) > 0
						|| (orgK.w_fu.mid ^ newK.w_fu.mid) > 0
						|| (orgK.w_fu.sita ^ newK.w_fu.sita) > 0) {
					if (((orgK.w_fu.ue ^ newK.w_fu.ue) & orgK.w_fu.ue) > 0) {
						int p = (orgK.w_fu.ue ^ newK.w_fu.ue) & orgK.w_fu.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.w_fu.mid ^ newK.w_fu.mid) & orgK.w_fu.mid) > 0) {
						int p = (orgK.w_fu.mid ^ newK.w_fu.mid) & orgK.w_fu.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = (orgK.w_fu.sita ^ newK.w_fu.sita)
								& orgK.w_fu.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}

					if (((orgK.w_fu.ue ^ newK.w_fu.ue) & newK.w_fu.ue) > 0) {
						int p = (orgK.w_fu.ue ^ newK.w_fu.ue) & newK.w_fu.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.w_fu.mid ^ newK.w_fu.mid) & newK.w_fu.mid) > 0) {
						int p = (orgK.w_fu.mid ^ newK.w_fu.mid) & newK.w_fu.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else if (((orgK.w_fu.sita ^ newK.w_fu.sita) & newK.w_fu.sita) > 0) {
						int p = (orgK.w_fu.sita ^ newK.w_fu.sita)
								& newK.w_fu.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
					if (((orgK.w_to.ue ^ newK.w_to.ue) & newK.w_to.ue) > 0) {
						int p = (orgK.w_to.ue ^ newK.w_to.ue) & newK.w_to.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p) + "+";
					} else if (((orgK.w_to.mid ^ newK.w_to.mid) & newK.w_to.mid) > 0) {
						int p = (orgK.w_to.mid ^ newK.w_to.mid) & newK.w_to.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p) + "+";
					} else if (((orgK.w_to.sita ^ newK.w_to.sita) & newK.w_to.sita) > 0) {
						int p = (orgK.w_to.sita ^ newK.w_to.sita)
								& newK.w_to.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p) + "+";
					}
				}

				// uƁv𓮂Ƃ
				else if ((orgK.w_to.ue ^ newK.w_to.ue) > 0
						|| (orgK.w_to.mid ^ newK.w_to.mid) > 0
						|| (orgK.w_to.sita ^ newK.w_to.sita) > 0) {
					if (((orgK.w_to.ue ^ newK.w_to.ue) & orgK.w_to.ue) > 0) {
						int p = (orgK.w_to.ue ^ newK.w_to.ue) & orgK.w_to.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.w_to.mid ^ newK.w_to.mid) & orgK.w_to.mid) > 0) {
						int p = (orgK.w_to.mid ^ newK.w_to.mid) & orgK.w_to.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = (orgK.w_to.sita ^ newK.w_to.sita)
								& orgK.w_to.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}

					if (((orgK.w_to.ue ^ newK.w_to.ue) & newK.w_to.ue) > 0) {
						int p = (orgK.w_to.ue ^ newK.w_to.ue) & newK.w_to.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.w_to.mid ^ newK.w_to.mid) & newK.w_to.mid) > 0) {
						int p = (orgK.w_to.mid ^ newK.w_to.mid) & newK.w_to.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else if (((orgK.w_to.sita ^ newK.w_to.sita) & newK.w_to.sita) > 0) {
						int p = (orgK.w_to.sita ^ newK.w_to.sita)
								& newK.w_to.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
				}

				// 𓮂Ƃ
				else if ((orgK.w_kyo.ue ^ newK.w_kyo.ue) > 0
						|| (orgK.w_kyo.mid ^ newK.w_kyo.mid) > 0
						|| (orgK.w_kyo.sita ^ newK.w_kyo.sita) > 0) {
					if (((orgK.w_kyo.ue ^ newK.w_kyo.ue) & orgK.w_kyo.ue) > 0) {
						int p = (orgK.w_kyo.ue ^ newK.w_kyo.ue) & orgK.w_kyo.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.w_kyo.mid ^ newK.w_kyo.mid) & orgK.w_kyo.mid) > 0) {
						int p = (orgK.w_kyo.mid ^ newK.w_kyo.mid)
								& orgK.w_kyo.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = (orgK.w_kyo.sita ^ newK.w_kyo.sita)
								& orgK.w_kyo.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}

					if (((orgK.w_kyo.ue ^ newK.w_kyo.ue) & newK.w_kyo.ue) > 0) {
						int p = (orgK.w_kyo.ue ^ newK.w_kyo.ue) & newK.w_kyo.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.w_kyo.mid ^ newK.w_kyo.mid) & newK.w_kyo.mid) > 0) {
						int p = (orgK.w_kyo.mid ^ newK.w_kyo.mid)
								& newK.w_kyo.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else if (((orgK.w_kyo.sita ^ newK.w_kyo.sita) & newK.w_kyo.sita) > 0) {
						int p = (orgK.w_kyo.sita ^ newK.w_kyo.sita)
								& newK.w_kyo.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
					if (((orgK.w_narikyo.ue ^ newK.w_narikyo.ue) & newK.w_narikyo.ue) > 0) {
						int p = (orgK.w_narikyo.ue ^ newK.w_narikyo.ue)
								& newK.w_narikyo.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p) + "+";
					} else if (((orgK.w_narikyo.mid ^ newK.w_narikyo.mid) & newK.w_narikyo.mid) > 0) {
						int p = (orgK.w_narikyo.mid ^ newK.w_narikyo.mid)
								& newK.w_narikyo.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p) + "+";
					} else if (((orgK.w_narikyo.sita ^ newK.w_narikyo.sita) & newK.w_narikyo.sita) > 0) {
						int p = (orgK.w_narikyo.sita ^ newK.w_narikyo.sita)
								& newK.w_narikyo.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p) + "+";
					}
				}
				// uv𓮂Ƃ
				else if ((orgK.w_narikyo.ue ^ newK.w_narikyo.ue) > 0
						|| (orgK.w_narikyo.mid ^ newK.w_narikyo.mid) > 0
						|| (orgK.w_narikyo.sita ^ newK.w_narikyo.sita) > 0) {
					if (((orgK.w_narikyo.ue ^ newK.w_narikyo.ue) & orgK.w_narikyo.ue) > 0) {
						int p = (orgK.w_narikyo.ue ^ newK.w_narikyo.ue)
								& orgK.w_narikyo.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.w_narikyo.mid ^ newK.w_narikyo.mid) & orgK.w_narikyo.mid) > 0) {
						int p = (orgK.w_narikyo.mid ^ newK.w_narikyo.mid)
								& orgK.w_narikyo.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = (orgK.w_narikyo.sita ^ newK.w_narikyo.sita)
								& orgK.w_narikyo.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}

					if (((orgK.w_narikyo.ue ^ newK.w_narikyo.ue) & newK.w_narikyo.ue) > 0) {
						int p = (orgK.w_narikyo.ue ^ newK.w_narikyo.ue)
								& newK.w_narikyo.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.w_narikyo.mid ^ newK.w_narikyo.mid) & newK.w_narikyo.mid) > 0) {
						int p = (orgK.w_narikyo.mid ^ newK.w_narikyo.mid)
								& newK.w_narikyo.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else if (((orgK.w_narikyo.sita ^ newK.w_narikyo.sita) & newK.w_narikyo.sita) > 0) {
						int p = (orgK.w_narikyo.sita ^ newK.w_narikyo.sita)
								& newK.w_narikyo.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
				}
				// j𓮂Ƃ
				else if ((orgK.w_kei.ue ^ newK.w_kei.ue) > 0
						|| (orgK.w_kei.mid ^ newK.w_kei.mid) > 0
						|| (orgK.w_kei.sita ^ newK.w_kei.sita) > 0) {
					if (((orgK.w_kei.ue ^ newK.w_kei.ue) & orgK.w_kei.ue) > 0) {
						int p = (orgK.w_kei.ue ^ newK.w_kei.ue) & orgK.w_kei.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.w_kei.mid ^ newK.w_kei.mid) & orgK.w_kei.mid) > 0) {
						int p = (orgK.w_kei.mid ^ newK.w_kei.mid)
								& orgK.w_kei.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = (orgK.w_kei.sita ^ newK.w_kei.sita)
								& orgK.w_kei.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}

					if (((orgK.w_kei.ue ^ newK.w_kei.ue) & newK.w_kei.ue) > 0) {
						int p = (orgK.w_kei.ue ^ newK.w_kei.ue) & newK.w_kei.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.w_kei.mid ^ newK.w_kei.mid) & newK.w_kei.mid) > 0) {
						int p = (orgK.w_kei.mid ^ newK.w_kei.mid)
								& newK.w_kei.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else if (((orgK.w_kei.sita ^ newK.w_kei.sita) & newK.w_kei.sita) > 0) {
						int p = (orgK.w_kei.sita ^ newK.w_kei.sita)
								& newK.w_kei.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
					if (((orgK.w_narikei.ue ^ newK.w_narikei.ue) & newK.w_narikei.ue) > 0) {
						int p = (orgK.w_narikei.ue ^ newK.w_narikei.ue)
								& newK.w_narikei.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p) + "+";
					} else if (((orgK.w_narikei.mid ^ newK.w_narikei.mid) & newK.w_narikei.mid) > 0) {
						int p = (orgK.w_narikei.mid ^ newK.w_narikei.mid)
								& newK.w_narikei.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p) + "+";
					} else if (((orgK.w_narikei.sita ^ newK.w_narikei.sita) & newK.w_narikei.sita) > 0) {
						int p = (orgK.w_narikei.sita ^ newK.w_narikei.sita)
								& newK.w_narikei.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p) + "+";
					}
				}
				// ujv𓮂Ƃ
				else if ((orgK.w_narikei.ue ^ newK.w_narikei.ue) > 0
						|| (orgK.w_narikei.mid ^ newK.w_narikei.mid) > 0
						|| (orgK.w_narikei.sita ^ newK.w_narikei.sita) > 0) {
					if (((orgK.w_narikei.ue ^ newK.w_narikei.ue) & orgK.w_narikei.ue) > 0) {
						int p = (orgK.w_narikei.ue ^ newK.w_narikei.ue)
								& orgK.w_narikei.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.w_narikei.mid ^ newK.w_narikei.mid) & orgK.w_narikei.mid) > 0) {
						int p = (orgK.w_narikei.mid ^ newK.w_narikei.mid)
								& orgK.w_narikei.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = (orgK.w_narikei.sita ^ newK.w_narikei.sita)
								& orgK.w_narikei.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}

					if (((orgK.w_narikei.ue ^ newK.w_narikei.ue) & newK.w_narikei.ue) > 0) {
						int p = (orgK.w_narikei.ue ^ newK.w_narikei.ue)
								& newK.w_narikei.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.w_narikei.mid ^ newK.w_narikei.mid) & newK.w_narikei.mid) > 0) {
						int p = (orgK.w_narikei.mid ^ newK.w_narikei.mid)
								& newK.w_narikei.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else if (((orgK.w_narikei.sita ^ newK.w_narikei.sita) & newK.w_narikei.sita) > 0) {
						int p = (orgK.w_narikei.sita ^ newK.w_narikei.sita)
								& newK.w_narikei.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
				}
				// 𓮂Ƃ
				else if ((orgK.w_gin.ue ^ newK.w_gin.ue) > 0
						|| (orgK.w_gin.mid ^ newK.w_gin.mid) > 0
						|| (orgK.w_gin.sita ^ newK.w_gin.sita) > 0) {
					if (((orgK.w_gin.ue ^ newK.w_gin.ue) & orgK.w_gin.ue) > 0) {
						int p = (orgK.w_gin.ue ^ newK.w_gin.ue) & orgK.w_gin.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.w_gin.mid ^ newK.w_gin.mid) & orgK.w_gin.mid) > 0) {
						int p = (orgK.w_gin.mid ^ newK.w_gin.mid)
								& orgK.w_gin.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = (orgK.w_gin.sita ^ newK.w_gin.sita)
								& orgK.w_gin.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}

					if (((orgK.w_gin.ue ^ newK.w_gin.ue) & newK.w_gin.ue) > 0) {
						int p = (orgK.w_gin.ue ^ newK.w_gin.ue) & newK.w_gin.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.w_gin.mid ^ newK.w_gin.mid) & newK.w_gin.mid) > 0) {
						int p = (orgK.w_gin.mid ^ newK.w_gin.mid)
								& newK.w_gin.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else if (((orgK.w_gin.sita ^ newK.w_gin.sita) & newK.w_gin.sita) > 0) {
						int p = (orgK.w_gin.sita ^ newK.w_gin.sita)
								& newK.w_gin.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
					if (((orgK.w_narigin.ue ^ newK.w_narigin.ue) & newK.w_narigin.ue) > 0) {
						int p = (orgK.w_narigin.ue ^ newK.w_narigin.ue)
								& newK.w_narigin.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p) + "+";
					} else if (((orgK.w_narigin.mid ^ newK.w_narigin.mid) & newK.w_narigin.mid) > 0) {
						int p = (orgK.w_narigin.mid ^ newK.w_narigin.mid)
								& newK.w_narigin.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p) + "+";
					} else if (((orgK.w_narigin.sita ^ newK.w_narigin.sita) & newK.w_narigin.sita) > 0) {
						int p = (orgK.w_narigin.sita ^ newK.w_narigin.sita)
								& newK.w_narigin.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p) + "+";
					}
				}
				// uv𓮂Ƃ
				else if ((orgK.w_narigin.ue ^ newK.w_narigin.ue) > 0
						|| (orgK.w_narigin.mid ^ newK.w_narigin.mid) > 0
						|| (orgK.w_narigin.sita ^ newK.w_narigin.sita) > 0) {
					if (((orgK.w_narigin.ue ^ newK.w_narigin.ue) & orgK.w_narigin.ue) > 0) {
						int p = (orgK.w_narigin.ue ^ newK.w_narigin.ue)
								& orgK.w_narigin.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.w_narigin.mid ^ newK.w_narigin.mid) & orgK.w_narigin.mid) > 0) {
						int p = (orgK.w_narigin.mid ^ newK.w_narigin.mid)
								& orgK.w_narigin.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = (orgK.w_narigin.sita ^ newK.w_narigin.sita)
								& orgK.w_narigin.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}

					if (((orgK.w_narigin.ue ^ newK.w_narigin.ue) & newK.w_narigin.ue) > 0) {
						int p = (orgK.w_narigin.ue ^ newK.w_narigin.ue)
								& newK.w_narigin.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.w_narigin.mid ^ newK.w_narigin.mid) & newK.w_narigin.mid) > 0) {
						int p = (orgK.w_narigin.mid ^ newK.w_narigin.mid)
								& newK.w_narigin.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else if (((orgK.w_narigin.sita ^ newK.w_narigin.sita) & newK.w_narigin.sita) > 0) {
						int p = (orgK.w_narigin.sita ^ newK.w_narigin.sita)
								& newK.w_narigin.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
				}

				// uv𓮂Ƃ
				else if ((orgK.w_kin.ue ^ newK.w_kin.ue) > 0
						|| (orgK.w_kin.mid ^ newK.w_kin.mid) > 0
						|| (orgK.w_kin.sita ^ newK.w_kin.sita) > 0) {
					if (((orgK.w_kin.ue ^ newK.w_kin.ue) & orgK.w_kin.ue) > 0) {
						int p = (orgK.w_kin.ue ^ newK.w_kin.ue) & orgK.w_kin.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.w_kin.mid ^ newK.w_kin.mid) & orgK.w_kin.mid) > 0) {
						int p = (orgK.w_kin.mid ^ newK.w_kin.mid)
								& orgK.w_kin.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = (orgK.w_kin.sita ^ newK.w_kin.sita)
								& orgK.w_kin.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}

					if (((orgK.w_kin.ue ^ newK.w_kin.ue) & newK.w_kin.ue) > 0) {
						int p = (orgK.w_kin.ue ^ newK.w_kin.ue) & newK.w_kin.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.w_kin.mid ^ newK.w_kin.mid) & newK.w_kin.mid) > 0) {
						int p = (orgK.w_kin.mid ^ newK.w_kin.mid)
								& newK.w_kin.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else if (((orgK.w_kin.sita ^ newK.w_kin.sita) & newK.w_kin.sita) > 0) {
						int p = (orgK.w_kin.sita ^ newK.w_kin.sita)
								& newK.w_kin.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
				}

				// p𓮂Ƃ
				else if ((orgK.w_kaku.ue ^ newK.w_kaku.ue) > 0
						|| (orgK.w_kaku.mid ^ newK.w_kaku.mid) > 0
						|| (orgK.w_kaku.sita ^ newK.w_kaku.sita) > 0) {
					if (((orgK.w_kaku.ue ^ newK.w_kaku.ue) & orgK.w_kaku.ue) > 0) {
						int p = (orgK.w_kaku.ue ^ newK.w_kaku.ue)
								& orgK.w_kaku.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.w_kaku.mid ^ newK.w_kaku.mid) & orgK.w_kaku.mid) > 0) {
						int p = (orgK.w_kaku.mid ^ newK.w_kaku.mid)
								& orgK.w_kaku.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = (orgK.w_kaku.sita ^ newK.w_kaku.sita)
								& orgK.w_kaku.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}

					if (((orgK.w_kaku.ue ^ newK.w_kaku.ue) & newK.w_kaku.ue) > 0) {
						int p = (orgK.w_kaku.ue ^ newK.w_kaku.ue)
								& newK.w_kaku.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.w_kaku.mid ^ newK.w_kaku.mid) & newK.w_kaku.mid) > 0) {
						int p = (orgK.w_kaku.mid ^ newK.w_kaku.mid)
								& newK.w_kaku.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else if (((orgK.w_kaku.sita ^ newK.w_kaku.sita) & newK.w_kaku.sita) > 0) {
						int p = (orgK.w_kaku.sita ^ newK.w_kaku.sita)
								& newK.w_kaku.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
					if (((orgK.w_uma.ue ^ newK.w_uma.ue) & newK.w_uma.ue) > 0) {
						int p = (orgK.w_uma.ue ^ newK.w_uma.ue) & newK.w_uma.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p) + "+";
					} else if (((orgK.w_uma.mid ^ newK.w_uma.mid) & newK.w_uma.mid) > 0) {
						int p = (orgK.w_uma.mid ^ newK.w_uma.mid)
								& newK.w_uma.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p) + "+";
					} else if (((orgK.w_uma.sita ^ newK.w_uma.sita) & newK.w_uma.sita) > 0) {
						int p = (orgK.w_uma.sita ^ newK.w_uma.sita)
								& newK.w_uma.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p) + "+";
					}
				}
				// unv𓮂Ƃ
				else if ((orgK.w_uma.ue ^ newK.w_uma.ue) > 0
						|| (orgK.w_uma.mid ^ newK.w_uma.mid) > 0
						|| (orgK.w_uma.sita ^ newK.w_uma.sita) > 0) {
					if (((orgK.w_uma.ue ^ newK.w_uma.ue) & orgK.w_uma.ue) > 0) {
						int p = (orgK.w_uma.ue ^ newK.w_uma.ue) & orgK.w_uma.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.w_uma.mid ^ newK.w_uma.mid) & orgK.w_uma.mid) > 0) {
						int p = (orgK.w_uma.mid ^ newK.w_uma.mid)
								& orgK.w_uma.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = (orgK.w_uma.sita ^ newK.w_uma.sita)
								& orgK.w_uma.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}

					if (((orgK.w_uma.ue ^ newK.w_uma.ue) & newK.w_uma.ue) > 0) {
						int p = (orgK.w_uma.ue ^ newK.w_uma.ue) & newK.w_uma.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.w_uma.mid ^ newK.w_uma.mid) & newK.w_uma.mid) > 0) {
						int p = (orgK.w_uma.mid ^ newK.w_uma.mid)
								& newK.w_uma.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else if (((orgK.w_uma.sita ^ newK.w_uma.sita) & newK.w_uma.sita) > 0) {
						int p = (orgK.w_uma.sita ^ newK.w_uma.sita)
								& newK.w_uma.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
				}

				// Ԃ𓮂Ƃ
				else if ((orgK.w_hisha.ue ^ newK.w_hisha.ue) > 0
						|| (orgK.w_hisha.mid ^ newK.w_hisha.mid) > 0
						|| (orgK.w_hisha.sita ^ newK.w_hisha.sita) > 0) {
					if (((orgK.w_hisha.ue ^ newK.w_hisha.ue) & orgK.w_hisha.ue) > 0) {
						int p = (orgK.w_hisha.ue ^ newK.w_hisha.ue)
								& orgK.w_hisha.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.w_hisha.mid ^ newK.w_hisha.mid) & orgK.w_hisha.mid) > 0) {
						int p = (orgK.w_hisha.mid ^ newK.w_hisha.mid)
								& orgK.w_hisha.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = (orgK.w_hisha.sita ^ newK.w_hisha.sita)
								& orgK.w_hisha.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}

					if (((orgK.w_hisha.ue ^ newK.w_hisha.ue) & newK.w_hisha.ue) > 0) {
						int p = (orgK.w_hisha.ue ^ newK.w_hisha.ue)
								& newK.w_hisha.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.w_hisha.mid ^ newK.w_hisha.mid) & newK.w_hisha.mid) > 0) {
						int p = (orgK.w_hisha.mid ^ newK.w_hisha.mid)
								& newK.w_hisha.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else if (((orgK.w_hisha.sita ^ newK.w_hisha.sita) & newK.w_hisha.sita) > 0) {
						int p = (orgK.w_hisha.sita ^ newK.w_hisha.sita)
								& newK.w_hisha.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
					if (((orgK.w_ryu.ue ^ newK.w_ryu.ue) & newK.w_ryu.ue) > 0) {
						int p = (orgK.w_ryu.ue ^ newK.w_ryu.ue) & newK.w_ryu.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p) + "+";
					} else if (((orgK.w_ryu.mid ^ newK.w_ryu.mid) & newK.w_ryu.mid) > 0) {
						int p = (orgK.w_ryu.mid ^ newK.w_ryu.mid)
								& newK.w_ryu.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p) + "+";
					} else if (((orgK.w_ryu.sita ^ newK.w_ryu.sita) & newK.w_ryu.sita) > 0) {
						int p = (orgK.w_ryu.sita ^ newK.w_ryu.sita)
								& newK.w_ryu.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p) + "+";
					}
				}
				// uv𓮂Ƃ
				else if ((orgK.w_ryu.ue ^ newK.w_ryu.ue) > 0
						|| (orgK.w_ryu.mid ^ newK.w_ryu.mid) > 0
						|| (orgK.w_ryu.sita ^ newK.w_ryu.sita) > 0) {
					if (((orgK.w_ryu.ue ^ newK.w_ryu.ue) & orgK.w_ryu.ue) > 0) {
						int p = (orgK.w_ryu.ue ^ newK.w_ryu.ue) & orgK.w_ryu.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.w_ryu.mid ^ newK.w_ryu.mid) & orgK.w_ryu.mid) > 0) {
						int p = (orgK.w_ryu.mid ^ newK.w_ryu.mid)
								& orgK.w_ryu.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = (orgK.w_ryu.sita ^ newK.w_ryu.sita)
								& orgK.w_ryu.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}

					if (((orgK.w_ryu.ue ^ newK.w_ryu.ue) & newK.w_ryu.ue) > 0) {
						int p = (orgK.w_ryu.ue ^ newK.w_ryu.ue) & newK.w_ryu.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.w_ryu.mid ^ newK.w_ryu.mid) & newK.w_ryu.mid) > 0) {
						int p = (orgK.w_ryu.mid ^ newK.w_ryu.mid)
								& newK.w_ryu.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else if (((orgK.w_ryu.sita ^ newK.w_ryu.sita) & newK.w_ryu.sita) > 0) {
						int p = (orgK.w_ryu.sita ^ newK.w_ryu.sita)
								& newK.w_ryu.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
				}

				// uv𓮂Ƃ
				else if ((orgK.w_ou.ue ^ newK.w_ou.ue) > 0
						|| (orgK.w_ou.mid ^ newK.w_ou.mid) > 0
						|| (orgK.w_ou.sita ^ newK.w_ou.sita) > 0) {
					if (((orgK.w_ou.ue ^ newK.w_ou.ue) & orgK.w_ou.ue) > 0) {
						int p = (orgK.w_ou.ue ^ newK.w_ou.ue) & orgK.w_ou.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.w_ou.mid ^ newK.w_ou.mid) & orgK.w_ou.mid) > 0) {
						int p = (orgK.w_ou.mid ^ newK.w_ou.mid) & orgK.w_ou.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else {
						int p = (orgK.w_ou.sita ^ newK.w_ou.sita)
								& orgK.w_ou.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}

					if (((orgK.w_ou.ue ^ newK.w_ou.ue) & newK.w_ou.ue) > 0) {
						int p = (orgK.w_ou.ue ^ newK.w_ou.ue) & newK.w_ou.ue;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_UE, p);
					} else if (((orgK.w_ou.mid ^ newK.w_ou.mid) & newK.w_ou.mid) > 0) {
						int p = (orgK.w_ou.mid ^ newK.w_ou.mid) & newK.w_ou.mid;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_MID, p);
					} else if (((orgK.w_ou.sita ^ newK.w_ou.sita) & newK.w_ou.sita) > 0) {
						int p = (orgK.w_ou.sita ^ newK.w_ou.sita)
								& newK.w_ou.sita;
						s += Bitop.sujidanUsi(Bitop.KOMAIDX_SITA, p);
					}
				}
			}
		}

		return s;
	}
}
