
public class unmake {
	
	private static void NocapProBPAWN( int from, int to, tree_t ptree){
		bitop.Xor( from, ptree.posi.b_pawn ); 
		bitop.Xor( to,  ptree.posi.b_pro_pawn );
		ptree.posi.asquare[from] = def.pawn;
	}
	private static void NocapProBLANCE( int from, int to, tree_t ptree){
		bitop.Xor( from, ptree.posi.b_lance ); 
		bitop.Xor( to,  ptree.posi.b_pro_lance );
		ptree.posi.asquare[from] = def.lance;
	}
	private static void NocapProBKNIGHT( int from, int to, tree_t ptree){
		bitop.Xor( from, ptree.posi.b_knight ); 
		bitop.Xor( to,  ptree.posi.b_pro_knight );
		ptree.posi.asquare[from] = def.knight;
	}
	private static void NocapProBSILVER( int from, int to, tree_t ptree){
		bitop.Xor( from, ptree.posi.b_silver ); 
		bitop.Xor( to,  ptree.posi.b_pro_silver );
		ptree.posi.asquare[from] = def.silver;
	}
	private static void NocapProBBISHOP( int from, int to, tree_t ptree){
		bitop.Xor( from, ptree.posi.b_bishop ); 
		bitop.Xor( to,  ptree.posi.b_horse );
		ptree.posi.asquare[from] = def.bishop;
	}
	private static void NocapProBROOK( int from, int to, tree_t ptree){
		bitop.Xor( from, ptree.posi.b_rook ); 
		bitop.Xor( to,  ptree.posi.b_dragon );
		ptree.posi.asquare[from] = def.rook;
	}
	
	private static void NocapNoproBPAWN( int from, tree_t ptree , bitboard_t bb_set_clear) {
		bitop.SetClear( ptree.posi.b_pawn,  bb_set_clear);
		ptree.posi.asquare[from] = def.pawn;
	}
	private static void NocapNoproBPRO_PAWN( int from, tree_t ptree , bitboard_t bb_set_clear) {
		bitop.SetClear( ptree.posi.b_pro_pawn,  bb_set_clear);
		ptree.posi.asquare[from] = def.pro_pawn;
	}
	private static void NocapNoproBLANCE( int from, tree_t ptree , bitboard_t bb_set_clear) {
		bitop.SetClear( ptree.posi.b_lance,  bb_set_clear);
		ptree.posi.asquare[from] = def.lance;
	}
	private static void NocapNoproBPRO_LANCE( int from, tree_t ptree , bitboard_t bb_set_clear) {
		bitop.SetClear( ptree.posi.b_pro_lance,  bb_set_clear);
		ptree.posi.asquare[from] = def.pro_lance;
	}
	private static void NocapNoproBKNIGHT( int from, tree_t ptree , bitboard_t bb_set_clear) {
		bitop.SetClear( ptree.posi.b_knight,  bb_set_clear);
		ptree.posi.asquare[from] = def.knight;
	}
	private static void NocapNoproBPRO_KNIGHT( int from, tree_t ptree , bitboard_t bb_set_clear) {
		bitop.SetClear( ptree.posi.b_pro_knight,  bb_set_clear);
		ptree.posi.asquare[from] = def.pro_knight;
	}
	private static void NocapNoproBSILVER( int from, tree_t ptree , bitboard_t bb_set_clear) {
		bitop.SetClear( ptree.posi.b_silver,  bb_set_clear);
		ptree.posi.asquare[from] = def.silver;
	}
	private static void NocapNoproBPRO_SILVER( int from, tree_t ptree , bitboard_t bb_set_clear) {
		bitop.SetClear( ptree.posi.b_pro_silver,  bb_set_clear);
		ptree.posi.asquare[from] = def.pro_silver;
	}
	private static void NocapNoproBGOLD( int from, tree_t ptree , bitboard_t bb_set_clear) {
		bitop.SetClear( ptree.posi.b_gold,  bb_set_clear);
		ptree.posi.asquare[from] = def.gold;
	}
	private static void NocapNoproBBISHOP( int from, tree_t ptree , bitboard_t bb_set_clear) {
		bitop.SetClear( ptree.posi.b_bishop,  bb_set_clear);
		ptree.posi.asquare[from] = def.bishop;
	}
	private static void NocapNoproBHORSE( int from, tree_t ptree , bitboard_t bb_set_clear) {
		bitop.SetClear( ptree.posi.b_horse,  bb_set_clear);
		ptree.posi.asquare[from] = def.horse;
	}
	private static void NocapNoproBROOK( int from, tree_t ptree , bitboard_t bb_set_clear) {
		bitop.SetClear( ptree.posi.b_rook,  bb_set_clear);
		ptree.posi.asquare[from] = def.rook;
	}
	private static void NocapNoproBDRAGON( int from, tree_t ptree , bitboard_t bb_set_clear) {
		bitop.SetClear( ptree.posi.b_dragon,  bb_set_clear);
		ptree.posi.asquare[from] = def.dragon;
	}
	
	
	
	private static void CapWPAWN(int to, tree_t ptree){
		bitop.Xor( to, ptree.posi.w_pawn );
		ptree.posi.hand_black      -= def.flag_hand_pawn;
		ptree.posi.asquare[to]  = (char)-def.pawn;
	}
	private static void CapWPRO_PAWN(int to, tree_t ptree){
		bitop.Xor( to, ptree.posi.w_pro_pawn );
		ptree.posi.hand_black      -= def.flag_hand_pawn;
		ptree.posi.asquare[to]  = (char)-def.pro_pawn;
	}
	private static void CapWLANCE(int to, tree_t ptree){
		bitop.Xor( to, ptree.posi.w_lance );
		ptree.posi.hand_black      -= def.flag_hand_lance;
		ptree.posi.asquare[to]  = (char)-def.lance;
	}
	private static void CapWPRO_LANCE(int to, tree_t ptree){
		bitop.Xor( to, ptree.posi.w_pro_lance );
		ptree.posi.hand_black      -= def.flag_hand_lance;
		ptree.posi.asquare[to]  = (char)-def.pro_lance;
	}
	private static void CapWKNIGHT(int to, tree_t ptree){
		bitop.Xor( to, ptree.posi.w_knight );
		ptree.posi.hand_black      -= def.flag_hand_knight;
		ptree.posi.asquare[to]  = (char)-def.knight;
	}
	private static void CapWPRO_KNIGHT(int to, tree_t ptree){
		bitop.Xor( to, ptree.posi.w_pro_knight );
		ptree.posi.hand_black      -= def.flag_hand_knight;
		ptree.posi.asquare[to]  = (char)-def.pro_knight;
	}
	private static void CapWSILVER(int to, tree_t ptree){
		bitop.Xor( to, ptree.posi.w_silver );
		ptree.posi.hand_black      -= def.flag_hand_silver;
		ptree.posi.asquare[to]  = (char)-def.silver;
	}
	private static void CapWPRO_SILVER(int to, tree_t ptree){
		bitop.Xor( to, ptree.posi.w_pro_silver );
		ptree.posi.hand_black      -= def.flag_hand_silver;
		ptree.posi.asquare[to]  = (char)-def.pro_silver;
	}
	private static void CapWGOLD(int to, tree_t ptree){
		bitop.Xor( to, ptree.posi.w_gold );
		ptree.posi.hand_black      -= def.flag_hand_gold;
		ptree.posi.asquare[to]  = (char)-def.gold;
	}
	private static void CapWBISHOP(int to, tree_t ptree){
		bitop.Xor( to, ptree.posi.w_bishop );
		ptree.posi.hand_black      -= def.flag_hand_bishop;
		ptree.posi.asquare[to]  = (char)-def.bishop;
	}
	private static void CapWHORSE(int to, tree_t ptree){
		bitop.Xor( to, ptree.posi.w_horse );
		ptree.posi.hand_black      -= def.flag_hand_bishop;
		ptree.posi.asquare[to]  = (char)-def.horse;
	}
	private static void CapWROOK(int to, tree_t ptree){
		bitop.Xor( to, ptree.posi.w_rook );
		ptree.posi.hand_black      -= def.flag_hand_rook;
		ptree.posi.asquare[to]  = (char)-def.rook;
	}
	private static void CapWDRAGON(int to, tree_t ptree){
		bitop.Xor( to, ptree.posi.w_dragon );
		ptree.posi.hand_black      -= def.flag_hand_rook;
		ptree.posi.asquare[to]  = (char)-def.dragon;
	}
	
	
	private static void NocapProWPAWN( int from,int to, tree_t ptree ){
		bitop.Xor( from, ptree.posi.w_pawn ); 
		bitop.Xor( to,   ptree.posi.w_pro_pawn );
	    ptree.posi.asquare[from] = (char)-def.pawn;
	}
	private static void NocapProWLANCE( int from,int to, tree_t ptree ){
		bitop.Xor( from, ptree.posi.w_lance ); 
		bitop.Xor( to,   ptree.posi.w_pro_lance );
	    ptree.posi.asquare[from] = (char)-def.lance;
	}
	private static void NocapProWKNIGHT( int from,int to, tree_t ptree ){
		bitop.Xor( from, ptree.posi.w_knight ); 
		bitop.Xor( to,   ptree.posi.w_pro_knight );
	    ptree.posi.asquare[from] = (char)-def.knight;
	}
	private static void NocapProWSILVER( int from,int to, tree_t ptree ){
		bitop.Xor( from, ptree.posi.w_silver ); 
		bitop.Xor( to,   ptree.posi.w_pro_silver );
	    ptree.posi.asquare[from] = (char)-def.silver;
	}
	private static void NocapProWBISHOP( int from,int to, tree_t ptree ){
		bitop.Xor( from, ptree.posi.w_bishop ); 
		bitop.Xor( to,   ptree.posi.w_horse );
	    ptree.posi.asquare[from] = (char)-def.bishop;
	}
	private static void NocapProWROOK( int from,int to, tree_t ptree ){
		bitop.Xor( from, ptree.posi.w_rook ); 
		bitop.Xor( to,   ptree.posi.w_dragon );
	    ptree.posi.asquare[from] = (char)-def.rook;
	}
	
	private static void NocapNoproWPAWN( int from, tree_t ptree, bitboard_t bb_set_clear  ){
		bitop.SetClear(  ptree.posi.w_pawn,  bb_set_clear);
		ptree.posi.asquare[from] =  (char)-def.pawn;
	}
	private static void NocapNoproWPRO_PAWN( int from, tree_t ptree, bitboard_t bb_set_clear  ){
		bitop.SetClear(  ptree.posi.w_pro_pawn,  bb_set_clear);
		ptree.posi.asquare[from] =  (char)-def.pro_pawn;
	}
	private static void NocapNoproWLANCE( int from, tree_t ptree, bitboard_t bb_set_clear  ){
		bitop.SetClear(  ptree.posi.w_lance,  bb_set_clear);
		ptree.posi.asquare[from] =  (char)-def.lance;
	}
	private static void NocapNoproWPRO_LANCE( int from, tree_t ptree, bitboard_t bb_set_clear  ){
		bitop.SetClear(  ptree.posi.w_pro_lance,  bb_set_clear);
		ptree.posi.asquare[from] =  (char)-def.pro_lance;
	}
	private static void NocapNoproWKNIGHT( int from, tree_t ptree, bitboard_t bb_set_clear  ){
		bitop.SetClear(  ptree.posi.w_knight,  bb_set_clear);
		ptree.posi.asquare[from] =  (char)-def.knight;
	}
	private static void NocapNoproWPRO_KNIGHT( int from, tree_t ptree, bitboard_t bb_set_clear  ){
		bitop.SetClear(  ptree.posi.w_pro_knight,  bb_set_clear);
		ptree.posi.asquare[from] =  (char)-def.pro_knight;
	}
	private static void NocapNoproWSILVER( int from, tree_t ptree, bitboard_t bb_set_clear  ){
		bitop.SetClear(  ptree.posi.w_silver,  bb_set_clear);
		ptree.posi.asquare[from] =  (char)-def.silver;
	}
	private static void NocapNoproWPRO_SILVER( int from, tree_t ptree, bitboard_t bb_set_clear  ){
		bitop.SetClear(  ptree.posi.w_pro_silver,  bb_set_clear);
		ptree.posi.asquare[from] =  (char)-def.pro_silver;
	}
	private static void NocapNoproWGOLD( int from, tree_t ptree, bitboard_t bb_set_clear  ){
		bitop.SetClear(  ptree.posi.w_gold,  bb_set_clear);
		ptree.posi.asquare[from] =  (char)-def.gold;
	}
	private static void NocapNoproWBISHOP( int from, tree_t ptree, bitboard_t bb_set_clear  ){
		bitop.SetClear(  ptree.posi.w_bishop,  bb_set_clear);
		ptree.posi.asquare[from] =  (char)-def.bishop;
	}
	private static void NocapNoproWHORSE( int from, tree_t ptree, bitboard_t bb_set_clear  ){
		bitop.SetClear(  ptree.posi.w_horse,  bb_set_clear);
		ptree.posi.asquare[from] =  (char)-def.horse;
	}
	private static void NocapNoproWROOK( int from, tree_t ptree, bitboard_t bb_set_clear  ){
		bitop.SetClear(  ptree.posi.w_rook,  bb_set_clear);
		ptree.posi.asquare[from] =  (char)-def.rook;
	}
	private static void NocapNoproWDRAGON( int from, tree_t ptree, bitboard_t bb_set_clear  ){
		bitop.SetClear(  ptree.posi.w_dragon,  bb_set_clear);
		ptree.posi.asquare[from] =  (char)-def.dragon;
	}
	
	private static void CapBPAWN( int to, tree_t ptree ){
		bitop.Xor( to, ptree.posi.b_pawn );      
		ptree.posi.hand_white  -= def.flag_hand_pawn;
	    ptree.posi.asquare[to]  = def.pawn;
	}
	private static void CapBPRO_PAWN( int to, tree_t ptree ){
		bitop.Xor( to, ptree.posi.b_pro_pawn );      
		ptree.posi.hand_white  -= def.flag_hand_pawn;
	    ptree.posi.asquare[to]  = def.pro_pawn;
	}
	private static void CapBLANCE( int to, tree_t ptree ){
		bitop.Xor( to, ptree.posi.b_lance );      
		ptree.posi.hand_white  -= def.flag_hand_lance;
	    ptree.posi.asquare[to]  = def.lance;
	}
	private static void CapBPRO_LANCE( int to, tree_t ptree ){
		bitop.Xor( to, ptree.posi.b_pro_lance );      
		ptree.posi.hand_white  -= def.flag_hand_lance;
	    ptree.posi.asquare[to]  = def.pro_lance;
	}
	private static void CapBKNIGHT( int to, tree_t ptree ){
		bitop.Xor( to, ptree.posi.b_knight );      
		ptree.posi.hand_white  -= def.flag_hand_knight;
	    ptree.posi.asquare[to]  = def.knight;
	}
	private static void CapBPRO_KNIGHT( int to, tree_t ptree ){
		bitop.Xor( to, ptree.posi.b_pro_knight );      
		ptree.posi.hand_white  -= def.flag_hand_knight;
	    ptree.posi.asquare[to]  = def.pro_knight;
	}
	private static void CapBSILVER( int to, tree_t ptree ){
		bitop.Xor( to, ptree.posi.b_silver );      
		ptree.posi.hand_white  -= def.flag_hand_silver;
	    ptree.posi.asquare[to]  = def.silver;
	}
	private static void CapBPRO_SILVER( int to, tree_t ptree ){
		bitop.Xor( to, ptree.posi.b_pro_silver );      
		ptree.posi.hand_white  -= def.flag_hand_silver;
	    ptree.posi.asquare[to]  = def.pro_silver;
	}
	private static void CapBGOLD( int to, tree_t ptree ){
		bitop.Xor( to, ptree.posi.b_gold );      
		ptree.posi.hand_white  -= def.flag_hand_gold;
	    ptree.posi.asquare[to]  = def.gold;
	}
	private static void CapBBISHOP( int to, tree_t ptree ){
		bitop.Xor( to, ptree.posi.b_bishop );      
		ptree.posi.hand_white  -= def.flag_hand_bishop;
	    ptree.posi.asquare[to]  = def.bishop;
	}
	private static void CapBHORSE( int to, tree_t ptree ){
		bitop.Xor( to, ptree.posi.b_horse );      
		ptree.posi.hand_white  -= def.flag_hand_bishop;
	    ptree.posi.asquare[to]  = def.horse;
	}
	private static void CapBROOK( int to, tree_t ptree ){
		bitop.Xor( to, ptree.posi.b_rook );      
		ptree.posi.hand_white  -= def.flag_hand_rook;
	    ptree.posi.asquare[to]  = def.rook;
	}
	private static void CapBDRAGON( int to, tree_t ptree ){
		bitop.Xor( to, ptree.posi.b_dragon );      
		ptree.posi.hand_white  -= def.flag_hand_rook;
	    ptree.posi.asquare[to]  = def.dragon;
	}
	
	public static void unmake_move_b( tree_t ptree, int move, int ply )
	{
	  int from = (int)bitop.I2From(move);
	  int to   = (int)bitop.I2To(move);
	  int nrep = ptree.nrep + ply - 1;

	  ptree.posi.hash_key = ptree.rep_board_list[nrep];
	  ptree.posi.material = ptree.save_material[ply];

	  if ( from >= def.nsquare )
	    {
	      switch( bitop.From2Drop(from) )
		{
		case def.pawn:    bitop.Xor( to, ptree.posi.b_pawn );
	                      bitop.Xor( to-def.nfile, ptree.posi.b_pawn_attacks );
	                      ptree.posi.hand_black += def.flag_hand_pawn;     break;
		case def.lance:   bitop.Xor( to, ptree.posi.b_lance );
	                      ptree.posi.hand_black += def.flag_hand_lance;    break;
		case def.knight:  bitop.Xor( to, ptree.posi.b_knight );
	                      ptree.posi.hand_black += def.flag_hand_knight;   break;
		case def.silver:  bitop.Xor( to, ptree.posi.b_silver );
	                      ptree.posi.hand_black += def.flag_hand_silver;   break;
		case def.gold:    bitop.Xor( to, ptree.posi.b_gold );
	                      bitop.Xor( to, ptree.posi.b_tgold );
	                      ptree.posi.hand_black += def.flag_hand_gold;     break;
		case def.bishop:  bitop.Xor( to, ptree.posi.b_bishop );
	                      bitop.Xor( to, ptree.posi.b_bh );
	                      ptree.posi.hand_black += def.flag_hand_bishop;   break;
		default:      assert( bitop.From2Drop(from) == def.rook );
	                      bitop.Xor( to, ptree.posi.b_rook );
	                      bitop.Xor( to, ptree.posi.b_rd );
	                      ptree.posi.hand_black += def.flag_hand_rook;  break;
		}

	      ptree.posi.asquare[to] = def.empty;
	      bitop.Xor( to, ptree.posi.b_occupied );
	      bitop.XorFile( to, ptree.posi.occupied_rl90 );
	      bitop.XorDiag2( to, ptree.posi.occupied_rl45 );
	      bitop.XorDiag1( to, ptree.posi.occupied_rr45 );
	    }
	  else {
	    final int ipiece_move = (int)bitop.I2PieceMove(move);
	    final int ipiece_cap  = (int)bitop.UToCap(move);
	    final int is_promote  = (int)bitop.I2IsPromote(move);
	    bitboard_t bb_set_clear = new bitboard_t();

	    bitop.BBOr( bb_set_clear, data.abb_mask[from], data.abb_mask[to] );
	    bitop.SetClear( ptree.posi.b_occupied , bb_set_clear);

	    if ( is_promote > 0 ) switch( ipiece_move )
	      {
	      case def.pawn:    NocapProBPAWN( from, to, ptree );
	                    bitop.Xor( to, ptree.posi.b_pawn_attacks );
	                    bitop.Xor( to, ptree.posi.b_tgold );                        break;
	      case def.lance:   NocapProBLANCE( from, to, ptree );
	                    bitop.Xor( to, ptree.posi.b_tgold );                        break;
	      case def.knight:  NocapProBKNIGHT( from, to, ptree);
	                    bitop.Xor( to, ptree.posi.b_tgold );                        break;
	      case def.silver:  NocapProBSILVER( from, to, ptree );
	                    bitop.Xor( to, ptree.posi.b_tgold );                        break;
	      case def.bishop:  NocapProBBISHOP( from, to, ptree );
	                    bitop.Xor( to, ptree.posi.b_hdk );
			    bitop.SetClear( ptree.posi.b_bh , bb_set_clear);                         break;
	      default:      assert( ipiece_move == def.rook );
	                    NocapProBROOK( from, to, ptree  );
	                    bitop.Xor( to, ptree.posi.b_hdk );
			    bitop.SetClear( ptree.posi.b_rd , bb_set_clear);                         break;
	      }
	    else switch ( ipiece_move )
	      {
	      case def.pawn:	NocapNoproBPAWN( from, ptree, bb_set_clear);
	                        bitop.Xor( to-def.nfile, ptree.posi.b_pawn_attacks );
	                        bitop.Xor( to,       ptree.posi.b_pawn_attacks );          break;
	      case def.lance:       NocapNoproBLANCE( from, ptree, bb_set_clear );           break;
	      case def.knight:      NocapNoproBKNIGHT( from, ptree, bb_set_clear );          break;
	      case def.silver:      NocapNoproBSILVER( from, ptree, bb_set_clear );          break;
	      case def.gold:        NocapNoproBGOLD( from, ptree, bb_set_clear );
	                        bitop.SetClear( ptree.posi.b_tgold, bb_set_clear );                  break;
	      case def.bishop:      NocapNoproBBISHOP( from, ptree, bb_set_clear );
	                        bitop.SetClear( ptree.posi.b_bh, bb_set_clear );                    break;
	      case def.rook:        NocapNoproBROOK( from, ptree, bb_set_clear);
	                        bitop.SetClear( ptree.posi.b_rd , bb_set_clear);                    break;
	      case def.king:	ptree.posi.asquare[from] = def.king;
	                        ptree.posi.isquare_b_king    = (char)from;
	                        bitop.SetClear( ptree.posi.b_hdk , bb_set_clear);                   break;
	      case def.pro_pawn:    NocapNoproBPRO_PAWN( from, ptree, bb_set_clear );
	                        bitop.SetClear( ptree.posi.b_tgold, bb_set_clear );                  break;
	      case def.pro_lance:   NocapNoproBPRO_LANCE( from, ptree, bb_set_clear );
	                        bitop.SetClear( ptree.posi.b_tgold , bb_set_clear);                  break;
	      case def.pro_knight:  NocapNoproBPRO_KNIGHT( from, ptree, bb_set_clear );
	                        bitop.SetClear( ptree.posi.b_tgold , bb_set_clear);                  break;
	      case def.pro_silver:  NocapNoproBPRO_SILVER( from, ptree, bb_set_clear );
	                        bitop.SetClear( ptree.posi.b_tgold, bb_set_clear );                  break;
	      case def.horse:	NocapNoproBHORSE( from, ptree, bb_set_clear );
	                        bitop.SetClear( ptree.posi.b_hdk, bb_set_clear );
	                        bitop.SetClear( ptree.posi.b_bh, bb_set_clear );                    break;
	      default:          assert( ipiece_move == def.dragon );
	                        NocapNoproBDRAGON( from, ptree, bb_set_clear );
	                        bitop.SetClear( ptree.posi.b_hdk , bb_set_clear);
	                        bitop.SetClear( ptree.posi.b_rd , bb_set_clear);                    break;
	      }

	    if ( ipiece_cap > 0)
	      {
		switch( ipiece_cap )
		  {
		  case def.pawn:        CapWPAWN( to, ptree );
	                            bitop.Xor( to+def.nfile, ptree.posi.w_pawn_attacks );        break;
		  case def.lance:       CapWLANCE( to, ptree);     break;
		  case def.knight:      CapWKNIGHT( to, ptree);    break;
		  case def.silver:      CapWSILVER( to, ptree);    break;
		  case def.gold:        CapWGOLD( to, ptree);
	                            bitop.Xor( to, ptree.posi.w_tgold );                 break;
		  case def.bishop:      CapWBISHOP( to, ptree);
				    bitop.Xor( to, ptree.posi.w_bh );                   break;
		  case def.rook:        CapWROOK( to, ptree);
	                            bitop.Xor( to, ptree.posi.w_rd );                   break;
		  case def.pro_pawn:    CapWPRO_PAWN( to, ptree);
	                            bitop.Xor( to, ptree.posi.w_tgold );                 break;
		  case def.pro_lance:   CapWPRO_LANCE( to, ptree);
	                            bitop.Xor( to, ptree.posi.w_tgold );                 break;
		  case def.pro_knight:  CapWPRO_KNIGHT( to, ptree);
	                            bitop.Xor( to, ptree.posi.w_tgold );                 break;
		  case def.pro_silver:  CapWPRO_SILVER(to, ptree);
	                            bitop.Xor( to, ptree.posi.w_tgold );                 break;
		  case def.horse:       CapWHORSE(to, ptree);
	                            bitop.Xor( to, ptree.posi.w_hdk );
				    bitop.Xor( to, ptree.posi.w_bh );                   break;
		  default:          assert( ipiece_cap == def.dragon );
	                            CapWDRAGON(to, ptree);
	                            bitop.Xor( to, ptree.posi.w_hdk );
	                            bitop.Xor( to, ptree.posi.w_rd );                   break;
		  }
	      bitop.Xor( to, ptree.posi.w_occupied );
	      bitop.XorFile( from, ptree.posi.occupied_rl90 );
	      bitop.XorDiag1( from, ptree.posi.occupied_rr45 );
	      bitop.XorDiag2( from, ptree.posi.occupied_rl45 );
	      }
	    else {
	      ptree.posi.asquare[to] = def.empty;
	      bitop.SetClearFile( from, to, ptree.posi.occupied_rl90 );
	      bitop.SetClearDiag1( from, to, ptree.posi.occupied_rr45 );
	      bitop.SetClearDiag2( from, to, ptree.posi.occupied_rl45 );
	    }
	  }

	  // assert( exam_bb( ptree ) ); //TODO: Ŏ
	}

	public static void unmake_move_w( tree_t ptree, int move, int ply )
	{
		  int from = (int)bitop.I2From(move);
		  int to   = (int)bitop.I2To(move);
		  int nrep = ptree.nrep + ply - 1;

		  ptree.posi.hash_key = ptree.rep_board_list[nrep];
		  ptree.posi.material = ptree.save_material[ply];

		  if ( from >= def.nsquare )
		    {
		      switch( bitop.From2Drop(from) )
			{
			case def.pawn:    bitop.Xor( to, ptree.posi.w_pawn );
		                      bitop.Xor( to+def.nfile, ptree.posi.w_pawn_attacks );
		                      ptree.posi.hand_white += def.flag_hand_pawn;    break;
			case def.lance:   bitop.Xor( to, ptree.posi.w_lance );
		                      ptree.posi.hand_white += def.flag_hand_lance;   break;
			case def.knight:  bitop.Xor( to, ptree.posi.w_knight );
		                      ptree.posi.hand_white += def.flag_hand_knight;  break;
			case def.silver:  bitop.Xor( to, ptree.posi.w_silver );
		                      ptree.posi.hand_white += def.flag_hand_silver;  break;
			case def.gold:    bitop.Xor( to, ptree.posi.w_gold );
		                      bitop.Xor( to, ptree.posi.w_tgold );
		                      ptree.posi.hand_white += def.flag_hand_gold;    break;
			case def.bishop:  bitop.Xor( to, ptree.posi.w_bishop );
		                      bitop.Xor( to, ptree.posi.w_bh );
		                      ptree.posi.hand_white += def.flag_hand_bishop;  break;
			default:      assert( bitop.From2Drop(from) == def.rook );
		                      bitop.Xor( to, ptree.posi.w_rook );
		                      bitop.Xor( to, ptree.posi.w_rd );
		                      ptree.posi.hand_white += def.flag_hand_rook;    break;
			}

		      ptree.posi.asquare[to] = def.empty;
		      bitop.Xor( to, ptree.posi.w_occupied );
		      bitop.XorFile( to, ptree.posi.occupied_rl90 );
		      bitop.XorDiag2( to, ptree.posi.occupied_rl45 );
		      bitop.XorDiag1( to, ptree.posi.occupied_rr45 );
		    }
		  else {
		    final int ipiece_move = (int)bitop.I2PieceMove(move);
		    final int ipiece_cap  = (int)bitop.UToCap(move);
		    final int is_promote  = (int)bitop.I2IsPromote(move);
		    bitboard_t bb_set_clear  = new bitboard_t();

		    bitop.BBOr( bb_set_clear, data.abb_mask[from], data.abb_mask[to] );
		    bitop.SetClear( ptree.posi.w_occupied, bb_set_clear);

		    if ( is_promote > 0) switch( ipiece_move )
		      {
		      case def.pawn:    NocapProWPAWN( from, to, ptree );
		                    bitop.Xor( to, ptree.posi.w_pawn_attacks );
		                    bitop.Xor( to, ptree.posi.w_tgold );                        break;
		      case def.lance:   NocapProWLANCE( from, to, ptree );
		                    bitop.Xor( to, ptree.posi.w_tgold );                        break;
		      case def.knight:  NocapProWKNIGHT( from, to, ptree );
		                    bitop.Xor( to, ptree.posi.w_tgold );                        break;
		      case def.silver:  NocapProWSILVER( from, to, ptree );
		                    bitop.Xor( to, ptree.posi.w_tgold );                        break;
		      case def.bishop:  NocapProWBISHOP( from, to, ptree );
		                    bitop.Xor( to, ptree.posi.w_hdk );
				    bitop.SetClear( ptree.posi.w_bh, bb_set_clear );                         break;
		      default:      assert( ipiece_move == def.rook );
		                    NocapProWROOK( from, to, ptree );
		                    bitop.Xor( to, ptree.posi.w_hdk );
				    bitop.SetClear( ptree.posi.w_rd , bb_set_clear);                         break;
		      }
		    else switch ( ipiece_move )
		      {
		      case def.pawn:        NocapNoproWPAWN( from, ptree, bb_set_clear  );
		                        bitop.Xor( to+def.nfile, ptree.posi.w_pawn_attacks );
		                        bitop.Xor( to,       ptree.posi.w_pawn_attacks );          break;
		      case def.lance:       NocapNoproWLANCE( from, ptree, bb_set_clear );          break;
		      case def.knight:      NocapNoproWKNIGHT( from, ptree, bb_set_clear  );         break;
		      case def.silver:      NocapNoproWSILVER( from, ptree, bb_set_clear  );         break;
		      case def.gold:        NocapNoproWGOLD( from, ptree, bb_set_clear  );
		                        bitop.SetClear( ptree.posi.w_tgold  , bb_set_clear);                  break;
		      case def.bishop:      NocapNoproWBISHOP( from, ptree, bb_set_clear  );
		                        bitop.SetClear( ptree.posi.w_bh , bb_set_clear );                    break;
		      case def.rook:        NocapNoproWROOK( from, ptree, bb_set_clear  );
		                        bitop.SetClear( ptree.posi.w_rd  , bb_set_clear);                    break;
		      case def.king:	ptree.posi.asquare[from] = (char)-def.king;
		                        ptree.posi.isquare_w_king    = (char)from;
		                        bitop.SetClear( ptree.posi.w_hdk , bb_set_clear);                   break;
		      case def.pro_pawn:    NocapNoproWPRO_PAWN( from, ptree, bb_set_clear );
		                        bitop.SetClear( ptree.posi.w_tgold , bb_set_clear);                  break;
		      case def.pro_lance:   NocapNoproWPRO_LANCE(from, ptree, bb_set_clear  );
		                        bitop.SetClear( ptree.posi.w_tgold , bb_set_clear);                  break;
		      case def.pro_knight:  NocapNoproWPRO_KNIGHT( from, ptree, bb_set_clear );
		                        bitop.SetClear( ptree.posi.w_tgold , bb_set_clear);                  break;
		      case def.pro_silver:  NocapNoproWPRO_SILVER( from, ptree, bb_set_clear  );
		                        bitop.SetClear( ptree.posi.w_tgold , bb_set_clear);                  break;
		      case def.horse:       NocapNoproWHORSE( from, ptree, bb_set_clear );
		                        bitop.SetClear( ptree.posi.w_hdk , bb_set_clear);
		                        bitop.SetClear( ptree.posi.w_bh , bb_set_clear);                    break;
		      default:          assert( ipiece_move == def.dragon );
		                        NocapNoproWDRAGON( from, ptree, bb_set_clear  );
		                        bitop.SetClear( ptree.posi.w_hdk, bb_set_clear );
		                        bitop.SetClear( ptree.posi.w_rd , bb_set_clear);                    break;
		      }
		    
		    if ( ipiece_cap > 0 )
		      {
			switch( ipiece_cap )
			  {
			  case def.pawn:        CapBPAWN( to, ptree );
			                    bitop.Xor( to-def.nfile, ptree.posi.b_pawn_attacks );      break;
			  case def.lance:       CapBLANCE( to, ptree );   break;
			  case def.knight:      CapBKNIGHT( to, ptree );  break;
			  case def.silver:      CapBSILVER( to, ptree );  break;
			  case def.gold:        CapBGOLD( to, ptree );
		                            bitop.Xor( to, ptree.posi.b_tgold );              break;
			  case def.bishop:      CapBBISHOP( to, ptree );
		                            bitop.Xor( to, ptree.posi.b_bh );                 break;
			  case def.rook:        CapBROOK( to, ptree );
		                            bitop.Xor( to, ptree.posi.b_rd );                 break;
			  case def.pro_pawn:    CapBPRO_PAWN( to, ptree );
		                            bitop.Xor( to, ptree.posi.b_tgold );              break;
			  case def.pro_lance:   CapBPRO_LANCE( to, ptree );
		                            bitop.Xor( to, ptree.posi.b_tgold );              break;
			  case def.pro_knight:  CapBPRO_KNIGHT( to, ptree );
		                            bitop.Xor( to, ptree.posi.b_tgold );              break;
			  case def.pro_silver:  CapBPRO_SILVER( to, ptree );
		                            bitop.Xor( to, ptree.posi.b_tgold );              break;
			  case def.horse:       CapBHORSE( to, ptree );
		                            bitop.Xor( to, ptree.posi.b_hdk );
		                            bitop.Xor( to, ptree.posi.b_bh );                 break;
			  default:          assert( ipiece_cap == def.dragon );
		                            CapBDRAGON( to, ptree);
		                            bitop.Xor( to, ptree.posi.b_hdk );
		                            bitop.Xor( to, ptree.posi.b_rd );                 break;
			  }
			bitop.Xor( to, ptree.posi.b_occupied );
			bitop.XorFile( from, ptree.posi.occupied_rl90 );
			bitop.XorDiag1( from, ptree.posi.occupied_rr45 );
			bitop.XorDiag2( from, ptree.posi.occupied_rl45 );
		      }
		    else {
		      ptree.posi.asquare[to] = def.empty;
		      bitop.SetClearFile( from, to, ptree.posi.occupied_rl90 );
		      bitop.SetClearDiag1( from, to, ptree.posi.occupied_rr45 );
		      bitop.SetClearDiag2( from, to, ptree.posi.occupied_rl45 );
		    }
		  }

		  // assert( exam_bb( ptree ) );// TODO:Ŏ
		}
}
