public class search {
	int search(tree_t ptree, int alpha, int beta, int turn, int depth, int ply,
			int state_node) {
		int value, alpha_old;

		if (ptree.nsuc_check[ply] == 0 && depth < def.PLY_INC) {
			return quiesrch.search_quies(ptree, alpha, beta, turn, ply, 1);
		}

		ptree.node_searched++;

		if (ply >= def.PLY_MAX - 1) {
			value = evaluate.evaluate(ptree, ply, turn);
			if (alpha < value && value < beta) {
				pv_close(ptree, ply, def.no_rep);
			}
			ptree.current_move[ply] = def.MOVE_NA;
			return value;
		}

		if (!(data.game_status > 0 & def.flag_learning > 0))

		{
			/* check time and input */

			if (data.node_next_signal < ++data.node_last_check
					&& detect_signals(ptree) > 0) {
				data.root_abort = 1;
				return 0;
			}

			/* repetitions */
			ptree.nrep_tried++;
			switch (detect_rep(ptree, ply, turn)) {
			case def.black_superi_rep:
				value = turn > 0 ? -def.score_inferior : def.score_inferior;
				if (alpha < value && value < beta) {
					pv_close(ptree, ply, def.black_superi_rep);
				}
				ptree.nsuperior_rep++;
				ptree.current_move[ply] = def.MOVE_NA;
				return value;

			case def.white_superi_rep:
				value = turn > 0 ? def.score_inferior : -def.score_inferior;
				if (alpha < value && value < beta) {
					pv_close(ptree, ply, def.white_superi_rep);
				}
				ptree.nsuperior_rep++;
				ptree.current_move[ply] = def.MOVE_NA;
				return value;

			case def.four_fold_rep:
				if (alpha < def.score_draw && def.score_draw < beta) {
					pv_close(ptree, ply, def.four_fold_rep);
				}
				ptree.nfour_fold_rep++;
				ptree.current_move[ply] = def.MOVE_NA;
				return def.score_draw;

			case def.perpetual_check:
				ptree.nperpetual_check++;
				ptree.current_move[ply] = def.MOVE_NA;
				return def.score_foul;

			case def.perpetual_check2:
				if (ply > 4) {
					ptree.nperpetual_check++;
					ptree.current_move[ply] = def.MOVE_NA;
					return -def.score_foul;
				}
				break;
			}
		}

		/*
		 * no repetitions. worst situation of this node is checkmate, and the
		 * best is to force checkmate within 1-ply.
		 */
		alpha_old = alpha;
		value = -(def.score_mate1ply + 2 - ply);
		if (alpha < value) {
			if (beta <= value) {
				ptree.current_move[ply] = def.MOVE_NA;
				return value;
			}
			alpha = value;
		} else {
			value = def.score_mate1ply + 1 - ply;
			if (value <= alpha) {
				return value;
			}
		}

		ptree.amove_hash[ply] = 0;

		{
			/* probe the transposition table */
			int[] ret = hash.hash_probe(ptree, ply, depth, turn, alpha, beta,
					state_node);
			state_node = ret[1];

			if (ret[0] == def.value_exact) {
				ptree.current_move[ply] = ptree.amove_hash[ply];
				assert (!bitop.IsMove(ptree.current_move[ply]) || valid
						.is_move_valid(ptree, ptree.current_move[ply], turn) > 0);
				if ((state_node & def.node_do_hashcut) > 0
						&& beta == alpha_old + 1) {
					if (alpha < ptree.sort_value[0]
							&& ptree.sort_value[0] < beta) {
						pv_close(ptree, ply, def.hash_hit);
					}
					return ptree.sort_value[0];
				}

			} else if (ret[0] == def.value_lower) {

				ptree.current_move[ply] = ptree.amove_hash[ply];
				assert (beta <= ptree.sort_value[0]);
				assert (!bitop.IsMove(ptree.current_move[ply]) || valid
						.is_move_valid(ptree, ptree.current_move[ply], turn) > 0);
				if ((state_node & def.node_do_hashcut) > 0
						&& beta == alpha_old + 1) {
					return ptree.sort_value[0];
				}
			}

			else if (ret[0] == def.value_upper) {
				assert (ptree.sort_value[0] <= alpha);
				if ((state_node & def.node_do_hashcut) > 0
						&& beta == alpha_old + 1) {
					return ptree.sort_value[0];
				}
			}
		}

		if (!(ptree.nsuc_check[ply] > 0)) {
			/* detect a move mates in 3-ply */
			if ((state_node & def.node_do_mate) > 0
					&& mate3.is_mate_in3ply(ptree, turn, ply) > 0) {
				value = def.score_mate1ply + 1 - ply;

				hash.hash_store(ptree, ply, depth, turn, def.value_exact,
						value, ptree.current_move[ply], 0);

				if (alpha < value && value < beta) {
					pv_close(ptree, ply, def.mate_search);
				}

				assert (valid.is_move_valid(ptree, ptree.current_move[ply],
						turn) > 0);
				return value;
			}

			/* null move pruning */
			if (2 * def.PLY_INC <= depth && (state_node & def.node_do_null) > 0
					&& beta == alpha_old + 1
					&& beta <= evaluate.evaluate(ptree, ply, turn)) {
				int null_depth, nrep;

				null_depth = bitop.NullDepth(depth);
				nrep = ptree.nrep + ply - 1;

				ptree.current_move[ply] = def.MOVE_PASS;
				ptree.move_last[ply] = ptree.move_last[ply - 1];
				ptree.save_eval[ply + 1] = -ptree.save_eval[ply];
				ptree.nsuc_check[ply + 1] = 0;
				ptree.rep_board_list[nrep] = ptree.posi.hash_key;
				ptree.rep_hand_list[nrep] = ptree.posi.hand_black;
				ptree.null_pruning_tried++;

				value = -search(ptree, -beta, 1 - beta, bitop.Flip(turn),
						null_depth, ply + 1, def.node_do_mate
								| def.node_do_recap | def.node_do_futile
								| def.node_do_recursion | def.node_do_hashcut);
				if (data.root_abort > 0) {
					return 0;
				}

				if (beta <= value) {
					ptree.null_pruning_done++;
					if (null_depth < def.PLY_INC) {
						hash.hash_store(ptree, ply, depth, turn,
								def.value_lower, value, def.MOVE_NA, state_node);
					}

					assert (!bitop.IsMove(ptree.current_move[ply]) || valid
							.is_move_valid(ptree, ptree.current_move[ply], turn) > 0);
					return value;
				}

				if (value == -(def.score_mate1ply - ply)) {
					state_node |= def.node_mate_threat;
				}
			}
		}

		/* recursive iterative-deepening */
		if (!(ptree.amove_hash[ply] > 0) && def.RecursionThreshold <= depth
				&& (state_node & def.node_do_recursion) > 0) {
			int new_depth = bitop.RecursionDepth(depth);
			int state_node_new = state_node
					& ~(def.node_do_mate | def.node_do_null | def.node_do_hashcut);

			value = search(ptree, alpha, beta, turn, new_depth, ply,
					state_node_new);
			if (data.root_abort > 0) {
				return 0;
			}

			if (beta <= value) {
				ptree.amove_hash[ply] = ptree.current_move[ply];
			} else if (alpha < value) {
				assert (ply <= (int) ptree.pv[ply - 1].length);
				assert (-def.score_bound < value);
				ptree.amove_hash[ply] = ptree.pv[ply - 1].a[ply];
			}

			assert (!(ptree.amove_hash[ply] > 0) || valid.is_move_valid(ptree,
					ptree.amove_hash[ply], turn) > 0);

		}

		{
			int depth_reduced, first_move_expanded, new_depth, extension;
			int state_node_new;

			ptree.move_last[ply] = ptree.move_last[ply - 1];
			ptree.anext_move[ply].next_phase = def.next_move_hash;
			ptree.hist_nmove[ply] = 0;
			first_move_expanded = 0;

			evaluate.evaluate(ptree, ply, turn);

			/* expand all of off-springs */
			while ((ptree.nsuc_check[ply] > 0 ? next.gen_next_evasion(ptree,
					ply, turn) : next.gen_next_move(ptree, ply, turn)) > 0) {

				ptree.nsuc_check[ply + 1] = 0;
				state_node_new = (def.node_do_mate | def.node_do_recap
						| def.node_do_null | def.node_do_futile
						| def.node_do_recursion | def.node_do_hashcut);
				extension = 0;
				depth_reduced = 0;

				hist_add(ptree, ply);

				/* decision of extensions */
				if (bitop.IsMoveCheck(ptree, turn, ptree.current_move[ply]) > 0) {
					ptree.check_extension_done++;
					ptree.nsuc_check[ply + 1] = (char) (ptree.nsuc_check[ply - 1] + 1);
					extension = def.EXT_CHECK;
				} else if (ptree.nsuc_check[ply] > 0
						&& ptree.move_last[ply] - ptree.move_last[ply - 1] == 1) {
					ptree.onerp_extension_done++;
					extension = def.EXT_ONEREP;
				} else if (!(ptree.nsuc_check[ply] > 0)
						&& (state_node & def.node_do_recap) > 0
						&& bitop.I2To(ptree.current_move[ply]) == bitop
								.I2To(ptree.current_move[ply - 1])
						&& (ptree.current_move[ply] == ptree.anext_move[ply].move_cap1 || ((ptree.anext_move[ply].value_cap1 < (ptree.anext_move[ply].value_cap2 + data.p_value_ex[15 + def.pawn])) && ptree.current_move[ply] == ptree.anext_move[ply].move_cap2))
						&& (bitop.UToCap(ptree.current_move[ply - 1]) > 0 || (bitop
								.I2IsPromote(ptree.current_move[ply - 1]) > 0 && bitop
								.I2PieceMove(ptree.current_move[ply - 1]) != def.silver))) {
					ptree.recap_extension_done++;
					state_node_new = (def.node_do_null | def.node_do_mate
							| def.node_do_futile | def.node_do_recursion | def.node_do_hashcut);
					if (!(bitop.I2IsPromote(ptree.current_move[ply]) > 0)
							&& bitop.I2PieceMove(ptree.current_move[ply - 1]) == bitop
									.UToCap(ptree.current_move[ply - 1])) {
						extension = def.EXT_RECAP2;
					} else {
						extension = def.EXT_RECAP1;
					}
				}

				extension = bitop.LimitExtension(extension, ply);

				new_depth = depth + extension - def.PLY_INC;

				/* reductions */
				if (def.PLY_INC <= new_depth
						&& first_move_expanded > 0
						&& !((state_node & def.node_mate_threat) > 0)
						&& !(ptree.nsuc_check[ply] > 0)
						&& !(bitop.UToCap(ptree.current_move[ply]) > 0)
						&& !(bitop.I2IsPromote(ptree.current_move[ply]) > 0 && bitop
								.I2PieceMove(ptree.current_move[ply]) != def.silver)
						&& ptree.amove_hash[ply] != ptree.current_move[ply]
						&& ptree.killers[ply].no1 != ptree.current_move[ply]
						&& ptree.killers[ply].no2 != ptree.current_move[ply]) {
					int key = phash.phash(ptree.current_move[ply], turn);
					int good = ptree.hist_good[key] + 1;
					int triedx8 = (ptree.hist_tried[key] + 2) * 8;

					if (beta != alpha_old + 1) {

						if (good * 160 < triedx8) {
							depth_reduced = def.PLY_INC * 3 / 2;
						} else if (good * 50 < triedx8) {
							depth_reduced = def.PLY_INC * 2 / 2;
						} else if (good * 19 < triedx8) {
							depth_reduced = def.PLY_INC * 1 / 2;
						}

					} else {

						if (good * 75 < triedx8) {
							depth_reduced = def.PLY_INC * 4 / 2;
						} else if (good * 46 < triedx8) {
							depth_reduced = def.PLY_INC * 3 / 2;
						} else if (good * 30 < triedx8) {
							depth_reduced = def.PLY_INC * 2 / 2;
						} else if (good * 12 < triedx8) {
							depth_reduced = def.PLY_INC * 1 / 2;
						}
					}

					new_depth -= depth_reduced;
				}

				/* futility pruning */
				if (!(ptree.nsuc_check[ply + 1] > 0)
						&& !(ptree.nsuc_check[ply] > 0)
						&& new_depth < 3 * def.PLY_INC) {
					int diff = evaldiff.estimate_score_diff(ptree,
							ptree.current_move[ply], turn);
					int bound = alpha;

					if (2 * def.PLY_INC <= new_depth) {
						bound -= ((data.p_value_ex[15 + def.dragon] * 2) / 8);
					} else if (1 * def.PLY_INC <= new_depth) {
						bound -= ((data.p_value_ex[15 + def.dragon] * 2) / 8);
					}

					if (evaldiff.eval_max_score(ptree, ptree.current_move[ply],
							ptree.save_eval[ply], turn, diff) <= bound) {
						first_move_expanded += 1;
						continue;
					}
				}

				if (new_depth < 2 * def.PLY_INC
						&& !(ptree.nsuc_check[ply] > 0)
						&& !(ptree.nsuc_check[ply + 1] > 0)
						&& !(bitop.UToCap(ptree.current_move[ply]) > 0)
						&& !(bitop.I2IsPromote(ptree.current_move[ply]) > 0 && bitop
								.I2PieceMove(ptree.current_move[ply]) != def.silver)
						&& ptree.amove_hash[ply] != ptree.current_move[ply]
						&& ptree.killers[ply].no1 != ptree.current_move[ply]
						&& ptree.killers[ply].no2 != ptree.current_move[ply]
						&& beta == alpha_old + 1
						&& swap.swap(ptree, ptree.current_move[ply], -1, 0,
								turn) <= -1) {
					first_move_expanded += 1;
					continue;
				}

				bitop.MakeMove(ptree, turn, ptree.current_move[ply], ply);
				if (bitop.I2From(ptree.current_move[ply]) < def.nsquare
						&& !(ptree.nsuc_check[ply] > 0)
						&& bitop.InCheck(turn, ptree)) {
					bitop.UnMakeMove(ptree, turn, ptree.current_move[ply], ply);
					continue;
				}

				if (!(ptree.nsuc_check[ply + 1] > 0)
						&& !(ptree.nsuc_check[ply] > 0)) {
					int score = -evaluate.evaluate(ptree, ply + 1,
							bitop.Flip(turn));
					assert (ptree.save_eval[ply] != Integer.MAX_VALUE);

					/* futility pruning */
					if ((new_depth < def.PLY_INC && score <= alpha)
							|| (new_depth < 2 * def.PLY_INC && score <= alpha
									- ((data.p_value_ex[15 + def.dragon] * 2) / 8))
							|| (new_depth < 3 * def.PLY_INC && score <= alpha
									- ((data.p_value_ex[15 + def.dragon] * 2) / 8))) {
						first_move_expanded += 1;
						bitop.UnMakeMove(ptree, turn, ptree.current_move[ply],
								ply);
						continue;
					}
				}

				if (!(first_move_expanded > 0)) {
					value = -search(ptree, -beta, -alpha, bitop.Flip(turn),
							new_depth, ply + 1, state_node_new);
				} else {
					value = -search(ptree, -alpha - 1, -alpha,
							bitop.Flip(turn), new_depth, ply + 1,
							state_node_new);
					if (!(data.root_abort > 0) && alpha < value
							&& depth_reduced > 0) {
						new_depth += depth_reduced;
						value = -search(ptree, -alpha - 1, -alpha,
								bitop.Flip(turn), new_depth, ply + 1,
								state_node_new);
					}
					if (!(data.root_abort > 0) && alpha < value
							&& beta != alpha + 1) {
						value = -search(ptree, -beta, -alpha, bitop.Flip(turn),
								new_depth, ply + 1, state_node_new);
					}
				}
				if (data.root_abort > 0) {
					bitop.UnMakeMove(ptree, turn, ptree.current_move[ply], ply);
					return 0;
				}

				bitop.UnMakeMove(ptree, turn, ptree.current_move[ply], ply);

				if (alpha < value) {
					if (new_depth < def.PLY_INC
							&& !(ptree.nsuc_check[ply + 1] > 0)
							&& ptree.save_eval[ply] != Integer.MAX_VALUE) {
						evaldiff.check_futile_score_quies(ptree,
								ptree.current_move[ply], ptree.save_eval[ply],
								-ptree.save_eval[ply + 1], turn);
					}

					if (beta <= value) {

						hash.hash_store(ptree, ply, depth, turn,
								def.value_lower, value,
								ptree.current_move[ply], state_node);
						hist_good(ptree, ptree.current_move[ply], ply, depth,
								turn);

						ptree.fail_high++;
						if (!(first_move_expanded > 0)) {
							ptree.fail_high_first++;
						}

						assert (valid.is_move_valid(ptree,
								ptree.current_move[ply], turn) > 0);
						return value;
					}
				}
				if (alpha < value) {
					alpha = value;
				}

				first_move_expanded += 1;

			}

			if (!(first_move_expanded > 0)) {

				if ((int) bitop.I2From(ptree.current_move[ply - 1]) == bitop
						.Drop2From(def.pawn)) {
					// out_warning( "A checkmate by dropping pawn!!" );
				}

				if (alpha != alpha_old) {
					pv_close(ptree, ply, 0);
				}
				return alpha;
			}

			if (alpha <= -(def.score_mate1ply + 2 - ply)) {

				if (alpha_old < -def.score_inferior
						&& -def.score_inferior < beta) {
					pv_close(ptree, ply, turn > 0 ? def.black_superi_rep
							: def.white_superi_rep);
				}
				ptree.current_move[ply] = def.MOVE_NA;
				return -def.score_inferior;
			}

			if (alpha != alpha_old) {
				hist_good(ptree, ptree.pv[ply].a[ply], ply, depth, turn);

				pv_copy(ptree, ply);

				if (!((data.game_status & def.flag_learning) > 0)) {
					hash.hash_store(ptree, ply, depth, turn, def.value_exact,
							alpha, ptree.pv[ply].a[ply], state_node);
				}
			} else {
				hash.hash_store(ptree, ply, depth, turn, def.value_upper,
						alpha, def.MOVE_NA, state_node);
			}
		}

		return alpha;
	}

	public static int detect_signals(tree_t ptree) {
		int tnow, telapsed, tpondered, tsearched, tcount, tlimit, tmax;
		int tlimit_count, u;
		int iret, easy_time, last_value, stable;

		return 1; // fukuda

		//
		//
		//
		// if ( ! ( (data.game_status & def.flag_nopeek) > 0 ) )
		// {
		// /* peek input-buffer to find a command */
		// iret = io.next_cmdline( 0 );
		// if ( iret == -1 )
		// {
		// data.game_status |= def.flag_search_error;
		// return 1;
		// }
		// else if ( iret == -2 )
		// {
		//
		// ShutdownAll();
		// }
		// else if ( (data.game_status & def.flag_quit) > 0 ) { return 1; } /*
		// EOF */
		// else if ( iret > 0)
		// {
		// /* a command is found */
		// iret = procedure( ptree );
		// if ( iret == -1 )
		// {
		// game_status |= flag_search_error;
		// next_cmdline( 1 );
		// return 1;
		// }
		// else if ( iret == -2 )
		// {
		// out_warning( "%s", str_error );
		// next_cmdline( 1 );
		// ShutdownAll();
		// }
		// else if ( iret == 1 ) { next_cmdline( 1 ); }
		//
		// if ( game_status & ( flag_quit | flag_quit_ponder
		// | flag_move_now | flag_suspend ) )
		// {
		// return 1;
		// }
		// }
		// }
		//
		// /* check conditions of search-abortion, and obtain tnow and elapsed
		// */
		// if ( node_limit <= ptree.node_searched ) { return 1; }
		// tnow = get_elapsed();
		//
		//
		//
		//
		//
		//
		//
		//
		// /* shortening the time limit by depth */
		// if ( time_limit != UINT_MAX
		// && sec_limit_depth < PLY_MAX
		// && iteration_depth + 10 >= (int)sec_limit_depth )
		// {
		// if ( iteration_depth + 0 >= (int)sec_limit_depth ) { u = 1; }
		// else if ( iteration_depth + 1 >= (int)sec_limit_depth ) { u = 3; }
		// else if ( iteration_depth + 2 >= (int)sec_limit_depth ) { u = 7; }
		// else if ( iteration_depth + 3 >= (int)sec_limit_depth ) { u = 15; }
		// else if ( iteration_depth + 4 >= (int)sec_limit_depth ) { u = 31; }
		// else if ( iteration_depth + 5 >= (int)sec_limit_depth ) { u = 63; }
		// else if ( iteration_depth + 6 >= (int)sec_limit_depth ) { u = 127; }
		// else if ( iteration_depth + 7 >= (int)sec_limit_depth ) { u = 255; }
		// else if ( iteration_depth + 8 >= (int)sec_limit_depth ) { u = 511; }
		// else if ( iteration_depth + 9 >= (int)sec_limit_depth ) { u = 1023; }
		// else { u = 2047; }
		//
		// tlimit = u * 1000 + 1000 - time_response;
		// tmax = u * 5000 + 1000 - time_response;
		// if ( tlimit > time_limit ) { tlimit = time_limit; }
		// if ( tmax > time_max_limit ) { tmax = time_max_limit; }
		// }
		// else {
		// tlimit = time_limit;
		// tmax = time_max_limit;
		// }
		//
		// telapsed = tnow - time_turn_start;
		// tpondered = time_turn_start - time_start;
		// tsearched = tnow - time_start;
		// easy_time = 0;
		// last_value = root_turn ? -last_root_value : last_root_value;
		// stable = ( tlimit != UINT_MAX
		// && ( ( root_alpha == root_value && ! root_nfail_low )
		// || last_pv.type == four_fold_rep
		// || ( root_nfail_high
		// && root_value + MT_CAP_DRAGON/8 >= last_value ) ) );
		//
		// if ( tlimit != tmax )
		// {
		// tcount = tsearched;
		// tlimit_count = tlimit;
		// }
		// else {
		// tcount = telapsed;
		// tlimit_count = tlimit + tpondered;
		// }
		//
		// if ( ! (( game_status & flag_pondering ) > 0)
		// && root_nmove == 1
		// && telapsed > 2000 - time_response ) { return 1; }
		//
		// if ( tcount > tmax ) { return 1; }
		//
		// if ( stable && tcount > tlimit ) { return 1; }
		//
		// if ( stable
		// && easy_abs > abs( last_value )
		// && easy_min < last_value - easy_value
		// && easy_max > last_value - easy_value )
		// {
		// u = tlimit_count / 5;
		// if ( u < tpondered ) { ; }
		// else if ( u - tpondered < 2000 - time_response )
		// {
		// u = tpondered + 2000 - time_response;
		// }
		// else {
		// u = ( ( u - tpondered ) / 1000 + 1 ) * 1000
		// + tpondered - time_response;
		// }
		//
		// if ( tsearched > u )
		// {
		// Out( "  The root move %s counted as easy!!\n",
		// str_CSA_move(root_move_list[0].move) );
		//
		// return 1;
		// }
		// else if ( tsearched + 500 > u ) { easy_time = 1; }
		// }
		//
		// /* update node_per_second */
		// {
		// double dn, dd;
		//
		// dn = (double)node_last_check * 1000.0;
		// dd = (double)( tnow - time_last_check ) + 0.1;
		// u = ( dn / dd );
		// if ( node_per_second > u * 2 ) { node_per_second /= 2; }
		// else if ( node_per_second < u / 2 ) { node_per_second *= 2; }
		// else { node_per_second = u; }
		// }
		//
		// /* update node_next_signal */
		// if ( ! ( game_status & flag_pondering ) && root_nmove == 1 )
		// {
		// u = 2000 - time_response;
		// }
		// else { u = tlimit; }
		//
		// if ( ! ( game_status & ( flag_pondering | flag_puzzling ) )
		// && ! easy_time
		// && u > tcount + 500 )
		// {
		// node_next_signal = node_per_second / 4;
		// }
		// else { node_next_signal = node_per_second / 32; }
		//
		// /* update time_last_check and node_last_check */
		// time_last_check = tnow;
		// node_last_check = 0;
		//
		// return 0;
	}

	static int detect_rep(tree_t ptree, int ply, int turn) {
		if (ply < 4) {
			return utility.detect_repetition(ptree, ply, turn, 2);
		} else {
			int n, i, imin, iret;

			n = ptree.nrep + ply - 1;
			imin = n - def.REP_MAX_PLY;
			if (imin < 0) {
				imin = 0;
			}

			for (i = n - 2; i >= imin; i--)
				if (ptree.rep_board_list[i] == ptree.posi.hash_key) {
					iret = rep_type(ptree, n, i, ply, turn);
					if (iret > 0) {
						return iret;
					}
				}
		}

		return def.no_rep;
	}

	static int rep_type(final tree_t ptree, int n, int i, int ply, int turn) {
		final int hand1 = ptree.posi.hand_black;
		final int hand2 = ptree.rep_hand_list[i];

		if (((n - i) & 1) > 0) {
			if (turn > 0) {
				if (utility.is_hand_eq_supe(hand2, hand1) > 0) {
					return def.white_superi_rep;
				}
			} else if (utility.is_hand_eq_supe(hand1, hand2) > 0) {
				return def.black_superi_rep;
			}
		} else if (hand1 == hand2) {
			final int ncheck = (int) ptree.nsuc_check[ply];
			final int nchecked = (int) ptree.nsuc_check[ply - 1];

			if (ncheck * 2 - 2 >= n - i) {
				return def.perpetual_check;
			} else if (nchecked * 2 >= n - i) {
				return def.perpetual_check2;
			} else {
				return def.four_fold_rep;
			}
		} else if (utility.is_hand_eq_supe(hand1, hand2) > 0) {
			return def.black_superi_rep;
		} else if (utility.is_hand_eq_supe(hand2, hand1) > 0) {
			return def.white_superi_rep;
		}

		return def.no_rep;
	}

	private static void hist_add(tree_t ptree, int ply) {
		if (ptree.nsuc_check[ply] > 0) {
			return;
		}
		if (bitop.UToCap(ptree.current_move[ply]) > 0) {
			return;
		}
		if (bitop.I2IsPromote(ptree.current_move[ply]) > 0
				&& bitop.I2PieceMove(ptree.current_move[ply]) != def.silver) {
			return;
		}

		assert (ptree.hist_nmove[ply] < def.MAX_LEGAL_MOVES);
		ptree.hist_move[ply][ptree.hist_nmove[ply]++] = ptree.current_move[ply];
	}

	private static void hist_good(tree_t ptree, int move_good, int ply,
			int depth, int turn) {
		int key, move;
		int i, n, value, value_no1, value_no2;

		if (ptree.nsuc_check[ply] > 0) {
			return;
		}

		value = data.p_value_ex[15 + bitop.UToCap(move_good)];
		value_no1 = data.p_value_ex[15 + ptree.posi.asquare[bitop
				.I2To(ptree.amove_killer[ply].no1)]];
		value_no2 = data.p_value_ex[15 + ptree.posi.asquare[bitop
				.I2To(ptree.amove_killer[ply].no2)]];
		if (move_good == ptree.anext_move[ply].move_cap1) {
			if ((ptree.anext_move[ply].phase_done & def.phase_killer1) > 0
					&& bitop.UToFromToPromo(move_good) != ptree.amove_killer[ply].no1) {
				ptree.amove_killer[ply].no1_value = ptree.anext_move[ply].value_cap1
						- value - 1;
			}
			if ((ptree.anext_move[ply].phase_done & def.phase_killer2) > 0
					&& bitop.UToFromToPromo(move_good) != ptree.amove_killer[ply].no2) {
				ptree.amove_killer[ply].no2_value = ptree.anext_move[ply].value_cap1
						- value - 2;
			}
		} else if (bitop.UToFromToPromo(move_good) == ptree.amove_killer[ply].no1) {
			if ((ptree.anext_move[ply].phase_done & def.phase_cap1) > 0
					&& (ptree.amove_killer[ply].no1_value + value < ptree.anext_move[ply].value_cap1 + 1)) {
				ptree.amove_killer[ply].no1_value = ptree.anext_move[ply].value_cap1
						- value + 1;
			}
			if ((ptree.anext_move[ply].phase_done & def.phase_killer2) > 0
					&& (ptree.amove_killer[ply].no1_value + value < ptree.amove_killer[ply].no2_value
							+ value_no2 + 1)) {
				ptree.amove_killer[ply].no1_value = ptree.amove_killer[ply].no2_value
						+ value_no2 - value + 1;
			}
		} else if (bitop.UToFromToPromo(move_good) == ptree.amove_killer[ply].no2) {
			int uswap;
			int iswap;

			if ((ptree.anext_move[ply].phase_done & def.phase_cap1) > 0
					&& (ptree.amove_killer[ply].no2_value + value < ptree.anext_move[ply].value_cap1 + 1)) {
				ptree.amove_killer[ply].no2_value = ptree.anext_move[ply].value_cap1
						- value + 1;
			}
			if ((ptree.anext_move[ply].phase_done & def.phase_killer1) > 0
					&& (ptree.amove_killer[ply].no2_value + value < ptree.amove_killer[ply].no1_value
							+ value_no1 + 1)) {
				ptree.amove_killer[ply].no2_value = ptree.amove_killer[ply].no1_value
						+ value_no1 - value + 1;
			}

			uswap = ptree.amove_killer[ply].no1;
			ptree.amove_killer[ply].no1 = ptree.amove_killer[ply].no2;
			ptree.amove_killer[ply].no2 = uswap;

			iswap = ptree.amove_killer[ply].no1_value;
			ptree.amove_killer[ply].no1_value = ptree.amove_killer[ply].no2_value;
			ptree.amove_killer[ply].no2_value = iswap;
		} else {
			ptree.amove_killer[ply].no2 = ptree.amove_killer[ply].no1;
			ptree.amove_killer[ply].no1 = bitop.UToFromToPromo(move_good);

			if ((ptree.anext_move[ply].phase_done & def.phase_killer1) > 0) {
				i = swap.swap(ptree, move_good,
						-data.p_value_ex[15 + def.rook],
						data.p_value_ex[15 + def.rook], turn);
				i -= value + 1;

				if (ptree.amove_killer[ply].no1_value > i) {
					ptree.amove_killer[ply].no1_value = i;
				}
			}
			ptree.amove_killer[ply].no2_value = ptree.amove_killer[ply].no1_value;
			ptree.amove_killer[ply].no1_value = ptree.anext_move[ply].value_cap1
					- value + 1;
		}

		if (bitop.UToCap(move_good) > 0) {
			return;
		}
		if (bitop.I2IsPromote(move_good) > 0
				&& bitop.I2PieceMove(move_good) != def.silver) {
			return;
		}

		if (ptree.killers[ply].no1 != move_good) {
			ptree.killers[ply].no2 = ptree.killers[ply].no1;
			ptree.killers[ply].no1 = move_good;
		}

		if (depth < 1) {
			depth = 1;
		}

		n = ptree.hist_nmove[ply];
		for (i = 0; i < n; i++) {
			move = ptree.hist_move[ply][i];
			assert (valid.is_move_valid(ptree, move, turn) > 0);

			key = phash.phash(move, turn);
			if (ptree.hist_tried[key] >= def.HIST_MAX) {
				ptree.hist_good[key] /= 2;
				ptree.hist_tried[key] /= 2;
			}

			assert (ptree.hist_tried[key] < def.HIST_MAX);
			ptree.hist_tried[key] = (short) ((int) ptree.hist_tried[key] + depth);
		}

		assert (valid.is_move_valid(ptree, move_good, turn) > 0);
		key = phash.phash(move_good, turn);

		assert (ptree.hist_good[key] < def.HIST_MAX);
		ptree.hist_good[key] = (short) ((int) ptree.hist_good[key] + depth);
	}

	/**
	 * ~bŕԂ
	 * 
	 * @param ptime
	 * @return
	 */
	private static int get_elapsed() {
		return (int) (System.nanoTime() / 1000000);
	}

	public static void pv_close(tree_t ptree, int ply, int type) {
		ptree.pv[ply - 1].a[ply - 1] = (ptree).current_move[ply - 1];
		ptree.pv[ply - 1].length = (char) (ply - 1);
		ptree.pv[ply - 1].type = (char) type;
		ptree.pv[ply - 1].depth = (char) data.iteration_depth;
	}

	public static void pv_copy(tree_t ptree, int ply) {
		// TODO: SPDǂ
		for (int i = 0; i < ptree.pv[ply].length - ply + 1; i++) {
			ptree.pv[ply - 1].a[ply + i] = ptree.pv[ply].a[ply + i];
		}

		ptree.pv[ply - 1].type = ptree.pv[ply].type;
		ptree.pv[ply - 1].length = ptree.pv[ply].length;
		ptree.pv[ply - 1].depth = ptree.pv[ply].depth;
		ptree.pv[ply - 1].a[ply - 1] = ptree.current_move[ply - 1];
	}

}
