public class mate3 {

	static long[] mate3_hash_tbl = new long[def.MATE3_MASK + 1];

	private static final int mate_king_cap_checker = 0;
	private static final int mate_cap_checker_gen = 1;
	private static final int mate_cap_checker = 2;
	private static final int mate_king_cap_gen = 3;
	private static final int mate_king_cap = 4;
	private static final int mate_king_move_gen = 5;
	private static final int mate_king_move = 6;
	private static final int mate_intercept_move_gen = 7;
	private static final int mate_intercept_move = 8;
	private static final int mate_intercept_weak_move = 9;
	private static final int mate_intercept_drop_sup = 10;

	public static int is_mate_in3ply(tree_t ptree, int turn, int ply) {
		int value, flag_skip;

		if (mhash_probe(ptree, turn, ply) > 0) {
			if (ptree.current_move[ply] == def.MOVE_NA) {
				return 0;
			} else {
				return 1;
			}
		}

		if (ply >= def.PLY_MAX - 2) {
			return 0;
		}

		flag_skip = 0;

		ptree.anext_move[ply].move_last = ptree.move_last[ply - 1];
		ptree.move_last[ply] = bitop.GenCheck(turn, ptree, ptree.amove,
				ptree.move_last[ply - 1]);
		int pmoveidx = ptree.move_last[ply];
		while (ptree.anext_move[ply].move_last != ptree.move_last[ply]) {
			ptree.current_move[ply] = ptree.amove[ptree.anext_move[ply].move_last++];

			if ((ptree.current_move[ply] & def.MOVE_CHK_CLEAR) > 0) {
				flag_skip = 0;
			}
			if (flag_skip > 0) {
				continue;
			}

			assert (valid.is_move_valid(ptree, ptree.current_move[ply], turn) > 0);
			bitop.MakeMove(ptree, turn, ptree.current_move[ply], ply);
			if (bitop.InCheck(turn, ptree)) {
				bitop.UnMakeMove(ptree, turn, ptree.current_move[ply], ply);
				continue;
			}

			value = mate3_and(ptree, bitop.Flip(turn), ply + 1, 0);

			bitop.UnMakeMove(ptree, turn, ptree.current_move[ply], ply);

			if (value > 0) {
				mhash_store(ptree, turn, ptree.current_move[ply]);
				return 1;
			}

			if ((ptree.current_move[ply] & def.MOVE_CHK_SET) > 0
					&& bitop.I2To(ptree.current_move[ply]) != bitop
							.I2To(ptree.current_move[ply + 1])) {
				flag_skip = 1;
			}
		}

		mhash_store(ptree, turn, def.MOVE_NA);
		return 0;
	}

	private static void mhash_store(tree_t ptree, int turn, int move) {
		long word;

		word = ptree.posi.hash_key & ~(long) 0x7ffff;
		word |= (move & 0x7ffff);
		word ^= ptree.posi.hand_black << 42;
		word ^= turn << 63;

		mate3_hash_tbl[(int) ptree.posi.hash_key & def.MATE3_MASK] = word;
	}

	private static int mate3_and(tree_t ptree, int turn, int ply, int flag) {
		boolean move;
		char[] asq = new char[2];

		assert (bitop.InCheck(turn, ptree));

		ptree.anext_move[ply].next_phase = mate_king_cap_checker;
		checker(ptree, asq, turn);

		while (gen_next_evasion_mate(ptree, asq, ply, turn, flag) > 0) {

			if (ptree.anext_move[ply].next_phase == mate_intercept_drop_sup) {
				return 0;
			}

			bitop.MakeMove(ptree, turn, ptree.current_move[ply], ply);
			assert (!bitop.InCheck(turn, ptree));

			if (bitop.InCheck(bitop.Flip(turn), ptree)) {
				move = false;
			} else {
				move = bitop.IsMateIn1Ply(bitop.Flip(turn), ptree);
			}

			if (!move
					&& ptree.anext_move[ply].next_phase == mate_intercept_weak_move) {
				assert (asq[1] == def.nsquare);
				move = mate_weak_or(ptree, bitop.Flip(turn), ply + 1, asq[0],
						bitop.I2To(ptree.current_move[ply])) > 0;
			}

			bitop.UnMakeMove(ptree, turn, ptree.current_move[ply], ply);

			if (!move) {
				return 0;
			}
		}

		return 1;
	}

	private static int mate_weak_or(tree_t ptree, int turn, int ply, int from,
			int to) {
		int idirec, pc, pc_cap, value, flag;

		if (ply >= def.PLY_MAX - 2) {
			return 0;
		}

		if (turn > 0) {
			if (bitop.IsDiscoverWK(from, to, ptree)) {
				return 0;
			}

			pc = -ptree.posi.asquare[from];
			pc_cap = ptree.posi.asquare[to];
			ptree.current_move[ply] = (bitop.To2Move(to)
					| bitop.From2Move(from) | bitop.Piece2Move(pc) | bitop
					.Cap2Move(pc_cap));
			if ((pc == def.bishop || pc == def.rook)
					&& (to > def.I4 || from > def.I4)) {
				ptree.current_move[ply] |= def.FLAG_PROMO;
			}
		} else {
			if (bitop.IsDiscoverBK(from, to, ptree)) {
				return 0;
			}

			pc = ptree.posi.asquare[from];
			pc_cap = -ptree.posi.asquare[to];
			ptree.current_move[ply] = (bitop.To2Move(to)
					| bitop.From2Move(from) | bitop.Piece2Move(pc) | bitop
					.Cap2Move(pc_cap));
			if ((pc == def.bishop || pc == def.rook)
					&& (to < def.A6 || from < def.A6)) {
				ptree.current_move[ply] |= def.FLAG_PROMO;
			}
		}

		bitop.MakeMove(ptree, turn, ptree.current_move[ply], ply);
		if (bitop.I2From(ptree.current_move[ply - 1]) < def.nsquare) {
			if (bitop.InCheck(turn, ptree)) {
				bitop.UnMakeMove(ptree, turn, ptree.current_move[ply], ply);
				return 0;
			}
			flag = 1;
		} else {
			assert (!bitop.InCheck(turn, ptree));
			flag = 2;
		}

		ptree.move_last[ply] = ptree.move_last[ply - 1];
		value = mate3_and(ptree, bitop.Flip(turn), ply + 1, flag);

		bitop.UnMakeMove(ptree, turn, ptree.current_move[ply], ply);

		return value;
	}

	private static int gen_next_evasion_mate(tree_t ptree, char[] psq, int ply,
			int turn, int flag) {
		switch (ptree.anext_move[ply].next_phase) {
		case mate_king_cap_checker:
			ptree.anext_move[ply].next_phase = mate_cap_checker_gen;
			ptree.current_move[ply] = gen_king_cap_checker(ptree, psq[0], turn);
			if (ptree.current_move[ply] > 0) {
				return 1;
			}

		case mate_cap_checker_gen:
			ptree.anext_move[ply].next_phase = mate_cap_checker;
			ptree.anext_move[ply].move_last = ptree.move_last[ply - 1];
			ptree.move_last[ply] = ptree.move_last[ply - 1];
			if (psq[1] == def.nsquare) {
				ptree.move_last[ply] = gen_move_to(ptree, psq[0], turn,
						ptree.move_last[ply - 1]);
			}

		case mate_cap_checker:
			if (ptree.anext_move[ply].move_last != ptree.move_last[ply]) {
				ptree.current_move[ply] = ptree.amove[ptree.anext_move[ply].move_last++];
				return 1;
			}

		case mate_king_cap_gen:
			ptree.anext_move[ply].next_phase = mate_king_cap;
			ptree.anext_move[ply].move_last = ptree.move_last[ply - 1];
			ptree.move_last[ply] = gen_king_move(ptree, psq, turn, 1,
					ptree.move_last[ply - 1]);

		case mate_king_cap:
			if (ptree.anext_move[ply].move_last != ptree.move_last[ply]) {
				ptree.current_move[ply] = ptree.amove[ptree.anext_move[ply].move_last++];
				return 1;
			}

		case mate_king_move_gen:
			ptree.anext_move[ply].next_phase = mate_king_move;
			ptree.anext_move[ply].move_last = ptree.move_last[ply - 1];
			ptree.move_last[ply] = gen_king_move(ptree, psq, turn, 0,
					ptree.move_last[ply - 1]);

		case mate_king_move:
			if (ptree.anext_move[ply].move_last != ptree.move_last[ply]) {
				ptree.current_move[ply] = ptree.amove[ptree.anext_move[ply].move_last];
				ptree.anext_move[ply].move_last++;
				return 1;
			}

		case mate_intercept_move_gen:
			ptree.anext_move[ply].remaining = 0;
			ptree.anext_move[ply].next_phase = mate_intercept_move;
			ptree.anext_move[ply].move_last = ptree.move_last[ply - 1];
			ptree.move_last[ply] = ptree.move_last[ply - 1];
			if (psq[1] == def.nsquare
					&& Math.abs(ptree.posi.asquare[(int) psq[0]]) != def.knight) {
				int n;
				int[] ret = gen_intercept(ptree, psq[0], ply, turn,
						ptree.move_last[ply - 1], flag);
				ptree.move_last[ply] = ret[0];
				n = ret[1];
				if (n < 0) {
					ptree.anext_move[ply].next_phase = mate_intercept_drop_sup;
					ptree.anext_move[ply].remaining = 0;
					ptree.current_move[ply] = ptree.amove[ptree.anext_move[ply].move_last++];
					return 1;
				}

				ptree.anext_move[ply].remaining = n;
			}

		case mate_intercept_move:
			if (ptree.anext_move[ply].remaining-- > 0) {
				ptree.current_move[ply] = ptree.amove[ptree.anext_move[ply].move_last++];
				return 1;
			}
			ptree.anext_move[ply].next_phase = mate_intercept_weak_move;

		case mate_intercept_weak_move:
			if (ptree.anext_move[ply].move_last != ptree.move_last[ply]) {
				ptree.current_move[ply] = ptree.amove[ptree.anext_move[ply].move_last++];
				return 1;
			}
			break;

		default:
			assert (false);
		}

		return 0;
	}

	private static int gen_king_move(tree_t ptree, char[] psq, int turn,
			int is_capture, int moveidx) {
		bitboard_t bb = new bitboard_t();
		int to, from;

		if (turn > 0) {
			from = ptree.posi.isquare_w_king;
			bb = data.abb_king_attacks[from];
			if (is_capture > 0) {
				bitop.BBAnd(bb, bb, ptree.posi.b_occupied);
				bitop.BBNotAnd(bb, bb, data.abb_mask[(int) psq[0]]);
			} else {
				bitop.BBNotAnd(bb, bb, ptree.posi.b_occupied);
			}
			bitop.BBNotAnd(bb, bb, ptree.posi.w_occupied);
		} else {
			from = ptree.posi.isquare_b_king;
			bb = data.abb_king_attacks[from];
			if (is_capture > 0) {
				bitop.BBAnd(bb, bb, ptree.posi.w_occupied);
				bitop.BBNotAnd(bb, bb, data.abb_mask[(int) psq[0]]);
			} else {
				bitop.BBNotAnd(bb, bb, ptree.posi.w_occupied);
			}
			bitop.BBNotAnd(bb, bb, ptree.posi.b_occupied);
		}

		while (bitop.BBTest(bb)) {
			to = bitop.LastOne(bb);
			bitop.Xor(to, bb);

			if (psq[1] != def.nsquare
					&& (data.adirec[from][(int) psq[1]] == data.adirec[from][to])) {
				continue;
			}

			if (psq[0] != to
					&& data.adirec[from][(int) psq[0]] == data.adirec[from][to]) {
				if ((data.adirec[from][(int) psq[0]] & def.flag_cross) > 0) {
					if (Math.abs(ptree.posi.asquare[(int) psq[0]]) == def.lance
							|| Math.abs(ptree.posi.asquare[(int) psq[0]]) == def.rook
							|| Math.abs(ptree.posi.asquare[(int) psq[0]]) == def.dragon) {
						continue;
					}
				} else if (((data.adirec[from][(int) psq[0]] & def.flag_diag) > 0)
						&& (Math.abs(ptree.posi.asquare[(int) psq[0]]) == def.bishop || Math
								.abs(ptree.posi.asquare[(int) psq[0]]) == def.horse)) {
					continue;
				}
			}

			if (turn > 0) {
				if (attack.is_white_attacked(ptree, to)) {
					continue;
				}

				ptree.amove[moveidx++] = (bitop.From2Move(from)
						| bitop.To2Move(to) | bitop.Piece2Move(def.king) | bitop
						.Cap2Move(ptree.posi.asquare[to]));
			} else {
				if (attack.is_black_attacked(ptree, to)) {
					continue;
				}

				ptree.amove[moveidx++] = (bitop.From2Move(from)
						| bitop.To2Move(to) | bitop.Piece2Move(def.king) | bitop
						.Cap2Move(-ptree.posi.asquare[to]));
			}
		}

		return moveidx;
	}

	private static int gen_move_to(tree_t ptree, int to, int turn, int moveidx) {
		bitboard_t bb = new bitboard_t();
		int direc, from, pc, flag_promo, flag_unpromo;

		if (turn > 0) {
			bb = attack.w_attacks_to_piece(ptree, to);
			bitop.BBNotAnd(bb, bb, data.abb_mask[ptree.posi.isquare_w_king]);
			while (bitop.BBTest(bb)) {
				from = bitop.LastOne(bb);
				bitop.Xor(from, bb);

				direc = (int) data.adirec[ptree.posi.isquare_w_king][from];
				if (direc > 0
						&& attack.is_pinned_on_white_king(ptree, from, direc) > 0) {
					continue;
				}

				flag_promo = 0;
				flag_unpromo = 1;
				pc = -ptree.posi.asquare[from];
				switch (pc) {
				case def.pawn:
					if (to > def.I4) {
						flag_promo = 1;
						flag_unpromo = 0;
					}
					break;

				case def.lance:
				case def.knight:
					if (to > def.I3) {
						flag_promo = 1;
						flag_unpromo = 0;
					} else if (to > def.I4) {
						flag_promo = 1;
					}
					break;

				case def.silver:
					if (to > def.I4 || from > def.I4) {
						flag_promo = 1;
					}
					break;

				case def.bishop:
				case def.rook:
					if (to > def.I4 || from > def.I4) {
						flag_promo = 1;
						flag_unpromo = 0;
					}
					break;

				default:
					break;
				}
				assert (flag_promo > 0 || flag_unpromo > 0);
				if (flag_promo > 0) {
					ptree.amove[moveidx++] = (bitop.From2Move(from)
							| bitop.To2Move(to) | def.FLAG_PROMO
							| bitop.Piece2Move(pc) | bitop
							.Cap2Move(ptree.posi.asquare[to]));
				}
				if (flag_unpromo > 0) {
					ptree.amove[moveidx++] = (bitop.From2Move(from)
							| bitop.To2Move(to) | bitop.Piece2Move(pc) | bitop
							.Cap2Move(ptree.posi.asquare[to]));
				}
			}
		} else {
			bb = attack.b_attacks_to_piece(ptree, to);
			bitop.BBNotAnd(bb, bb, data.abb_mask[ptree.posi.isquare_b_king]);
			while (bitop.BBTest(bb)) {
				from = bitop.FirstOne(bb);
				bitop.Xor(from, bb);

				direc = (int) data.adirec[ptree.posi.isquare_b_king][from];
				if (direc > 0
						&& attack.is_pinned_on_black_king(ptree, from, direc) > 0) {
					continue;
				}

				flag_promo = 0;
				flag_unpromo = 1;
				pc = ptree.posi.asquare[from];
				switch (pc) {
				case def.pawn:
					if (to < def.A6) {
						flag_promo = 1;
						flag_unpromo = 0;
					}
					break;

				case def.lance:
				case def.knight:
					if (to < def.A7) {
						flag_promo = 1;
						flag_unpromo = 0;
					} else if (to < def.A6) {
						flag_promo = 1;
					}
					break;

				case def.silver:
					if (to < def.A6 || from < def.A6) {
						flag_promo = 1;
					}
					break;

				case def.bishop:
				case def.rook:
					if (to < def.A6 || from < def.A6) {
						flag_promo = 1;
						flag_unpromo = 0;
					}
					break;

				default:
					break;
				}
				assert (flag_promo > 0 || flag_unpromo > 0);
				if (flag_promo > 0) {
					ptree.amove[moveidx++] = (bitop.From2Move(from)
							| bitop.To2Move(to) | def.FLAG_PROMO
							| bitop.Piece2Move(pc) | bitop
							.Cap2Move(-ptree.posi.asquare[to]));
				}
				if (flag_unpromo > 0) {
					ptree.amove[moveidx++] = (bitop.From2Move(from)
							| bitop.To2Move(to) | bitop.Piece2Move(pc) | bitop
							.Cap2Move(-ptree.posi.asquare[to]));
				}
			}
		}

		return moveidx;
	}

	private static int gen_king_cap_checker(tree_t ptree, int to, int turn) {
		int move;
		int from;

		if (turn > 0) {
			from = ptree.posi.isquare_w_king;
			if (!(bitop.BBContract(data.abb_king_attacks[from],
					data.abb_mask[to]) > 0)) {
				return 0;
			}
			if (is_white_attacked(ptree, to) > 0) {
				return 0;
			}
			move = bitop.Cap2Move(ptree.posi.asquare[to]);
		} else {
			from = ptree.posi.isquare_b_king;
			if (!(bitop.BBContract(data.abb_king_attacks[from],
					data.abb_mask[to]) > 0)) {
				return 0;
			}
			if (attack.is_black_attacked(ptree, to)) {
				return 0;
			}
			move = bitop.Cap2Move(-ptree.posi.asquare[to]);
		}
		move |= bitop.To2Move(to) | bitop.From2Move(from)
				| bitop.Piece2Move(def.king);

		return move;
	}

	private static int is_black_attacked(tree_t ptree, int sq) {
		bitboard_t bb = new bitboard_t(), bb1 = new bitboard_t(), bb_atk = new bitboard_t();

		bitop.BBAnd(bb, ptree.posi.w_pawn_attacks, data.abb_mask[sq]);
		bitop.BBAndOr(bb, ptree.posi.w_knight, data.abb_b_knight_attacks[sq]);
		bitop.BBAndOr(bb, ptree.posi.w_silver, data.abb_b_silver_attacks[sq]);
		bitop.BBAndOr(bb, ptree.posi.w_tgold, data.abb_b_gold_attacks[sq]);
		bitop.BBAndOr(bb, ptree.posi.w_hdk, data.abb_king_attacks[sq]);

		bitop.AttackBishop(bb_atk, sq, ptree);
		bitop.BBAndOr(bb, ptree.posi.w_bh, bb_atk);

		bb1 = ptree.posi.w_rd;
		bitop.BBAndOr(bb1, ptree.posi.w_lance, data.abb_minus_rays[sq]);
		bitop.BBAndOr(bb, bb1, bitop.AttackFile(sq, ptree));
		bitop.BBAndOr(bb, ptree.posi.w_rd, bitop.AttackRank(sq, ptree));

		return bitop.BBToU(bb);
	}

	public static int is_white_attacked(tree_t ptree, int sq) {
		bitboard_t bb = new bitboard_t(), bb1 = new bitboard_t(), bb_atk = new bitboard_t();

		bitop.BBAnd(bb, ptree.posi.b_pawn_attacks, data.abb_mask[sq]);
		bitop.BBAndOr(bb, ptree.posi.b_knight, data.abb_w_knight_attacks[sq]);
		bitop.BBAndOr(bb, ptree.posi.b_silver, data.abb_w_silver_attacks[sq]);
		bitop.BBAndOr(bb, ptree.posi.b_tgold, data.abb_w_gold_attacks[sq]);
		bitop.BBAndOr(bb, ptree.posi.b_hdk, data.abb_king_attacks[sq]);

		bitop.AttackBishop(bb_atk, sq, ptree);
		bitop.BBAndOr(bb, ptree.posi.b_bh, bb_atk);

		bb1 = ptree.posi.b_rd;
		bitop.BBAndOr(bb1, ptree.posi.b_lance, data.abb_plus_rays[sq]);
		bitop.BBAndOr(bb, bb1, bitop.AttackFile(sq, ptree));
		bitop.BBAndOr(bb, ptree.posi.b_rd, bitop.AttackRank(sq, ptree));

		return bitop.BBToU(bb);
	}

	private static int Drop(int pc) {
		return bitop.To2Move(pc) | bitop.Drop2Move(pc);
	}

	private static int[] gen_intercept(tree_t ptree, int sq_checker, int ply,
			int turn, int moveidx, int flag) {

		bitboard_t bb_atk = new bitboard_t(), bb_defender = new bitboard_t(), bb = new bitboard_t();
		int[] amove = new int[16];
		int hand;
		int n0, n1, inc, pc, sq_k, to, from, direc, nmove, nsup, i, min_chuai, itemp;
		int dist, flag_promo, flag_unpromo;

		n0 = n1 = 0;
		if (turn > 0) {
			sq_k = ptree.posi.isquare_w_king;
			bb_defender = ptree.posi.w_occupied;
			bitop.BBNotAnd(bb_defender, bb_defender, data.abb_mask[sq_k]);
		} else {
			sq_k = ptree.posi.isquare_b_king;
			bb_defender = ptree.posi.b_occupied;
			bitop.BBNotAnd(bb_defender, bb_defender, data.abb_mask[sq_k]);
		}

		if ((int) data.adirec[sq_k][sq_checker] == def.direc_rank) {
			min_chuai = (sq_k < def.A8 || def.I2 < sq_k) ? 2 : 4;
			inc = 1;
		} else if ((int) data.adirec[sq_k][sq_checker] == def.direc_diag1) {
			min_chuai = 3;
			inc = 8;

		} else if ((int) data.adirec[sq_k][sq_checker] == def.direc_file) {
			itemp = (int) def.aifile[sq_k];
			min_chuai = (itemp == def.file1 || itemp == def.file9) ? 2 : 4;
			inc = 9;
		} else {
			assert ((int) data.adirec[sq_k][sq_checker] == def.direc_diag2);
			min_chuai = 3;
			inc = 10;
		}
		if (sq_k > sq_checker) {
			inc = -inc;
		}

		for (dist = 1, to = sq_k + inc; to != sq_checker; dist += 1, to += inc) {

			assert (0 <= to && to < def.nsquare && ptree.posi.asquare[to] == def.empty);

			nmove = 0;
			bb_atk = new bitboard_t(attack.attacks_to_piece(ptree, to));
			bitop.BBAnd(bb, bb_defender, bb_atk);
			while (bitop.BBTest(bb)) {
				from = bitop.LastOne(bb);
				bitop.Xor(from, bb);

				direc = (int) data.adirec[sq_k][from];
				flag_promo = 0;
				flag_unpromo = 1;
				if (turn > 0) {
					if (direc > 0
							&& attack.is_pinned_on_white_king(ptree, from,
									direc) > 0) {
						continue;
					}
					pc = -ptree.posi.asquare[from];
					switch (pc) {
					case def.pawn:
						if (to > def.I4) {
							flag_promo = 1;
							flag_unpromo = 0;
						}
						break;

					case def.lance:
					case def.knight:
						if (to > def.I3) {
							flag_promo = 1;
							flag_unpromo = 0;
						} else if (to > def.I4) {
							flag_promo = 1;
						}
						break;

					case def.silver:
						if (to > def.I4 || from > def.I4) {
							flag_promo = 1;
						}
						break;

					case def.bishop:
					case def.rook:
						if (to > def.I4 || from > def.I4) {
							flag_promo = 1;
							flag_unpromo = 0;
						}
						break;

					default:
						break;
					}
				} else {
					if (direc > 0
							&& attack.is_pinned_on_black_king(ptree, from,
									direc) > 0) {
						continue;
					}
					pc = ptree.posi.asquare[from];
					switch (pc) {
					case def.pawn:
						if (to < def.A6) {
							flag_promo = 1;
							flag_unpromo = 0;
						}
						break;

					case def.lance:
					case def.knight:
						if (to < def.A7) {
							flag_promo = 1;
							flag_unpromo = 0;
						} else if (to < def.A6) {
							flag_promo = 1;
						}
						break;

					case def.silver:
						if (to < def.A6 || from < def.A6) {
							flag_promo = 1;
						}
						break;

					case def.bishop:
					case def.rook:
						if (to < def.A6 || from < def.A6) {
							flag_promo = 1;
							flag_unpromo = 0;
						}
						break;

					default:
						break;
					}
				}
				assert (flag_promo > 0 || flag_unpromo > 0);
				if (flag_promo > 0) {
					amove[nmove++] = (bitop.From2Move(from) | bitop.To2Move(to)
							| def.FLAG_PROMO | bitop.Piece2Move(pc));
				}
				if (flag_unpromo > 0) {
					amove[nmove++] = (bitop.From2Move(from) | bitop.To2Move(to) | bitop
							.Piece2Move(pc));
				}
			}

			nsup = (to == sq_k + inc) ? nmove + 1 : nmove;
			if (nsup > 1) {
				for (i = n0 + n1 - 1; i >= n0; i--) {
					ptree.amove[moveidx + i + nmove] = ptree.amove[moveidx + i];
				}
				for (i = 0; i < nmove; i++) {
					ptree.amove[moveidx + n0++] = amove[i];
				}
			} else if (nmove > 0) {
				ptree.amove[moveidx + n0 + n1++] = amove[0];
			}

			if (!(nsup > 0)) {
				/* - tentative assumption - */
				/* no recursive drops at non-supported square. */
				if (flag == 2) {
					continue;
				}

				/* -tentative assumption- */
				/* no intercept-drop at non-supported square. */
				if ((int) bitop.I2To(ptree.current_move[ply - 1]) == sq_checker
						&& dist > min_chuai) {
					continue;
				}
			}

			nmove = 0;

			if (turn > 0) {

				hand = ptree.posi.hand_white;

				if (nsup > 0) {

					if (bitop.IsHandRook(hand) > 0) {
						amove[nmove++] = Drop(def.rook);
					} else if (bitop.IsHandLance(hand) > 0 && to < def.A1) {
						amove[nmove++] = Drop(def.lance);
					} else if (bitop.IsHandPawn(hand) > 0
							&& to < def.A1
							&& !((bitop.BBToU(ptree.posi.w_pawn) & (def.mask_file1 >> def.aifile[to])) > 0)
							&& !bitop.IsMateWPawnDrop(ptree, to)) {
						amove[nmove++] = Drop(def.pawn);
					}

				} else {

					if (bitop.IsHandPawn(hand) > 0
							&& to < def.A1
							&& !((bitop.BBToU(ptree.posi.w_pawn) & (def.mask_file1 >> def.aifile[to])) > 0)
							&& !bitop.IsMateWPawnDrop(ptree, to)) {
						amove[nmove++] = Drop(def.pawn);
					}
					if (bitop.IsHandLance(hand) > 0 && to < def.A1) {
						amove[nmove++] = Drop(def.lance);
					}
					if (bitop.IsHandRook(hand) > 0) {
						amove[nmove++] = Drop(def.rook);
					}
				}

				if (bitop.IsHandKnight(hand) > 0 && to < def.A2) {
					amove[nmove++] = Drop(def.knight);
				}

			} else {

				hand = ptree.posi.hand_black;

				if (nsup > 0) {

					if (bitop.IsHandRook(hand) > 0) {
						amove[nmove++] = Drop(def.rook);
					} else if (bitop.IsHandLance(hand) > 0 && to > def.I9) {
						amove[nmove++] = Drop(def.lance);
					} else if (bitop.IsHandPawn(hand) > 0
							&& to > def.I9
							&& !((bitop.BBToU(ptree.posi.b_pawn) & (def.mask_file1 >> def.aifile[to])) > 0)
							&& !bitop.IsMateBPawnDrop(ptree, to)) {
						amove[nmove++] = Drop(def.pawn);
					}

				} else {

					if (bitop.IsHandPawn(hand) > 0
							&& to > def.I9
							&& !((bitop.BBToU(ptree.posi.b_pawn) & (def.mask_file1 >> def.aifile[to])) > 0)
							&& !bitop.IsMateBPawnDrop(ptree, to)) {
						amove[nmove++] = Drop(def.pawn);
					}
					if (bitop.IsHandLance(hand) > 0 && to > def.I9) {
						amove[nmove++] = Drop(def.lance);
					}
					if (bitop.IsHandRook(hand) > 0) {
						amove[nmove++] = Drop(def.rook);
					}
				}

				if (bitop.IsHandKnight(hand) > 0 && to > def.I8) {
					amove[nmove++] = Drop(def.knight);
				}
			}

			if (bitop.IsHandSilver(hand) > 0) {
				amove[nmove++] = Drop(def.silver);
			}
			if (bitop.IsHandGold(hand) > 0) {
				amove[nmove++] = Drop(def.gold);
			}
			if (bitop.IsHandBishop(hand) > 0) {
				amove[nmove++] = Drop(def.bishop);
			}

			if (nsup > 0) {
				/* - tentative assumption - */
				/*
				 * a supported intercepter saves the king for two plies at
				 * least.
				 */
				if (nmove > 0
						&& flag == 0
						&& dist > min_chuai
						&& bitop.I2From(ptree.current_move[ply - 1]) >= def.nsquare) {
					int[] ret = new int[2];
					ret[0] = moveidx + 1;
					ret[1] = -1;
					ptree.amove[moveidx] = amove[0];
					return ret;
				}

				for (i = n0 + n1 - 1; i >= n0; i--) {
					ptree.amove[moveidx + i + nmove] = ptree.amove[moveidx + i];
				}
				for (i = 0; i < nmove; i++) {
					ptree.amove[moveidx + n0++] = amove[i];
				}
			} else
				for (i = 0; i < nmove; i++) {
					ptree.amove[moveidx + n0 + n1++] = amove[i];
				}
		}
		int[] ret = new int[2];
		ret[0] = moveidx + n0 + n1;
		ret[1] = n0;
		return ret;

	}

	private static void checker(tree_t ptree, char[] psq, int turn) {
		bitboard_t bb = new bitboard_t();
		int n, sq0, sq1, sq_king;

		if (turn > 0) {
			sq_king = ptree.posi.isquare_w_king;
			bb = attack.b_attacks_to_piece(ptree, sq_king);
		} else {
			sq_king = ptree.posi.isquare_b_king;
			bb = attack.w_attacks_to_piece(ptree, sq_king);
		}

		assert (bitop.BBTest(bb));
		sq0 = bitop.LastOne(bb);
		sq1 = def.nsquare;

		bitop.Xor(sq0, bb);
		if (bitop.BBTest(bb)) {
			sq1 = bitop.LastOne(bb);
			if (bitop.BBContract(data.abb_king_attacks[sq_king],
					data.abb_mask[sq1]) > 0) {
				n = sq0;
				sq0 = sq1;
				sq1 = n;
			}
		}

		psq[0] = (char) sq0;
		psq[1] = (char) sq1;
	}

	private static int mhash_probe(tree_t ptree, int turn, int ply) {
		long key_current, key, word;
		int move;

		word = mate3_hash_tbl[(int) (ptree.posi.hash_key & def.MATE3_MASK)];

		key = word & ~(long) 0x7ffff;
		key_current = ptree.posi.hash_key & ~(long) 0x7ffff;
		key_current ^= (long) ptree.posi.hand_black << 42;
		key_current ^= (long) turn << 63;

		if (key != key_current) {
			return 0;
		}

		move = (int) (word & 0x7ffff);
		if (move != def.MOVE_NA) {
			move |= turn > 0 ? bitop.Cap2Move(ptree.posi.asquare[bitop
					.I2To(move)]) : bitop.Cap2Move(-ptree.posi.asquare[bitop
					.I2To(move)]);
		}

		ptree.current_move[ply] = move;

		return 1;
	}
}
