public class genchk {

	public static int b_gen_checks(tree_t ptree, int[] pmove, int moveidx) {
		bitboard_t bb_piece = new bitboard_t(), bb_rook_chk = new bitboard_t(), bb_bishop_chk = new bitboard_t(), bb_chk = new bitboard_t(), bb_move_to = new bitboard_t();
		bitboard_t bb_diag1_chk = new bitboard_t(), bb_diag2_chk = new bitboard_t(), bb_file_chk = new bitboard_t(), bb_drop_to = new bitboard_t(), bb_desti = new bitboard_t();
		bitboard_t bb_rank_chk = new bitboard_t();

		int u0, u1, u2;
		int from, to, sq_wk, idirec;

		sq_wk = ptree.posi.isquare_w_king;
		bb_file_chk = new bitboard_t(bitop.AttackFile(sq_wk, ptree));
		bb_rank_chk = new bitboard_t(bitop.AttackRank(sq_wk, ptree));
		bitop.BBOr(bb_rook_chk, bb_file_chk, bb_rank_chk);

		bb_diag1_chk = new bitboard_t(bitop.AttackDiag1(sq_wk, ptree));
		bb_diag2_chk = new bitboard_t(bitop.AttackDiag2(sq_wk, ptree));
		bitop.BBOr(bb_bishop_chk, bb_diag1_chk, bb_diag2_chk);
		bitop.BBNot(bb_move_to, ptree.posi.b_occupied);
		bitop.BBOr(bb_drop_to, ptree.posi.b_occupied, ptree.posi.w_occupied);
		bitop.BBNot(bb_drop_to, bb_drop_to);

		from = ptree.posi.isquare_b_king;
		idirec = (int) data.adirec[sq_wk][from];
		if (idirec > 0
				&& attack.is_pinned_on_white_king(ptree, from, idirec) > 0) {
			bitop.BBIni(bb_chk);
			add_behind_attacks(bb_chk, idirec, sq_wk);
			bitop.BBAnd(bb_chk, bb_chk, data.abb_king_attacks[from]);
			bitop.BBAnd(bb_chk, bb_chk, bb_move_to);

			while (bitop.BBTest(bb_chk)) {
				to = bitop.LastOne(bb_chk);
				bitop.Xor(to, bb_chk);
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.king)
						| bitop.Cap2Move(-ptree.posi.asquare[to]);
			}
		}

		bb_piece = new bitboard_t(ptree.posi.b_dragon);
		while (bitop.BBTest(bb_piece)) {
			from = bitop.LastOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bitop.BBOr(bb_chk, bb_rook_chk, data.abb_king_attacks[sq_wk]);
			idirec = (int) data.adirec[sq_wk][from];
			if (idirec > 0
					&& attack.is_pinned_on_white_king(ptree, from, idirec) > 0) {
				add_behind_attacks(bb_chk, idirec, sq_wk);
			}

			bitop.AttackDragon(bb_desti, from, ptree);
			bitop.BBAnd(bb_chk, bb_chk, bb_desti);
			bitop.BBAnd(bb_chk, bb_chk, bb_move_to);

			while (bitop.BBTest(bb_chk)) {
				to = bitop.LastOne(bb_chk);
				bitop.Xor(to, bb_chk);
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.dragon)
						| bitop.Cap2Move(-ptree.posi.asquare[to]);
			}
		}

		bb_piece = new bitboard_t(ptree.posi.b_horse);
		while (bitop.BBTest(bb_piece)) {
			from = bitop.LastOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bitop.BBOr(bb_chk, bb_bishop_chk, data.abb_king_attacks[sq_wk]);
			idirec = (int) data.adirec[sq_wk][from];
			if (idirec > 0
					&& attack.is_pinned_on_white_king(ptree, from, idirec) > 0) {
				add_behind_attacks(bb_chk, idirec, sq_wk);
			}

			bitop.AttackHorse(bb_desti, from, ptree);
			bitop.BBAnd(bb_chk, bb_chk, bb_desti);
			bitop.BBAnd(bb_chk, bb_chk, bb_move_to);

			while (bitop.BBTest(bb_chk)) {
				to = bitop.LastOne(bb_chk);
				bitop.Xor(to, bb_chk);
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.horse)
						| bitop.Cap2Move(-ptree.posi.asquare[to]);
			}
		}

		u1 = ptree.posi.b_rook.p[1];
		u2 = ptree.posi.b_rook.p[2];
		while (u1 > 0 || u2 > 0) {
			from = bitop.last_one12(u1, u2);
			u1 ^= data.abb_mask[from].p[1];
			u2 ^= data.abb_mask[from].p[2];

			bitop.AttackRook(bb_desti, from, ptree);

			idirec = (int) data.adirec[sq_wk][from];
			if (idirec > 0
					&& attack.is_pinned_on_white_king(ptree, from, idirec) > 0) {
				bitop.BBAnd(bb_chk, bb_desti, bb_move_to);
			} else {
				bb_chk = bb_rook_chk;
				bb_chk.p[0] |= data.abb_king_attacks[sq_wk].p[0];
				bitop.BBAnd(bb_chk, bb_chk, bb_desti);
				bitop.BBAnd(bb_chk, bb_chk, bb_move_to);
			}

			while (bb_chk.p[0] > 0) {
				to = bitop.last_one0(bb_chk.p[0]);
				bb_chk.p[0] ^= data.abb_mask[to].p[0];
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.rook)
						| bitop.Cap2Move(-ptree.posi.asquare[to])
						| def.FLAG_PROMO;
			}

			while (bb_chk.p[1] > 0 || bb_chk.p[2] > 0) {
				to = bitop.last_one12(bb_chk.p[1], bb_chk.p[2]);
				bb_chk.p[1] ^= data.abb_mask[to].p[1];
				bb_chk.p[2] ^= data.abb_mask[to].p[2];
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.rook)
						| bitop.Cap2Move(-ptree.posi.asquare[to]);
			}
		}

		u0 = ptree.posi.b_rook.p[0];
		while (u0 > 0) {
			from = bitop.last_one0(u0);
			u0 ^= data.abb_mask[from].p[0];

			bitop.AttackRook(bb_desti, from, ptree);

			idirec = (int) data.adirec[sq_wk][from];
			if (idirec > 0
					&& attack.is_pinned_on_white_king(ptree, from, idirec) > 0) {
				bitop.BBAnd(bb_chk, bb_desti, bb_move_to);
			} else {
				bitop.BBOr(bb_chk, bb_rook_chk, data.abb_king_attacks[sq_wk]);
				bitop.BBAnd(bb_chk, bb_chk, bb_desti);
				bitop.BBAnd(bb_chk, bb_chk, bb_move_to);
			}

			while (bitop.BBTest(bb_chk)) {
				to = bitop.LastOne(bb_chk);
				bitop.Xor(to, bb_chk);
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.rook)
						| bitop.Cap2Move(-ptree.posi.asquare[to])
						| def.FLAG_PROMO;
			}
		}

		u1 = ptree.posi.b_bishop.p[1];
		u2 = ptree.posi.b_bishop.p[2];
		while (u1 > 0 || u2 > 0) {
			from = bitop.last_one12(u1, u2);
			u1 ^= data.abb_mask[from].p[1];
			u2 ^= data.abb_mask[from].p[2];

			bitop.AttackBishop(bb_desti, from, ptree);

			idirec = (int) data.adirec[sq_wk][from];
			if (idirec > 0
					&& attack.is_pinned_on_white_king(ptree, from, idirec) > 0) {
				bitop.BBAnd(bb_chk, bb_desti, bb_move_to);
			} else {
				bb_chk = bb_bishop_chk;
				bb_chk.p[0] |= data.abb_king_attacks[sq_wk].p[0];
				bitop.BBAnd(bb_chk, bb_chk, bb_desti);
				bitop.BBAnd(bb_chk, bb_chk, bb_move_to);
			}

			while (bb_chk.p[0] > 0) {
				to = bitop.last_one0(bb_chk.p[0]);
				bb_chk.p[0] ^= data.abb_mask[to].p[0];
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.bishop)
						| bitop.Cap2Move(-ptree.posi.asquare[to])
						| def.FLAG_PROMO;
			}

			while (bb_chk.p[1] > 0 || bb_chk.p[2] > 0) {
				to = bitop.last_one12(bb_chk.p[1], bb_chk.p[2]);
				bb_chk.p[1] ^= data.abb_mask[to].p[1];
				bb_chk.p[2] ^= data.abb_mask[to].p[2];
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.bishop)
						| bitop.Cap2Move(-ptree.posi.asquare[to]);
			}
		}

		u0 = ptree.posi.b_bishop.p[0];
		while (u0 > 0) {
			from = bitop.last_one0(u0);
			u0 ^= data.abb_mask[from].p[0];

			bitop.AttackBishop(bb_desti, from, ptree);

			idirec = (int) data.adirec[sq_wk][from];
			if (idirec > 0
					&& attack.is_pinned_on_white_king(ptree, from, idirec) > 0) {
				bitop.BBAnd(bb_chk, bb_desti, bb_move_to);
			} else {
				bitop.BBOr(bb_chk, bb_bishop_chk, data.abb_king_attacks[sq_wk]);
				bitop.BBAnd(bb_chk, bb_chk, bb_desti);
				bitop.BBAnd(bb_chk, bb_chk, bb_move_to);
			}

			while (bitop.BBTest(bb_chk)) {
				to = bitop.LastOne(bb_chk);
				bitop.Xor(to, bb_chk);
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.bishop)
						| bitop.Cap2Move(-ptree.posi.asquare[to])
						| def.FLAG_PROMO;
			}
		}

		bb_piece = new bitboard_t(ptree.posi.b_tgold);
		while (bitop.BBTest(bb_piece)) {
			from = bitop.LastOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bb_chk = data.abb_w_gold_attacks[sq_wk];

			idirec = (int) data.adirec[sq_wk][from];
			if (idirec > 0
					&& attack.is_pinned_on_white_king(ptree, from, idirec) > 0) {
				add_behind_attacks(bb_chk, idirec, sq_wk);
			}

			bitop.BBAnd(bb_chk, bb_chk, data.abb_b_gold_attacks[from]);
			bitop.BBAnd(bb_chk, bb_chk, bb_move_to);

			while (bitop.BBTest(bb_chk)) {
				to = bitop.LastOne(bb_chk);
				bitop.Xor(to, bb_chk);
				ptree.amove[moveidx++] = (bitop.To2Move(to)
						| bitop.From2Move(from)
						| bitop.Piece2Move(ptree.posi.asquare[from]) | bitop
						.Cap2Move(-ptree.posi.asquare[to]));
			}
		}

		u0 = ptree.posi.b_silver.p[0];
		while (u0 > 0) {
			from = bitop.last_one0(u0);
			u0 ^= data.abb_mask[from].p[0];

			bb_chk.p[0] = data.abb_w_gold_attacks[sq_wk].p[0];
			bb_chk.p[1] = data.abb_w_gold_attacks[sq_wk].p[1];
			bb_chk.p[2] = 0;

			idirec = (int) data.adirec[sq_wk][from];
			if (idirec > 0
					&& attack.is_pinned_on_white_king(ptree, from, idirec) > 0) {
				add_behind_attacks(bb_chk, idirec, sq_wk);
			}

			bb_chk.p[0] &= bb_move_to.p[0]
					& data.abb_b_silver_attacks[from].p[0];
			bb_chk.p[1] &= bb_move_to.p[1]
					& data.abb_b_silver_attacks[from].p[1];

			while (bb_chk.p[0] > 0 || bb_chk.p[1] > 0) {
				to = bitop.last_one01(bb_chk.p[0], bb_chk.p[1]);
				bb_chk.p[0] ^= data.abb_mask[to].p[0];
				bb_chk.p[1] ^= data.abb_mask[to].p[1];
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.silver)
						| bitop.Cap2Move(-ptree.posi.asquare[to])
						| def.FLAG_PROMO;
			}
		}

		u1 = ptree.posi.b_silver.p[1] & 0x7fc0000;
		while (u1 > 0) {
			from = bitop.last_one1(u1);
			u1 ^= data.abb_mask[from].p[1];

			bb_chk.p[0] = data.abb_w_gold_attacks[sq_wk].p[0];
			bb_chk.p[1] = bb_chk.p[2] = 0;

			idirec = (int) data.adirec[sq_wk][from];
			if (idirec > 0
					&& attack.is_pinned_on_white_king(ptree, from, idirec) > 0) {
				add_behind_attacks(bb_chk, idirec, sq_wk);
			}

			bb_chk.p[0] &= bb_move_to.p[0]
					& data.abb_b_silver_attacks[from].p[0];
			while (bb_chk.p[0] > 0) {
				to = bitop.last_one0(bb_chk.p[0]);
				bb_chk.p[0] ^= data.abb_mask[to].p[0];
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.silver)
						| bitop.Cap2Move(-ptree.posi.asquare[to])
						| def.FLAG_PROMO;
			}
		}

		bb_piece = new bitboard_t(ptree.posi.b_silver);
		while (bitop.BBTest(bb_piece)) {
			from = bitop.LastOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bb_chk = data.abb_w_silver_attacks[sq_wk];

			idirec = (int) data.adirec[sq_wk][from];
			if (idirec > 0
					&& attack.is_pinned_on_white_king(ptree, from, idirec) > 0) {
				add_behind_attacks(bb_chk, idirec, sq_wk);
			}

			bitop.BBAnd(bb_chk, bb_chk, data.abb_b_silver_attacks[from]);
			bitop.BBAnd(bb_chk, bb_chk, bb_move_to);

			while (bitop.BBTest(bb_chk)) {
				to = bitop.LastOne(bb_chk);
				bitop.Xor(to, bb_chk);
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.silver)
						| bitop.Cap2Move(-ptree.posi.asquare[to]);
			}
		}

		u0 = ptree.posi.b_knight.p[0];
		u1 = ptree.posi.b_knight.p[1] & 0x7fffe00;
		while (u0 > 0 || u1 > 0) {
			from = bitop.last_one01(u0, u1);
			u0 ^= data.abb_mask[from].p[0];
			u1 ^= data.abb_mask[from].p[1];

			bb_chk.p[0] = data.abb_w_gold_attacks[sq_wk].p[0];
			bb_chk.p[1] = bb_chk.p[2] = 0;

			idirec = (int) data.adirec[sq_wk][from];
			if (idirec > 0
					&& attack.is_pinned_on_white_king(ptree, from, idirec) > 0) {
				add_behind_attacks(bb_chk, idirec, sq_wk);
			}

			bb_chk.p[0] &= data.abb_b_knight_attacks[from].p[0]
					& bb_move_to.p[0];

			while (bb_chk.p[0] > 0) {
				to = bitop.last_one0(bb_chk.p[0]);
				bb_chk.p[0] ^= data.abb_mask[to].p[0];
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.knight)
						| bitop.Cap2Move(-ptree.posi.asquare[to])
						| def.FLAG_PROMO;
			}
		}

		u2 = ptree.posi.b_knight.p[2];
		u1 = ptree.posi.b_knight.p[1] & 0x3ffff;
		while (u2 > 0 || u1 > 0) {
			from = bitop.last_one12(u1, u2);
			u2 ^= data.abb_mask[from].p[2];
			u1 ^= data.abb_mask[from].p[1];

			bb_chk = data.abb_w_knight_attacks[sq_wk];

			idirec = (int) data.adirec[sq_wk][from];
			if (idirec > 0
					&& attack.is_pinned_on_white_king(ptree, from, idirec) > 0) {
				add_behind_attacks(bb_chk, idirec, sq_wk);
			}

			bitop.BBAnd(bb_chk, bb_chk, data.abb_b_knight_attacks[from]);
			bitop.BBAnd(bb_chk, bb_chk, bb_move_to);

			while (bitop.BBTest(bb_chk)) {
				to = bitop.LastOne(bb_chk);
				bitop.Xor(to, bb_chk);
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.knight)
						| bitop.Cap2Move(-ptree.posi.asquare[to]);
			}
		}

		bb_piece = new bitboard_t(ptree.posi.b_lance);
		while (bitop.BBTest(bb_piece)) {
			from = bitop.LastOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bb_chk.p[0] = data.abb_w_gold_attacks[sq_wk].p[0];
			bb_chk.p[1] = bb_chk.p[2] = 0;

			idirec = (int) data.adirec[sq_wk][from];
			if (idirec > 0
					&& attack.is_pinned_on_white_king(ptree, from, idirec) > 0) {
				add_behind_attacks(bb_chk, idirec, sq_wk);
			}

			bitop.BBAnd(bb_chk, bb_chk, bitop.AttackFile(from, ptree));
			bitop.BBAnd(bb_chk, bb_chk, data.abb_minus_rays[from]);
			bitop.BBAnd(bb_chk, bb_chk, bb_move_to);

			while (bitop.BBTest(bb_chk)) {
				to = bitop.LastOne(bb_chk);
				bitop.Xor(to, bb_chk);
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.lance)
						| bitop.Cap2Move(-ptree.posi.asquare[to])
						| def.FLAG_PROMO;
			}
		}

		u1 = ptree.posi.b_lance.p[1];
		u2 = ptree.posi.b_lance.p[2];
		while (u1 > 0 || u2 > 0) {
			from = bitop.last_one12(u1, u2);
			u1 ^= data.abb_mask[from].p[1];
			u2 ^= data.abb_mask[from].p[2];

			bb_chk = bb_file_chk;
			idirec = (int) data.adirec[sq_wk][from];
			if (idirec > 0
					&& attack.is_pinned_on_white_king(ptree, from, idirec) > 0) {
				add_behind_attacks(bb_chk, idirec, sq_wk);
				bitop.BBAnd(bb_chk, bb_chk, data.abb_minus_rays[from]);
			} else {
				bitop.BBAnd(bb_chk, bb_file_chk, data.abb_plus_rays[sq_wk]);
			}

			bitop.BBAnd(bb_chk, bb_chk, bitop.AttackFile(from, ptree));
			bitop.BBAnd(bb_chk, bb_chk, bb_move_to);
			bb_chk.p[0] = bb_chk.p[0] & 0x1ff;

			while (bitop.BBTest(bb_chk)) {
				to = bitop.LastOne(bb_chk);
				bitop.Xor(to, bb_chk);
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.lance)
						| bitop.Cap2Move(-ptree.posi.asquare[to]);
			}
		}

		bitop.BBIni(bb_chk);
		bb_chk.p[0] = data.abb_w_gold_attacks[sq_wk].p[0];
		if (sq_wk < def.A2) {
			bitop.BBOr(bb_chk, bb_chk, data.abb_mask[sq_wk + def.nfile]);
		}
		bitop.BBAnd(bb_chk, bb_chk, bb_move_to);
		bitop.BBAnd(bb_chk, bb_chk, ptree.posi.b_pawn_attacks);

		bitop.BBAnd(bb_piece, bb_diag1_chk, ptree.posi.b_pawn);
		while (bitop.BBTest(bb_piece)) {
			from = bitop.LastOne(bb_piece);
			bitop.Xor(from, bb_piece);

			to = from - def.nfile;
			if (ptree.posi.asquare[to] > 0) {
				continue;
			}

			bb_desti = bitop.AttackDiag1(from, ptree);
			if (bitop.BBContract(bb_desti, ptree.posi.b_bh) > 0) {
				bitop.BBNotAnd(bb_chk, bb_chk, data.abb_mask[to]);

				ptree.amove[moveidx] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.pawn)
						| bitop.Cap2Move(-ptree.posi.asquare[to]);
				if (from < def.A5) {
					ptree.amove[moveidx] |= def.FLAG_PROMO;
				}
				moveidx++;
			}
		}

		bitop.BBAnd(bb_piece, bb_diag2_chk, ptree.posi.b_pawn);
		while (bitop.BBTest(bb_piece)) {
			from = bitop.LastOne(bb_piece);
			bitop.Xor(from, bb_piece);

			to = from - def.nfile;
			if (ptree.posi.asquare[to] > 0) {
				continue;
			}

			bb_desti = bitop.AttackDiag2(from, ptree);
			if (bitop.BBContract(bb_desti, ptree.posi.b_bh) > 0) {
				bitop.BBNotAnd(bb_chk, bb_chk, data.abb_mask[to]);

				ptree.amove[moveidx] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.pawn)
						| bitop.Cap2Move(-ptree.posi.asquare[to]);
				if (from < def.A5) {
					ptree.amove[moveidx] |= def.FLAG_PROMO;
				}
				moveidx++;
			}
		}

		bitop.BBAnd(bb_piece, bb_rank_chk, ptree.posi.b_pawn);
		while (bitop.BBTest(bb_piece)) {
			from = bitop.LastOne(bb_piece);
			bitop.Xor(from, bb_piece);

			to = from - def.nfile;
			if (ptree.posi.asquare[to] > 0) {
				continue;
			}

			bb_desti = bitop.AttackRank(from, ptree);
			if (bitop.BBContract(bb_desti, ptree.posi.b_rd) > 0) {
				bitop.BBNotAnd(bb_chk, bb_chk, data.abb_mask[to]);

				ptree.amove[moveidx] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.pawn)
						| bitop.Cap2Move(-ptree.posi.asquare[to]);
				if (from < def.A5) {
					ptree.amove[moveidx] |= def.FLAG_PROMO;
				}
				moveidx++;
			}
		}

		while (bitop.BBTest(bb_chk)) {
			to = bitop.LastOne(bb_chk);
			bitop.Xor(to, bb_chk);

			from = to + def.nfile;
			ptree.amove[moveidx] = bitop.To2Move(to) | bitop.From2Move(from)
					| bitop.Piece2Move(def.pawn)
					| bitop.Cap2Move(-ptree.posi.asquare[to]);
			if (from < def.A5) {
				ptree.amove[moveidx] |= def.FLAG_PROMO;
			}
			moveidx++;
		}

		if (bitop.IsHandGold(ptree.posi.hand_black) > 0) {
			bitop.BBAnd(bb_chk, bb_drop_to, data.abb_w_gold_attacks[sq_wk]);
			while (bitop.BBTest(bb_chk)) {
				to = bitop.LastOne(bb_chk);
				bitop.Xor(to, bb_chk);
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.Drop2Move(def.gold);
			}
		}

		if (bitop.IsHandSilver(ptree.posi.hand_black) > 0) {
			bitop.BBAnd(bb_chk, bb_drop_to, data.abb_w_silver_attacks[sq_wk]);
			while (bitop.BBTest(bb_chk)) {
				to = bitop.LastOne(bb_chk);
				bitop.Xor(to, bb_chk);
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.Drop2Move(def.silver);
			}
		}

		if (bitop.IsHandKnight(ptree.posi.hand_black) > 0 && sq_wk < def.A2) {
			to = sq_wk + 2 * def.nfile - 1;
			if (def.aifile[sq_wk] != def.file1
					&& ptree.posi.asquare[to] == def.empty) {
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.Drop2Move(def.knight);
			}

			to = sq_wk + 2 * def.nfile + 1;
			if (def.aifile[sq_wk] != def.file9
					&& ptree.posi.asquare[to] == def.empty) {
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.Drop2Move(def.knight);
			}
		}

		if (bitop.IsHandPawn(ptree.posi.hand_black) > 0
				&& sq_wk < def.A1
				&& !((bitop.BBToU(ptree.posi.b_pawn) & (def.mask_file1 >> def.aifile[sq_wk])) > 0)) {
			to = sq_wk + def.nfile;
			if (ptree.posi.asquare[to] == def.empty
					&& !(attack.is_mate_b_pawn_drop(ptree, to) > 0)) {
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.Drop2Move(def.pawn);
			}
		}

		if (bitop.IsHandLance(ptree.posi.hand_black) > 0) {
			int move;
			int dist, min_dist;

			if ((int) def.aifile[sq_wk] == def.file1
					|| (int) def.aifile[sq_wk] == def.file9) {
				min_dist = 2;
			} else {
				min_dist = 3;
			}

			for (to = sq_wk + def.nfile, dist = 1; to < def.nsquare
					&& ptree.posi.asquare[to] == def.empty; to += def.nfile, dist += 1) {
				move = bitop.To2Move(to) | bitop.Drop2Move(def.lance);
				if (dist == 1) {
					move |= def.MOVE_CHK_CLEAR;
				} else if (dist > min_dist) {
					move |= def.MOVE_CHK_SET;
				}
				ptree.amove[moveidx++] = move;
			}
		}

		if (bitop.IsHandRook(ptree.posi.hand_black) > 0) {
			int move;
			int file, dist, min_dist;

			if ((int) def.aifile[sq_wk] == def.file1
					|| (int) def.aifile[sq_wk] == def.file9) {
				min_dist = 2;
			} else {
				min_dist = 3;
			}

			for (to = sq_wk + def.nfile, dist = 1; to < def.nsquare
					&& ptree.posi.asquare[to] == def.empty; to += def.nfile, dist += 1) {
				move = bitop.To2Move(to) | bitop.Drop2Move(def.rook);
				if (dist == 1) {
					move |= def.MOVE_CHK_CLEAR;
				} else if (dist > min_dist) {
					move |= def.MOVE_CHK_SET;
				}
				ptree.amove[moveidx++] = move;
			}

			for (file = (int) def.aifile[sq_wk] - 1, to = sq_wk - 1, dist = 1; file >= def.file1
					&& ptree.posi.asquare[to] == def.empty; file -= 1, to -= 1, dist += 1) {
				move = bitop.To2Move(to) | bitop.Drop2Move(def.rook);
				if (dist == 1) {
					move |= def.MOVE_CHK_CLEAR;
				} else if (dist > min_dist) {
					move |= def.MOVE_CHK_SET;
				}
				ptree.amove[moveidx++] = move;
			}

			if (sq_wk < def.A8 || def.I2 < sq_wk) {
				min_dist = 2;
			} else {
				min_dist = 3;
			}

			for (file = (int) def.aifile[sq_wk] + 1, to = sq_wk + 1, dist = 1; file <= def.file9
					&& ptree.posi.asquare[to] == def.empty; file += 1, to += 1, dist += 1) {
				move = bitop.To2Move(to) | bitop.Drop2Move(def.rook);
				if (dist == 1) {
					move |= def.MOVE_CHK_CLEAR;
				} else if (dist > min_dist) {
					move |= def.MOVE_CHK_SET;
				}
				ptree.amove[moveidx++] = move;
			}

			for (to = sq_wk - def.nfile, dist = 1; to >= 0
					&& ptree.posi.asquare[to] == def.empty; to -= def.nfile, dist += 1) {
				move = bitop.To2Move(to) | bitop.Drop2Move(def.rook);
				if ((int) def.airank[to] == def.rank3) {
					move |= def.MOVE_CHK_CLEAR;
				}
				if (dist == 1) {
					move |= def.MOVE_CHK_CLEAR;
				} else if (dist > min_dist) {
					move |= def.MOVE_CHK_SET;
				}
				ptree.amove[moveidx++] = move;
			}
		}

		if (bitop.IsHandBishop(ptree.posi.hand_black) > 0) {
			int move;
			int file, rank, dist;

			to = sq_wk;
			file = (int) def.aifile[sq_wk];
			rank = (int) def.airank[sq_wk];
			for (to -= 10, file -= 1, rank -= 1, dist = 1; file >= 0
					&& rank >= 0 && ptree.posi.asquare[to] == def.empty; to -= 10, file -= 1, rank -= 1, dist += 1) {
				move = bitop.To2Move(to) | bitop.Drop2Move(def.bishop);
				if (rank == def.rank3) {
					move |= def.MOVE_CHK_CLEAR;
				}
				if (dist == 1) {
					move |= def.MOVE_CHK_CLEAR;
				} else if (dist > 2) {
					move |= def.MOVE_CHK_SET;
				}
				ptree.amove[moveidx++] = move;
			}

			to = sq_wk;
			file = (int) def.aifile[sq_wk];
			rank = (int) def.airank[sq_wk];
			for (to -= 8, file += 1, rank -= 1, dist = 1; file <= def.file9
					&& rank >= 0 && ptree.posi.asquare[to] == def.empty; to -= 8, file += 1, rank -= 1, dist += 1) {
				move = bitop.To2Move(to) | bitop.Drop2Move(def.bishop);
				if (rank == def.rank3) {
					move |= def.MOVE_CHK_CLEAR;
				}
				if (dist == 1) {
					move |= def.MOVE_CHK_CLEAR;
				} else if (dist > 2) {
					move |= def.MOVE_CHK_SET;
				}
				ptree.amove[moveidx++] = move;
			}

			to = sq_wk;
			file = (int) def.aifile[sq_wk];
			rank = (int) def.airank[sq_wk];
			for (to += 8, file -= 1, rank += 1, dist = 1; file >= 0
					&& rank <= def.rank9 && ptree.posi.asquare[to] == def.empty; to += 8, file -= 1, rank += 1, dist += 1) {
				move = bitop.To2Move(to) | bitop.Drop2Move(def.bishop);
				if (dist == 1) {
					move |= def.MOVE_CHK_CLEAR;
				} else if (dist > 2) {
					move |= def.MOVE_CHK_SET;
				}
				ptree.amove[moveidx++] = move;
			}

			to = sq_wk;
			file = (int) def.aifile[sq_wk];
			rank = (int) def.airank[sq_wk];
			for (to += 10, file += 1, rank += 1, dist = 1; file <= def.file9
					&& rank <= def.rank9 && ptree.posi.asquare[to] == def.empty; to += 10, file += 1, rank += 1, dist += 1) {
				move = bitop.To2Move(to) | bitop.Drop2Move(def.bishop);
				if (dist == 1) {
					move |= def.MOVE_CHK_CLEAR;
				} else if (dist > 2) {
					move |= def.MOVE_CHK_SET;
				}
				ptree.amove[moveidx++] = move;
			}
		}

		return moveidx;
	}

	public static int w_gen_checks(tree_t ptree, int[] pmove, int moveidx) {

		bitboard_t bb_piece = new bitboard_t();
		bitboard_t bb_rook_chk = new bitboard_t();
		bitboard_t bb_bishop_chk = new bitboard_t();
		bitboard_t bb_chk = new bitboard_t();
		bitboard_t bb_move_to = new bitboard_t();
		bitboard_t bb_diag1_chk = new bitboard_t();
		bitboard_t bb_diag2_chk = new bitboard_t();
		bitboard_t bb_file_chk = new bitboard_t();
		bitboard_t bb_drop_to = new bitboard_t();
		bitboard_t bb_desti = new bitboard_t();
		bitboard_t bb_rank_chk = new bitboard_t();

		int u0, u1, u2;
		int from, to, sq_bk, idirec;

		sq_bk = ptree.posi.isquare_b_king;
		bb_file_chk = new bitboard_t(bitop.AttackFile(sq_bk, ptree));
		bb_rank_chk = new bitboard_t(bitop.AttackRank(sq_bk, ptree));
		bitop.BBOr(bb_rook_chk, bb_file_chk, bb_rank_chk);

		bb_diag1_chk = new bitboard_t(bitop.AttackDiag1(sq_bk, ptree));
		bb_diag2_chk = new bitboard_t(bitop.AttackDiag2(sq_bk, ptree));
		bitop.BBOr(bb_bishop_chk, bb_diag1_chk, bb_diag2_chk);
		bitop.BBNot(bb_move_to, ptree.posi.w_occupied);
		bitop.BBOr(bb_drop_to, ptree.posi.b_occupied, ptree.posi.w_occupied);
		bitop.BBNot(bb_drop_to, bb_drop_to);

		from = ptree.posi.isquare_w_king;
		idirec = (int) data.adirec[sq_bk][from];
		if (idirec > 0
				&& attack.is_pinned_on_black_king(ptree, from, idirec) > 0) {
			bitop.BBIni(bb_chk);
			add_behind_attacks(bb_chk, idirec, sq_bk);
			bitop.BBAnd(bb_chk, bb_chk, data.abb_king_attacks[from]);
			bitop.BBAnd(bb_chk, bb_chk, bb_move_to);

			while (bitop.BBTest(bb_chk)) {
				to = bitop.FirstOne(bb_chk);
				bitop.Xor(to, bb_chk);
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.king)
						| bitop.Cap2Move(ptree.posi.asquare[to]);
			}
		}

		bb_piece = new bitboard_t(ptree.posi.w_dragon);
		while (bitop.BBTest(bb_piece)) {
			from = bitop.FirstOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bitop.BBOr(bb_chk, bb_rook_chk, data.abb_king_attacks[sq_bk]);
			idirec = (int) data.adirec[sq_bk][from];
			if (idirec > 0
					&& attack.is_pinned_on_black_king(ptree, from, idirec) > 0) {
				add_behind_attacks(bb_chk, idirec, sq_bk);
			}

			bitop.AttackDragon(bb_desti, from, ptree);
			bitop.BBAnd(bb_chk, bb_chk, bb_desti);
			bitop.BBAnd(bb_chk, bb_chk, bb_move_to);

			while (bitop.BBTest(bb_chk)) {
				to = bitop.LastOne(bb_chk);
				bitop.Xor(to, bb_chk);
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.dragon)
						| bitop.Cap2Move(ptree.posi.asquare[to]);
			}
		}

		bb_piece = new bitboard_t(ptree.posi.w_horse);
		while (bitop.BBTest(bb_piece)) {
			from = bitop.FirstOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bitop.BBOr(bb_chk, bb_bishop_chk, data.abb_king_attacks[sq_bk]);
			idirec = (int) data.adirec[sq_bk][from];
			if (idirec > 0
					&& attack.is_pinned_on_black_king(ptree, from, idirec) > 0) {
				add_behind_attacks(bb_chk, idirec, sq_bk);
			}

			bitop.AttackHorse(bb_desti, from, ptree);
			bitop.BBAnd(bb_chk, bb_chk, bb_desti);
			bitop.BBAnd(bb_chk, bb_chk, bb_move_to);

			while (bitop.BBTest(bb_chk)) {
				to = bitop.FirstOne(bb_chk);
				bitop.Xor(to, bb_chk);
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.horse)
						| bitop.Cap2Move(ptree.posi.asquare[to]);
			}
		}

		u0 = ptree.posi.w_rook.p[0];
		u1 = ptree.posi.w_rook.p[1];
		while ((u0 | u1) > 0) {
			from = bitop.first_one01(u0, u1);
			u0 ^= data.abb_mask[from].p[0];
			u1 ^= data.abb_mask[from].p[1];

			bitop.AttackRook(bb_desti, from, ptree);

			idirec = (int) data.adirec[sq_bk][from];
			if (idirec > 0
					&& attack.is_pinned_on_black_king(ptree, from, idirec) > 0) {
				bitop.BBAnd(bb_chk, bb_desti, bb_move_to);
			} else {
				bb_chk = bb_rook_chk;
				bb_chk.p[2] |= data.abb_king_attacks[sq_bk].p[2];
				bitop.BBAnd(bb_chk, bb_chk, bb_desti);
				bitop.BBAnd(bb_chk, bb_chk, bb_move_to);
			}

			while (bb_chk.p[2] > 0) {
				to = bitop.first_one2(bb_chk.p[2]);
				bb_chk.p[2] ^= data.abb_mask[to].p[2];
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.rook)
						| bitop.Cap2Move(ptree.posi.asquare[to])
						| def.FLAG_PROMO;
			}

			while ((bb_chk.p[0] | bb_chk.p[1]) > 0) {
				to = bitop.first_one01(bb_chk.p[0], bb_chk.p[1]);
				bb_chk.p[0] ^= data.abb_mask[to].p[0];
				bb_chk.p[1] ^= data.abb_mask[to].p[1];
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.rook)
						| bitop.Cap2Move(ptree.posi.asquare[to]);
			}
		}

		u2 = ptree.posi.w_rook.p[2];
		while (u2 > 0) {
			from = bitop.first_one2(u2);
			u2 ^= data.abb_mask[from].p[2];

			bitop.AttackRook(bb_desti, from, ptree);

			idirec = (int) data.adirec[sq_bk][from];
			if (idirec > 0
					&& attack.is_pinned_on_black_king(ptree, from, idirec) > 0) {
				bitop.BBAnd(bb_chk, bb_desti, bb_move_to);
			} else {
				bitop.BBOr(bb_chk, bb_rook_chk, data.abb_king_attacks[sq_bk]);
				bitop.BBAnd(bb_chk, bb_chk, bb_desti);
				bitop.BBAnd(bb_chk, bb_chk, bb_move_to);
			}

			while (bitop.BBTest(bb_chk)) {
				to = bitop.FirstOne(bb_chk);
				bitop.Xor(to, bb_chk);
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.rook)
						| bitop.Cap2Move(ptree.posi.asquare[to])
						| def.FLAG_PROMO;
			}
		}

		u0 = ptree.posi.w_bishop.p[0];
		u1 = ptree.posi.w_bishop.p[1];
		while ((u0 > 0 || u1 > 0)) {
			from = bitop.first_one01(u0, u1);
			u0 ^= data.abb_mask[from].p[0];
			u1 ^= data.abb_mask[from].p[1];

			bitop.AttackBishop(bb_desti, from, ptree);

			idirec = (int) data.adirec[sq_bk][from];
			if (idirec > 0
					&& attack.is_pinned_on_black_king(ptree, from, idirec) > 0) {
				bitop.BBAnd(bb_chk, bb_desti, bb_move_to);
			} else {
				bb_chk = bb_bishop_chk;
				bb_chk.p[2] |= data.abb_king_attacks[sq_bk].p[2];
				bitop.BBAnd(bb_chk, bb_chk, bb_desti);
				bitop.BBAnd(bb_chk, bb_chk, bb_move_to);
			}

			while (bb_chk.p[2] > 0) {
				to = bitop.first_one2(bb_chk.p[2]);
				bb_chk.p[2] ^= data.abb_mask[to].p[2];
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.bishop)
						| bitop.Cap2Move(ptree.posi.asquare[to])
						| def.FLAG_PROMO;
			}

			while (bb_chk.p[0] > 0 | bb_chk.p[1] > 0) {
				to = bitop.first_one01(bb_chk.p[0], bb_chk.p[1]);
				bb_chk.p[0] ^= data.abb_mask[to].p[0];
				bb_chk.p[1] ^= data.abb_mask[to].p[1];
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.bishop)
						| bitop.Cap2Move(ptree.posi.asquare[to]);
			}
		}

		u2 = ptree.posi.w_bishop.p[2];
		while (u2 > 0) {
			from = bitop.first_one2(u2);
			u2 ^= data.abb_mask[from].p[2];

			bitop.AttackBishop(bb_desti, from, ptree);

			idirec = (int) data.adirec[sq_bk][from];
			if (idirec > 0
					&& attack.is_pinned_on_black_king(ptree, from, idirec) > 0) {
				bitop.BBAnd(bb_chk, bb_desti, bb_move_to);
			} else {
				bitop.BBOr(bb_chk, bb_bishop_chk, data.abb_king_attacks[sq_bk]);
				bitop.BBAnd(bb_chk, bb_chk, bb_desti);
				bitop.BBAnd(bb_chk, bb_chk, bb_move_to);
			}

			while (bitop.BBTest(bb_chk)) {
				to = bitop.FirstOne(bb_chk);
				bitop.Xor(to, bb_chk);
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.bishop)
						| bitop.Cap2Move(ptree.posi.asquare[to])
						| def.FLAG_PROMO;
			}
		}

		bb_piece = new bitboard_t(ptree.posi.w_tgold);
		while (bitop.BBTest(bb_piece)) {
			from = bitop.FirstOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bb_chk = data.abb_b_gold_attacks[sq_bk];

			idirec = (int) data.adirec[sq_bk][from];
			if (idirec > 0
					&& attack.is_pinned_on_black_king(ptree, from, idirec) > 0) {
				add_behind_attacks(bb_chk, idirec, sq_bk);
			}

			bitop.BBAnd(bb_chk, bb_chk, data.abb_w_gold_attacks[from]);
			bitop.BBAnd(bb_chk, bb_chk, bb_move_to);

			while (bitop.BBTest(bb_chk)) {
				to = bitop.FirstOne(bb_chk);
				bitop.Xor(to, bb_chk);
				ptree.amove[moveidx++] = (bitop.To2Move(to)
						| bitop.From2Move(from)
						| bitop.Piece2Move(-ptree.posi.asquare[from]) | bitop
						.Cap2Move(ptree.posi.asquare[to]));
			}
		}

		u2 = ptree.posi.w_silver.p[2];
		while (u2 > 0) {
			from = bitop.first_one2(u2);
			u2 ^= data.abb_mask[from].p[2];

			bb_chk.p[2] = data.abb_b_gold_attacks[sq_bk].p[2];
			bb_chk.p[1] = data.abb_b_gold_attacks[sq_bk].p[1];
			bb_chk.p[0] = 0;

			idirec = (int) data.adirec[sq_bk][from];
			if (idirec > 0
					&& attack.is_pinned_on_black_king(ptree, from, idirec) > 0) {
				add_behind_attacks(bb_chk, idirec, sq_bk);
			}

			bb_chk.p[2] &= bb_move_to.p[2]
					& data.abb_w_silver_attacks[from].p[2];
			bb_chk.p[1] &= bb_move_to.p[1]
					& data.abb_w_silver_attacks[from].p[1];

			while (bb_chk.p[2] > 0 || bb_chk.p[1] > 0) {
				to = bitop.first_one12(bb_chk.p[1], bb_chk.p[2]);
				bb_chk.p[1] ^= data.abb_mask[to].p[1];
				bb_chk.p[2] ^= data.abb_mask[to].p[2];
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.silver)
						| bitop.Cap2Move(ptree.posi.asquare[to])
						| def.FLAG_PROMO;
			}
		}

		u1 = ptree.posi.w_silver.p[1] & 0x1ff;
		while (u1 > 0) {
			from = bitop.first_one1(u1);
			u1 ^= data.abb_mask[from].p[1];

			bb_chk.p[2] = data.abb_b_gold_attacks[sq_bk].p[2];
			bb_chk.p[1] = bb_chk.p[0] = 0;

			idirec = (int) data.adirec[sq_bk][from];
			if (idirec > 0
					&& attack.is_pinned_on_black_king(ptree, from, idirec) > 0) {
				add_behind_attacks(bb_chk, idirec, sq_bk);
			}

			bb_chk.p[2] &= bb_move_to.p[2]
					& data.abb_w_silver_attacks[from].p[2];
			while (bb_chk.p[2] > 0) {
				to = bitop.first_one2(bb_chk.p[2]);
				bb_chk.p[2] ^= data.abb_mask[to].p[2];
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.silver)
						| bitop.Cap2Move(ptree.posi.asquare[to])
						| def.FLAG_PROMO;
			}
		}

		bb_piece = new bitboard_t(ptree.posi.w_silver);
		while (bitop.BBTest(bb_piece)) {
			from = bitop.FirstOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bb_chk = data.abb_b_silver_attacks[sq_bk];

			idirec = (int) data.adirec[sq_bk][from];
			if (idirec > 0
					&& attack.is_pinned_on_black_king(ptree, from, idirec) > 0) {
				add_behind_attacks(bb_chk, idirec, sq_bk);
			}

			bitop.BBAnd(bb_chk, bb_chk, data.abb_w_silver_attacks[from]);
			bitop.BBAnd(bb_chk, bb_chk, bb_move_to);

			while (bitop.BBTest(bb_chk)) {
				to = bitop.FirstOne(bb_chk);
				bitop.Xor(to, bb_chk);
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.silver)
						| bitop.Cap2Move(ptree.posi.asquare[to]);
			}
		}

		u2 = ptree.posi.w_knight.p[2];
		u1 = ptree.posi.w_knight.p[1] & 0x3ffff;
		while (u2 > 0 || u1 > 0) {
			from = bitop.first_one12(u1, u2);
			u2 ^= data.abb_mask[from].p[2];
			u1 ^= data.abb_mask[from].p[1];

			bb_chk.p[2] = data.abb_b_gold_attacks[sq_bk].p[2];
			bb_chk.p[1] = bb_chk.p[0] = 0;

			idirec = (int) data.adirec[sq_bk][from];
			if (idirec > 0
					&& attack.is_pinned_on_black_king(ptree, from, idirec) > 0) {
				add_behind_attacks(bb_chk, idirec, sq_bk);
			}

			bb_chk.p[2] &= data.abb_w_knight_attacks[from].p[2]
					& bb_move_to.p[2];

			while (bb_chk.p[2] > 0) {
				to = bitop.first_one2(bb_chk.p[2]);
				bb_chk.p[2] ^= data.abb_mask[to].p[2];
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.knight)
						| bitop.Cap2Move(ptree.posi.asquare[to])
						| def.FLAG_PROMO;
			}
		}

		u0 = ptree.posi.w_knight.p[0];
		u1 = ptree.posi.w_knight.p[1] & 0x7fffe00;
		while (u0 > 0 || u1 > 0) {
			from = bitop.first_one01(u0, u1);
			u0 ^= data.abb_mask[from].p[0];
			u1 ^= data.abb_mask[from].p[1];

			bb_chk = data.abb_b_knight_attacks[sq_bk];

			idirec = (int) data.adirec[sq_bk][from];
			if (idirec > 0
					&& attack.is_pinned_on_black_king(ptree, from, idirec) > 0) {
				add_behind_attacks(bb_chk, idirec, sq_bk);
			}

			bitop.BBAnd(bb_chk, bb_chk, data.abb_w_knight_attacks[from]);
			bitop.BBAnd(bb_chk, bb_chk, bb_move_to);

			while (bitop.BBTest(bb_chk)) {
				to = bitop.FirstOne(bb_chk);
				bitop.Xor(to, bb_chk);
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.knight)
						| bitop.Cap2Move(ptree.posi.asquare[to]);
			}
		}

		bb_piece = new bitboard_t(ptree.posi.w_lance);
		while (bitop.BBTest(bb_piece)) {
			from = bitop.FirstOne(bb_piece);
			bitop.Xor(from, bb_piece);

			bb_chk.p[2] = data.abb_b_gold_attacks[sq_bk].p[2];
			bb_chk.p[1] = bb_chk.p[0] = 0;

			idirec = (int) data.adirec[sq_bk][from];
			if (idirec > 0
					&& attack.is_pinned_on_black_king(ptree, from, idirec) > 0) {
				add_behind_attacks(bb_chk, idirec, sq_bk);
			}

			bitop.BBAnd(bb_chk, bb_chk, bitop.AttackFile(from, ptree));
			bitop.BBAnd(bb_chk, bb_chk, data.abb_plus_rays[from]);
			bitop.BBAnd(bb_chk, bb_chk, bb_move_to);

			while (bitop.BBTest(bb_chk)) {
				to = bitop.FirstOne(bb_chk);
				bitop.Xor(to, bb_chk);
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.lance)
						| bitop.Cap2Move(ptree.posi.asquare[to])
						| def.FLAG_PROMO;
			}
		}

		u0 = ptree.posi.w_lance.p[0];
		u1 = ptree.posi.w_lance.p[1];
		while (u0 > 0 || u1 > 0) {
			from = bitop.first_one01(u0, u1);
			u0 ^= data.abb_mask[from].p[0];
			u1 ^= data.abb_mask[from].p[1];

			bb_chk = bb_file_chk;
			idirec = (int) data.adirec[sq_bk][from];
			if (idirec > 0
					&& attack.is_pinned_on_black_king(ptree, from, idirec) > 0) {
				add_behind_attacks(bb_chk, idirec, sq_bk);
				bitop.BBAnd(bb_chk, bb_chk, data.abb_plus_rays[from]);
			} else {
				bitop.BBAnd(bb_chk, bb_file_chk, data.abb_minus_rays[sq_bk]);
			}

			bitop.BBAnd(bb_chk, bb_chk, bitop.AttackFile(from, ptree));
			bitop.BBAnd(bb_chk, bb_chk, bb_move_to);
			bb_chk.p[2] = bb_chk.p[2] & 0x7fc0000;

			while (bitop.BBTest(bb_chk)) {
				to = bitop.FirstOne(bb_chk);
				bitop.Xor(to, bb_chk);
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.lance)
						| bitop.Cap2Move(ptree.posi.asquare[to]);
			}
		}

		bitop.BBIni(bb_chk);
		bb_chk.p[2] = data.abb_b_gold_attacks[sq_bk].p[2];
		if (sq_bk > def.I8) {
			bitop.BBOr(bb_chk, bb_chk, data.abb_mask[sq_bk - def.nfile]);
		}
		bitop.BBAnd(bb_chk, bb_chk, bb_move_to);
		bitop.BBAnd(bb_chk, bb_chk, ptree.posi.w_pawn_attacks);

		bitop.BBAnd(bb_piece, bb_diag1_chk, ptree.posi.w_pawn);
		while (bitop.BBTest(bb_piece)) {
			from = bitop.FirstOne(bb_piece);
			bitop.Xor(from, bb_piece);

			to = from + def.nfile;
			if (ptree.posi.asquare[to] < 0) {
				continue;
			}

			bb_desti = bitop.AttackDiag1(from, ptree);
			if (bitop.BBContract(bb_desti, ptree.posi.w_bh) > 0) {
				bitop.BBNotAnd(bb_chk, bb_chk, data.abb_mask[to]);

				ptree.amove[moveidx] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.pawn)
						| bitop.Cap2Move(ptree.posi.asquare[to]);
				if (from > def.I5) {
					ptree.amove[moveidx] |= def.FLAG_PROMO;
				}
				moveidx++;
			}
		}

		bitop.BBAnd(bb_piece, bb_diag2_chk, ptree.posi.w_pawn);
		while (bitop.BBTest(bb_piece)) {
			from = bitop.FirstOne(bb_piece);
			bitop.Xor(from, bb_piece);

			to = from + def.nfile;
			if (ptree.posi.asquare[to] < 0) {
				continue;
			}

			bb_desti = bitop.AttackDiag2(from, ptree);
			if (bitop.BBContract(bb_desti, ptree.posi.w_bh) > 0) {
				bitop.BBNotAnd(bb_chk, bb_chk, data.abb_mask[to]);

				ptree.amove[moveidx] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.pawn)
						| bitop.Cap2Move(ptree.posi.asquare[to]);
				if (from > def.I5) {
					ptree.amove[moveidx] |= def.FLAG_PROMO;
				}
				moveidx++;
			}
		}

		bitop.BBAnd(bb_piece, bb_rank_chk, ptree.posi.w_pawn);
		while (bitop.BBTest(bb_piece)) {
			from = bitop.FirstOne(bb_piece);
			bitop.Xor(from, bb_piece);

			to = from + def.nfile;
			if (ptree.posi.asquare[to] < 0) {
				continue;
			}

			bb_desti = bitop.AttackRank(from, ptree);
			if (bitop.BBContract(bb_desti, ptree.posi.w_rd) > 0) {
				bitop.BBNotAnd(bb_chk, bb_chk, data.abb_mask[to]);

				ptree.amove[moveidx] = bitop.To2Move(to)
						| bitop.From2Move(from) | bitop.Piece2Move(def.pawn)
						| bitop.Cap2Move(ptree.posi.asquare[to]);
				if (from > def.I5) {
					ptree.amove[moveidx] |= def.FLAG_PROMO;
				}
				moveidx++;
			}
		}

		while (bitop.BBTest(bb_chk)) {
			to = bitop.FirstOne(bb_chk);
			bitop.Xor(to, bb_chk);

			from = to - def.nfile;
			ptree.amove[moveidx] = bitop.To2Move(to) | bitop.From2Move(from)
					| bitop.Piece2Move(def.pawn)
					| bitop.Cap2Move(ptree.posi.asquare[to]);
			if (from > def.I5) {
				ptree.amove[moveidx] |= def.FLAG_PROMO;
			}
			moveidx++;
		}

		if (bitop.IsHandGold(ptree.posi.hand_white) > 0) {
			bitop.BBAnd(bb_chk, bb_drop_to, data.abb_b_gold_attacks[sq_bk]);
			while (bitop.BBTest(bb_chk)) {
				to = bitop.FirstOne(bb_chk);
				bitop.Xor(to, bb_chk);
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.Drop2Move(def.gold);
			}
		}

		if (bitop.IsHandSilver(ptree.posi.hand_white) > 0) {
			bitop.BBAnd(bb_chk, bb_drop_to, data.abb_b_silver_attacks[sq_bk]);
			while (bitop.BBTest(bb_chk)) {
				to = bitop.FirstOne(bb_chk);
				bitop.Xor(to, bb_chk);
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.Drop2Move(def.silver);
			}
		}

		if (bitop.IsHandKnight(ptree.posi.hand_white) > 0 && sq_bk > def.I8) {
			to = sq_bk - 2 * def.nfile - 1;
			if (def.aifile[sq_bk] != def.file1
					&& ptree.posi.asquare[to] == def.empty) {
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.Drop2Move(def.knight);
			}

			to = sq_bk - 2 * def.nfile + 1;
			if (def.aifile[sq_bk] != def.file9
					&& ptree.posi.asquare[to] == def.empty) {
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.Drop2Move(def.knight);
			}
		}

		if (bitop.IsHandPawn(ptree.posi.hand_white) > 0
				&& sq_bk > def.I9
				&& !((bitop.BBToU(ptree.posi.w_pawn) & (def.mask_file1 >> def.aifile[sq_bk])) > 0)) {
			to = sq_bk - def.nfile;
			if (ptree.posi.asquare[to] == def.empty
					&& !(attack.is_mate_w_pawn_drop(ptree, to) > 0)) {
				ptree.amove[moveidx++] = bitop.To2Move(to)
						| bitop.Drop2Move(def.pawn);
			}
		}

		if (bitop.IsHandLance(ptree.posi.hand_white) > 0) {
			int move;
			int dist, min_dist;

			if ((int) def.aifile[sq_bk] == def.file1
					|| (int) def.aifile[sq_bk] == def.file9) {
				min_dist = 2;
			} else {
				min_dist = 3;
			}

			for (to = sq_bk - def.nfile, dist = 1; to >= 0
					&& ptree.posi.asquare[to] == def.empty; to -= def.nfile, dist += 1) {
				move = bitop.To2Move(to) | bitop.Drop2Move(def.lance);
				if (dist == 1) {
					move |= def.MOVE_CHK_CLEAR;
				} else if (dist > min_dist) {
					move |= def.MOVE_CHK_SET;
				}
				ptree.amove[moveidx++] = move;
			}
		}

		if (bitop.IsHandRook(ptree.posi.hand_white) > 0) {
			int move;
			int file, dist, min_dist;

			if ((int) def.aifile[sq_bk] == def.file1
					|| (int) def.aifile[sq_bk] == def.file9) {
				min_dist = 2;
			} else {
				min_dist = 3;
			}

			for (to = sq_bk - def.nfile, dist = 1; to >= 0
					&& ptree.posi.asquare[to] == def.empty; to -= def.nfile, dist += 1) {
				move = bitop.To2Move(to) | bitop.Drop2Move(def.rook);
				if (dist == 1) {
					move |= def.MOVE_CHK_CLEAR;
				} else if (dist > min_dist) {
					move |= def.MOVE_CHK_SET;
				}
				ptree.amove[moveidx++] = move;
			}

			for (to = sq_bk + def.nfile, dist = 1; to < def.nsquare
					&& ptree.posi.asquare[to] == def.empty; to += def.nfile, dist += 1) {
				move = bitop.To2Move(to) | bitop.Drop2Move(def.rook);
				if ((int) def.airank[to] == def.rank7) {
					move |= def.MOVE_CHK_CLEAR;
				}
				if (dist == 1) {
					move |= def.MOVE_CHK_CLEAR;
				} else if (dist > min_dist) {
					move |= def.MOVE_CHK_SET;
				}
				ptree.amove[moveidx++] = move;
			}

			if (sq_bk < def.A8 || def.I2 < sq_bk) {
				min_dist = 2;
			} else {
				min_dist = 3;
			}

			for (file = (int) def.aifile[sq_bk] + 1, to = sq_bk + 1, dist = 1; file <= def.file9
					&& ptree.posi.asquare[to] == def.empty; file += 1, to += 1, dist += 1) {
				move = bitop.To2Move(to) | bitop.Drop2Move(def.rook);
				if (dist == 1) {
					move |= def.MOVE_CHK_CLEAR;
				} else if (dist > min_dist) {
					move |= def.MOVE_CHK_SET;
				}
				ptree.amove[moveidx++] = move;
			}

			for (file = (int) def.aifile[sq_bk] - 1, to = sq_bk - 1, dist = 1; file >= def.file1
					&& ptree.posi.asquare[to] == def.empty; file -= 1, to -= 1, dist += 1) {
				move = bitop.To2Move(to) | bitop.Drop2Move(def.rook);
				if (dist == 1) {
					move |= def.MOVE_CHK_CLEAR;
				} else if (dist > min_dist) {
					move |= def.MOVE_CHK_SET;
				}
				ptree.amove[moveidx++] = move;
			}
		}

		if (bitop.IsHandBishop(ptree.posi.hand_white) > 0) {
			int move;
			int file, rank, dist;

			to = sq_bk;
			file = (int) def.aifile[sq_bk];
			rank = (int) def.airank[sq_bk];
			for (to += 10, file += 1, rank += 1, dist = 1; file <= def.file9
					&& rank <= def.rank9 && ptree.posi.asquare[to] == def.empty; to += 10, file += 1, rank += 1, dist += 1) {
				move = bitop.To2Move(to) | bitop.Drop2Move(def.bishop);
				if (rank == def.rank7) {
					move |= def.MOVE_CHK_CLEAR;
				}
				if (dist == 1) {
					move |= def.MOVE_CHK_CLEAR;
				} else if (dist > 2) {
					move |= def.MOVE_CHK_SET;
				}
				ptree.amove[moveidx++] = move;
			}

			to = sq_bk;
			file = (int) def.aifile[sq_bk];
			rank = (int) def.airank[sq_bk];
			for (to += 8, file -= 1, rank += 1, dist = 1; file >= 0
					&& rank <= def.rank9 && ptree.posi.asquare[to] == def.empty; to += 8, file -= 1, rank += 1, dist += 1) {
				move = bitop.To2Move(to) | bitop.Drop2Move(def.bishop);
				if (rank == def.rank7) {
					move |= def.MOVE_CHK_CLEAR;
				}
				if (dist == 1) {
					move |= def.MOVE_CHK_CLEAR;
				} else if (dist > 2) {
					move |= def.MOVE_CHK_SET;
				}
				ptree.amove[moveidx++] = move;
			}

			to = sq_bk;
			file = (int) def.aifile[sq_bk];
			rank = (int) def.airank[sq_bk];
			for (to -= 8, file += 1, rank -= 1, dist = 1; file <= def.file9
					&& rank >= 0 && ptree.posi.asquare[to] == def.empty; to -= 8, file += 1, rank -= 1, dist += 1) {
				move = bitop.To2Move(to) | bitop.Drop2Move(def.bishop);
				if (dist == 1) {
					move |= def.MOVE_CHK_CLEAR;
				} else if (dist > 2) {
					move |= def.MOVE_CHK_SET;
				}
				ptree.amove[moveidx++] = move;
			}

			to = sq_bk;
			file = (int) def.aifile[sq_bk];
			rank = (int) def.airank[sq_bk];
			for (to -= 10, file -= 1, rank -= 1, dist = 1; file >= 0
					&& rank >= 0 && ptree.posi.asquare[to] == def.empty; to -= 10, file -= 1, rank -= 1, dist += 1) {
				move = bitop.To2Move(to) | bitop.Drop2Move(def.bishop);
				if (dist == 1) {
					move |= def.MOVE_CHK_CLEAR;
				} else if (dist > 2) {
					move |= def.MOVE_CHK_SET;
				}
				ptree.amove[moveidx++] = move;
			}
		}

		return moveidx;
	}

	private static void add_behind_attacks(bitboard_t pbb, int idirec, int ik) {
		bitboard_t bb_tmp;

		if (idirec == def.direc_diag1) {
			bb_tmp = new bitboard_t(data.abb_bishop_attacks_rr45[ik][0]);
		} else if (idirec == def.direc_diag2) {
			bb_tmp = new bitboard_t(data.abb_bishop_attacks_rl45[ik][0]);
		} else if (idirec == def.direc_file) {
			bb_tmp = new bitboard_t(data.abb_file_attacks[ik][0]);
		} else {
			assert (idirec == def.direc_rank);
			bb_tmp = new bitboard_t(data.abb_rank_attacks[ik][0]);
		}
		bitop.BBNot(bb_tmp, bb_tmp);
		bitop.BBOr(pbb, pbb, bb_tmp);
	}

}
