public class evaluate {

	// R}̕]lvZ
	// Ֆʂ̏̂ƂɈxĂяo邾B
	// ȍ~͍vZ
	public static int eval_material(tree_t ptree) {
		int material, itemp;

		itemp = bitop.PopuCount(ptree.posi.b_pawn)
				+ bitop.I2HandPawn(ptree.posi.hand_black);
		itemp -= bitop.PopuCount(ptree.posi.w_pawn)
				+ bitop.I2HandPawn(ptree.posi.hand_white);
		material = itemp * data.p_value[15 + def.pawn];

		itemp = bitop.PopuCount(ptree.posi.b_lance)
				+ bitop.I2HandLance(ptree.posi.hand_black);
		itemp -= bitop.PopuCount(ptree.posi.w_lance)
				+ bitop.I2HandLance(ptree.posi.hand_white);
		material = itemp * data.p_value[15 + def.lance];

		itemp = bitop.PopuCount(ptree.posi.b_knight)
				+ bitop.I2HandKnight(ptree.posi.hand_black);
		itemp -= bitop.PopuCount(ptree.posi.w_knight)
				+ bitop.I2HandKnight(ptree.posi.hand_white);
		material = itemp * data.p_value[15 + def.knight];

		itemp = bitop.PopuCount(ptree.posi.b_silver)
				+ bitop.I2HandSilver(ptree.posi.hand_black);
		itemp -= bitop.PopuCount(ptree.posi.w_silver)
				+ bitop.I2HandSilver(ptree.posi.hand_white);
		material = itemp * data.p_value[15 + def.silver];

		itemp = bitop.PopuCount(ptree.posi.b_gold)
				+ bitop.I2HandGold(ptree.posi.hand_black);
		itemp -= bitop.PopuCount(ptree.posi.w_gold)
				+ bitop.I2HandGold(ptree.posi.hand_white);
		material = itemp * data.p_value[15 + def.gold];

		itemp = bitop.PopuCount(ptree.posi.b_bishop)
				+ bitop.I2HandBishop(ptree.posi.hand_black);
		itemp -= bitop.PopuCount(ptree.posi.w_bishop)
				+ bitop.I2HandBishop(ptree.posi.hand_white);
		material = itemp * data.p_value[15 + def.bishop];

		itemp = bitop.PopuCount(ptree.posi.b_rook)
				+ bitop.I2HandRook(ptree.posi.hand_black);
		itemp -= bitop.PopuCount(ptree.posi.w_rook)
				+ bitop.I2HandRook(ptree.posi.hand_white);
		material = itemp * data.p_value[15 + def.rook];

		itemp = bitop.PopuCount(ptree.posi.b_pro_pawn);
		itemp -= bitop.PopuCount(ptree.posi.w_pro_pawn);
		material = itemp * data.p_value[15 + def.pro_pawn];

		itemp = bitop.PopuCount(ptree.posi.b_pro_lance);
		itemp -= bitop.PopuCount(ptree.posi.w_pro_lance);
		material = itemp * data.p_value[15 + def.pro_lance];

		itemp = bitop.PopuCount(ptree.posi.b_pro_knight);
		itemp -= bitop.PopuCount(ptree.posi.w_pro_knight);
		material = itemp * data.p_value[15 + def.pro_knight];

		itemp = bitop.PopuCount(ptree.posi.b_pro_silver);
		itemp -= bitop.PopuCount(ptree.posi.w_pro_silver);
		material = itemp * data.p_value[15 + def.pro_silver];

		itemp = bitop.PopuCount(ptree.posi.b_horse);
		itemp -= bitop.PopuCount(ptree.posi.w_horse);
		material = itemp * data.p_value[15 + def.horse];

		itemp = bitop.PopuCount(ptree.posi.b_dragon);
		itemp -= bitop.PopuCount(ptree.posi.w_dragon);
		material = itemp * data.p_value[15 + def.dragon];

		return material;
	}

	public static int evaluate(tree_t ptree, int ply, int turn) {
		int[] list0 = new int[52];
		int[] list1 = new int[52];
		int nlist, score, sq_bk, sq_wk, k0, k1, l0, l1, i, j, sum;

		assert (0 < ply);
		ptree.neval_called++;

		if (ptree.save_eval[ply] != Integer.MAX_VALUE) {
			return (int) ptree.save_eval[ply] / def.FV_SCALE;
		}

		score = ehash_probe(ptree.posi.hash_key, ptree.posi.hand_black);
		if (score != Integer.MIN_VALUE) {
			score = turn > 0 ? -score : score;
			ptree.save_eval[ply] = score;

			return score / def.FV_SCALE;
		}

		list0[0] = def.f_hand_pawn + bitop.I2HandPawn(ptree.posi.hand_black);
		list0[1] = def.e_hand_pawn + bitop.I2HandPawn(ptree.posi.hand_white);
		list0[2] = def.f_hand_lance + bitop.I2HandLance(ptree.posi.hand_black);
		list0[3] = def.e_hand_lance + bitop.I2HandLance(ptree.posi.hand_white);
		list0[4] = def.f_hand_knight
				+ bitop.I2HandKnight(ptree.posi.hand_black);
		list0[5] = def.e_hand_knight
				+ bitop.I2HandKnight(ptree.posi.hand_white);
		list0[6] = def.f_hand_silver
				+ bitop.I2HandSilver(ptree.posi.hand_black);
		list0[7] = def.e_hand_silver
				+ bitop.I2HandSilver(ptree.posi.hand_white);
		list0[8] = def.f_hand_gold + bitop.I2HandGold(ptree.posi.hand_black);
		list0[9] = def.e_hand_gold + bitop.I2HandGold(ptree.posi.hand_white);
		list0[10] = def.f_hand_bishop
				+ bitop.I2HandBishop(ptree.posi.hand_black);
		list0[11] = def.e_hand_bishop
				+ bitop.I2HandBishop(ptree.posi.hand_white);
		list0[12] = def.f_hand_rook + bitop.I2HandRook(ptree.posi.hand_black);
		list0[13] = def.e_hand_rook + bitop.I2HandRook(ptree.posi.hand_white);

		list1[0] = def.f_hand_pawn + bitop.I2HandPawn(ptree.posi.hand_white);
		list1[1] = def.e_hand_pawn + bitop.I2HandPawn(ptree.posi.hand_black);
		list1[2] = def.f_hand_lance + bitop.I2HandLance(ptree.posi.hand_white);
		list1[3] = def.e_hand_lance + bitop.I2HandLance(ptree.posi.hand_black);
		list1[4] = def.f_hand_knight
				+ bitop.I2HandKnight(ptree.posi.hand_white);
		list1[5] = def.e_hand_knight
				+ bitop.I2HandKnight(ptree.posi.hand_black);
		list1[6] = def.f_hand_silver
				+ bitop.I2HandSilver(ptree.posi.hand_white);
		list1[7] = def.e_hand_silver
				+ bitop.I2HandSilver(ptree.posi.hand_black);
		list1[8] = def.f_hand_gold + bitop.I2HandGold(ptree.posi.hand_white);
		list1[9] = def.e_hand_gold + bitop.I2HandGold(ptree.posi.hand_black);
		list1[10] = def.f_hand_bishop
				+ bitop.I2HandBishop(ptree.posi.hand_white);
		list1[11] = def.e_hand_bishop
				+ bitop.I2HandBishop(ptree.posi.hand_black);
		list1[12] = def.f_hand_rook + bitop.I2HandRook(ptree.posi.hand_white);
		list1[13] = def.e_hand_rook + bitop.I2HandRook(ptree.posi.hand_black);

		score = calc_difference(ptree, ply, turn, list0, list1);
		if (score != Integer.MIN_VALUE) {
			ehash_store(ptree.posi.hash_key, ptree.posi.hand_black, score);
			score = turn > 0 ? -score : score;
			ptree.save_eval[ply] = score;

			return score / def.FV_SCALE;
		}

		int[] ret = make_list(ptree, list0, list1);
		nlist = ret[0];
		score = ret[1];
		sq_bk = ptree.posi.isquare_b_king;
		sq_wk = bitop.Inv(ptree.posi.isquare_w_king);

		sum = 0;
		for (i = 0; i < nlist; i++) {
			k0 = list0[i];
			k1 = list1[i];
			for (j = 0; j <= i; j++) {
				l0 = list0[j];
				l1 = list1[j];
				assert (k0 >= l0 && k1 >= l1);
				sum += bitop.PcPcOnSq(sq_bk, k0, l0);
				sum -= bitop.PcPcOnSq(sq_wk, k1, l1);
			}
		}

		score += sum;
		score += ptree.posi.material * def.FV_SCALE;

		ehash_store(ptree.posi.hash_key, ptree.posi.hand_black, score);

		score = turn > 0 ? -score : score;

		ptree.save_eval[ply] = score;

		score /= def.FV_SCALE;

		return score;

	}

	// KKP(̉1ɂ3)vZBKPPpŎg߂̋Xg񋓂łKKPvZ
	// nlistscoreԂ
	private static int[] make_list(tree_t ptree, int[] list0, int[] list1) {
		bitboard_t bb;
		int[] list2 = new int[34];
		int nlist, sq, n2, i, score, sq_bk0, sq_wk0, sq_bk1, sq_wk1;

		nlist = 14;
		score = 0;
		sq_bk0 = ptree.posi.isquare_b_king;
		sq_wk0 = ptree.posi.isquare_w_king;
		sq_bk1 = bitop.Inv(ptree.posi.isquare_w_king);
		sq_wk1 = bitop.Inv(ptree.posi.isquare_b_king);

		// ̖̎̕ƁA(sq_bk0 = square black king = ̋ʂ̔Տ̍W)ƌ(sq_wk0 =
		// square white king = ̋ʂ̔Տ̍W)KKP]Ă镔
		score += data.kkp[sq_bk0][sq_wk0][def.kkp_hand_pawn
				+ bitop.I2HandPawn(ptree.posi.hand_black)];
		score += data.kkp[sq_bk0][sq_wk0][def.kkp_hand_lance
				+ bitop.I2HandLance(ptree.posi.hand_black)];
		score += data.kkp[sq_bk0][sq_wk0][def.kkp_hand_knight
				+ bitop.I2HandKnight(ptree.posi.hand_black)];
		score += data.kkp[sq_bk0][sq_wk0][def.kkp_hand_silver
				+ bitop.I2HandSilver(ptree.posi.hand_black)];
		score += data.kkp[sq_bk0][sq_wk0][def.kkp_hand_gold
				+ bitop.I2HandGold(ptree.posi.hand_black)];
		score += data.kkp[sq_bk0][sq_wk0][def.kkp_hand_bishop
				+ bitop.I2HandBishop(ptree.posi.hand_black)];
		score += data.kkp[sq_bk0][sq_wk0][def.kkp_hand_rook
				+ bitop.I2HandRook(ptree.posi.hand_black)];

		score -= data.kkp[sq_bk1][sq_wk1][def.kkp_hand_pawn
				+ bitop.I2HandPawn(ptree.posi.hand_white)];
		score -= data.kkp[sq_bk1][sq_wk1][def.kkp_hand_lance
				+ bitop.I2HandLance(ptree.posi.hand_white)];
		score -= data.kkp[sq_bk1][sq_wk1][def.kkp_hand_knight
				+ bitop.I2HandKnight(ptree.posi.hand_white)];
		score -= data.kkp[sq_bk1][sq_wk1][def.kkp_hand_silver
				+ bitop.I2HandSilver(ptree.posi.hand_white)];
		score -= data.kkp[sq_bk1][sq_wk1][def.kkp_hand_gold
				+ bitop.I2HandGold(ptree.posi.hand_white)];
		score -= data.kkp[sq_bk1][sq_wk1][def.kkp_hand_bishop
				+ bitop.I2HandBishop(ptree.posi.hand_white)];
		score -= data.kkp[sq_bk1][sq_wk1][def.kkp_hand_rook
				+ bitop.I2HandRook(ptree.posi.hand_white)];

		n2 = 0;
		bb = new bitboard_t(ptree.posi.b_pawn);
		while (bitop.BBTest(bb)) {
			sq = bitop.FirstOne(bb);
			bitop.Xor(sq, bb);

			list0[nlist] = def.f_pawn + sq;
			list2[n2] = def.e_pawn + bitop.Inv(sq);
			score += data.kkp[sq_bk0][sq_wk0][def.kkp_pawn + sq];
			nlist += 1;
			n2 += 1;
		}

		bb = new bitboard_t(ptree.posi.w_pawn);
		while (bitop.BBTest(bb)) {
			sq = bitop.FirstOne(bb);
			bitop.Xor(sq, bb);

			list0[nlist] = def.e_pawn + sq;
			list2[n2] = def.f_pawn + bitop.Inv(sq);
			score -= data.kkp[sq_bk1][sq_wk1][def.kkp_pawn + bitop.Inv(sq)];
			nlist += 1;
			n2 += 1;
		}
		for (i = 0; i < n2; i++) {
			list1[nlist - i - 1] = list2[i];
		}

		n2 = 0;
		bb = new bitboard_t(ptree.posi.b_lance);
		while (bitop.BBTest(bb)) {
			sq = bitop.FirstOne(bb);
			bitop.Xor(sq, bb);

			list0[nlist] = def.f_lance + sq;
			list2[n2] = def.e_lance + bitop.Inv(sq);
			score += data.kkp[sq_bk0][sq_wk0][def.kkp_lance + sq];
			nlist += 1;
			n2 += 1;
		}

		bb = new bitboard_t(ptree.posi.w_lance);
		while (bitop.BBTest(bb)) {
			sq = bitop.FirstOne(bb);
			bitop.Xor(sq, bb);

			list0[nlist] = def.e_lance + sq;
			list2[n2] = def.f_lance + bitop.Inv(sq);
			score -= data.kkp[sq_bk1][sq_wk1][def.kkp_lance + bitop.Inv(sq)];
			nlist += 1;
			n2 += 1;
		}
		for (i = 0; i < n2; i++) {
			list1[nlist - i - 1] = list2[i];
		}

		n2 = 0;
		bb = new bitboard_t(ptree.posi.b_knight);
		while (bitop.BBTest(bb)) {
			sq = bitop.FirstOne(bb);
			bitop.Xor(sq, bb);

			list0[nlist] = def.f_knight + sq;
			list2[n2] = def.e_knight + bitop.Inv(sq);
			score += data.kkp[sq_bk0][sq_wk0][def.kkp_knight + sq];
			nlist += 1;
			n2 += 1;
		}

		bb = new bitboard_t(ptree.posi.w_knight);
		while (bitop.BBTest(bb)) {
			sq = bitop.FirstOne(bb);
			bitop.Xor(sq, bb);

			list0[nlist] = def.e_knight + sq;
			list2[n2] = def.f_knight + bitop.Inv(sq);
			score -= data.kkp[sq_bk1][sq_wk1][def.kkp_knight + bitop.Inv(sq)];
			nlist += 1;
			n2 += 1;
		}
		for (i = 0; i < n2; i++) {
			list1[nlist - i - 1] = list2[i];
		}

		n2 = 0;
		bb = new bitboard_t(ptree.posi.b_silver);
		while (bitop.BBTest(bb)) {
			sq = bitop.FirstOne(bb);
			bitop.Xor(sq, bb);

			list0[nlist] = def.f_silver + sq;
			list2[n2] = def.e_silver + bitop.Inv(sq);
			score += data.kkp[sq_bk0][sq_wk0][def.kkp_silver + sq];
			nlist += 1;
			n2 += 1;
		}

		bb = new bitboard_t(ptree.posi.w_silver);
		while (bitop.BBTest(bb)) {
			sq = bitop.FirstOne(bb);
			bitop.Xor(sq, bb);

			list0[nlist] = def.e_silver + sq;
			list2[n2] = def.f_silver + bitop.Inv(sq);
			score -= data.kkp[sq_bk1][sq_wk1][def.kkp_silver + bitop.Inv(sq)];
			nlist += 1;
			n2 += 1;
		}
		for (i = 0; i < n2; i++) {
			list1[nlist - i - 1] = list2[i];
		}

		n2 = 0;
		bb = new bitboard_t(ptree.posi.b_gold);
		while (bitop.BBTest(bb)) {
			sq = bitop.FirstOne(bb);
			bitop.Xor(sq, bb);

			list0[nlist] = def.f_gold + sq;
			list2[n2] = def.e_gold + bitop.Inv(sq);
			score += data.kkp[sq_bk0][sq_wk0][def.kkp_gold + sq];
			nlist += 1;
			n2 += 1;
		}

		bb = new bitboard_t(ptree.posi.w_gold);
		while (bitop.BBTest(bb)) {
			sq = bitop.FirstOne(bb);
			bitop.Xor(sq, bb);

			list0[nlist] = def.e_gold + sq;
			list2[n2] = def.f_gold + bitop.Inv(sq);
			score -= data.kkp[sq_bk1][sq_wk1][def.kkp_gold + bitop.Inv(sq)];
			nlist += 1;
			n2 += 1;
		}
		for (i = 0; i < n2; i++) {
			list1[nlist - i - 1] = list2[i];
		}

		n2 = 0;
		bb = new bitboard_t(ptree.posi.b_bishop);
		while (bitop.BBTest(bb)) {
			sq = bitop.FirstOne(bb);
			bitop.Xor(sq, bb);

			list0[nlist] = def.f_bishop + sq;
			list2[n2] = def.e_bishop + bitop.Inv(sq);
			score += data.kkp[sq_bk0][sq_wk0][def.kkp_bishop + sq];
			nlist += 1;
			n2 += 1;
		}

		bb = new bitboard_t(ptree.posi.w_bishop);
		while (bitop.BBTest(bb)) {
			sq = bitop.FirstOne(bb);
			bitop.Xor(sq, bb);

			list0[nlist] = def.e_bishop + sq;
			list2[n2] = def.f_bishop + bitop.Inv(sq);
			score -= data.kkp[sq_bk1][sq_wk1][def.kkp_bishop + bitop.Inv(sq)];
			nlist += 1;
			n2 += 1;
		}
		for (i = 0; i < n2; i++) {
			list1[nlist - i - 1] = list2[i];
		}

		n2 = 0;
		bb = new bitboard_t(ptree.posi.b_horse);
		while (bitop.BBTest(bb)) {
			sq = bitop.FirstOne(bb);
			bitop.Xor(sq, bb);

			list0[nlist] = def.f_horse + sq;
			list2[n2] = def.e_horse + bitop.Inv(sq);
			score += data.kkp[sq_bk0][sq_wk0][def.kkp_horse + sq];
			nlist += 1;
			n2 += 1;
		}

		bb = new bitboard_t(ptree.posi.w_horse);
		while (bitop.BBTest(bb)) {
			sq = bitop.FirstOne(bb);
			bitop.Xor(sq, bb);

			list0[nlist] = def.e_horse + sq;
			list2[n2] = def.f_horse + bitop.Inv(sq);
			score -= data.kkp[sq_bk1][sq_wk1][def.kkp_horse + bitop.Inv(sq)];
			nlist += 1;
			n2 += 1;
		}
		for (i = 0; i < n2; i++) {
			list1[nlist - i - 1] = list2[i];
		}

		n2 = 0;
		bb = new bitboard_t(ptree.posi.b_rook);
		while (bitop.BBTest(bb)) {
			sq = bitop.FirstOne(bb);
			bitop.Xor(sq, bb);

			list0[nlist] = def.f_rook + sq;
			list2[n2] = def.e_rook + bitop.Inv(sq);
			score += data.kkp[sq_bk0][sq_wk0][def.kkp_rook + sq];
			nlist += 1;
			n2 += 1;
		}

		bb = new bitboard_t(ptree.posi.w_rook);
		while (bitop.BBTest(bb)) {
			sq = bitop.FirstOne(bb);
			bitop.Xor(sq, bb);

			list0[nlist] = def.e_rook + sq;
			list2[n2] = def.f_rook + bitop.Inv(sq);
			score -= data.kkp[sq_bk1][sq_wk1][def.kkp_rook + bitop.Inv(sq)];
			nlist += 1;
			n2 += 1;
		}
		for (i = 0; i < n2; i++) {
			list1[nlist - i - 1] = list2[i];
		}

		n2 = 0;
		bb = new bitboard_t(ptree.posi.b_dragon);
		while (bitop.BBTest(bb)) {
			sq = bitop.FirstOne(bb);
			bitop.Xor(sq, bb);

			list0[nlist] = def.f_dragon + sq;
			list2[n2] = def.e_dragon + bitop.Inv(sq);
			score += data.kkp[sq_bk0][sq_wk0][def.kkp_dragon + sq];
			nlist += 1;
			n2 += 1;
		}

		bb = new bitboard_t(ptree.posi.w_dragon);
		while (bitop.BBTest(bb)) {
			sq = bitop.FirstOne(bb);
			bitop.Xor(sq, bb);

			list0[nlist] = def.e_dragon + sq;
			list2[n2] = def.f_dragon + bitop.Inv(sq);
			score -= data.kkp[sq_bk1][sq_wk1][def.kkp_dragon + bitop.Inv(sq)];
			nlist += 1;
			n2 += 1;
		}
		for (i = 0; i < n2; i++) {
			list1[nlist - i - 1] = list2[i];
		}

		assert (nlist <= 52);

		int[] ret = new int[2];
		ret[0] = nlist;
		ret[1] = score;
		return ret;
	}

	private static void ehash_store(long key, int hand_b, int score) {
		long hash_word;

		hash_word = key;
		hash_word ^= (long) hand_b << 21;
		hash_word &= ~(long) 0x1fffff;
		hash_word |= (long) (score + 0x100000);

		data.ehash_tbl[(int) key & def.EHASH_MASK] = hash_word;
	}

	private static int calc_difference(tree_t ptree, int ply, int turn, int[] list0,
			int[] list1) {
		bitboard_t bb = new bitboard_t();
		int nlist, diff, from, to, sq, pc;

		if (ptree.save_eval[ply - 1] == Integer.MAX_VALUE) {
			return Integer.MIN_VALUE;
		}
		if (bitop.I2PieceMove(ptree.current_move[ply - 1]) == def.king) {
			return Integer.MIN_VALUE;
		}

		assert (ptree.current_move[ply - 1] != def.MOVE_PASS);

		nlist = 14;
		diff = 0;
		from = bitop.I2From(ptree.current_move[ply - 1]);
		to = bitop.I2To(ptree.current_move[ply - 1]);

		bitop.BBOr(bb, ptree.posi.b_occupied, ptree.posi.w_occupied);
		bitop.Xor(ptree.posi.isquare_b_king, bb);
		bitop.Xor(ptree.posi.isquare_w_king, bb);
		bitop.Xor(to, bb);

		while (bitop.BBTest(bb)) {
			sq = bitop.FirstOne(bb);
			bitop.Xor(sq, bb);

			pc = ptree.posi.asquare[sq];
			list0[nlist] = def.aikpp[15 + pc] + sq;
			list1[nlist++] = def.aikpp[15 - pc] + bitop.Inv(sq);
		}

		pc = ptree.posi.asquare[to];
		list0[nlist] = def.aikpp[15 + pc] + to;
		list1[nlist++] = def.aikpp[15 - pc] + bitop.Inv(to);

		diff = doapc(ptree, pc, to, list0, list1, nlist);
		nlist -= 1;

		if (from >= def.nsquare) {
			int hand;
			int hand_index;

			pc = bitop.From2Drop(from);
			hand = turn > 0 ? ptree.posi.hand_black : ptree.posi.hand_white;

			switch (pc) {
			case def.pawn:
				hand_index = bitop.I2HandPawn(hand);
				break;
			case def.lance:
				hand_index = bitop.I2HandLance(hand);
				break;
			case def.knight:
				hand_index = bitop.I2HandKnight(hand);
				break;
			case def.silver:
				hand_index = bitop.I2HandSilver(hand);
				break;
			case def.gold:
				hand_index = bitop.I2HandGold(hand);
				break;
			case def.bishop:
				hand_index = bitop.I2HandBishop(hand);
				break;
			default:
				hand_index = bitop.I2HandRook(hand);
				break;
			}

			diff += doacapt(ptree, pc, turn, hand_index, list0, list1, nlist);

			list0[2 * (pc - 1) + 1 - turn] += 1;
			list1[2 * (pc - 1) + turn] += 1;
			hand_index += 1;

			diff -= doacapt(ptree, pc, turn, hand_index, list0, list1, nlist);
		} else {
			int pc_cap = bitop.UToCap(ptree.current_move[ply - 1]);
			if (pc_cap > 0) {
				int hand;
				int hand_index;

				pc = pc_cap & ~def.promote;
				hand = turn > 0 ? ptree.posi.hand_black : ptree.posi.hand_white;
				pc_cap = turn > 0 ? -pc_cap : pc_cap;
				diff += turn > 0 ? data.p_value_ex[15 + pc_cap] * def.FV_SCALE
						: -data.p_value_ex[15 + pc_cap] * def.FV_SCALE;

				switch (pc) {
				case def.pawn:
					hand_index = bitop.I2HandPawn(hand);
					break;
				case def.lance:
					hand_index = bitop.I2HandLance(hand);
					break;
				case def.knight:
					hand_index = bitop.I2HandKnight(hand);
					break;
				case def.silver:
					hand_index = bitop.I2HandSilver(hand);
					break;
				case def.gold:
					hand_index = bitop.I2HandGold(hand);
					break;
				case def.bishop:
					hand_index = bitop.I2HandBishop(hand);
					break;
				default:
					hand_index = bitop.I2HandRook(hand);
					break;
				}

				diff += doacapt(ptree, pc, turn, hand_index, list0, list1,
						nlist);

				list0[2 * (pc - 1) + 1 - turn] -= 1;
				list1[2 * (pc - 1) + turn] -= 1;
				hand_index -= 1;

				diff -= doacapt(ptree, pc, turn, hand_index, list0, list1,
						nlist);

				list0[nlist] = def.aikpp[15 + pc_cap] + to;
				list1[nlist++] = def.aikpp[15 - pc_cap] + bitop.Inv(to);

				diff -= doapc(ptree, pc_cap, to, list0, list1, nlist);
			}

			pc = bitop.I2PieceMove(ptree.current_move[ply - 1]);
			if (bitop.I2IsPromote(ptree.current_move[ply - 1]) > 0) {
				diff += (turn > 0 ? data.p_value_pm[7 + pc]
						: -data.p_value_pm[7 + pc]) * def.FV_SCALE;
			}

			pc = turn > 0 ? pc : -pc;

			list0[nlist] = def.aikpp[15 + pc] + from;
			list1[nlist++] = def.aikpp[15 - pc] + bitop.Inv(from);

			diff -= doapc(ptree, pc, from, list0, list1, nlist);

		}

		diff += turn > 0 ? ptree.save_eval[ply - 1] : -ptree.save_eval[ply - 1];

		return diff;
	}

	private static int doacapt(tree_t ptree, int pc, int turn, int hand_index, int[] list0,
			int[] list1, int nlist) {
		int i, sum, sq_bk, sq_wk, index_b, index_w;

		index_b = 2 * (pc - 1) + 1 - turn;
		index_w = 2 * (pc - 1) + turn;
		sq_bk = ptree.posi.isquare_b_king;
		sq_wk = bitop.Inv(ptree.posi.isquare_w_king);

		sum = 0;
		for (i = 14; i < nlist; i++) {
			sum += bitop.PcPcOnSq(sq_bk, list0[i], list0[index_b]);
			sum -= bitop.PcPcOnSq(sq_wk, list1[i], list1[index_w]);
		}

		for (i = 0; i <= 2 * (pc - 1); i++) {
			sum += bitop.PcPcOnSq(sq_bk, list0[index_b], list0[i]);
			sum -= bitop.PcPcOnSq(sq_wk, list1[index_w], list1[i]);
		}

		for (i += 1; i < 14; i++) {
			sum += bitop.PcPcOnSq(sq_bk, list0[i], list0[index_b]);
			sum -= bitop.PcPcOnSq(sq_wk, list1[i], list1[index_w]);
		}

		if (turn > 0) {
			sum += bitop.PcPcOnSq(sq_bk, list0[index_w], list0[index_b]);
			sum -= bitop.PcPcOnSq(sq_wk, list1[index_w], list1[index_w]);
			sq_bk = ptree.posi.isquare_b_king;
			sq_wk = ptree.posi.isquare_w_king;
			sum += data.kkp[sq_bk][sq_wk][def.aikkp_hand[pc] + hand_index];
		} else {
			sum += bitop.PcPcOnSq(sq_bk, list0[index_b], list0[index_b]);
			sum -= bitop.PcPcOnSq(sq_wk, list1[index_b], list1[index_w]);
			sq_bk = bitop.Inv(ptree.posi.isquare_w_king);
			sq_wk = bitop.Inv(ptree.posi.isquare_b_king);
			sum -= data.kkp[sq_bk][sq_wk][def.aikkp_hand[pc] + hand_index];
		}

		return sum;
	}

	private static int doapc(tree_t ptree, int pc, int sq, int[] list0, int[] list1,
			int nlist) {
		int i, sum;
		int index_b = def.aikpp[15 + pc] + sq;
		int index_w = def.aikpp[15 - pc] + bitop.Inv(sq);
		int sq_bk = ptree.posi.isquare_b_king;
		int sq_wk = bitop.Inv(ptree.posi.isquare_w_king);

		sum = 0;
		for (i = 0; i < 14; i++) {
			sum += bitop.PcPcOnSq(sq_bk, index_b, list0[i]);
			sum -= bitop.PcPcOnSq(sq_wk, index_w, list1[i]);
		}

		for (i = 14; i < nlist; i++) {
			sum += bitop.PcPcOnSqAny(sq_bk, index_b, list0[i]);
			sum -= bitop.PcPcOnSqAny(sq_wk, index_w, list1[i]);
		}

		if (pc > 0) {
			sq_bk = ptree.posi.isquare_b_king;
			sq_wk = ptree.posi.isquare_w_king;
			sum += data.kkp[sq_bk][sq_wk][def.aikkp[pc] + sq];
		} else {
			sq_bk = bitop.Inv(ptree.posi.isquare_w_king);
			sq_wk = bitop.Inv(ptree.posi.isquare_b_king);
			sum -= data.kkp[sq_bk][sq_wk][def.aikkp[-pc] + bitop.Inv(sq)];
		}

		return sum;
	}

	/**
	 * pscoreԂ̂ňpscore͓Ȃ ̂0ςƂInteger.MinvalueԂ̂łŔ肷
	 * 
	 * @param current_key
	 * @param hand_b
	 * @return
	 */
	private static int ehash_probe(long current_key, int hand_b) {
		long hash_word, hash_key;

		hash_word = data.ehash_tbl[(int) current_key & def.EHASH_MASK];

		current_key ^= (long) hand_b << 21;
		current_key &= ~(long) 0x1fffff;

		hash_key = hash_word;
		hash_key &= ~(long) 0x1fffff;

		if (hash_key != current_key) {
			return Integer.MIN_VALUE;
		}

		return (int) ((int) hash_word & 0x1fffff) - 0x100000;
	}
}
