package submit05;

import java.io.*;
import java.util.*;

import static java.lang.Math.*;
import static java.lang.Integer.*;


/*
N : 407
Holes count (Cnt) = 99
Holes area (Area) = 2877461934
Score  = 28202004415134
 */


public class RectanglesAndHoles {

	static PrintStream err = System.err;
	static long progtime = 0;
	
	static int N = 0;
	Random rnd = new Random();
	static boolean debug = true;

	static void debug(String s){
		if(debug){
			err.print(s);
		}
	}
	static void debug(int i){
		if(debug){
			err.print(i);
		}
	}
	
	List<R> rs = null;
	List<L> lines = null;
	List<L> tateLines = null;
	List<L> yokoLines = null;
	
	public int[] place(int[] A, int[] B){
		long start =  System.currentTimeMillis();
		lines = new ArrayList<L>();
		tateLines = new ArrayList<L>();
		yokoLines = new ArrayList<L>();
		int[] ret = null;
		N = A.length;
		List<R> orgs = new ArrayList<R>();
		rs = new ArrayList<R>();

		try{
			for(int i = 0; i < N; i++){
				R r = new R(A[i], B[i]);
				r.idx = i;
				rs.add(r);
				orgs.add(r);
			}
			
			Collections.sort(rs, new Comparator<R>() {
				@Override
				public int compare(R o1, R o2) {
					return o2.l - o1.l;
				}
			});
			
			mycalc2();
			//mycalc(rs);

			ret = new int[N*3];
			for(int i = 0; i < N; i++){
				R r = orgs.get(i);
				ret[3*i] = r.x;
				ret[3*i+1] = r.y;
				ret[3*i+2] = r.d;
			}
			
		}
		catch(Exception ex){
			err.println(ex.getMessage());
		}
		
		progtime += System.currentTimeMillis() - start;
		return ret;
	}
	
	private void mycalc2() throws Exception{
		List<R> ups = new ArrayList<R>();
		List<R> dws = new ArrayList<R>();
		List<R> lfs = new ArrayList<R>();
		List<R> ris = new ArrayList<R>();
		int uplen = 0;
		int dwlen = 0;
		int lflen = 0;
		int rilen = 0;
		
		List<R> lasts = new ArrayList<R>();
		for(int i = 0; i < 6; i++){
			lasts.add(rs.remove(0));
		}
		{
			R r = rs.remove(0);
			uplen = r.l;
			if(r.b > r.a){
				r.d = 1;
			}
			ups.add(r);
		}
		{
			R r = rs.remove(0);
			dwlen = r.l;
			if(r.b > r.a){
				r.d = 1;
			}
			dws.add(r);
		}
		{
			R r = rs.remove(0);
			if(r.a > r.b){
				r.d = 1;
			}
			r.y = 0;
			r.x = -r.s;
			lflen += r.l;
			lfs.add(r);
		}
		{
			R r = rs.remove(0);
			if(r.a > r.b){
				r.d = 1;
			}
			r.y = rilen;
			r.x = 0;
			rilen += r.l;
			ris.add(r);
		}
		
		int holes = 0;
		
		while(rs.size() > 0){
			
			int next = getNextDir(uplen, dwlen, lflen, rilen);
			int debugidx = 226;
			if(next == 0){
				if(rs.size() >= 4){
					holes++;
					R lastR = ups.get(ups.size()-1);
					List<R> newR = new ArrayList<R>();
					{
						R r = getLastR();
						if(r.idx == debugidx){
							err.print("");
						}
						if(r.a < r.b){
							r.d = 1;
						}
						r.y = -r.s;
						r.x = uplen;
						uplen += r.l;
						newR.add(r);
					}
					{
						R r = rs.remove(rs.size()-2);
						if(r.idx == debugidx){
							err.print("");
						}
						if(r.a < r.b){
							r.d = 1;
						}
						r.y = 0;
						r.x = uplen;
						uplen += r.l;
						newR.add(r);
					}
					{
						R r = getLastR();
						if(r.idx == debugidx){
							err.print("");
						}
						if(r.a < r.b){
							r.d = 1;
						}
						int miny = Math.min(lastR.s, newR.get(1).s);
						if(miny == lastR.s){
							r.y = miny;
							r.x = newR.get(1).x - r.l;
						}
						else{
							r.y = miny;
							r.x = newR.get(0).x;
						}
						
						newR.add(newR.size()-1, r);
					}
					ups.addAll(newR);
					
				}
				else{
					R r = rs.remove(0);
					if(r.b > r.a){
						r.d = 1;
					}
					r.y = 0;
					r.x = uplen;
					uplen += r.l;
					ups.add(r);
				}
			}
			else if(next == 1){
				if(rs.size() >= 4){
					holes++;
					R lastR = dws.get(dws.size()-1);
					List<R> newR = new ArrayList<R>();
					{
						R r = getLastR();
						if(r.idx == debugidx){
							err.print("");
						}
						if(r.a < r.b){
							r.d = 1;
						}
						r.y = 0;
						r.x = dwlen;
						dwlen += r.l;
						newR.add(r);
					}
					{
						R r = rs.remove(rs.size()-2);
						if(r.idx == debugidx){
							err.print("");
						}
						if(r.a < r.b){
							r.d = 1;
						}
						r.y = -r.s;
						r.x = dwlen;
						dwlen += r.l;
						newR.add(r);
					}
					{
						R r = getLastR();
						if(r.idx == debugidx){
							err.print("");
						}
						if(r.a < r.b){
							r.d = 1;
						}
						int maxy = Math.max(newR.get(1).y, lastR.y);
						if(maxy == newR.get(1).y){
							r.y = maxy - r.s;
							r.x = newR.get(0).x;
						}
						else{
							r.y = maxy - r.s;
							r.x = newR.get(1).x - r.l;
						}
						newR.add(newR.size()-1, r);
					}
					dws.addAll(newR);
				}
				else{
					R r = rs.remove(0);
					if(r.b > r.a){
						r.d = 1;
					}
					r.y = -r.s;
					r.x = dwlen;
					dwlen += r.l;
					dws.add(r);
				}
			}
			else if(next == 2){ // 
				if(rs.size() >= 4){
					R lastR = lfs.get(lfs.size()-1);
					List<R> newR = new ArrayList<R>();
					{
						R r = getLastR();
						if(r.idx == debugidx){
							err.print("");
						}
						if(r.a > r.b){
							r.d = 1;
						}
						r.y = lflen;
						r.x = 0;
						lflen += r.l;
						newR.add(r);
					}
					{
						R r = rs.remove(rs.size()-2);
						if(r.idx == debugidx){
							err.print("");
						}
						if(r.a > r.b){
							r.d = 1;
						}
						r.y = lflen;
						r.x = -r.s;
						lflen += r.l;
						newR.add(r);
					}
					{
						R r = getLastR();
						if(r.idx == debugidx){
							err.print("");
						}
						if(r.a > r.b){
							r.d = 1;
						}
						int maxx = Math.max(newR.get(1).x, lastR.x);
						if(maxx == newR.get(1).x){
							r.y = newR.get(0).y;
							r.x = maxx-r.s;
						}
						else{
							r.y = newR.get(1).y - r.l;
							r.x = lastR.x - r.s;
						}
						newR.add(newR.size()-1, r);
					}
					lfs.addAll(newR);
				}
				else{
					R r = rs.remove(0);
					if(r.a > r.b){
						r.d = 1;
					}
					r.y = lflen;
					r.x = -r.s;
					lflen += r.l;
					lfs.add(r);
				}
			}
			else{
				if(rs.size() > 4){
					R lastR = ris.get(ris.size()-1);
					List<R> newR = new ArrayList<R>();
					{
						R r = getLastR();
						if(r.idx == debugidx){
							err.print("");
						}
						if(r.a > r.b){
							r.d = 1;
						}
						r.y = rilen;
						r.x = -r.s;
						rilen += r.l;
						newR.add(r);
					}
					{
						R r = rs.remove(rs.size()-2);
						if(r.idx == debugidx){
							err.print("");
						}
						if(r.a > r.b){
							r.d = 1;
						}
						r.y = rilen;
						r.x = 0;
						rilen += r.l;
						newR.add(r);
					}
					{
						R r = getLastR();
						if(r.idx == debugidx){
							err.print("");
						}
						if(r.a > r.b){
							r.d = 1;
						}
						int minx = Math.min(newR.get(1).x + newR.get(1).s, lastR.x + lastR.s);
						if(minx == newR.get(1).x + newR.get(1).s){
							r.y = newR.get(0).y;
							r.x = minx;
						}
						else{
							r.y = newR.get(1).y - r.l;
							r.x = minx;
						}
						newR.add(newR.size()-1, r);
					}
					ris.addAll(newR);
					
				}
				else{
					R r = rs.remove(0);
					if(r.a > r.b){
						r.d = 1;
					}
					r.y = rilen;
					r.x = 0;
					rilen += r.l;
					ris.add(r);
				}
			}
		}
		//err.println("holes : " + holes);
		
		// ŌɏdȂȂ悤ɒ
		while(uplen > dwlen){
			R r = lasts.remove(0);
			if(r.b > r.a){
				r.d = 1;
			}
			r.y = -r.s;
			r.x = dwlen;
			dwlen += r.l;
			dws.add(r);
		}
		
		while(rilen > lflen){
			R r = lasts.remove(0);
			if(r.a > r.b){
				r.d = 1;
			}
			r.y = lflen;
			r.x = -r.s;
			lflen += r.l;
			lfs.add(r);
		}
		
		
		while(lasts.size() > 0){
			if(lasts.size() >= 2){
				{
					// ŏdown
					R r = lasts.remove(0);
					if(r.b > r.a){
						r.d = 1;
					}
					r.y = -r.s;
					r.x = dwlen;
					dwlen += r.l;
					dws.add(r);
				}
				{
					R r = lasts.remove(0);
					if(r.b > r.a){
						r.d = 1;
					}
					r.y = 0;
					r.x = uplen;
					uplen += r.l;
					ups.add(r);
				}
			}
			else{
				R r = lasts.remove(0);
				if(r.b > r.a){
					r.d = 1;
				}
				r.y = -r.s;
				r.x = dwlen;
				dwlen += r.l;
				dws.add(r);
			}
			if(lasts.size() >= 2){
				{
					R r = lasts.remove(0);
					if(r.a > r.b){
						r.d = 1;
					}
					r.y = lflen;
					r.x = -r.s;
					lflen += r.l;
					lfs.add(r);
				}
				{
					R r = lasts.remove(0);
					if(r.a > r.b){
						r.d = 1;
					}
					r.y = rilen;
					r.x = 0;
					rilen += r.l;
					ris.add(r);
				}
			}
			else if(lasts.size() > 0){
				R r = lasts.remove(0);
				if(r.a > r.b){
					r.d = 1;
				}
				r.y = lflen;
				r.x = -r.s;
				lflen += r.l;
				lfs.add(r);
			}
		}
		
		
		int rightXoffset = Math.min(uplen, dwlen);
		for(R r: ris){
			r.x += rightXoffset;
		}
		int upYoffset = Math.min(lflen, rilen);
		for(R r : ups){
			r.y += upYoffset;
		}
		

	}
	
	R getLastR(){
		return rs.remove(rs.size()-1);
	}
	
	int getNextDir(int uplen, int dwlen, int lflen, int rilen){
		int minlen = Math.min(Math.min(uplen, dwlen), Math.min(lflen, rilen));
		if(uplen == minlen){
			return 0;
		}
		else if(dwlen == minlen){
			return 1;
		}
		else if(lflen == minlen){
			return 2;
		}
		return 3;
	}
	
	
	private void mycalc(List<R> rs) throws Exception{
		lines = new ArrayList<L>();
		
		//ŏ̂P
		R r = rs.remove(0);
		if(r.b > r.a){
			r.d = 1;
		}
		List<R> leftRs = new ArrayList<R>();
		List<R> rightRs = new ArrayList<R>();
	
		addLines(getLines(r));
		
		int debug = 0;
		while(rs.size() >= 3){
			L topL = getTopMostLine(lines);
			addTopMost(rs, lines, topL, leftRs, rightRs);
			
			if(leftRs.size() >= 2){
				addLeftDent(rs, leftRs);
				debug++;
			}
			addRightDent(rs, rightRs);
		}
		
		// ŌQ1
		addLast(rs, lines);
	}
	
	void addLines(List<L> ls) throws Exception{
		lines.addAll(ls);
		for(L l : ls){
			if(l.x1 == l.x2){
				boolean ins = false;
				for(int i = 0; i < tateLines.size(); i++){
					L bl = tateLines.get(i);
					if(bl.x1 > l.x2){
						tateLines.add(i, l);
						ins = true;
						break;
					}
					else if(bl.x1 == l.x1){
						int j = i;
						for(; j < tateLines.size(); j++){
							bl = tateLines.get(j);
							if(bl.x1 != l.x1)break; 
							if(bl.y1 > l.y2){
								tateLines.add(j, l);
								ins = true;
								break;
							}
							else if( l.y1 <= bl.y1 && bl.y1 <= l.y2 || l.y1 <= bl.y2 && bl.y2 <= l.y2
									|| bl.y1 <= l.y1 && l.y1 <= bl.y2 || bl.y1 <= l.y2 && l.y2 <= bl.y2){
								ins = true;
								int maxy = Math.max(bl.y2, l.y2);
								int miny = Math.min(bl.y1, l.y1);
								bl.y2 = maxy;
								bl.y1 = miny;
								int k = j+1;
								while(k < tateLines.size()){
									L nbl = tateLines.get(k);
									if(nbl.x1 != l.x1){
										break;
									}
									if( bl.y1 <= nbl.y1 && nbl.y1 <= bl.y2 || bl.y1 <= nbl.y2 && nbl.y2 <= bl.y2
										|| nbl.y1 <= bl.y1 && bl.y1 <= nbl.y2 || nbl.y1 <= bl.y2 && bl.y2 <= nbl.y2){
										maxy = Math.max(nbl.y2, bl.y2);
										miny = Math.min(nbl.y1, bl.y1);
										bl.y2 = maxy;
										bl.y1 = miny;
										tateLines.remove(nbl);
									}
									else{
										break;
									}
								}
							}
							else if(bl.y2 < l.y1){
								ins = true;
								tateLines.add(j+1, l);
							}
							
						}
						if(!ins){
							throw new Exception("unexpected");
						}
						break;
					}
				}
				if(!ins){
					tateLines.add(l);
				}
			}
			else{ //l.y1 == l.y2
				boolean ins = false;
				for(int i = 0; i < yokoLines.size(); i++){
					L bl = yokoLines.get(i);
					if(bl.y1 > l.y2){
						yokoLines.add(i, l);
						ins = true;
						break;
					}
					else if(bl.y1 == l.y1){
						int j = i;
						for(; j < yokoLines.size(); j++){
							bl = yokoLines.get(j);
							if(bl.y1 != l.y1)break; 
							if(bl.x1 > l.x2){
								yokoLines.add(j, l);
								ins = true;
								break;
							}
							else if( l.x1 <= bl.x1 && bl.x1 <= l.x2 || l.x1 <= bl.x2 && bl.x2 <= l.x2
									|| bl.x1 <= l.x1 && l.x1 <= bl.x2 || bl.x1 <= l.x2 && l.x2 <= bl.x2){
								ins = true;
								int maxx = Math.max(bl.x2, l.x2);
								int minx = Math.min(bl.x1, l.x1);
								bl.x2 = maxx;
								bl.x1 = minx;
								int k = j+1;
								while(k < yokoLines.size()){
									L nbl = yokoLines.get(k);
									if(nbl.y1 != l.y1){
										break;
									}
									if( bl.x1 <= nbl.x1 && nbl.x1 <= bl.x2 || bl.x1 <= nbl.x2 && nbl.x2 <= bl.x2
											|| nbl.x1 <= bl.x1 && bl.x1 <= nbl.x2 || nbl.x1 <= bl.x2 && bl.x2 <= nbl.x2){
										maxx = Math.max(nbl.x2, bl.x2);
										minx = Math.min(nbl.x1, bl.x1);
										bl.x2 = maxx;
										bl.x1 = minx;
										yokoLines.remove(nbl);
									}
									else{
										break;
									}
								}
							}
							else if(bl.x2 < l.x1){
								ins = true;
								yokoLines.add(j+1, l);
							}
							
						}
						if(!ins){
							throw new Exception("unexpected");
						}
						break;
					}
				}
				if(!ins){
					yokoLines.add(l);
				}
			}
		}
		
	}
	
	void addLeftDent(List<R> rs, List<R> leftRs) throws Exception{
		if(leftRs.size() < 2){
			return;
		}
		if(rs.size() == 0) return;
		R topR = leftRs.get(leftRs.size()-1);
		R botR = leftRs.get(leftRs.size()-2);
		int uy = topR.y;
		int by = botR.y + botR.l;
		int ux = topR.x;
		int bx = botR.x;
		int wide = uy - by;
		R targetR = null;
		for(int i = rs.size() - 1; i >= 0; i--){
			R r = rs.get(i);
			if(r.l >= wide){
				targetR = r;
				break;
			}
		}
		if(targetR == null) return;
		int y = 0;
		int x = 0;
		if(ux <= bx){
			y = uy - targetR.l;
			x = bx - targetR.s;
		}
		else{
			y = by;
			x = ux - targetR.s;
		}
		// ̉A̎lp˂hȂB傫̊֌WÂ܂ŕ܂ႤƂ͂肦Ȃ
		L ckl1 = new L(y, x, y, x + targetR.s);
		
		// ̍
		L ckl2 = new L(y, x, y+targetR.l, x);
		if(!iscrossFailure(ckl1) && !iscrossFailure(ckl2)){
			targetR.y = y;
			targetR.x = x;
			if(targetR.a > targetR.b){
				targetR.d = 1;
			}
			rs.remove(targetR);
			addLines(getLines(targetR));
		}
	}
	
	void addRightDent(List<R> rs, List<R> rightRs) throws Exception{
		if(rightRs.size() < 2){
			return;
		}
		if(rs.size() == 0) return;
		R topR = rightRs.get(rightRs.size()-1);
		R botR = rightRs.get(rightRs.size()-2);
		int uy = topR.y;
		int by = botR.y + botR.l;
		int ux = topR.x + topR.s;
		int bx = botR.x + botR.s;
		int wide = uy - by;
		R targetR = null;
		for(int i = rs.size() - 1; i >= 0; i--){
			R r = rs.get(i);
			if(r.l >= wide){
				targetR = r;
				break;
			}
		}
		if(targetR == null) return;
		int y = 0;
		int x = 0;
		if(ux <= bx){
			y = by;
			x = ux;
		}
		else{
			y = uy - targetR.l;
			x = bx;
		}
		// ̉A̎lp˂hȂB傫̊֌WÂ܂ŕ܂ႤƂ͂肦Ȃ
		L ckl1 = new L(y, x, y, x + targetR.s);
		
		// ̉E
		L ckl2 = new L(y, x+targetR.s, y+targetR.l, x+targetR.s);
		if(!iscrossFailure(ckl1) && !iscrossFailure(ckl2)){
			targetR.y = y;
			targetR.x = x;
			//System.err.println(targetR.idx);
			if(targetR.a > targetR.b){
				targetR.d = 1;
			}
			rs.remove(targetR);
			addLines(getLines(targetR));
		}
	}
	
	boolean iscrossFailure(L ck){
		if(ck.x1 == ck.x2){
			int ckx = ck.x1;
			for(L l : yokoLines){
				if(l.x1 < ckx && ckx < l.x2){
					int ly = l.y1;
					if(ck.y1 < ly && ly < ck.y2){
						return true;
					}
				}
			}
		}
		else{
			int cky = ck.y1;
			for(L l : tateLines){
				int lx = l.x1;
				if(lx <= ck.x1 || lx >= ck.x2){
					continue;
				}
				if(l.y1 < cky && cky < l.y2){
					return true;
				}
			}
		}
		
		return false;
	}
	
	
	
	boolean iscrossFailure(List<L> lines, L ck){
		if(ck.x1 == ck.x2){
			int ckx = ck.x1;
			for(L l : lines){
				if(l.x1 == l.x2) continue;
				int ly = l.y1;
				if(ly <= ck.y1 || ly >= ck.y2){
					continue;
				}
				if(l.x1 < ckx && ckx < l.x2){
					return true;
				}
			}
		}
		else{
			int cky = ck.y1;
			for(L l : lines){
				if(l.y1 == l.y2) continue;
				int lx = l.x1;
				if(lx <= ck.x1 || lx >= ck.x2){
					continue;
				}
				if(l.y1 < cky && cky < l.y2){
					return true;
				}
			}
		}
		
		return false;
	}
	
	void addTopMost(List<R> rs, List<L> lines, L topL, List<R> leftRs, List<R> rightRs) throws Exception{
		R r = null;
		List<L> lastAddedLines = null;
		{ // ŏ̍
			
			r = rs.remove(2);
			if(r.a > r.b){
				r.d = 1;
			}
			r.y = topL.y1;
			r.x = topL.x1 - r.s;
			lastAddedLines = getLines(r);
		
			addLines(lastAddedLines);
			leftRs.add(r);
		}
		
		{ // ̎lp
			L ctopL = getTopMostLine(lastAddedLines);
			r = rs.remove(1);
			if(r.b > r.a){
				r.d = 1;
			}
			r.y = ctopL.y2;
			r.x = ctopL.x2;
			lastAddedLines = getLines(r);
		}
		 
		{  // ŌEꏊTȂǉ
			r = rs.remove(0);
			rightRs.add(r);
			if(r.a > r.b){
				r.d = 1;
			}
			
			// 2Ԗڂ̎lp̉L
			L lastBotL = getBottomMostLine(lastAddedLines);
			int y = lastBotL.y1;
			int x = lastBotL.x2;
			L ckL = new L(y - r.l, x, y, x);
			L targetL = getTopMostLine(lines, ckL);
			if(targetL != null){
				r.y = targetL.y1;
				r.x = x;
			}
			else{
				while(true){
					x--;
					ckL = new L(y - r.l, x, y, x);
					targetL = getTopMostLine(lines, ckL);
					if(targetL != null){
						r.y = y - r.l;
						r.x = x;
						break;
					}
				}
			}
			
			// QԂ߂̂Œǉ
			addLines(lastAddedLines);
			
			// Ō̕ŒǉB
			lastAddedLines = getLines(r);
			addLines(lastAddedLines);
		}
	}
	
	
	
	
	
	/**
	 * ŌQǉ
	 * @param rs
	 * @param lines
	 */
	void addLast(List<R> rs, List<L> lines){
		R r = null;
		if(rs.size() > 0){
			L prevTopL = getTopMostLine(lines);
			r = rs.remove(0);
			if(r.b > r.a){
				r.d = 1;
			}
			r.y = prevTopL.y1;
			r.x = prevTopL.x1 - r.l;
			
			
			List<L> lastAddedlines = getLines(r);
		
			
			//Ō̂PA
			if(rs.size() > 0){
				r = rs.remove(0);
				if(r.a > r.b){
					r.d = 1;
				}
				L l = getBottomMostLine(lastAddedlines);
				
				int y = l.y1;
				int x = l.x1;
				
				L ckL = new L(y - r.l, x, y, x);
				L targetL = getTopMostLine(lines, ckL);
				if(targetL != null){
					r.y = targetL.y1;
					r.x = x - r.s;
				}
				else{
					while(true){
						x++;
						ckL = new L(y - r.l, x, y, x);
						targetL = getTopMostLine(lines, ckL);
						if(targetL != null){
							r.y = y - r.l;
							r.x = x - r.s;
							break;
						}
					}
				}
				lines.addAll(lastAddedlines);
				lastAddedlines = getLines(r);
				lines.addAll(lastAddedlines);
			}
		}
	}
	
//	void addToUpper(List<R> rs, List<L> lines){
//		List<R> addedRs = new ArrayList<R>();
//		R r = null;
//		{ // ŏ̍
//			L leftMostL = getLeftMostLine(lines);
//			r = rs.remove(0);
//			addedRs.add(r);
//			if(r.a > r.b){
//				r.d = 1;
//			}
//			r.y = leftMostL.y2;
//			r.x = leftMostL.x1 - r.s;
//			
//		}
//		
//		{ // 
//			
//			//Olp̉E
//			int y = r.y + r.l;
//			int x = r.x + r.s;
//			
//			
//			r = rs.remove(0);
//			if(r.b > r.a){
//				r.d = 1;
//			}
//			L ck1 = new L(y, x, y, x + r.l);
//			L ck2 = new L(y+r.s, x, y+r.s, x + r.l);
//			
//			L target = getLeftMostLine(lines, ck1, ck2);
//			addedRs.add(r);
//			if(target == null){
//				r.y = y;
//				r.x = x;
//			}
//			else{
//				// holeɂȂ̂łŏI
//				r.y = y;
//				r.x = target.x1 - r.l;
//				for(R ar : addedRs){
//					lines.addAll(getLines(ar));
//				}
//				return;
//			}
//			
//			
//		}
//		 
//		{  // ŌEꏊTȂǉ
//			r = rs.remove(0);
//			if(r.a > r.b){
//				r.d = 1;
//			}
//			
//			// 2Ԗڂ̎lp̉L
//			L lastBotL = getBottomMostLine(lastAddedLines);
//			int y = lastBotL.y1;
//			int x = lastBotL.x2;
//			L ckL = new L(y - r.l, x, y, x);
//			L targetL = getTopMostLine(lines, ckL);
//			if(targetL != null){
//				r.y = targetL.y1;
//				r.x = x;
//			}
//			else{
//				while(true){
//					x--;
//					ckL = new L(y - r.l, x, y, x);
//					targetL = getTopMostLine(lines, ckL);
//					if(targetL != null){
//						r.y = y - r.l;
//						r.x = x;
//						break;
//					}
//				}
//			}
//			
//			// QԂ߂̂Œǉ
//			lines.addAll(lastAddedLines);
//			
//			// Ō̕ŒǉB
//			lastAddedLines = getLines(r);
//			lines.addAll(lastAddedLines);
//		}
//	}
//	
//	/**
//	 * ck1, ck2͉x1, x2͓Bi܂蓯lp̉Ə̐
//	 * @param lines
//	 * @param ck1 ̐
//	 * @param ck2 ̐
//	 * @return
//	 */
//	private L getLeftMostLine(List<L> lines, L ck1, L ck2){
//		L ret = null;
//		
//		int lx = ck1.x1;
//		int rx = ck1.x2;
//		
//		int ck2y = ck2.y2;
//		int ck1y = ck1.y2;
//		
//		for(L l : lines){
//			if(l.x1 != l.x2){
//				continue;
//			}
//			int x = l.x1;
//			if(lx <= x && x <= rx){
//				int uy = l.y2;
//				int dy = l.y1;
//				if(dy <= ck1y && ck1y <= uy ||
//						dy <= ck2y && ck2y <= uy){
//					if(ret == null){
//						ret = l;
//					}
//					else if(l.x1 < ret.x1){
//						ret = l;
//					}
//				}
//			}
//			
//		}
//
//		return ret;
//	}
	
	private L getLeftMostLine(List<L> lines){
		L ret = null;
		for(L l : lines){
			if(l.x1 == l.x2){
				if(ret == null){
					ret = l;
				}
				else{
					if(l.x1 < ret.x1){
						ret = l;
					}
					else if(ret.x1 == l.x1){
						if(l.w > ret.w){
							ret = l;
						}
					}
				}
			}
		}

		return ret;
	}
	
	private L getRightMostLine(List<L> lines){
		L ret = null;
		for(L l : lines){
			if(l.x1 == l.x2){
				if(ret == null){
					ret = l;
				}
				else{
					if(l.x1 > ret.x1){
						ret = l;
					}
					else if(ret.x1 == l.x1){
						if(l.w > ret.w){
							ret = l;
						}
					}
				}
			}
		}

		return ret;
	}
	
	
	// cklɂԏ̉LԂB^b`B
	// ckl͏c̐O
	private L getTopMostLine(List<L> lines, L ckL){
		L ret = null;
		int ckX = ckL.x1;
		for(L l : lines){
			if(l.y1 == l.y2 && 
			   l.x1 <= ckX && ckX <= l.x2 &&
			   ckL.y1 <= l.y1 && l.y1 <= ckL.y2){
				if(ret == null){
					ret = l;
				}
				else{
					if(l.y1 > ret.y1){
						ret = l;
					}
				}
			}
		}
		return ret;
	}
	
	private L getTopMostLine(List<L> lines){
		L ret = null;
		for(L l : lines){
			if(l.y1 == l.y2){
				if(ret == null){
					ret = l;
				}
				else{
					if(ret.y1 < l.y1){
						ret = l;
					}
					else if(ret.y1 == l.y1){
						if(l.w > ret.w){
							ret = l;
						}
					}
				}
			}
		}

		return ret;
	}
	
	private L getBottomMostLine(List<L> lines){
		L ret = null;
		for(L l : lines){
			if(l.y1 == l.y2){
				if(ret == null){
					ret = l;
				}
				else{
					if(ret.y1 > l.y1){
						ret = l;
					}
					else if(ret.y1 == l.y1){
						if(l.w > ret.w){
							ret = l;
						}
					}
				}
			}
		}

		return ret;
	}
	
	
	private boolean iscross(List<L> l1, List<L> l2){
		for(L ml : l1){
			for(L l : l2){
				if(cross(ml, l)){
					return true;
				}
			}
		}
		return false;
	}
	
	private int nextrnd(){
		return rnd.nextInt(1800000) - 900000;
	}
	
	List<L> getLines(R r){
		return getLines(r, 0, 0);
	}
	
	// y, xƂɏقɗ悤
	List<L> getLines(R r, int oy, int ox){
		List<L> l = new ArrayList<L>();
		int y = r.y + oy;
		int x = r.x + ox;
		if(r.d == 0){
			int ny = y + r.b;
			int nx = x;
			l.add(new L(y, x, ny, nx));
			y = ny;
			x = nx;
			nx += r.a;
			l.add(new L(y, x, ny, nx));
			y = ny;
			x = nx;
			ny -= r.b;
			l.add(new L(ny, nx, y, x));
			y = ny;
			x = nx;
			nx -= r.a;
			l.add(new L(ny, nx, y, x));
		}
		else{
			int ny = y + r.a;
			int nx = x;
			l.add(new L(y, x, ny, nx));
			y = ny;
			x = nx;
			nx += r.b;
			l.add(new L(y, x, ny, nx));
			y = ny;
			x = nx;
			ny -= r.a;
			l.add(new L(ny, nx, y, x));
			y = ny;
			x = nx;
			nx -= r.b;
			l.add(new L(ny, nx, y, x));
		}
		
		return l;
	}

	
	boolean cross(L l1, L l2){
		int ly1 = Math.max(l1.y1, l1.y2);
		int sy1 = Math.min(l1.y1, l1.y2);
		int ly2 = Math.max(l2.y1, l2.y2);
		int sy2 = Math.min(l2.y1, l2.y2);
		
		int lx1 = Math.max(l1.x1, l1.x2);
		int sx1 = Math.min(l1.x1, l1.x2);
		int lx2 = Math.max(l2.x1, l2.x2);
		int sx2 = Math.min(l2.x1, l2.x2);
		
		
		if(l1.x1 == l1.x2){
			if(l2.x1 != l2.x2){
				if(sy1 < l2.y1 && l2.y1 < ly1 && sx2 < l1.x1 && l1.x1 < lx2){
					return true;
				}
			}
		}
		else{
			if(l2.y1 != l2.y2){
				if(sx1 < l2.x1 && l2.x1 < lx1 && sy2 < l1.y1 && l1.y1 < ly2){
					return true;
				}
			}
		}

		return false;
	}
	

	class L{
		public L(int y1, int x1, int y2, int x2){
			this.y1 = y1;
			this.x1 = x1;
			this.y2 = y2;
			this.x2 = x2;
			if(y1 == y2){
				w = x2 - x1;
			}
			else{
				w = y2 - y1;
			}
		}
		int y1 = 0;
		int x1 = 0;
		int y2 = 0;
		int x2 = 0;
		int w = 0;
	}
	
			
	
	class R{
		public R(int a, int b){
			this.a = a;
			this.b = b;
			l = Math.max(a, b);
			s = Math.min(a, b);
		}
		int a = 0;
		int b = 0;
		int l = 0;
		int s = 0;
		int idx = 0;
		int y = 0;
		int x = 0;
		int d = 0;
	}
	
	class G {
		List<R> rs = new ArrayList<R>();
		int oy = 0;
		int ox = 0;
	}

	
	
	
//	
//	public static void main(String[] args) throws Exception{
//		RectanglesAndHoles r = new RectanglesAndHoles();
//		//s.test();
//		err = System.err;
//
//		progtime = 0;
//
//		BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
//		BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(System.out));
//
//		String s = null;
//		while( (s = br.readLine()) != null){
//			int n = parseInt(s);
//			int[] A = new int[n];
//			int[] B = new int[n];
//			for(int i = 0; i < n; i++){
//				A[i] = parseInt(br.readLine());
//			}
//			for(int i = 0; i < n; i++){
//				B[i] = parseInt(br.readLine());
//			}
//			int[] ret = r.place(A, B);
//			for(int i = 0; i < ret.length; i++){
//				bw.write(ret[i] + "\n");
//			}
//			bw.flush();
//		}
//
//	    bw.close();
//	    br.close();
//	    err.println("time : " + progtime);
//	}

}
